/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.engine;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.devices.AudioDeviceFactory;
import com.jsyn.devices.AudioDeviceInputStream;
import com.jsyn.devices.AudioDeviceManager;
import com.jsyn.devices.AudioDeviceOutputStream;
import com.jsyn.engine.LoadAnalyzer;
import com.jsyn.unitgen.UnitGenerator;
import com.softsynth.shared.time.ScheduledCommand;
import com.softsynth.shared.time.ScheduledQueue;
import com.softsynth.shared.time.TimeStamp;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;

public class SynthesisEngine
implements Runnable,
Synthesizer {
    private static final int BLOCKS_PER_BUFFER = 8;
    private static final int FRAMES_PER_BUFFER = 64;
    public static final int DEFAULT_FRAME_RATE = 44100;
    private AudioDeviceManager audioDeviceManager;
    private AudioDeviceOutputStream audioOutputStream;
    private AudioDeviceInputStream audioInputStream;
    private Thread audioThread;
    private ScheduledQueue<ScheduledCommand> commandQueue = new ScheduledQueue();
    private volatile boolean go;
    private InterleavingBuffer inputBuffer;
    private InterleavingBuffer outputBuffer;
    private double inverseNyquist;
    private long frameCount;
    private boolean pullDataEnabled = true;
    private boolean useRealTime = true;
    private boolean started;
    private int frameRate = 44100;
    private double framePeriod = 1.0 / (double)this.frameRate;
    private ArrayList<UnitGenerator> allUnitList = new ArrayList();
    private ArrayList<UnitGenerator> runningUnitList = new ArrayList();
    private ArrayList<UnitGenerator> stoppingUnitList = new ArrayList();
    private LoadAnalyzer loadAnalyzer;
    private CopyOnWriteArrayList<Runnable> audioTasks = new CopyOnWriteArrayList();
    public static final double DB96 = 1.5848931924611107E-5;
    public static final double DB90 = 3.0517578125E-5;
    static Logger logger = Logger.getLogger(SynthesisEngine.class.getName());

    public SynthesisEngine(AudioDeviceManager audioDeviceManager) {
        this.audioDeviceManager = audioDeviceManager;
    }

    public SynthesisEngine() {
        this(AudioDeviceFactory.createAudioDeviceManager());
    }

    public String getVersion() {
        return "16.7.3";
    }

    public int getVersionCode() {
        return 1050371;
    }

    public String toString() {
        return "JSyn " + JSyn.VERSION_TEXT;
    }

    public boolean isPullDataEnabled() {
        return this.pullDataEnabled;
    }

    public void setPullDataEnabled(boolean bl) {
        this.pullDataEnabled = bl;
    }

    private void setupAudioBuffers(int n, int n2) {
        this.inputBuffer = new InterleavingBuffer(64, 8, n);
        this.outputBuffer = new InterleavingBuffer(64, 8, n2);
    }

    public void terminate() {
    }

    public void start() {
        this.start(44100, -1, 0, -1, 2);
    }

    public void start(int n) {
        this.start(n, -1, 0, -1, 2);
    }

    public synchronized void start(int n, int n2, int n3, int n4, int n5) {
        if (this.started) {
            logger.info("JSyn already started.");
            return;
        }
        this.frameRate = n;
        this.framePeriod = 1.0 / (double)n;
        for (UnitGenerator unitGenerator : this.allUnitList) {
            unitGenerator.setFrameRate(n);
        }
        this.setupAudioBuffers(n3, n5);
        logger.info("Pure Java JSyn from www.softsynth.com, rate = " + n + ", " + (this.useRealTime ? "RT" : "NON-RealTime") + ", " + JSyn.VERSION_TEXT);
        this.inverseNyquist = 2.0 / (double)n;
        if (this.useRealTime) {
            if (n3 > 0) {
                this.audioInputStream = this.audioDeviceManager.createInputStream(n2, n, n3);
            }
            if (n5 > 0) {
                this.audioOutputStream = this.audioDeviceManager.createOutputStream(n4, n, n5);
            }
            this.audioThread = new Thread(this);
            logger.fine("Synth thread old priority = " + this.audioThread.getPriority());
            this.audioThread.setPriority(this.audioThread.getPriority() + 2);
            logger.fine("Synth thread new priority = " + this.audioThread.getPriority());
            this.go = true;
            this.audioThread.start();
        }
        this.started = true;
    }

    public boolean isRunning() {
        return this.go;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (!this.started) {
            logger.info("JSyn already stopped.");
            return;
        }
        if (this.useRealTime) {
            this.go = false;
            if (this.audioThread != null) {
                try {
                    this.audioThread.interrupt();
                    this.audioThread.join(1000L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
        ArrayList<UnitGenerator> arrayList = this.runningUnitList;
        synchronized (arrayList) {
            this.runningUnitList.clear();
        }
        this.started = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        logger.fine("JSyn synthesis thread starting.");
        try {
            String string;
            if (this.audioInputStream != null) {
                logger.finer("JSyn synthesis thread trying to start audio INPUT!");
                this.audioInputStream.start();
                string = String.format("Input Latency in = %5.1f msec", 1000.0 * this.audioInputStream.getLatency());
                logger.fine(string);
            }
            if (this.audioOutputStream != null) {
                logger.finer("JSyn synthesis thread trying to start audio OUTPUT!");
                this.audioOutputStream.start();
                string = String.format("Output Latency = %5.1f msec", 1000.0 * this.audioOutputStream.getLatency());
                logger.fine(string);
                this.audioOutputStream.write(this.outputBuffer.interleavedBuffer);
            }
            this.loadAnalyzer = new LoadAnalyzer();
            while (this.go) {
                if (this.audioInputStream != null) {
                    this.audioInputStream.read(this.inputBuffer.interleavedBuffer);
                }
                this.loadAnalyzer.start();
                this.runAudioTasks();
                this.generateNextBuffer();
                this.loadAnalyzer.stop();
                if (this.audioOutputStream == null) continue;
                this.audioOutputStream.write(this.outputBuffer.interleavedBuffer);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.go = false;
        }
        finally {
            logger.info("JSyn synthesis thread in finally code.");
            if (this.audioInputStream != null) {
                this.audioInputStream.stop();
            }
            if (this.audioOutputStream != null) {
                this.audioOutputStream.stop();
            }
        }
        logger.fine("JSyn synthesis thread exiting.");
    }

    private void runAudioTasks() {
        for (Runnable runnable : this.audioTasks) {
            runnable.run();
        }
    }

    public void generateNextBuffer() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < 8; ++i) {
            if (this.inputBuffer != null) {
                n2 = this.inputBuffer.deinterleave(n2);
            }
            TimeStamp timeStamp = this.createTimeStamp();
            this.processScheduledCommands(timeStamp);
            this.clearBlockBuffers();
            this.synthesizeBuffer();
            if (this.outputBuffer != null) {
                n = this.outputBuffer.interleave(n);
            }
            this.frameCount += 8L;
        }
    }

    public double getCurrentTime() {
        return (double)this.frameCount * this.framePeriod;
    }

    public TimeStamp createTimeStamp() {
        return new TimeStamp(this.getCurrentTime());
    }

    private void processScheduledCommands(TimeStamp timeStamp) {
        List<ScheduledCommand> list = this.commandQueue.removeNextList(timeStamp);
        while (list != null) {
            while (!list.isEmpty()) {
                ScheduledCommand scheduledCommand = list.remove(0);
                logger.fine("processing " + scheduledCommand + ", at time " + timeStamp.getTime());
                scheduledCommand.run();
            }
            list = this.commandQueue.removeNextList(timeStamp);
        }
    }

    public void scheduleCommand(TimeStamp timeStamp, ScheduledCommand scheduledCommand) {
        if (Thread.currentThread() == this.audioThread && timeStamp.getTime() <= this.getCurrentTime()) {
            scheduledCommand.run();
        } else {
            logger.fine("scheduling " + scheduledCommand + ", at time " + timeStamp.getTime());
            this.commandQueue.add(timeStamp, scheduledCommand);
        }
    }

    public void scheduleCommand(double d, ScheduledCommand scheduledCommand) {
        TimeStamp timeStamp = new TimeStamp(d);
        this.scheduleCommand(timeStamp, scheduledCommand);
    }

    public void queueCommand(ScheduledCommand scheduledCommand) {
        TimeStamp timeStamp = this.createTimeStamp();
        this.scheduleCommand(timeStamp, scheduledCommand);
    }

    private void clearBlockBuffers() {
        this.outputBuffer.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synthesizeBuffer() {
        ArrayList<UnitGenerator> arrayList = this.runningUnitList;
        synchronized (arrayList) {
            ListIterator<UnitGenerator> listIterator = this.runningUnitList.listIterator();
            while (listIterator.hasNext()) {
                UnitGenerator unitGenerator = listIterator.next();
                if (this.pullDataEnabled) {
                    unitGenerator.pullData(this.getFrameCount(), 0, 8);
                    continue;
                }
                unitGenerator.generate(0, 8);
            }
            for (UnitGenerator unitGenerator : this.stoppingUnitList) {
                this.runningUnitList.remove(unitGenerator);
                unitGenerator.flattenOutputs();
            }
        }
        this.stoppingUnitList.clear();
    }

    public double[] getInputBuffer(int n) {
        try {
            return this.inputBuffer.getChannelBuffer(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new RuntimeException("Audio Input not configured in start() method.");
        }
    }

    public double[] getOutputBuffer(int n) {
        try {
            return this.outputBuffer.getChannelBuffer(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new RuntimeException("Audio Output not configured in start() method.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalStopUnit(UnitGenerator unitGenerator) {
        ArrayList<UnitGenerator> arrayList = this.runningUnitList;
        synchronized (arrayList) {
            this.runningUnitList.remove(unitGenerator);
        }
        unitGenerator.flattenOutputs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void autoStopUnit(UnitGenerator unitGenerator) {
        ArrayList<UnitGenerator> arrayList = this.stoppingUnitList;
        synchronized (arrayList) {
            this.stoppingUnitList.add(unitGenerator);
        }
    }

    public void startUnit(UnitGenerator unitGenerator, double d) {
        this.startUnit(unitGenerator, new TimeStamp(d));
    }

    public void stopUnit(UnitGenerator unitGenerator, double d) {
        this.stopUnit(unitGenerator, new TimeStamp(d));
    }

    public void startUnit(final UnitGenerator unitGenerator, TimeStamp timeStamp) {
        if (unitGenerator.getCircuit() == null) {
            this.scheduleCommand(timeStamp, new ScheduledCommand(){

                public void run() {
                    SynthesisEngine.this.internalStartUnit(unitGenerator);
                }
            });
        }
    }

    public void stopUnit(final UnitGenerator unitGenerator, TimeStamp timeStamp) {
        this.scheduleCommand(timeStamp, new ScheduledCommand(){

            public void run() {
                SynthesisEngine.this.internalStopUnit(unitGenerator);
            }
        });
    }

    public void startUnit(UnitGenerator unitGenerator) {
        this.startUnit(unitGenerator, this.createTimeStamp());
    }

    public void stopUnit(UnitGenerator unitGenerator) {
        this.stopUnit(unitGenerator, this.createTimeStamp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalStartUnit(UnitGenerator unitGenerator) {
        if (unitGenerator.getCircuit() == null) {
            ArrayList<UnitGenerator> arrayList = this.runningUnitList;
            synchronized (arrayList) {
                if (!this.runningUnitList.contains(unitGenerator)) {
                    this.runningUnitList.add(unitGenerator);
                }
            }
        }
    }

    public double getInverseNyquist() {
        return this.inverseNyquist;
    }

    public double convertTimeToExponentialScaler(double d) {
        double d2 = d * (double)this.getFrameRate();
        return Math.pow(3.0517578125E-5, 1.0 / d2);
    }

    public long getFrameCount() {
        return this.frameCount;
    }

    public int getFrameRate() {
        return this.frameRate;
    }

    public double getFramePeriod() {
        return this.framePeriod;
    }

    public static double convertShortToDouble(short s) {
        return (double)s * 3.051850947599719E-5;
    }

    public static short convertDoubleToShort(double d) {
        if (d > 0.999969481490524) {
            d = 0.999969481490524;
        } else if (d < -1.0) {
            d = -1.0;
        }
        return (short)(d * 32767.0);
    }

    public void addAudioTask(Runnable runnable) {
        this.audioTasks.add(runnable);
    }

    public void removeAudioTask(Runnable runnable) {
        this.audioTasks.remove(runnable);
    }

    public double getUsage() {
        LoadAnalyzer loadAnalyzer = this.loadAnalyzer;
        if (loadAnalyzer != null) {
            return loadAnalyzer.getAverageLoad();
        }
        return 0.0;
    }

    public AudioDeviceManager getAudioDeviceManager() {
        return this.audioDeviceManager;
    }

    public void setRealTime(boolean bl) {
        this.useRealTime = bl;
    }

    public boolean isRealTime() {
        return this.useRealTime;
    }

    public double getOutputLatency() {
        if (this.audioOutputStream != null) {
            return this.audioOutputStream.getLatency();
        }
        return 0.0;
    }

    public double getInputLatency() {
        if (this.audioInputStream != null) {
            return this.audioInputStream.getLatency();
        }
        return 0.0;
    }

    public void add(UnitGenerator unitGenerator) {
        unitGenerator.setSynthesisEngine(this);
        this.allUnitList.add(unitGenerator);
        if (this.frameRate > 0) {
            unitGenerator.setFrameRate(this.frameRate);
        }
    }

    public void remove(UnitGenerator unitGenerator) {
        this.allUnitList.remove(unitGenerator);
    }

    public void sleepUntil(double d) throws InterruptedException {
        double d2 = d - this.getCurrentTime();
        while (d2 > 0.0) {
            if (this.useRealTime) {
                long l = (long)(1000.0 * d2);
                if (l <= 0L) {
                    l = 1L;
                }
                Thread.sleep(l);
            } else {
                this.generateNextBuffer();
            }
            d2 = d - this.getCurrentTime();
        }
    }

    public void sleepFor(double d) throws InterruptedException {
        this.sleepUntil(this.getCurrentTime() + d);
    }

    public void printConnections() {
        if (this.pullDataEnabled) {
            ListIterator<UnitGenerator> listIterator = this.runningUnitList.listIterator();
            while (listIterator.hasNext()) {
                UnitGenerator unitGenerator = listIterator.next();
                unitGenerator.printConnections();
            }
        }
    }

    class ChannelBlockBuffer {
        private double[] values;

        ChannelBlockBuffer(int n) {
            this.values = new double[n];
        }

        void clear() {
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = 0.0;
            }
        }
    }

    class InterleavingBuffer {
        private double[] interleavedBuffer;
        ChannelBlockBuffer[] blockBuffers;

        InterleavingBuffer(int n, int n2, int n3) {
            this.interleavedBuffer = new double[n * n3];
            this.blockBuffers = new ChannelBlockBuffer[n3];
            for (int i = 0; i < this.blockBuffers.length; ++i) {
                this.blockBuffers[i] = new ChannelBlockBuffer(n2);
            }
        }

        int deinterleave(int n) {
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < this.blockBuffers.length; ++j) {
                    ChannelBlockBuffer channelBlockBuffer = this.blockBuffers[j];
                    ((ChannelBlockBuffer)channelBlockBuffer).values[i] = this.interleavedBuffer[n++];
                }
            }
            return n;
        }

        int interleave(int n) {
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < this.blockBuffers.length; ++j) {
                    ChannelBlockBuffer channelBlockBuffer = this.blockBuffers[j];
                    this.interleavedBuffer[n++] = channelBlockBuffer.values[i];
                }
            }
            return n;
        }

        public double[] getChannelBuffer(int n) {
            return this.blockBuffers[n].values;
        }

        public void clear() {
            for (int i = 0; i < this.blockBuffers.length; ++i) {
                this.blockBuffers[i].clear();
            }
        }
    }
}

