/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.data;

import com.jsyn.data.AudioSample;
import com.jsyn.engine.SynthesisEngine;

public class ShortSample
extends AudioSample {
    private short[] buffer;

    public ShortSample() {
    }

    public ShortSample(int n, int n2) {
        this.allocate(n, n2);
    }

    public ShortSample(short[] sArray) {
        this(sArray.length, 1);
        this.write(sArray);
    }

    public ShortSample(short[] sArray, int n) {
        this(sArray.length / n, n);
        this.write(sArray);
    }

    public void allocate(int n, int n2) {
        this.buffer = new short[n * n2];
        this.numFrames = n;
        this.channelsPerFrame = n2;
    }

    public void write(int n, short[] sArray, int n2, int n3) {
        int n4 = n3 * this.channelsPerFrame;
        int n5 = n * this.channelsPerFrame;
        System.arraycopy(sArray, n2, this.buffer, n5, n4);
    }

    public void read(int n, short[] sArray, int n2, int n3) {
        int n4 = n3 * this.channelsPerFrame;
        int n5 = n * this.channelsPerFrame;
        System.arraycopy(this.buffer, n5, sArray, n2, n4);
    }

    public void write(short[] sArray) {
        this.write(0, sArray, 0, sArray.length);
    }

    public void read(short[] sArray) {
        this.read(0, sArray, 0, sArray.length);
    }

    public short readShort(int n) {
        return this.buffer[n];
    }

    public void writeShort(int n, short s) {
        this.buffer[n] = s;
    }

    public double readDouble(int n) {
        return SynthesisEngine.convertShortToDouble(this.buffer[n]);
    }

    public void writeDouble(int n, double d) {
        this.buffer[n] = SynthesisEngine.convertDoubleToShort(d);
    }
}

