/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.data;

import com.jsyn.data.SequentialDataCommon;

public class SegmentedEnvelope
extends SequentialDataCommon {
    private double[] buffer;

    public SegmentedEnvelope(int n) {
        this.allocate(n);
    }

    public SegmentedEnvelope(double[] dArray) {
        this(dArray.length / 2);
        this.write(dArray);
    }

    public void allocate(int n) {
        this.buffer = new double[n * 2];
        this.maxFrames = n;
        this.numFrames = 0;
    }

    public void write(int n, double[] dArray, int n2, int n3) {
        System.arraycopy(dArray, n2 * 2, this.buffer, n * 2, n3 * 2);
        if (n + n3 > this.numFrames) {
            this.numFrames = n + n3;
        }
    }

    public void read(int n, double[] dArray, int n2, int n3) {
        System.arraycopy(this.buffer, n * 2, dArray, n2 * 2, n3 * 2);
    }

    public void write(double[] dArray) {
        this.write(0, dArray, 0, dArray.length / 2);
    }

    public void read(double[] dArray) {
        this.read(0, dArray, 0, dArray.length / 2);
    }

    public double readDouble(int n) {
        return this.buffer[n * 2 + 1];
    }

    public void writeDouble(int n, double d) {
        this.buffer[n * 2 + 1] = d;
        if (n + 1 > this.numFrames) {
            this.numFrames = n + 1;
        }
    }

    public double getRateScaler(int n, double d) {
        double d2 = this.buffer[n * 2];
        if (d2 < d) {
            d2 = d;
        }
        return 1.0 / d2;
    }

    public int getChannelsPerFrame() {
        return 1;
    }
}

