/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.data;

import com.jsyn.data.Function;
import com.jsyn.data.ShortSample;
import com.jsyn.exceptions.ChannelMismatchException;

public class DoubleTable
implements Function {
    private double[] table;

    public DoubleTable(int n) {
        this.allocate(n);
    }

    public DoubleTable(double[] dArray) {
        this.allocate(dArray.length);
        this.write(dArray);
    }

    public DoubleTable(ShortSample shortSample) {
        int n;
        int n2;
        if (shortSample.getChannelsPerFrame() != 1) {
            throw new ChannelMismatchException("DoubleTable can only be built from mono samples.");
        }
        short[] sArray = new short[256];
        this.allocate(n2);
        int n3 = 0;
        for (n2 = shortSample.getNumFrames(); n2 > 0; n2 -= n) {
            n = n2;
            if (n > sArray.length) {
                n = sArray.length;
            }
            shortSample.read(n3, sArray, 0, n);
            this.write(n3, sArray, 0, n);
            n3 += n;
        }
    }

    public void allocate(int n) {
        this.table = new double[n];
    }

    public void write(double[] dArray) {
        this.write(0, dArray, 0, dArray.length);
    }

    public void write(int n, short[] sArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            this.table[n + i] = (double)sArray[n2 + i] * 3.0517578125E-5;
        }
    }

    public void write(int n, double[] dArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            this.table[n + i] = dArray[n2 + i];
        }
    }

    public double evaluate(double d) {
        double d2;
        if (d < -1.0) {
            d2 = this.table[0];
        } else if (d < 1.0) {
            double d3 = (double)(this.table.length - 1) * (d - -1.0) / 2.0;
            int n = (int)d3;
            double d4 = d3 - (double)n;
            double d5 = this.table[n];
            double d6 = this.table[n + 1];
            d2 = (d6 - d5) * d4 + d5;
        } else {
            d2 = this.table[this.table.length - 1];
        }
        return d2;
    }
}

