/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.apps;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.instruments.JSynInstrumentLibrary;
import com.jsyn.swing.InstrumentBrowser;
import com.jsyn.swing.JAppletFrame;
import com.jsyn.swing.PresetSelectionListener;
import com.jsyn.swing.SoundTweaker;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.UnitSource;
import com.jsyn.unitgen.UnitVoice;
import com.jsyn.util.PolyphonicInstrument;
import com.jsyn.util.VoiceDescription;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JApplet;

public class InstrumentTester
extends JApplet {
    private static final long serialVersionUID = -2704222221111608377L;
    private Synthesizer synth;
    private LineOut lineOut;
    private SoundTweaker tweaker;

    public void init() {
        this.setLayout(new BorderLayout());
        this.synth = JSyn.createSynthesizer();
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        InstrumentBrowser instrumentBrowser = new InstrumentBrowser(new JSynInstrumentLibrary());
        instrumentBrowser.addPresetSelectionListener(new PresetSelectionListener(){

            public void presetSelected(VoiceDescription voiceDescription, int n) {
                UnitVoice[] unitVoiceArray = new UnitVoice[8];
                for (int i = 0; i < unitVoiceArray.length; ++i) {
                    unitVoiceArray[i] = voiceDescription.createUnitVoice();
                }
                PolyphonicInstrument polyphonicInstrument = new PolyphonicInstrument(unitVoiceArray);
                InstrumentTester.this.synth.add(polyphonicInstrument);
                polyphonicInstrument.usePreset(n, InstrumentTester.this.synth.createTimeStamp());
                String string = voiceDescription.getVoiceClassName() + ": " + voiceDescription.getPresetNames()[n];
                InstrumentTester.this.useSource(polyphonicInstrument, string);
            }
        });
        this.add((Component)instrumentBrowser, "North");
        this.validate();
    }

    private void useSource(UnitSource unitSource, String string) {
        this.lineOut.input.disconnectAll(0);
        this.lineOut.input.disconnectAll(1);
        unitSource.getOutput().connect(0, this.lineOut.input, 0);
        unitSource.getOutput().connect(0, this.lineOut.input, 1);
        if (this.tweaker != null) {
            this.remove(this.tweaker);
        }
        try {
            if (this.synth.isRunning()) {
                this.synth.sleepFor(0.1);
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.tweaker = new SoundTweaker(this.synth, string, unitSource);
        this.add((Component)this.tweaker, "Center");
        this.validate();
    }

    public void start() {
        this.synth.start();
        this.lineOut.start();
    }

    public void stop() {
        this.synth.stop();
    }

    public static void main(String[] stringArray) {
        InstrumentTester instrumentTester = new InstrumentTester();
        JAppletFrame jAppletFrame = new JAppletFrame("InstrumentTester", instrumentTester);
        jAppletFrame.setSize(600, 800);
        jAppletFrame.setVisible(true);
        jAppletFrame.test();
    }
}

