/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.util;

import com.aliasi.util.Streams;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class Files {
    private static String FILE_URL_PREFIX = "file:///";
    private static final String TEMP_DIRECTORY_SYS_PROPERTY = "java.io.tmpdir";
    public static final FileFilter NON_CVS_DIRECTORY_FILE_FILTER = new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory() && !file.getName().equalsIgnoreCase("CVS");
        }
    };
    public static final FileFilter FILES_ONLY_FILE_FILTER = new FileFilter(){

        public boolean accept(File file) {
            return file.isFile();
        }
    };

    private Files() {
    }

    public static void writeBytesToFile(byte[] bytes, File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        out.write(bytes);
        Streams.closeOutputStream(out);
    }

    public static byte[] readBytesFromFile(File file) throws IOException {
        long fileLength = file.length();
        if (fileLength > Integer.MAX_VALUE) {
            String msg = "Files must be less than Integer.MAX_VALUE=2147483647 in length. Found file.length()=" + file.length();
            throw new IllegalArgumentException(msg);
        }
        FileInputStream in = new FileInputStream(file);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream((int)fileLength);
        Streams.copy(in, bytesOut);
        Streams.closeInputStream(in);
        return bytesOut.toByteArray();
    }

    public static void writeCharsToFile(char[] chars, File file, String encoding) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, encoding);
        writer.write(chars);
        Streams.closeWriter(writer);
    }

    public static void writeStringToFile(String s, File file, String encoding) throws IOException {
        Files.writeCharsToFile(s.toCharArray(), file, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] readCharsFromFile(File file, String encoding) throws IOException {
        long fileLength = file.length();
        if (fileLength > Integer.MAX_VALUE) {
            String msg = "Files must be less than Integer.MAX_VALUE=2147483647 in length. Found file.length()=" + file.length();
            throw new IllegalArgumentException(msg);
        }
        CharArrayWriter charWriter = new CharArrayWriter((int)fileLength);
        FileInputStream in = null;
        InputStreamReader inReader = null;
        BufferedReader bufferedReader = null;
        try {
            in = new FileInputStream(file);
            inReader = new InputStreamReader((InputStream)in, encoding);
            bufferedReader = new BufferedReader(inReader);
            Streams.copy(bufferedReader, charWriter);
        }
        catch (Throwable throwable) {
            Streams.closeReader(bufferedReader);
            Streams.closeReader(inReader);
            Streams.closeInputStream(in);
            throw throwable;
        }
        Streams.closeReader(bufferedReader);
        Streams.closeReader(inReader);
        Streams.closeInputStream(in);
        return charWriter.toCharArray();
    }

    public static String readFromFile(File file, String encoding) throws IOException {
        return new String(Files.readCharsFromFile(file, encoding));
    }

    public static String baseName(File file) {
        return Files.prefix(file.getName());
    }

    static String prefix(String name) {
        int lastDotIndex = name.lastIndexOf(46);
        if (lastDotIndex < 0) {
            return name;
        }
        return name.substring(0, lastDotIndex);
    }

    public static String extension(File file) {
        String name = file.getName();
        int lastDotIndex = name.lastIndexOf(46);
        if (lastDotIndex < 0) {
            return null;
        }
        return name.substring(lastDotIndex + 1);
    }

    public static int removeRecursive(File file) {
        if (file == null) {
            return 0;
        }
        int descCount = Files.removeDescendants(file);
        file.delete();
        return descCount + 1;
    }

    public static int removeDescendants(File file) {
        if (!file.isDirectory()) {
            return 0;
        }
        int count = 0;
        File[] files = file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            count += Files.removeRecursive(files[i]);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File from, File to) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(from);
            out = new FileOutputStream(to);
            byte[] bytes = new byte[4096];
            int len = 0;
            while ((len = in.read(bytes)) >= 0) {
                out.write(bytes, 0, len);
            }
        }
        catch (Throwable throwable) {
            Streams.closeInputStream(in);
            Streams.closeOutputStream(out);
            throw throwable;
        }
        Streams.closeInputStream(in);
        Streams.closeOutputStream(out);
    }
}

