/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.tag;

import com.aliasi.classify.ConditionalClassification;
import com.aliasi.classify.ConditionalClassifierEvaluator;
import com.aliasi.corpus.ObjectHandler;
import com.aliasi.tag.MarginalTagger;
import com.aliasi.tag.NBestTaggerEvaluator;
import com.aliasi.tag.TagLattice;
import com.aliasi.tag.TaggerEvaluator;
import com.aliasi.tag.Tagging;
import com.aliasi.util.ObjectToDoubleMap;
import com.aliasi.util.Strings;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarginalTaggerEvaluator<E>
implements ObjectHandler<Tagging<E>> {
    private MarginalTagger<E> mTagger;
    private final Set<String> mTagSet;
    private final boolean mStoreTokens;
    private final ConditionalClassifierEvaluator<E> mEval;
    private Tagging<E> mLastReferenceTagging;

    public MarginalTaggerEvaluator(MarginalTagger<E> tagger, Set<String> tagSet, boolean storeTokens) {
        this.mTagger = tagger;
        this.mTagSet = new HashSet<String>(tagSet);
        this.mStoreTokens = storeTokens;
        String[] tags = tagSet.toArray(Strings.EMPTY_STRING_ARRAY);
        this.mEval = new ConditionalClassifierEvaluator(null, tags, storeTokens);
    }

    public MarginalTagger<E> tagger() {
        return this.mTagger;
    }

    public void setTagger(MarginalTagger<E> tagger) {
        this.mTagger = tagger;
    }

    public boolean storeTokens() {
        return this.mStoreTokens;
    }

    public Set<String> tagSet() {
        return Collections.unmodifiableSet(this.mTagSet);
    }

    public void addCase(Tagging<E> referenceTagging, TagLattice<E> responseLattice) {
        this.mLastReferenceTagging = referenceTagging;
        if (referenceTagging.size() != responseLattice.numTokens()) {
            String msg = "Reference and response must have the same number of tokens. Found referenceTagging.size()=" + referenceTagging.size() + " responseLattice.numTokens()=" + responseLattice.numTokens();
            throw new IllegalArgumentException(msg);
        }
        for (int i = 0; i < referenceTagging.size(); ++i) {
            if (referenceTagging.token(i).equals(responseLattice.token(i))) continue;
            String msg = "Reference and response token lists must be the same. referenceTagging.token(" + i + ")=|" + referenceTagging.token(i) + "|" + " responseLattice.token(" + i + ")=|" + responseLattice.token(i) + "|";
            throw new IllegalArgumentException(msg);
        }
        for (String tag : referenceTagging.tags()) {
            if (this.mTagSet.contains(tag)) continue;
            String msg = "Unknown tag in reference tagging. Unknown tag=" + tag + " reference tagging=" + referenceTagging;
            throw new IllegalArgumentException(msg);
        }
        List<String> responseTags = responseLattice.tagList();
        for (String tag : responseTags) {
            if (this.mTagSet.contains(tag)) continue;
            String msg = "Unknown tag in output lattice. Tag=" + tag + " referenceTagging=" + referenceTagging;
            throw new IllegalArgumentException(msg);
        }
        List<E> tokens = referenceTagging.tokens();
        for (int n = 0; n < tokens.size(); ++n) {
            E token = referenceTagging.token(n);
            List<String> tags = responseLattice.tagList();
            String referenceTag = referenceTagging.tag(n);
            ObjectToDoubleMap<String> tagToScore = new ObjectToDoubleMap<String>();
            for (int i = 0; i < tags.size(); ++i) {
                tagToScore.set(responseTags.get(i), Math.exp(responseLattice.logProbability(n, i)));
            }
            List responseTagsList = tagToScore.keysOrderedByValueList();
            String[] responseTagArray = responseTags.toArray(Strings.EMPTY_STRING_ARRAY);
            double[] responseProbs = new double[responseTags.size()];
            for (int i = 0; i < responseTagArray.length; ++i) {
                responseProbs[i] = tagToScore.getValue(responseTagArray[i]);
            }
            ConditionalClassification responseClassification = ConditionalClassification.createProbs(responseTagArray, responseProbs);
            this.mEval.addClassification(referenceTag, responseClassification, token);
        }
    }

    @Override
    public void handle(Tagging<E> referenceTagging) {
        List<E> tokens = referenceTagging.tokens();
        TagLattice<E> responseLattice = this.mTagger.tagMarginal(tokens);
        this.addCase(referenceTagging, responseLattice);
    }

    public String lastCaseToString(int maxTagsPerToken) {
        if (this.mLastReferenceTagging == null) {
            return "No cases seen yet.";
        }
        List<E> tokenList = this.mLastReferenceTagging.tokens();
        TagLattice<E> lattice = this.mTagger.tagMarginal(tokenList);
        StringBuilder sb = new StringBuilder();
        sb.append("Index Token  RefTag  (Prob:ResponseTag)*\n");
        for (int tokenIndex = 0; tokenIndex < tokenList.size(); ++tokenIndex) {
            ConditionalClassification tagScores = lattice.tokenClassification(tokenIndex);
            sb.append(TaggerEvaluator.pad(Integer.toString(tokenIndex), 4));
            sb.append(TaggerEvaluator.pad(tokenList.get(tokenIndex), 15));
            String refTag = this.mLastReferenceTagging.tag(tokenIndex);
            sb.append(TaggerEvaluator.pad(refTag, 6));
            sb.append("  ");
            for (int i = 0; i < maxTagsPerToken; ++i) {
                double conditionalProb = tagScores.score(i);
                String tag = tagScores.category(i);
                sb.append(" " + NBestTaggerEvaluator.format(conditionalProb) + ":" + TaggerEvaluator.pad(tag, 4));
                sb.append(tag.equals(refTag) ? "* " : "  ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public ConditionalClassifierEvaluator<E> perTokenEval() {
        return this.mEval;
    }
}

