/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.features;

import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.BinaryMap;
import com.aliasi.util.FeatureExtractor;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringLengthFeatureExtractor
implements FeatureExtractor<CharSequence>,
Serializable {
    static final long serialVersionUID = 4390057742097519384L;
    private final int[] mLengths;
    private final String[] mFeatureNames;

    public StringLengthFeatureExtractor(int ... lengths) {
        if (lengths.length < 1) {
            String msg = "Require non-empty array of lengths.";
            throw new IllegalArgumentException(msg);
        }
        for (int i = 0; i < lengths.length; ++i) {
            if (lengths[i] >= 0) continue;
            String msg = "Lengths must be non-negative. Found lengths[" + i + "]=" + lengths[i];
            throw new IllegalArgumentException(msg);
        }
        TreeSet<Integer> lengthSet = new TreeSet<Integer>();
        for (int length : lengths) {
            lengthSet.add(length);
        }
        this.mLengths = new int[lengthSet.size()];
        int pos = 0;
        for (Integer length : lengthSet) {
            this.mLengths[pos] = length;
            ++pos;
        }
        this.mFeatureNames = new String[this.mLengths.length];
        for (int i = 0; i < this.mLengths.length; ++i) {
            this.mFeatureNames[i] = "LEN>=" + this.mLengths[i];
        }
    }

    @Override
    public Map<String, ? extends Number> features(CharSequence in) {
        int end;
        int len = in.length();
        for (end = 0; end < this.mLengths.length && len >= this.mLengths[end]; ++end) {
        }
        if (end == 0) {
            return Collections.emptyMap();
        }
        BinaryMap<String> features = new BinaryMap<String>();
        for (int i = 0; i < end; ++i) {
            features.add(this.mFeatureNames[i]);
        }
        return features;
    }

    Object writeReplace() {
        return new Serializer(this);
    }

    static class Serializer
    extends AbstractExternalizable {
        static final long serialVersionUID = 5726292832004631457L;
        StringLengthFeatureExtractor mExtractor;

        public Serializer() {
            this(null);
        }

        public Serializer(StringLengthFeatureExtractor extractor) {
            this.mExtractor = extractor;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            Serializer.writeInts(this.mExtractor.mLengths, out);
        }

        public Object read(ObjectInput in) throws IOException {
            int[] lengths = Serializer.readInts(in);
            return new StringLengthFeatureExtractor(lengths);
        }
    }
}

