/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.dict;

import com.aliasi.dict.AbstractDictionary;
import com.aliasi.dict.DictionaryEntry;
import com.aliasi.dict.Node;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.Compilable;
import com.aliasi.util.Iterators;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrieDictionary<C>
extends AbstractDictionary<C>
implements Serializable,
Compilable {
    static final long serialVersionUID = -6772406715071883449L;
    Node<C> mRootNode = new Node();

    @Override
    DictionaryEntry<C>[] phraseEntries(String phrase) {
        Node<C> node = this.mRootNode;
        for (int i = 0; i < phrase.length(); ++i) {
            if ((node = node.getDtr(phrase.charAt(i))) != null) continue;
            return Node.emptyEntries();
        }
        return node.mEntries;
    }

    @Override
    public Iterator<DictionaryEntry<C>> phraseEntryIt(String phrase) {
        return Iterators.array(this.phraseEntries(phrase));
    }

    @Override
    public void addEntry(DictionaryEntry<C> entry) {
        String phrase = entry.phrase();
        Node<C> node = this.mRootNode;
        for (int i = 0; i < phrase.length(); ++i) {
            node = node.getOrAddDtr(phrase.charAt(i));
        }
        node.addEntry(entry);
    }

    @Override
    public Iterator<DictionaryEntry<C>> iterator() {
        return new TrieIterator<C>(this.mRootNode);
    }

    private Object writeReplace() {
        return new Externalizer(this);
    }

    @Override
    public void compileTo(ObjectOutput out) throws IOException {
        out.writeObject(new Externalizer(this));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TrieIterator<D>
    extends Iterators.Buffered<DictionaryEntry<D>> {
        LinkedList<Node<D>> mQueue = new LinkedList();
        DictionaryEntry<D>[] mEntries;
        int mNextEntry = -1;

        TrieIterator(Node<D> root) {
            this.mQueue.add(root);
        }

        @Override
        protected DictionaryEntry<D> bufferNext() {
            while (this.mEntries == null && !this.mQueue.isEmpty()) {
                Node<D> node = this.mQueue.removeFirst();
                this.addDtrs(node.mDtrNodes);
                if (node.mEntries.length <= 0) continue;
                this.mEntries = node.mEntries;
                this.mNextEntry = 0;
            }
            if (this.mEntries == null) {
                return null;
            }
            DictionaryEntry<D> result = this.mEntries[this.mNextEntry++];
            if (this.mNextEntry >= this.mEntries.length) {
                this.mEntries = null;
            }
            return result;
        }

        void addDtrs(Node<D>[] dtrs) {
            int i = dtrs.length;
            while (--i >= 0) {
                if (dtrs[i] == null) {
                    System.out.println("ADDING=" + i);
                }
                this.mQueue.addFirst(dtrs[i]);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Externalizer<F>
    extends AbstractExternalizable {
        static final long serialVersionUID = -6351978792499636468L;
        private final TrieDictionary<F> mDictionary;

        public Externalizer(TrieDictionary<F> dict) {
            this.mDictionary = dict;
        }

        public Externalizer() {
            this(null);
        }

        @Override
        public Object read(ObjectInput in) throws IOException, ClassNotFoundException {
            TrieDictionary dict = new TrieDictionary();
            int numEntries = in.readInt();
            for (int i = 0; i < numEntries; ++i) {
                DictionaryEntry entry = (DictionaryEntry)in.readObject();
                dict.addEntry(entry);
            }
            return dict;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            int count = this.mDictionary.size();
            out.writeInt(count);
            for (DictionaryEntry<F> entry : this.mDictionary) {
                entry.compileTo(out);
            }
        }
    }
}

