/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.cluster;

import com.aliasi.cluster.ClusterScore;
import com.aliasi.cluster.LeafDendrogram;
import com.aliasi.cluster.LinkDendrogram;
import com.aliasi.stats.Statistics;
import com.aliasi.util.BoundedPriorityQueue;
import com.aliasi.util.Distance;
import com.aliasi.util.Scored;
import com.aliasi.util.ScoredObject;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Dendrogram<E>
implements Scored {
    private LinkDendrogram<E> mParent;
    private Dendrogram<E> mReferenceLink = this;

    Dendrogram() {
    }

    public LinkDendrogram<E> parent() {
        return this.mParent;
    }

    public Dendrogram<E> dereference() {
        LinkDendrogram<E> ancestor = this.mReferenceLink.parent();
        if (ancestor == null) {
            return this.mReferenceLink;
        }
        LinkDendrogram<E> nextAncestor = null;
        while ((nextAncestor = ancestor.parent()) != null) {
            ancestor = nextAncestor;
        }
        this.mReferenceLink = ancestor;
        return this.mReferenceLink;
    }

    public int size() {
        return this.memberSet().size();
    }

    public boolean contains(E elt) {
        return this.memberSet().contains(elt);
    }

    public Set<Set<E>> partitionK(int numClusters) {
        if (numClusters < 1) {
            String msg = "Require at least one cluster.  Found numClusters=" + numClusters;
            throw new IllegalArgumentException(msg);
        }
        if (this.size() < numClusters) {
            String msg = "This dendrogram contains only " + this.size() + " elements. " + " Require at least numClusters=" + numClusters;
            throw new IllegalArgumentException(msg);
        }
        BoundedPriorityQueue<Dendrogram<Dendrogram>> queue = new BoundedPriorityQueue<Dendrogram<Dendrogram>>(ScoredObject.comparator(), numClusters + 1);
        queue.offer(this);
        HashSet<Set<Set<E>>> resultSet = new HashSet<Set<Set<E>>>(numClusters);
        while (queue.size() + resultSet.size() < numClusters) {
            Dendrogram toSplit = (Dendrogram)queue.poll();
            toSplit.split(resultSet, queue);
        }
        for (Dendrogram dendrogram : queue) {
            resultSet.add(dendrogram.memberSet());
        }
        return resultSet;
    }

    public Set<Set<E>> partitionDistance(double maxDistance) {
        HashSet<Set<Set<E>>> clustering = new HashSet<Set<Set<E>>>();
        LinkedList<Dendrogram<Dendrogram>> stack = new LinkedList<Dendrogram<Dendrogram>>();
        stack.addFirst(this);
        while (!stack.isEmpty()) {
            Dendrogram curDendro = (Dendrogram)stack.removeFirst();
            if (curDendro.score() <= maxDistance) {
                clustering.add(curDendro.memberSet());
                continue;
            }
            curDendro.subpartitionDistance(stack);
        }
        return clustering;
    }

    void subpartitionDistance(LinkedList<Dendrogram<E>> stack) {
    }

    abstract void split(Collection<Set<E>> var1, BoundedPriorityQueue<Dendrogram<E>> var2);

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder();
        this.prettyPrint(sb, 0);
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb, 1);
        return sb.toString();
    }

    public abstract Set<E> memberSet();

    @Override
    public abstract double score();

    abstract void prettyPrint(StringBuilder var1, int var2);

    abstract void addMembers(Set<E> var1);

    abstract void toString(StringBuilder var1, int var2);

    public double withinClusterScatter(int numClusters, Distance<? super E> distance) {
        if (numClusters < 1 || numClusters > this.size()) {
            String msg = "Require number of clusters between 1 and size. Found numClusters=" + numClusters + " size()=" + this.size();
            throw new IllegalArgumentException(msg);
        }
        Set<Set<E>> clustering = this.partitionK(numClusters);
        return ClusterScore.withinClusterScatter(clustering, distance);
    }

    public double copheneticCorrelation(Distance<? super E> distance) {
        int size = this.size() * (this.size() - 1) / 2;
        double[] xs = new double[size];
        double[] ys = new double[size];
        this.copheneticCorrelation(0, xs, ys, distance);
        return Statistics.correlation(xs, ys);
    }

    public static <E> boolean structurallyEquivalent(Dendrogram<E> dendrogram1, Dendrogram<E> dendrogram2) {
        if (dendrogram1 instanceof LeafDendrogram) {
            if (!(dendrogram2 instanceof LeafDendrogram)) {
                return false;
            }
            LeafDendrogram leafDendrogram1 = (LeafDendrogram)dendrogram1;
            LeafDendrogram leafDendrogram2 = (LeafDendrogram)dendrogram2;
            return leafDendrogram1.object().equals(leafDendrogram2.object()) && leafDendrogram1.score() == leafDendrogram2.score();
        }
        if (!(dendrogram2 instanceof LinkDendrogram)) {
            return false;
        }
        LinkDendrogram linkDendrogram1 = (LinkDendrogram)dendrogram1;
        LinkDendrogram linkDendrogram2 = (LinkDendrogram)dendrogram2;
        if (linkDendrogram1.score() != linkDendrogram2.score()) {
            return false;
        }
        return Dendrogram.structurallyEquivalent(linkDendrogram1.dendrogram1(), linkDendrogram2.dendrogram1()) && Dendrogram.structurallyEquivalent(linkDendrogram1.dendrogram2(), linkDendrogram2.dendrogram2()) || Dendrogram.structurallyEquivalent(linkDendrogram1.dendrogram1(), linkDendrogram2.dendrogram2()) && Dendrogram.structurallyEquivalent(linkDendrogram1.dendrogram2(), linkDendrogram2.dendrogram1());
    }

    abstract int copheneticCorrelation(int var1, double[] var2, double[] var3, Distance<? super E> var4);

    void indent(StringBuilder sb, int indent) {
        sb.append('\n');
        for (int i = 0; i < indent; ++i) {
            sb.append("    ");
        }
    }

    void setParent(LinkDendrogram<E> parent) {
        this.mParent = parent;
        this.mReferenceLink = parent;
    }
}

