/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.classify;

import com.aliasi.classify.Classification;
import com.aliasi.classify.Classified;
import com.aliasi.classify.ScoredClassification;
import com.aliasi.classify.ScoredClassifier;
import com.aliasi.corpus.Corpus;
import com.aliasi.corpus.ObjectHandler;
import com.aliasi.features.Features;
import com.aliasi.matrix.KernelFunction;
import com.aliasi.matrix.Vector;
import com.aliasi.symbol.MapSymbolTable;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.Arrays;
import com.aliasi.util.FeatureExtractor;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerceptronClassifier<E>
implements ScoredClassifier<E>,
Serializable {
    static final long serialVersionUID = 8752291174601085455L;
    final FeatureExtractor<? super E> mFeatureExtractor;
    final MapSymbolTable mSymbolTable;
    final KernelFunction mKernelFunction;
    final Vector[] mBasisVectors;
    final int[] mBasisWeights;
    final String mAcceptCategory;
    final String mRejectCategory;
    static final Vector[] EMPTY_SPARSE_FLOAT_VECTOR_ARRAY = new Vector[0];
    static final int INITIAL_BASIS_SIZE = 32768;

    PerceptronClassifier(FeatureExtractor<? super E> featureExtractor, KernelFunction kernelFunction, MapSymbolTable symbolTable, Vector[] basisVectors, int[] basisWeights, String acceptCategory, String rejectCategory) {
        this.mFeatureExtractor = featureExtractor;
        this.mKernelFunction = kernelFunction;
        this.mBasisVectors = basisVectors;
        this.mBasisWeights = basisWeights;
        this.mAcceptCategory = acceptCategory;
        this.mRejectCategory = rejectCategory;
        this.mSymbolTable = symbolTable;
    }

    public PerceptronClassifier(Corpus<ObjectHandler<Classified<E>>> corpus, FeatureExtractor<? super E> featureExtractor, KernelFunction kernelFunction, String corpusAcceptCategory, int numIterations, String outputAcceptCategory, String outputRejectCategory) throws IOException {
        this.mFeatureExtractor = featureExtractor;
        this.mKernelFunction = kernelFunction;
        this.mAcceptCategory = outputAcceptCategory;
        this.mRejectCategory = outputRejectCategory;
        this.mSymbolTable = new MapSymbolTable();
        CorpusCollector collector = new CorpusCollector();
        corpus.visitCorpus(collector);
        Vector[] featureVectors = collector.featureVectors();
        boolean[] polarities = collector.polarities();
        corpus = null;
        int currentPerceptronIndex = -1;
        int[] weights = new int[32768];
        int[] basisIndexes = new int[32768];
        for (int iteration = 0; iteration < numIterations; ++iteration) {
            for (int i = 0; i < featureVectors.length; ++i) {
                boolean accept;
                double yHat = this.prediction(featureVectors[i], featureVectors, polarities, weights, basisIndexes, currentPerceptronIndex);
                boolean bl = accept = yHat > 0.0;
                if (accept == polarities[i]) {
                    if (currentPerceptronIndex < 0) continue;
                    int n = currentPerceptronIndex;
                    weights[n] = weights[n] + 1;
                    continue;
                }
                if (++currentPerceptronIndex >= weights.length) {
                    weights = Arrays.reallocate(weights);
                    basisIndexes = Arrays.reallocate(basisIndexes);
                }
                basisIndexes[currentPerceptronIndex] = i;
                weights[currentPerceptronIndex] = 1;
            }
        }
        HashMap<Integer, Integer> renumbering = new HashMap<Integer, Integer>();
        int next = 0;
        for (int i = 0; i <= currentPerceptronIndex; ++i) {
            if (renumbering.containsKey(basisIndexes[i])) continue;
            renumbering.put(basisIndexes[i], next++);
        }
        this.mBasisVectors = new Vector[renumbering.size()];
        this.mBasisWeights = new int[renumbering.size()];
        int weightSum = 0;
        int i = currentPerceptronIndex + 1;
        while (--i >= 0) {
            int oldIndex = basisIndexes[i];
            int newIndex = (Integer)renumbering.get(oldIndex);
            this.mBasisVectors[newIndex] = featureVectors[oldIndex];
            weightSum += weights[i];
            if (polarities[i]) {
                int n = newIndex;
                this.mBasisWeights[n] = this.mBasisWeights[n] + weightSum;
                continue;
            }
            int n = newIndex;
            this.mBasisWeights[n] = this.mBasisWeights[n] - weightSum;
        }
    }

    public KernelFunction kernelFunction() {
        return this.mKernelFunction;
    }

    public FeatureExtractor<? super E> featureExtractor() {
        return this.mFeatureExtractor;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Averaged Perceptron");
        sb.append("  Kernel Function=" + this.mKernelFunction + "\n");
        for (int i = 0; i < this.mBasisVectors.length; ++i) {
            sb.append("  idx=" + i + " " + "vec=" + this.mBasisVectors[i] + " wgt=" + this.mBasisWeights[i] + "\n");
        }
        return sb.toString();
    }

    @Override
    public ScoredClassification classify(E in) {
        Map<String, Number> featureVector = this.mFeatureExtractor.features(in);
        Vector inputVector = Features.toVector(featureVector, this.mSymbolTable, Integer.MAX_VALUE, false);
        double sum = 0.0;
        int i = this.mBasisVectors.length;
        while (--i >= 0) {
            sum += (double)this.mBasisWeights[i] * this.mKernelFunction.proximity(this.mBasisVectors[i], inputVector);
        }
        return sum > 0.0 ? new ScoredClassification(new String[]{this.mAcceptCategory, this.mRejectCategory}, new double[]{sum, -sum}) : new ScoredClassification(new String[]{this.mRejectCategory, this.mAcceptCategory}, new double[]{-sum, sum});
    }

    double prediction(Vector inputVector, Vector[] featureVectors, boolean[] polarities, int[] ignoreMyWeights, int[] basisIndexes, int currentPerceptronIndex) {
        double sum = 0.0;
        int weightSum = 1;
        for (int i = currentPerceptronIndex; i >= 0; --i) {
            int index = basisIndexes[i];
            double kernel = this.mKernelFunction.proximity(inputVector, featureVectors[index]);
            double total = (double)(polarities[i] ? weightSum : -weightSum) * kernel;
            sum += total;
        }
        return sum;
    }

    static double power(double base, int exponent) {
        switch (exponent) {
            case 0: {
                return 1.0;
            }
            case 1: {
                return base;
            }
            case 2: {
                return base * base;
            }
            case 3: {
                return base * base * base;
            }
            case 4: {
                return base * base * base * base;
            }
        }
        return Math.pow(base, exponent);
    }

    private Object writeReplace() {
        return new Externalizer(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Externalizer<F>
    extends AbstractExternalizable {
        static final long serialVersionUID = -1901362811305741506L;
        final PerceptronClassifier<F> mClassifier;

        public Externalizer() {
            this(null);
        }

        public Externalizer(PerceptronClassifier<F> classifier) {
            this.mClassifier = classifier;
        }

        @Override
        public Object read(ObjectInput in) throws ClassNotFoundException, IOException {
            FeatureExtractor featureExtractor = (FeatureExtractor)in.readObject();
            KernelFunction kernelFunction = (KernelFunction)in.readObject();
            MapSymbolTable symbolTable = (MapSymbolTable)in.readObject();
            int basisLen = in.readInt();
            Vector[] basisVectors = new Vector[basisLen];
            for (int i = 0; i < basisLen; ++i) {
                basisVectors[i] = (Vector)in.readObject();
            }
            int[] basisWeights = new int[basisLen];
            for (int i = 0; i < basisLen; ++i) {
                basisWeights[i] = in.readInt();
            }
            String acceptCategory = in.readUTF();
            String rejectCategory = in.readUTF();
            return new PerceptronClassifier(featureExtractor, kernelFunction, symbolTable, basisVectors, basisWeights, acceptCategory, rejectCategory);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            int i;
            AbstractExternalizable.compileOrSerialize(this.mClassifier.mFeatureExtractor, out);
            AbstractExternalizable.compileOrSerialize(this.mClassifier.mKernelFunction, out);
            out.writeObject(this.mClassifier.mSymbolTable);
            out.writeInt(this.mClassifier.mBasisVectors.length);
            for (i = 0; i < this.mClassifier.mBasisVectors.length; ++i) {
                out.writeObject(this.mClassifier.mBasisVectors[i]);
            }
            for (i = 0; i < this.mClassifier.mBasisWeights.length; ++i) {
                out.writeInt(this.mClassifier.mBasisWeights[i]);
            }
            out.writeUTF(this.mClassifier.mAcceptCategory);
            out.writeUTF(this.mClassifier.mRejectCategory);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CorpusCollector
    implements ObjectHandler<Classified<E>> {
        final List<Vector> mInputFeatureVectorList = new ArrayList<Vector>();
        final List<Boolean> mInputAcceptList = new ArrayList<Boolean>();

        CorpusCollector() {
        }

        @Override
        public void handle(Classified<E> classified) {
            Object object = classified.getObject();
            Classification c = classified.getClassification();
            Map<String, Number> featureMap = PerceptronClassifier.this.mFeatureExtractor.features(object);
            this.mInputFeatureVectorList.add(Features.toVectorAddSymbols(featureMap, PerceptronClassifier.this.mSymbolTable, Integer.MAX_VALUE, false));
            this.mInputAcceptList.add(PerceptronClassifier.this.mAcceptCategory.equals(c.bestCategory()) ? Boolean.TRUE : Boolean.FALSE);
        }

        Vector[] featureVectors() {
            return this.mInputFeatureVectorList.toArray(EMPTY_SPARSE_FLOAT_VECTOR_ARRAY);
        }

        boolean[] polarities() {
            boolean[] categories = new boolean[this.mInputAcceptList.size()];
            for (int i = 0; i < categories.length; ++i) {
                categories[i] = this.mInputAcceptList.get(i);
            }
            return categories;
        }
    }
}

