/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.chunk;

import com.aliasi.chunk.AbstractTagChunkCodec;
import com.aliasi.chunk.Chunk;
import com.aliasi.chunk.ChunkFactory;
import com.aliasi.chunk.Chunking;
import com.aliasi.chunk.ChunkingImpl;
import com.aliasi.symbol.SymbolTable;
import com.aliasi.tag.StringTagging;
import com.aliasi.tag.TagLattice;
import com.aliasi.tag.Tagging;
import com.aliasi.tokenizer.Tokenizer;
import com.aliasi.tokenizer.TokenizerFactory;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.BoundedPriorityQueue;
import com.aliasi.util.Iterators;
import com.aliasi.util.Math;
import com.aliasi.util.Scored;
import com.aliasi.util.ScoredObject;
import com.aliasi.util.Strings;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BioTagChunkCodec
extends AbstractTagChunkCodec
implements Serializable {
    static final long serialVersionUID = -4597052413756614276L;
    private final String mBeginTagPrefix;
    private final String mInTagPrefix;
    private final String mOutTag;
    public static final String OUT_TAG = "O";
    public static final String BEGIN_TAG_PREFIX = "B_";
    public static final String IN_TAG_PREFIX = "I_";
    static final int PREFIX_LENGTH = 2;

    public BioTagChunkCodec() {
        this(null, false);
    }

    public BioTagChunkCodec(TokenizerFactory tokenizerFactory, boolean enforceConsistency) {
        this(tokenizerFactory, enforceConsistency, BEGIN_TAG_PREFIX, IN_TAG_PREFIX, OUT_TAG);
    }

    public BioTagChunkCodec(TokenizerFactory tokenizerFactory, boolean enforceConsistency, String beginTagPrefix, String inTagPrefix, String outTag) {
        super(tokenizerFactory, enforceConsistency);
        this.mOutTag = outTag;
        this.mBeginTagPrefix = beginTagPrefix;
        this.mInTagPrefix = inTagPrefix;
    }

    @Override
    public boolean enforceConsistency() {
        return this.mEnforceConsistency;
    }

    @Override
    public Set<String> tagSet(Set<String> chunkTypes) {
        HashSet<String> tagSet = new HashSet<String>();
        tagSet.add(this.mOutTag);
        for (String chunkType : chunkTypes) {
            tagSet.add(this.mBeginTagPrefix + chunkType);
            tagSet.add(this.mInTagPrefix + chunkType);
        }
        return tagSet;
    }

    @Override
    public boolean legalTagSubSequence(String ... tags) {
        if (tags.length == 0) {
            return true;
        }
        if (tags.length == 1) {
            return this.legalTagSingle(tags[0]);
        }
        for (int i = 1; i < tags.length; ++i) {
            if (this.legalTagPair(tags[i - 1], tags[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean legalTags(String ... tags) {
        return this.legalTagSubSequence(tags) && (tags.length == 0 || !tags[0].startsWith(this.mInTagPrefix));
    }

    @Override
    public Chunking toChunking(StringTagging tagging) {
        this.enforceConsistency(tagging);
        ChunkingImpl chunking = new ChunkingImpl(tagging.characters());
        for (int n = 0; n < tagging.size(); ++n) {
            String tag = tagging.tag(n);
            if (this.mOutTag.equals(tag)) continue;
            if (!tag.startsWith(this.mBeginTagPrefix)) {
                String msg;
                if (n == 0) {
                    msg = "First tag must be out or begin. Found tagging.tag(0)=" + tagging.tag(0);
                    throw new IllegalArgumentException(msg);
                }
                msg = "Illegal tag sequence. tagging.tag(" + (n - 1) + ")=" + tagging.tag(n - 1) + " tagging.tag(" + n + ")=" + tagging.tag(n);
                throw new IllegalArgumentException(msg);
            }
            String type = tag.substring(2);
            int start = tagging.tokenStart(n);
            String inTag = this.mInTagPrefix + type;
            while (n + 1 < tagging.size() && inTag.equals(tagging.tag(n + 1))) {
                ++n;
            }
            int end = tagging.tokenEnd(n);
            Chunk chunk = ChunkFactory.createChunk(start, end, type);
            chunking.add(chunk);
        }
        return chunking;
    }

    @Override
    public StringTagging toStringTagging(Chunking chunking) {
        if (this.mTokenizerFactory == null) {
            String msg = "Tokenizer factory must be non-null to convert chunking to tagging.";
            throw new UnsupportedOperationException(msg);
        }
        this.enforceConsistency(chunking);
        ArrayList<String> tokenList = new ArrayList<String>();
        ArrayList<String> tagList = new ArrayList<String>();
        ArrayList<Integer> tokenStartList = new ArrayList<Integer>();
        ArrayList<Integer> tokenEndList = new ArrayList<Integer>();
        this.toTagging(chunking, tokenList, tagList, tokenStartList, tokenEndList);
        StringTagging tagging = new StringTagging(tokenList, tagList, chunking.charSequence(), tokenStartList, tokenEndList);
        return tagging;
    }

    @Override
    public Tagging<String> toTagging(Chunking chunking) {
        if (this.mTokenizerFactory == null) {
            String msg = "Tokenizer factory must be non-null to convert chunking to tagging.";
            throw new UnsupportedOperationException(msg);
        }
        this.enforceConsistency(chunking);
        ArrayList<String> tokens = new ArrayList<String>();
        ArrayList<String> tags = new ArrayList<String>();
        this.toTagging(chunking, tokens, tags, null, null);
        return new Tagging<String>(tokens, tags);
    }

    @Override
    public Iterator<Chunk> nBestChunks(TagLattice<String> lattice, int[] tokenStarts, int[] tokenEnds, int maxResults) {
        int i;
        if (maxResults < 0) {
            String msg = "Require non-negative number of results.";
            throw new IllegalArgumentException(msg);
        }
        if (tokenStarts.length != lattice.numTokens()) {
            String msg = "Token starts must line up with num tokens. Found tokenStarts.length=" + tokenStarts.length + " lattice.numTokens()=" + lattice.numTokens();
            throw new IllegalArgumentException(msg);
        }
        if (tokenEnds.length != lattice.numTokens()) {
            String msg = "Token ends must line up with num tokens. Found tokenEnds.length=" + tokenEnds.length + " lattice.numTokens()=" + lattice.numTokens();
            throw new IllegalArgumentException(msg);
        }
        for (i = 1; i < tokenStarts.length; ++i) {
            if (tokenStarts[i - 1] > tokenStarts[i]) {
                String msg = "Token starts must be in order. Found tokenStarts[" + (i - 1) + "]=" + tokenStarts[i - 1] + " tokenStarts[" + i + "]=" + tokenStarts[i];
                throw new IllegalArgumentException(msg);
            }
            if (tokenEnds[i - 1] <= tokenEnds[i]) continue;
            String msg = "Token ends must be in order. Found tokenEnds[" + (i - 1) + "]=" + tokenEnds[i - 1] + " tokenEnds[" + i + "]=" + tokenEnds[i];
            throw new IllegalArgumentException(msg);
        }
        if (lattice.numTags() == 0) {
            return Iterators.empty();
        }
        for (i = 0; i < tokenStarts.length; ++i) {
            if (tokenStarts[i] <= tokenEnds[i]) continue;
            String msg = "Token ends must not precede starts. Found tokenStarts[" + i + "]=" + tokenStarts[i] + " tokenEnds[" + i + "]=" + tokenEnds[i];
            throw new IllegalArgumentException(msg);
        }
        return new NBestIterator(lattice, tokenStarts, tokenEnds, maxResults, this.mBeginTagPrefix, this.mInTagPrefix, this.mOutTag);
    }

    public String toString() {
        return "BioTagChunkCodec";
    }

    @Override
    void enforceConsistency(StringTagging tagging) {
        if (!this.mEnforceConsistency) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (this.isDecodable(tagging, sb)) {
            return;
        }
        throw new IllegalArgumentException(sb.toString());
    }

    @Override
    void enforceConsistency(Chunking chunking) {
        if (!this.mEnforceConsistency) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (this.isEncodable(chunking, sb)) {
            return;
        }
        throw new IllegalArgumentException(sb.toString());
    }

    boolean legalTagSingle(String tag) {
        return this.mOutTag.equals(tag) || tag.startsWith(this.mBeginTagPrefix) || tag.startsWith(this.mInTagPrefix);
    }

    boolean legalTagPair(String tag1, String tag2) {
        if (!this.legalTagSingle(tag1)) {
            return false;
        }
        if (!this.legalTagSingle(tag2)) {
            return false;
        }
        if (tag2.startsWith(this.mInTagPrefix)) {
            return tag1.endsWith(tag2.substring(this.mInTagPrefix.length()));
        }
        return true;
    }

    void toTagging(Chunking chunking, List<String> tokenList, List<String> tagList, List<Integer> tokenStartList, List<Integer> tokenEndList) {
        char[] cs = Strings.toCharArray(chunking.charSequence());
        Set<Chunk> chunkSet = chunking.chunkSet();
        Chunk[] chunks = chunkSet.toArray(new Chunk[chunkSet.size()]);
        Arrays.sort(chunks, Chunk.TEXT_ORDER_COMPARATOR);
        int pos = 0;
        for (Chunk chunk : chunks) {
            String type = chunk.type();
            int start = chunk.start();
            int end = chunk.end();
            this.outBioTag(cs, pos, start, tokenList, tagList, tokenStartList, tokenEndList);
            this.chunkBioTag(cs, type, start, end, tokenList, tagList, tokenStartList, tokenEndList);
            pos = end;
        }
        this.outBioTag(cs, pos, cs.length, tokenList, tagList, tokenStartList, tokenEndList);
    }

    void outBioTag(char[] cs, int start, int end, List<String> tokenList, List<String> tagList, List<Integer> tokenStartList, List<Integer> tokenEndList) {
        String token;
        int length = end - start;
        Tokenizer tokenizer = this.mTokenizerFactory.tokenizer(cs, start, length);
        while ((token = tokenizer.nextToken()) != null) {
            tokenList.add(token);
            this.addOffsets(tokenizer, start, tokenStartList, tokenEndList);
            tagList.add(this.mOutTag);
        }
    }

    void chunkBioTag(char[] cs, String type, int start, int end, List<String> tokenList, List<String> tagList, List<Integer> tokenStartList, List<Integer> tokenEndList) {
        String token;
        int length = end - start;
        Tokenizer tokenizer = this.mTokenizerFactory.tokenizer(cs, start, length);
        String firstToken = tokenizer.nextToken();
        if (firstToken == null) {
            String msg = "Chunks must contain at least one token. Found chunk with yield=|" + new String(cs, start, length) + "|";
            throw new IllegalArgumentException(msg);
        }
        tokenList.add(firstToken);
        this.addOffsets(tokenizer, start, tokenStartList, tokenEndList);
        String beginTag = this.mBeginTagPrefix + type;
        tagList.add(beginTag);
        String inTag = this.mInTagPrefix + type;
        while ((token = tokenizer.nextToken()) != null) {
            tokenList.add(token);
            this.addOffsets(tokenizer, start, tokenStartList, tokenEndList);
            tagList.add(inTag);
        }
    }

    void addOffsets(Tokenizer tokenizer, int offset, List<Integer> tokenStartList, List<Integer> tokenEndList) {
        if (tokenStartList == null) {
            return;
        }
        int start = tokenizer.lastTokenStartPosition() + offset;
        int end = tokenizer.lastTokenEndPosition() + offset;
        tokenStartList.add(start);
        tokenEndList.add(end);
    }

    Object writeReplace() {
        return new Serializer(this);
    }

    static class Serializer
    extends AbstractExternalizable {
        static final long serialVersionUID = -2473387657606045149L;
        private final BioTagChunkCodec mCodec;

        public Serializer() {
            this(null);
        }

        public Serializer(BioTagChunkCodec codec) {
            this.mCodec = codec;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeBoolean(this.mCodec.mEnforceConsistency);
            out.writeObject(Boolean.TRUE);
            out.writeObject(this.mCodec.mTokenizerFactory != null ? this.mCodec.mTokenizerFactory : Boolean.FALSE);
            out.writeUTF(this.mCodec.mBeginTagPrefix);
            out.writeUTF(this.mCodec.mInTagPrefix);
            out.writeUTF(this.mCodec.mOutTag);
        }

        public Object read(ObjectInput in) throws IOException, ClassNotFoundException {
            boolean enforceConsistency = in.readBoolean();
            Object obj = in.readObject();
            if (Boolean.TRUE.equals(obj)) {
                Object obj2 = in.readObject();
                TokenizerFactory tf = Boolean.FALSE.equals(obj2) ? null : (TokenizerFactory)obj2;
                String beginTagPrefix = in.readUTF();
                String inTagPrefix = in.readUTF();
                String outTag = in.readUTF();
                return new BioTagChunkCodec(tf, enforceConsistency, beginTagPrefix, inTagPrefix, outTag);
            }
            TokenizerFactory tf = Boolean.FALSE.equals(obj) ? null : (TokenizerFactory)obj;
            return new BioTagChunkCodec(tf, enforceConsistency);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NBestIterator
    extends Iterators.Buffered<Chunk> {
        private final String mBeginTagPrefix;
        private final String mInTagPrefix;
        private final String mOutTag;
        private final TagLattice<String> mLattice;
        private final int[] mTokenStarts;
        private final int[] mTokenEnds;
        private final BoundedPriorityQueue<Chunk> mChunkQueue;
        private final BoundedPriorityQueue<NBestState> mStateQueue;
        private final int mMaxResults;
        private final String[] mChunkTypes;
        private final int[] mBeginTagIds;
        private final int[] mInTagIds;
        private final int mOutTagId;
        private int mNumResults = 0;

        public NBestIterator(TagLattice<String> lattice, int[] tokenStarts, int[] tokenEnds, int maxResults, String beginTagPrefix, String inTagPrefix, String outTag) {
            this.mBeginTagPrefix = beginTagPrefix;
            this.mInTagPrefix = inTagPrefix;
            this.mOutTag = outTag;
            this.mLattice = lattice;
            this.mTokenStarts = tokenStarts;
            this.mTokenEnds = tokenEnds;
            this.mMaxResults = maxResults;
            HashSet<String> chunkTypeSet = new HashSet<String>();
            SymbolTable tagSymbolTable = lattice.tagSymbolTable();
            for (int k = 0; k < lattice.numTags(); ++k) {
                if (!lattice.tag(k).startsWith(this.mInTagPrefix)) continue;
                chunkTypeSet.add(lattice.tag(k).substring(this.mInTagPrefix.length()));
            }
            this.mChunkTypes = chunkTypeSet.toArray(Strings.EMPTY_STRING_ARRAY);
            this.mBeginTagIds = new int[this.mChunkTypes.length];
            this.mInTagIds = new int[this.mChunkTypes.length];
            for (int j = 0; j < this.mChunkTypes.length; ++j) {
                this.mBeginTagIds[j] = tagSymbolTable.symbolToID(this.mBeginTagPrefix + this.mChunkTypes[j]);
                this.mInTagIds[j] = tagSymbolTable.symbolToID(this.mInTagPrefix + this.mChunkTypes[j]);
            }
            this.mOutTagId = tagSymbolTable.symbolToID(this.mOutTag);
            this.mStateQueue = new BoundedPriorityQueue(ScoredObject.comparator(), maxResults);
            this.mChunkQueue = new BoundedPriorityQueue(ScoredObject.comparator(), maxResults);
            double[] nonContBuf = new double[lattice.numTags() - 1];
            for (int j = 0; j < this.mChunkTypes.length; ++j) {
                double nonCont;
                int n;
                int lastN = lattice.numTokens() - 1;
                if (lastN < 0) continue;
                String chunkType = this.mChunkTypes[j];
                int inTagId = this.mInTagIds[j];
                int beginTagId = this.mBeginTagIds[j];
                this.mChunkQueue.offer(ChunkFactory.createChunk(this.mTokenStarts[lastN], this.mTokenEnds[lastN], chunkType, lattice.logProbability(lastN, beginTagId)));
                if (lastN > 0) {
                    this.mStateQueue.offer(new NBestState(lattice.logBackward(lastN, inTagId), lastN, lastN, j));
                }
                for (n = 0; n < lastN; ++n) {
                    nonCont = this.nonContLogSumExp(j, n, beginTagId, lattice, nonContBuf);
                    this.mChunkQueue.offer(ChunkFactory.createChunk(this.mTokenStarts[n], this.mTokenEnds[n], chunkType, nonCont + lattice.logForward(n, beginTagId) - lattice.logZ()));
                }
                for (n = 1; n < lastN; ++n) {
                    nonCont = this.nonContLogSumExp(j, n, inTagId, lattice, nonContBuf);
                    this.mStateQueue.offer(new NBestState(nonCont, n, n, j));
                }
            }
        }

        double nonContLogSumExp(int j, int n, int fromTagId, TagLattice<String> lattice, double[] nonContBuf) {
            nonContBuf[0] = lattice.logBackward(n + 1, this.mOutTagId) + lattice.logTransition(n, fromTagId, this.mOutTagId);
            int bufPos = 1;
            for (int j2 = 0; j2 < this.mBeginTagIds.length; ++j2) {
                nonContBuf[bufPos++] = lattice.logBackward(n + 1, this.mBeginTagIds[j2]) + lattice.logTransition(n, fromTagId, this.mBeginTagIds[j2]);
                if (j == j2) continue;
                nonContBuf[bufPos++] = lattice.logBackward(n + 1, this.mInTagIds[j2]) + lattice.logTransition(n, fromTagId, this.mInTagIds[j2]);
            }
            double result = Math.logSumOfExponentials(nonContBuf);
            return result;
        }

        @Override
        public Chunk bufferNext() {
            if (this.mNumResults >= this.mMaxResults) {
                return null;
            }
            this.search();
            Chunk chunk = this.mChunkQueue.poll();
            if (chunk == null) {
                return null;
            }
            ++this.mNumResults;
            return chunk;
        }

        void search() {
            while (!this.mStateQueue.isEmpty() && (this.mChunkQueue.isEmpty() || this.mChunkQueue.peek().score() < this.mStateQueue.peek().score())) {
                NBestState state = this.mStateQueue.poll();
                this.extend(state);
            }
        }

        void extend(NBestState state) {
            int beginTagId = this.mBeginTagIds[state.mChunkId];
            int inTagId = this.mInTagIds[state.mChunkId];
            this.mChunkQueue.offer(ChunkFactory.createChunk(this.mTokenStarts[state.mPos - 1], this.mTokenEnds[state.mEndPos], this.mChunkTypes[state.mChunkId], state.score() + this.mLattice.logForward(state.mPos - 1, beginTagId) + this.mLattice.logTransition(state.mPos - 1, beginTagId, inTagId) - this.mLattice.logZ()));
            if (state.mPos > 1) {
                this.mStateQueue.offer(new NBestState(state.score() + this.mLattice.logTransition(state.mPos - 1, inTagId, inTagId), state.mPos - 1, state.mEndPos, state.mChunkId));
            }
        }

        static class NBestState
        implements Scored {
            private final double mScore;
            private final int mPos;
            private final int mEndPos;
            private int mChunkId;

            public NBestState(double score, int pos, int endPos, int chunkId) {
                this.mScore = score;
                this.mPos = pos;
                this.mEndPos = endPos;
                this.mChunkId = chunkId;
            }

            public double score() {
                return this.mScore;
            }

            public String toString() {
                return "score=" + this.mScore + " pos=" + this.mPos + " end=" + this.mEndPos + " id=" + this.mChunkId;
            }
        }
    }
}

