/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.util.cr.linereader;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.uima.UimaContext;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.util.ViewUriUtil;
import org.cleartk.util.cr.linereader.LineHandler;

public class DefaultLineHandler
implements LineHandler {
    int count;

    @Override
    public void initialize(UimaContext context) throws ResourceInitializationException {
        this.count = 1;
    }

    @Override
    public void handleLine(JCas jCas, File rootFile, File file, String line) throws IOException, CollectionException {
        URI uri;
        jCas.setSofaDataString(line, "text/plain");
        try {
            uri = new URI(String.format("%s#%d", file.toURI().toString(), this.count));
        }
        catch (URISyntaxException e) {
            throw new CollectionException((Throwable)e);
        }
        ViewUriUtil.setURI(jCas, uri);
        ++this.count;
    }
}

