/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.util.cr;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.XCASDeserializer;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.util.CleartkInitializationException;
import org.cleartk.util.cr.FilesCollectionReader;

public class XReader
extends FilesCollectionReader {
    public static final String XMI = "XMI";
    public static final String XCAS = "XCAS";
    public static final String PARAM_XML_SCHEME = "xmlScheme";
    @ConfigurationParameter(name="xmlScheme", mandatory=false, defaultValue={"XMI"}, description="specifies the UIMA XML serialization scheme that should be used. Valid values for this parameter are 'XMI' and 'XCAS'")
    private String xmlScheme;

    @Override
    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        if (!this.xmlScheme.equals(XMI) && !this.xmlScheme.equals(XCAS)) {
            throw CleartkInitializationException.invalidParameterValueSelectFrom(PARAM_XML_SCHEME, Arrays.asList(XMI, XCAS), this.xmlScheme);
        }
    }

    @Override
    public void getNext(JCas jCas) throws IOException, CollectionException {
        if (!this.hasNext()) {
            throw new RuntimeException("getNext(jCas) was called but hasNext() returns false");
        }
        try (FileInputStream inputStream = new FileInputStream(this.currentFile);){
            if (this.xmlScheme.equals(XMI)) {
                XmiCasDeserializer.deserialize((InputStream)inputStream, (CAS)jCas.getCas());
            } else {
                XCASDeserializer.deserialize((InputStream)inputStream, (CAS)jCas.getCas());
            }
        }
        ++this.completed;
        this.currentFile = null;
    }
}

