/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.mixins;

import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.AfterRender;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.InjectContainer;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SetupRender;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.Cookies;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

@Import(library={"../Chenillekit.js", "../Cookie.js", "${tapestry.scriptaculous}/dragdrop.js", "Resizable.js"}, stylesheet={"Resizable.css"})
public class Resizable
implements ClientElement {
    @InjectContainer
    private ClientElement clientElement;
    @Inject
    private ComponentResources resources;
    @Environmental
    private JavaScriptSupport javascriptSupport;
    @Inject
    private Cookies cookies;
    @Parameter(value="prop:componentResources.id", defaultPrefix="literal")
    private String clientId;
    @Parameter(defaultPrefix="literal")
    private String constraint;
    @Parameter(value="false", defaultPrefix="prop")
    private boolean persist;
    private String assignedClientId;

    @SetupRender
    void setupRender() {
        this.assignedClientId = this.javascriptSupport.allocateClientId(this.clientId);
    }

    @AfterRender
    void afterRender(MarkupWriter writer) {
        writer.element("div", new Object[]{"id", "handle_" + this.clientElement.getClientId(), "class", "ck-resizable-handle"});
        writer.end();
        if (this.persist) {
            int width = this.getIntValueFromCookie(this.clientElement.getClientId() + ".width");
            int height = this.getIntValueFromCookie(this.clientElement.getClientId() + ".height");
            if (width > 0) {
                this.javascriptSupport.addScript("$('%s').style.width = '%dpx';", new Object[]{this.clientElement.getClientId(), width});
            }
            if (height > 0) {
                this.javascriptSupport.addScript("$('%s').style.height = '%dpx';", new Object[]{this.clientElement.getClientId(), height});
            }
        }
        String jsString = "%s = new Resizable('%s', {handle:$('handle_%s')";
        if (this.constraint != null) {
            jsString = jsString + String.format(",constraint:'%s'", this.constraint);
        }
        jsString = jsString + ", persist:%s});";
        this.javascriptSupport.addScript(jsString, new Object[]{this.getClientId(), this.clientElement.getClientId(), this.clientElement.getClientId(), this.persist});
    }

    public String getClientId() {
        return this.assignedClientId;
    }

    private int getIntValueFromCookie(String key) {
        int intValue = 0;
        String cookieValue = this.cookies.readCookieValue(key);
        if (cookieValue != null) {
            try {
                intValue = Integer.parseInt(cookieValue);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException(e);
            }
        }
        return intValue;
    }
}

