/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.components.prototype_ui;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.ComponentEventCallback;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.FieldTranslator;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.ValidationTracker;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.corelib.base.AbstractField;
import org.apache.tapestry5.internal.util.Holder;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.ResponseRenderer;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

@Import(library={"../../Chenillekit.js", "prototype-ui.js", "AutoComplete.js"}, stylesheet={"themes/auto_complete/default.css", "themes/shadow/drop_shadow.css", "themes/shadow/auto_complete.css"})
public class AutoComplete
extends AbstractField {
    static final String EVENT_NAME = "autocomplete";
    private static final String PARAM_NAME = "search";
    @Parameter(required=true, allowNull=false)
    private List<Object> selected;
    @Parameter(required=true, allowNull=false, defaultPrefix="translate")
    private FieldTranslator<Object> translate;
    @Inject
    private Request request;
    @Inject
    private ResponseRenderer responseRenderer;
    @Inject
    private TypeCoercer coercer;
    @Inject
    private ComponentResources resources;
    @Environmental
    private JavaScriptSupport javascriptSupport;
    @Inject
    private PropertyAccess propertyAccess;
    @Environmental
    private ValidationTracker tracker;

    void beginRender(MarkupWriter writer) {
        writer.element("input", new Object[]{"type", "hidden", "name", this.getControlName(), "id", this.getClientId() + "-internal"});
        writer.end();
        writer.element("input", new Object[]{"type", "text", "id", this.getClientId()});
    }

    void afterRender(MarkupWriter writer) {
        writer.end();
        JSONObject config = new JSONObject();
        config.put("url", (Object)this.resources.createEventLink(EVENT_NAME, new Object[0]).toAbsoluteURI());
        config.put("preSelected", (Object)this.generateResponseMarkup(this.selected));
        this.configure(config);
        this.javascriptSupport.addScript("new Ck.AutoComplete('%s', %s);", new Object[]{this.getClientId(), config});
    }

    protected void configure(JSONObject options) {
    }

    JSONArray onAutocomplete() {
        String input = this.request.getParameter(PARAM_NAME);
        final Holder matchesHolder = Holder.create();
        matchesHolder.put(Collections.emptyList());
        ComponentEventCallback callback = new ComponentEventCallback(){

            public boolean handleResult(Object result) {
                List matches = (List)AutoComplete.this.coercer.coerce(result, List.class);
                matchesHolder.put((Object)matches);
                return true;
            }
        };
        this.resources.triggerEvent("providecompletions", new Object[]{input}, callback);
        return this.generateResponseMarkup((List)matchesHolder.get());
    }

    protected void processSubmission(String elementName) {
        String parameterValue = this.request.getParameter(elementName);
        String[] values = parameterValue.split(",");
        List selected = this.selected;
        if (selected == null) {
            selected = CollectionFactory.newList();
        } else {
            selected.clear();
        }
        int count = values.length;
        try {
            for (int i = 0; i < count; ++i) {
                String value = StringUtils.trim((String)values[i]);
                Object objectValue = this.translate.parse(value);
                if (objectValue == null) continue;
                selected.add(objectValue);
            }
        }
        catch (ValidationException ex) {
            this.tracker.recordError((Field)this, ex.getMessage());
        }
        this.selected = selected;
    }

    protected JSONArray generateResponseMarkup(List matches) {
        JSONArray jsonObject = new JSONArray();
        for (Object o : matches) {
            String value = this.translate.toClient(o);
            Object label = this.propertyAccess.get(o, this.getLabel());
            JSONObject item = new JSONObject();
            item.put("text", label);
            item.put("value", (Object)value);
            jsonObject.put((Object)item);
        }
        return jsonObject;
    }
}

