/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.components;

import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.runtime.Component;
import org.chenillekit.tapestry.core.components.PagedLoop;
import org.chenillekit.tapestry.core.internal.PagedSource;

@Import(stylesheet={"Pager.css"})
public class Pager {
    @Parameter
    private PagedSource<?> source;
    @Parameter
    private int rowsPerPage;
    @Parameter
    private int currentPage;
    @Parameter(defaultPrefix="literal", name="for")
    private String forId;
    @Parameter(value="5")
    private int range;
    private int lastIndex;
    private int maxPages;
    @Inject
    private ComponentResources resources;
    @Inject
    private Messages messages;
    private Component pagedLoopComponent;
    private PagedLoop pagedLoop;

    void setupRender() {
        if (this.forId != null) {
            this.source = this.getPagedLoop().getPagedSource();
            this.rowsPerPage = this.getPagedLoop().getRowsPerPage();
            this.currentPage = this.getPagedLoop().getCurrentPage();
        }
    }

    void beginRender(MarkupWriter writer) {
        int i;
        int availableRows = this.source.getTotalRowCount();
        this.maxPages = (availableRows - 1) / this.rowsPerPage + 1;
        if (this.maxPages < 2) {
            return;
        }
        writer.element(this.resources.getContainer().getComponentResources().getElementName(), new Object[]{"class", "ck_paged_loop_pager"});
        writer.element("div", new Object[]{"class", "ck_paged_loop_pager"});
        this.lastIndex = 0;
        for (int i2 = 1; i2 <= 2; ++i2) {
            this.writePageLink(writer, i2);
        }
        int low = this.currentPage - this.range;
        int high = this.currentPage + this.range;
        if (low < 1) {
            low = 1;
            high = 2 * this.range + 1;
        } else if (high > this.maxPages) {
            high = this.maxPages;
            low = high - 2 * this.range;
        }
        for (i = low; i <= high; ++i) {
            this.writePageLink(writer, i);
        }
        for (i = this.maxPages - 1; i <= this.maxPages; ++i) {
            this.writePageLink(writer, i);
        }
        writer.end();
        writer.end();
    }

    void onAction(int newPage) {
        this.currentPage = newPage;
        if (this.forId != null) {
            this.getPagedLoopComponent().getComponentResources().triggerEvent("action", (Object[])new Integer[]{newPage}, null);
        }
    }

    private Component getPagedLoopComponent() {
        if (this.forId != null && this.pagedLoopComponent == null) {
            this.pagedLoopComponent = this.resources.getPage().getComponentResources().getEmbeddedComponent(this.forId);
        }
        return this.pagedLoopComponent;
    }

    private PagedLoop getPagedLoop() {
        if (this.forId != null && this.pagedLoop == null) {
            this.pagedLoop = (PagedLoop)this.getPagedLoopComponent();
        }
        return this.pagedLoop;
    }

    private void writePageLink(MarkupWriter writer, int pageIndex) {
        if (pageIndex < 1 || pageIndex > this.maxPages) {
            return;
        }
        if (pageIndex <= this.lastIndex) {
            return;
        }
        if (pageIndex != this.lastIndex + 1) {
            writer.write(" ... ");
        }
        this.lastIndex = pageIndex;
        if (pageIndex == this.currentPage) {
            writer.element("span", new Object[]{"class", "ck_paged_loop_current"});
            writer.write(Integer.toString(pageIndex));
            writer.end();
            return;
        }
        Link link = this.resources.createEventLink("action", new Object[]{pageIndex});
        writer.element("a", new Object[]{"href", link, "title", this.messages.format("goto-page", new Object[]{pageIndex})});
        writer.write(Integer.toString(pageIndex));
        writer.end();
    }
}

