/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.components;

import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

@SupportsInformalParameters
@Import(library={"../Chenillekit.js", "FieldSet.js"}, stylesheet={"FieldSet.css"})
public class FieldSet {
    @Parameter(value="false", required=false)
    private boolean closed;
    @Parameter(value="prop:componentResources.id", defaultPrefix="literal")
    private String clientId;
    private String assignedClientId;
    @Environmental
    private JavaScriptSupport javascriptSupport;
    @Inject
    private ComponentResources resources;

    void setupRender() {
        this.assignedClientId = this.javascriptSupport.allocateClientId(this.clientId);
    }

    void beginRender(MarkupWriter writer) {
        writer.element("fieldset", new Object[]{"id", this.getClientId(), "class", "ck_fieldset"});
        this.resources.renderInformalParameters(writer);
    }

    void afterRender(MarkupWriter writer) {
        writer.end();
        this.javascriptSupport.addScript("var %s = new Ck.FieldSet('%s', %s);", new Object[]{this.getClientId(), this.getClientId(), this.closed});
    }

    public String getClientId() {
        return this.assignedClientId;
    }
}

