/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.LoggingMXBean;
import jdk.Profile+Annotation;
import org.checkerframework.checker.index.qual.LessThanUnknown;
import org.checkerframework.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.checker.index.qual.SameLenUnknown;
import org.checkerframework.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.common.value.qual.UnknownVal;

/*
 * Exception performing whole class analysis.
 * Exception performing whole class analysis ignored.
 */
@Profile+Annotation(value=1)
public class LogManager {
    private static final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown LogManager manager;
    private volatile @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Properties props;
    private static final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Level defaultLevel;
    private final Map<Object, Integer> listenerMap;
    private final LoggerContext systemContext;
    private final LoggerContext userContext;
    private volatile @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Logger rootLogger;
    private volatile @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown boolean readPrimordialConfiguration;
    private @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown boolean initializedGlobalHandlers;
    private @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown boolean deathImminent;
    private boolean initializedCalled;
    private volatile boolean initializationDone;
    private WeakHashMap<Object, LoggerContext> contextsMap;
    private final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown ReferenceQueue<@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Logger> loggerRefQueue;
    private static final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown int MAX_ITERATIONS = 400;
    private final Permission controlPermission;
    private static @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown LoggingMXBean loggingMXBean;
    public static final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String LOGGING_MXBEAN_NAME = "java.util.logging:type=Logging";

    protected LogManager();

    private LogManager(Void var1);

    private static Void checkSubclassPermissions();

    final void ensureLogManagerInitialized();

    public static @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown LogManager getLogManager();

    private void readPrimordialConfiguration();

    @Deprecated
    public void addPropertyChangeListener(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown PropertyChangeListener var1) throws SecurityException;

    @Deprecated
    public void removePropertyChangeListener(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown PropertyChangeListener var1) throws SecurityException;

    private LoggerContext getUserContext();

    final LoggerContext getSystemContext();

    private List<LoggerContext> contexts();

    Logger demandLogger(String var1, String var2, Class<?> var3);

    Logger demandSystemLogger(String var1, String var2);

    private void loadLoggerHandlers(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Logger var1, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String var2, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String var3);

    final void drainLoggerRefQueueBounded();

    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown boolean addLogger(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Logger var1);

    private static void doSetLevel(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Logger var0, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Level var1);

    private static void doSetParent(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Logger var0, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Logger var1);

    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Logger getLogger(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String var1);

    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Enumeration<@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String> getLoggerNames();

    public void readConfiguration() throws IOException, SecurityException;

    public void reset() throws SecurityException;

    private void resetLogger(Logger var1);

    private @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown [] parseClassNames(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String var1);

    public void readConfiguration(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown InputStream var1) throws IOException, SecurityException;

    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String getProperty(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String var1);

    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String getStringProperty(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String var1, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String var2);

    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown int getIntProperty(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String var1, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown int var2);

    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown boolean getBooleanProperty(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String var1, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown boolean var2);

    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Level getLevelProperty(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String var1, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Level var2);

    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Filter getFilterProperty(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String var1, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Filter var2);

    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Formatter getFormatterProperty(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String var1, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Formatter var2);

    private synchronized void initializeGlobalHandlers();

    void checkPermission();

    public void checkAccess() throws SecurityException;

    private synchronized void setLevelsOnExistingLoggers();

    public static synchronized @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown LoggingMXBean getLoggingMXBean();

    static;

    /*
     * Exception performing whole class analysis.
     * Exception performing whole class analysis ignored.
     */
    private class Cleaner
    extends Thread {
        private Cleaner(LogManager var1);

        @Override
        public void run();
    }

    class LoggerContext {
        private final ConcurrentHashMap<String, LoggerWeakRef> namedLoggers = new ConcurrentHashMap();
        private final LogNode root = new LogNode(null, this);

        private LoggerContext() {
        }

        final boolean requiresDefaultLoggers() {
            boolean requiresDefaultLoggers;
            boolean bl = requiresDefaultLoggers = this.getOwner() == manager;
            if (requiresDefaultLoggers) {
                this.getOwner().ensureLogManagerInitialized();
            }
            return requiresDefaultLoggers;
        }

        final LogManager getOwner() {
            return LogManager.this;
        }

        final Logger getRootLogger() {
            return this.getOwner().rootLogger;
        }

        final Logger getGlobalLogger() {
            Logger global = Logger.global;
            return global;
        }

        Logger demandLogger(String name, String resourceBundleName, Module module) {
            LogManager owner = this.getOwner();
            return owner.demandLogger(name, resourceBundleName, module);
        }

        private void ensureInitialized() {
            if (this.requiresDefaultLoggers()) {
                this.ensureDefaultLogger(this.getRootLogger());
                this.ensureDefaultLogger(this.getGlobalLogger());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Logger findLogger(String name) {
            Logger logger;
            LoggerWeakRef ref = this.namedLoggers.get(name);
            Logger logger2 = logger = ref == null ? null : (Logger)ref.get();
            if (logger != null || ref == null && !name.isEmpty() && !name.equals("global")) {
                return logger;
            }
            LoggerContext loggerContext = this;
            synchronized (loggerContext) {
                this.ensureInitialized();
                ref = this.namedLoggers.get(name);
                if (ref == null) {
                    return null;
                }
                logger = (Logger)ref.get();
                if (logger == null) {
                    ref.dispose();
                }
                return logger;
            }
        }

        private void ensureAllDefaultLoggers(Logger logger) {
            String name;
            if (this.requiresDefaultLoggers() && !(name = logger.getName()).isEmpty()) {
                this.ensureDefaultLogger(this.getRootLogger());
                if (!"global".equals(name)) {
                    this.ensureDefaultLogger(this.getGlobalLogger());
                }
            }
        }

        private void ensureDefaultLogger(Logger logger) {
            if (!this.requiresDefaultLoggers() || logger == null || logger != this.getGlobalLogger() && logger != LogManager.this.rootLogger) {
                assert (logger == null);
                return;
            }
            if (!this.namedLoggers.containsKey(logger.getName())) {
                this.addLocalLogger(logger, false);
            }
        }

        boolean addLocalLogger(Logger logger) {
            return this.addLocalLogger(logger, this.requiresDefaultLoggers());
        }

        synchronized boolean addLocalLogger(Logger logger, boolean addDefaultLoggersIfNeeded) {
            LoggerWeakRef nodeRef;
            String name;
            if (addDefaultLoggersIfNeeded) {
                this.ensureAllDefaultLoggers(logger);
            }
            if ((name = logger.getName()) == null) {
                throw new NullPointerException();
            }
            LoggerWeakRef ref = this.namedLoggers.get(name);
            if (ref != null) {
                if (ref.refersTo(null)) {
                    ref.dispose();
                } else {
                    return false;
                }
            }
            LogManager owner = this.getOwner();
            logger.setLogManager(owner);
            LogManager logManager = owner;
            Objects.requireNonNull(logManager);
            ref = new LoggerWeakRef(logManager, logger);
            Level level = owner.getLevelProperty(name + ".level", null);
            if (level != null && !logger.isLevelInitialized()) {
                LogManager.doSetLevel(logger, level);
            }
            this.processParentHandlers(logger, name, VisitedLoggers.NEVER);
            LogNode node = this.getNode(name);
            node.loggerRef = ref;
            Logger parent = null;
            LogNode nodep = node.parent;
            while (nodep != null && ((nodeRef = nodep.loggerRef) == null || (parent = (Logger)nodeRef.get()) == null)) {
                nodep = nodep.parent;
            }
            if (parent != null) {
                LogManager.doSetParent(logger, parent);
            }
            node.walkAndSetParent(logger);
            ref.setNode(node);
            this.namedLoggers.put(name, ref);
            return true;
        }

        void removeLoggerRef(String name, LoggerWeakRef ref) {
            this.namedLoggers.remove(name, ref);
        }

        synchronized Enumeration<String> getLoggerNames() {
            this.ensureInitialized();
            return Collections.enumeration(this.namedLoggers.keySet());
        }

        private void processParentHandlers(final Logger logger, final String name, Predicate<Logger> visited) {
            String pname;
            int ix2;
            final LogManager owner = this.getOwner();
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    boolean useParent;
                    if (logger != owner.rootLogger && !(useParent = owner.getBooleanProperty(name + ".useParentHandlers", true))) {
                        logger.setUseParentHandlers(false);
                    }
                    return null;
                }
            });
            int ix = 1;
            while ((ix2 = name.indexOf(46, ix)) >= 0 && (owner.getProperty((pname = name.substring(0, ix2)) + ".level") == null && owner.getProperty(pname + ".handlers") == null || !visited.test(this.demandLogger(pname, null, null)))) {
                ix = ix2 + 1;
            }
        }

        LogNode getNode(String name) {
            if (name == null || name.isEmpty()) {
                return this.root;
            }
            LogNode node = this.root;
            while (name.length() > 0) {
                LogNode child;
                String head;
                int ix = name.indexOf(46);
                if (ix > 0) {
                    head = name.substring(0, ix);
                    name = name.substring(ix + 1);
                } else {
                    head = name;
                    name = "";
                }
                if (node.children == null) {
                    node.children = new HashMap();
                }
                if ((child = node.children.get(head)) == null) {
                    child = new LogNode(node, this);
                    node.children.put(head, child);
                }
                node = child;
            }
            return node;
        }
    }

    final class SystemLoggerContext
    extends LoggerContext {
        SystemLoggerContext(LogManager this$0) {
        }

        @Override
        Logger demandLogger(String name, String resourceBundleName, Module module) {
            Logger result = this.findLogger(name);
            if (result == null) {
                Logger newLogger = new Logger(name, resourceBundleName, module, this.getOwner(), true);
                while ((result = this.addLocalLogger(newLogger) ? newLogger : this.findLogger(name)) == null) {
                }
            }
            return result;
        }
    }

    /*
     * Exception performing whole class analysis.
     * Exception performing whole class analysis ignored.
     */
    final class LoggerWeakRef
    extends WeakReference<Logger> {
        private @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String name;
        private @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown LogNode node;
        private @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown WeakReference<@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Logger> parentRef;
        private boolean disposed;

        LoggerWeakRef(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown LogManager var1, Logger var2);

        void dispose();

        void setNode(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown LogNode var1);

        void setParentRef(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown WeakReference<@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Logger> var1);
    }

    /*
     * Exception performing whole class analysis.
     * Exception performing whole class analysis ignored.
     */
    private static class LogNode {
        @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown HashMap<@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown String, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown LogNode> children;
        @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown LogManager. @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown LoggerWeakRef loggerRef;
        @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown LogNode parent;
        final LoggerContext context;

        LogNode(LogNode var1, LoggerContext var2);

        void walkAndSetParent(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Logger var1);
    }

    /*
     * Exception performing whole class analysis.
     * Exception performing whole class analysis ignored.
     */
    private final class RootLogger
    extends Logger {
        private RootLogger(LogManager var1);

        @Override
        public void log(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown LogRecord var1);

        @Override
        public void addHandler(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Handler var1);

        @Override
        public void removeHandler(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown Handler var1);

        @Override
        Handler[] accessCheckedHandlers();
    }
}

