/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import jdk.Profile+Annotation;
import jdk.internal.util.OperatingSystem;
import org.checkerframework.checker.nullness.qual.Nullable;

/*
 * Exception performing whole class analysis.
 * Exception performing whole class analysis ignored.
 */
@Profile+Annotation(value=1)
public final class ProcessBuilder {
    private List<String> command;
    private File directory;
    private Map<String, String> environment;
    private boolean redirectErrorStream;
    private Redirect[] redirects;

    public ProcessBuilder(List<String> var1);

    public ProcessBuilder(String ... var1);

    public ProcessBuilder command(List<String> var1);

    public ProcessBuilder command(String ... var1);

    public List<String> command();

    public Map<String, String> environment();

    ProcessBuilder environment(String[] var1);

    public @Nullable File directory();

    public ProcessBuilder directory(@Nullable File var1);

    private Redirect[] redirects();

    public ProcessBuilder redirectInput(Redirect var1);

    public ProcessBuilder redirectOutput(Redirect var1);

    public ProcessBuilder redirectError(Redirect var1);

    public ProcessBuilder redirectInput(File var1);

    public ProcessBuilder redirectOutput(File var1);

    public ProcessBuilder redirectError(File var1);

    public Redirect redirectInput();

    public Redirect redirectOutput();

    public Redirect redirectError();

    public ProcessBuilder inheritIO();

    public boolean redirectErrorStream();

    public ProcessBuilder redirectErrorStream(boolean var1);

    public Process start() throws IOException;

    static;

    static class NullInputStream
    extends InputStream {
        static final NullInputStream INSTANCE = new NullInputStream();

        private NullInputStream() {
        }

        @Override
        public int read() {
            return -1;
        }

        @Override
        public int available() {
            return 0;
        }
    }

    static class NullOutputStream
    extends OutputStream {
        static final NullOutputStream INSTANCE = new NullOutputStream();

        private NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            throw new IOException("Stream closed");
        }
    }

    public static abstract class Redirect {
        private static final File NULL_FILE = new File(OperatingSystem.isWindows() ? "NUL" : "/dev/null");
        public static final Redirect PIPE = new Redirect(){

            @Override
            public Type type() {
                return Type.PIPE;
            }

            public String toString() {
                return this.type().toString();
            }
        };
        public static final Redirect INHERIT = new Redirect(){

            @Override
            public Type type() {
                return Type.INHERIT;
            }

            public String toString() {
                return this.type().toString();
            }
        };
        public static final Redirect DISCARD = new Redirect(){

            @Override
            public Type type() {
                return Type.WRITE;
            }

            public String toString() {
                return this.type().toString();
            }

            @Override
            public File file() {
                return NULL_FILE;
            }

            @Override
            boolean append() {
                return false;
            }
        };

        public abstract Type type();

        public File file() {
            return null;
        }

        boolean append() {
            throw new UnsupportedOperationException();
        }

        public static Redirect from(final File file) {
            if (file == null) {
                throw new NullPointerException();
            }
            return new Redirect(){

                @Override
                public Type type() {
                    return Type.READ;
                }

                @Override
                public File file() {
                    return file;
                }

                public String toString() {
                    return "redirect to read from file \"" + file + "\"";
                }
            };
        }

        public static Redirect to(final File file) {
            if (file == null) {
                throw new NullPointerException();
            }
            return new Redirect(){

                @Override
                public Type type() {
                    return Type.WRITE;
                }

                @Override
                public File file() {
                    return file;
                }

                public String toString() {
                    return "redirect to write to file \"" + file + "\"";
                }

                @Override
                boolean append() {
                    return false;
                }
            };
        }

        public static Redirect appendTo(final File file) {
            if (file == null) {
                throw new NullPointerException();
            }
            return new Redirect(){

                @Override
                public Type type() {
                    return Type.APPEND;
                }

                @Override
                public File file() {
                    return file;
                }

                public String toString() {
                    return "redirect to append to file \"" + file + "\"";
                }

                @Override
                boolean append() {
                    return true;
                }
            };
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Redirect)) {
                return false;
            }
            Redirect r = (Redirect)obj;
            if (r.type() != this.type()) {
                return false;
            }
            assert (this.file() != null);
            return this.file().equals(r.file());
        }

        public int hashCode() {
            File file = this.file();
            if (file == null) {
                return super.hashCode();
            }
            return file.hashCode();
        }

        private Redirect() {
        }

        public static enum Type {
            PIPE,
            INHERIT,
            READ,
            WRITE,
            APPEND;

        }
    }
}

