/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class Objects {
    private Objects() {
        throw new AssertionError((Object)"No java.util.Objects instances for you!");
    }

    @Pure
    public static boolean equals(@Nullable Object object, @Nullable Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    @Pure
    public static boolean deepEquals(@Nullable Object object, @Nullable Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return Arrays.deepEquals0(object, object2);
    }

    @Pure
    public static int hashCode(@Nullable Object object) {
        return object != null ? object.hashCode() : 0;
    }

    @Pure
    public static int hash(Object ... objectArray) {
        return Arrays.hashCode(objectArray);
    }

    @SideEffectFree
    public static String toString(@Nullable Object object) {
        return String.valueOf(object);
    }

    @SideEffectFree
    public static String toString(@Nullable Object object, String string) {
        return object != null ? object.toString() : string;
    }

    @Pure
    public static <T> int compare(@Nullable T t, @Nullable T t2, Comparator<? super T> comparator) {
        return t == t2 ? 0 : comparator.compare(t, t2);
    }

    @SideEffectFree
    public static <T> T requireNonNull(@Nullable T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        return t;
    }

    @SideEffectFree
    public static <T> T requireNonNull(@Nullable T t, @Nullable String string) {
        if (t == null) {
            throw new NullPointerException(string);
        }
        return t;
    }

    @Pure
    public static boolean isNull(@Nullable Object object) {
        return object == null;
    }

    @Pure
    public static boolean nonNull(@Nullable Object object) {
        return object != null;
    }

    public static <T> T requireNonNull(T t, Supplier<String> supplier) {
        if (t == null) {
            throw new NullPointerException(supplier.get());
        }
        return t;
    }
}

