/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.checkerframework.checker.javari.qual.PolyRead;
import org.checkerframework.checker.javari.qual.ReadOnly;
import sun.misc.SharedSecrets;

public class EnumMap<K extends Enum<K>, V>
extends AbstractMap<K, V>
implements Serializable,
Cloneable {
    private final Class<K> keyType;
    private transient K[] keyUniverse;
    private transient Object[] vals;
    private transient int size = 0;
    private static final Object NULL = new Object(){

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return "java.util.EnumMap.NULL";
        }
    };
    private static final Enum<?>[] ZERO_LENGTH_ENUM_ARRAY = new Enum[0];
    private transient Set<Map.Entry<K, V>> entrySet = null;
    private static final long serialVersionUID = 458661240069192865L;

    private Object maskNull(Object object) {
        return object == null ? NULL : object;
    }

    private V unmaskNull(Object object) {
        return (V)(object == NULL ? null : object);
    }

    public EnumMap(Class<K> clazz) {
        this.keyType = clazz;
        this.keyUniverse = EnumMap.getKeyUniverse(clazz);
        this.vals = new Object[this.keyUniverse.length];
    }

    public @PolyRead EnumMap(@PolyRead EnumMap<K, ? extends V> enumMap) {
        this.keyType = enumMap.keyType;
        this.keyUniverse = enumMap.keyUniverse;
        this.vals = (Object[])enumMap.vals.clone();
        this.size = enumMap.size;
    }

    public @PolyRead EnumMap(@PolyRead Map<K, ? extends V> map) {
        if (map instanceof EnumMap) {
            EnumMap enumMap = (EnumMap)map;
            this.keyType = enumMap.keyType;
            this.keyUniverse = enumMap.keyUniverse;
            this.vals = (Object[])enumMap.vals.clone();
            this.size = enumMap.size;
        } else {
            if (map.isEmpty()) {
                throw new IllegalArgumentException("Specified map is empty");
            }
            this.keyType = ((Enum)map.keySet().iterator().next()).getDeclaringClass();
            this.keyUniverse = EnumMap.getKeyUniverse(this.keyType);
            this.vals = new Object[this.keyUniverse.length];
            this.putAll(map);
        }
    }

    @Override
    public int size(@ReadOnly EnumMap<K, V> this) {
        return this.size;
    }

    @Override
    public boolean containsValue(@ReadOnly EnumMap<K, V> this, @ReadOnly Object object) {
        object = this.maskNull(object);
        for (Object object2 : this.vals) {
            if (!object.equals(object2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsKey(@ReadOnly EnumMap<K, V> this, @ReadOnly Object object) {
        return this.isValidKey(object) && this.vals[((Enum)object).ordinal()] != null;
    }

    private boolean containsMapping(Object object, Object object2) {
        return this.isValidKey(object) && this.maskNull(object2).equals(this.vals[((Enum)object).ordinal()]);
    }

    @Override
    public V get(@ReadOnly EnumMap<K, V> this, @ReadOnly Object object) {
        return this.isValidKey(object) ? (V)this.unmaskNull(this.vals[((Enum)object).ordinal()]) : null;
    }

    @Override
    public V put(K k, V v) {
        this.typeCheck(k);
        int n = ((Enum)k).ordinal();
        Object object = this.vals[n];
        this.vals[n] = this.maskNull(v);
        if (object == null) {
            ++this.size;
        }
        return this.unmaskNull(object);
    }

    @Override
    public V remove(@ReadOnly Object object) {
        if (!this.isValidKey(object)) {
            return null;
        }
        int n = ((Enum)object).ordinal();
        Object object2 = this.vals[n];
        this.vals[n] = null;
        if (object2 != null) {
            --this.size;
        }
        return this.unmaskNull(object2);
    }

    private boolean removeMapping(Object object, Object object2) {
        if (!this.isValidKey(object)) {
            return false;
        }
        int n = ((Enum)object).ordinal();
        if (this.maskNull(object2).equals(this.vals[n])) {
            this.vals[n] = null;
            --this.size;
            return true;
        }
        return false;
    }

    private boolean isValidKey(Object object) {
        if (object == null) {
            return false;
        }
        Class<?> clazz = object.getClass();
        return clazz == this.keyType || clazz.getSuperclass() == this.keyType;
    }

    @Override
    public void putAll(@ReadOnly Map<? extends K, ? extends V> map) {
        if (map instanceof EnumMap) {
            EnumMap enumMap = (EnumMap)map;
            if (enumMap.keyType != this.keyType) {
                if (enumMap.isEmpty()) {
                    return;
                }
                throw new ClassCastException(enumMap.keyType + " != " + this.keyType);
            }
            for (int i = 0; i < this.keyUniverse.length; ++i) {
                Object object = enumMap.vals[i];
                if (object == null) continue;
                if (this.vals[i] == null) {
                    ++this.size;
                }
                this.vals[i] = object;
            }
        } else {
            super.putAll(map);
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.vals, null);
        this.size = 0;
    }

    @Override
    public @PolyRead Set<K> keySet(@PolyRead EnumMap<K, V> this) {
        Set set = this.keySet;
        if (set != null) {
            return set;
        }
        this.keySet = new KeySet(this, null);
        return this.keySet;
    }

    @Override
    public @PolyRead Collection<V> values(@PolyRead EnumMap<K, V> this) {
        Collection collection = this.values;
        if (collection != null) {
            return collection;
        }
        this.values = new Values(this, null);
        return this.values;
    }

    @Override
    public @PolyRead Set<Map.Entry<K, V>> entrySet(@PolyRead EnumMap<K, V> this) {
        Set<Map.Entry<K, V>> set = this.entrySet;
        if (set != null) {
            return set;
        }
        this.entrySet = new EntrySet(this, null);
        return this.entrySet;
    }

    @Override
    public boolean equals(@ReadOnly EnumMap<K, V> this, @ReadOnly Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof EnumMap) {
            return this.equals((EnumMap)object);
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (this.size != map.size()) {
            return false;
        }
        for (int i = 0; i < this.keyUniverse.length; ++i) {
            if (null == this.vals[i]) continue;
            K k = this.keyUniverse[i];
            V v = this.unmaskNull(this.vals[i]);
            if (!(null == v ? null != map.get(k) || !map.containsKey(k) : !v.equals(map.get(k)))) continue;
            return false;
        }
        return true;
    }

    private boolean equals(EnumMap<?, ?> enumMap) {
        if (enumMap.keyType != this.keyType) {
            return this.size == 0 && enumMap.size == 0;
        }
        for (int i = 0; i < this.keyUniverse.length; ++i) {
            Object object = enumMap.vals[i];
            Object object2 = this.vals[i];
            if (object == object2 || object != null && object.equals(object2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.keyUniverse.length; ++i) {
            if (null == this.vals[i]) continue;
            n += this.entryHashCode(i);
        }
        return n;
    }

    private int entryHashCode(int n) {
        return ((Enum)this.keyUniverse[n]).hashCode() ^ this.vals[n].hashCode();
    }

    @Override
    public EnumMap<K, V> clone() {
        EnumMap enumMap = null;
        try {
            enumMap = (EnumMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError();
        }
        enumMap.vals = (Object[])enumMap.vals.clone();
        enumMap.entrySet = null;
        return enumMap;
    }

    private void typeCheck(K k) {
        Class<?> clazz = k.getClass();
        if (clazz != this.keyType && clazz.getSuperclass() != this.keyType) {
            throw new ClassCastException(clazz + " != " + this.keyType);
        }
    }

    private static <K extends Enum<K>> K[] getKeyUniverse(Class<K> clazz) {
        return SharedSecrets.getJavaLangAccess().getEnumConstantsShared(clazz);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        int n = this.size;
        int n2 = 0;
        while (n > 0) {
            if (null != this.vals[n2]) {
                objectOutputStream.writeObject(this.keyUniverse[n2]);
                objectOutputStream.writeObject(this.unmaskNull(this.vals[n2]));
                --n;
            }
            ++n2;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.keyUniverse = EnumMap.getKeyUniverse(this.keyType);
        this.vals = new Object[this.keyUniverse.length];
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            Enum enum_ = (Enum)objectInputStream.readObject();
            Object object = objectInputStream.readObject();
            this.put((K)enum_, (V)object);
        }
    }

    static /* synthetic */ int access$200(EnumMap enumMap) {
        return enumMap.size;
    }

    static /* synthetic */ Object access$500(EnumMap enumMap, Object object) {
        return enumMap.maskNull(object);
    }

    static /* synthetic */ Object[] access$600(EnumMap enumMap) {
        return enumMap.vals;
    }

    static /* synthetic */ int access$210(EnumMap enumMap) {
        return enumMap.size--;
    }

    static /* synthetic */ boolean access$900(EnumMap enumMap, Object object, Object object2) {
        return enumMap.containsMapping(object, object2);
    }

    static /* synthetic */ boolean access$1000(EnumMap enumMap, Object object, Object object2) {
        return enumMap.removeMapping(object, object2);
    }

    static /* synthetic */ Enum[] access$1100(EnumMap enumMap) {
        return enumMap.keyUniverse;
    }

    static /* synthetic */ Object access$1200(EnumMap enumMap, Object object) {
        return enumMap.unmaskNull(object);
    }

    static /* synthetic */ int access$1600(EnumMap enumMap, int n) {
        return enumMap.entryHashCode(n);
    }

    private class EntryIterator
    extends EnumMapIterator<Map.Entry<K, V>> {
        private java.util.EnumMap$EntryIterator.Entry lastReturnedEntry;

        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturnedEntry = new Entry(this.index++);
            return this.lastReturnedEntry;
        }

        @Override
        public void remove() {
            this.lastReturnedIndex = null == this.lastReturnedEntry ? -1 : this.lastReturnedEntry.index;
            super.remove();
            this.lastReturnedEntry.index = this.lastReturnedIndex;
            this.lastReturnedEntry = null;
        }

        private class Entry
        implements Map.Entry<K, V> {
            private int index;

            private Entry(int index) {
                this.index = index;
            }

            @Override
            public K getKey() {
                this.checkIndexForEntryUse();
                return EnumMap.this.keyUniverse[this.index];
            }

            @Override
            public V getValue() {
                this.checkIndexForEntryUse();
                return EnumMap.this.unmaskNull(EnumMap.this.vals[this.index]);
            }

            @Override
            public V setValue(V value) {
                this.checkIndexForEntryUse();
                Object oldValue = EnumMap.this.unmaskNull(EnumMap.this.vals[this.index]);
                EnumMap.this.vals[this.index] = EnumMap.this.maskNull(value);
                return oldValue;
            }

            @Override
            public boolean equals(Object o) {
                if (this.index < 0) {
                    return o == this;
                }
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                Object ourValue = EnumMap.this.unmaskNull(EnumMap.this.vals[this.index]);
                Object hisValue = e.getValue();
                return e.getKey() == EnumMap.this.keyUniverse[this.index] && (ourValue == hisValue || ourValue != null && ourValue.equals(hisValue));
            }

            @Override
            public int hashCode() {
                if (this.index < 0) {
                    return super.hashCode();
                }
                return EnumMap.this.entryHashCode(this.index);
            }

            public String toString() {
                if (this.index < 0) {
                    return super.toString();
                }
                return EnumMap.this.keyUniverse[this.index] + "=" + EnumMap.this.unmaskNull(EnumMap.this.vals[this.index]);
            }

            private void checkIndexForEntryUse() {
                if (this.index < 0) {
                    throw new IllegalStateException("Entry was removed");
                }
            }
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            Map.Entry entry;
            return o instanceof Map.Entry && EnumMap.this.containsMapping((entry = (Map.Entry)o).getKey(), entry.getValue());
        }

        @Override
        public boolean remove(Object o) {
            Map.Entry entry;
            return o instanceof Map.Entry && EnumMap.this.removeMapping((entry = (Map.Entry)o).getKey(), entry.getValue());
        }

        @Override
        public int size() {
            return EnumMap.this.size;
        }

        @Override
        public void clear() {
            EnumMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            return this.fillEntryArray(new Object[EnumMap.this.size]);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            int size = this.size();
            if (a.length < size) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
            }
            if (a.length > size) {
                a[size] = null;
            }
            return this.fillEntryArray(a);
        }

        private Object[] fillEntryArray(Object[] a) {
            int j = 0;
            for (int i = 0; i < EnumMap.this.vals.length; ++i) {
                if (EnumMap.this.vals[i] == null) continue;
                a[j++] = new AbstractMap.SimpleEntry(EnumMap.this.keyUniverse[i], EnumMap.this.unmaskNull(EnumMap.this.vals[i]));
            }
            return a;
        }
    }

    private abstract class EnumMapIterator<T>
    implements Iterator<T> {
        int index = 0;
        int lastReturnedIndex = -1;

        private EnumMapIterator() {
        }

        @Override
        public boolean hasNext() {
            while (this.index < EnumMap.this.vals.length && EnumMap.this.vals[this.index] == null) {
                ++this.index;
            }
            return this.index != EnumMap.this.vals.length;
        }

        @Override
        public void remove() {
            this.checkLastReturnedIndex();
            if (EnumMap.this.vals[this.lastReturnedIndex] != null) {
                EnumMap.this.vals[this.lastReturnedIndex] = null;
                --EnumMap.this.size;
            }
            this.lastReturnedIndex = -1;
        }

        private void checkLastReturnedIndex() {
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException();
            }
        }
    }

    private class KeyIterator
    extends EnumMapIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturnedIndex = this.index++;
            return EnumMap.this.keyUniverse[this.lastReturnedIndex];
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return EnumMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return EnumMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            int oldSize = EnumMap.this.size;
            EnumMap.this.remove(o);
            return EnumMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            EnumMap.this.clear();
        }
    }

    private class ValueIterator
    extends EnumMapIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturnedIndex = this.index++;
            return EnumMap.this.unmaskNull(EnumMap.this.vals[this.lastReturnedIndex]);
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return EnumMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return EnumMap.this.containsValue(o);
        }

        @Override
        public boolean remove(Object o) {
            o = EnumMap.this.maskNull(o);
            for (int i = 0; i < EnumMap.this.vals.length; ++i) {
                if (!o.equals(EnumMap.this.vals[i])) continue;
                EnumMap.this.vals[i] = null;
                --EnumMap.this.size;
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            EnumMap.this.clear();
        }
    }
}

