/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import sun.nio.ch.FileChannelImpl;

@DefaultQualifier(value=NonNull.class)
public class FileInputStream
extends InputStream {
    private final FileDescriptor fd;
    private FileChannel channel = null;
    private final Object closeLock = new Object();
    private volatile boolean closed = false;

    public FileInputStream(String string) throws FileNotFoundException {
        this(string != null ? new File(string) : null);
    }

    public FileInputStream(File file) throws FileNotFoundException {
        String string = file != null ? file.getPath() : null;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string);
        }
        if (string == null) {
            throw new NullPointerException();
        }
        if (file.isInvalid()) {
            throw new FileNotFoundException("Invalid file path");
        }
        this.fd = new FileDescriptor();
        this.fd.attach(this);
        this.open(string);
    }

    public FileInputStream(FileDescriptor fileDescriptor) {
        SecurityManager securityManager = System.getSecurityManager();
        if (fileDescriptor == null) {
            throw new NullPointerException();
        }
        if (securityManager != null) {
            securityManager.checkRead(fileDescriptor);
        }
        this.fd = fileDescriptor;
        this.fd.attach(this);
    }

    private native void open(String var1) throws FileNotFoundException;

    @Override
    public native int read() throws IOException;

    private native int readBytes(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.readBytes(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.readBytes(byArray, n, n2);
    }

    @Override
    public native long skip(long var1) throws IOException;

    @Override
    public native int available() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        if (this.channel != null) {
            this.channel.close();
        }
        this.fd.closeAll(new Closeable(){

            @Override
            public void close() throws IOException {
                FileInputStream.this.fd.close();
            }
        });
    }

    public final FileDescriptor getFD(@ReadOnly FileInputStream this) throws IOException {
        if (this.fd != null) {
            return this.fd;
        }
        throw new IOException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChannel getChannel() {
        FileInputStream fileInputStream = this;
        synchronized (fileInputStream) {
            if (this.channel == null) {
                this.channel = FileChannelImpl.open((FileDescriptor)this.fd, (boolean)true, (boolean)false, (Object)this);
            }
            return this.channel;
        }
    }

    private static native void initIDs();

    private native void close0() throws IOException;

    protected void finalize() throws IOException {
        if (this.fd != null && this.fd != FileDescriptor.in) {
            this.close();
        }
    }

    static /* synthetic */ void access$000(FileInputStream fileInputStream) throws IOException {
        fileInputStream.close0();
    }

    static {
        FileInputStream.initIDs();
    }
}

