/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public class BufferedInputStream
extends FilterInputStream {
    private static int DEFAULT_BUFFER_SIZE = 8192;
    private static int MAX_BUFFER_SIZE = 0x7FFFFFF7;
    protected volatile byte[] buf;
    private static final AtomicReferenceFieldUpdater<BufferedInputStream, byte[]> bufUpdater = AtomicReferenceFieldUpdater.newUpdater(BufferedInputStream.class, byte[].class, "buf");
    protected int count;
    protected int pos;
    protected int markpos = -1;
    protected int marklimit;

    private InputStream getInIfOpen() throws IOException {
        InputStream inputStream = this.in;
        if (inputStream == null) {
            throw new IOException("Stream closed");
        }
        return inputStream;
    }

    private byte[] getBufIfOpen() throws IOException {
        byte[] byArray = this.buf;
        if (byArray == null) {
            throw new IOException("Stream closed");
        }
        return byArray;
    }

    public BufferedInputStream(InputStream inputStream) {
        this(inputStream, DEFAULT_BUFFER_SIZE);
    }

    public BufferedInputStream(InputStream inputStream, int n) {
        super(inputStream);
        if (n <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buf = new byte[n];
    }

    private void fill() throws IOException {
        int n;
        byte[] byArray = this.getBufIfOpen();
        if (this.markpos < 0) {
            this.pos = 0;
        } else if (this.pos >= byArray.length) {
            if (this.markpos > 0) {
                n = this.pos - this.markpos;
                System.arraycopy(byArray, this.markpos, byArray, 0, n);
                this.pos = n;
                this.markpos = 0;
            } else if (byArray.length >= this.marklimit) {
                this.markpos = -1;
                this.pos = 0;
            } else {
                if (byArray.length >= MAX_BUFFER_SIZE) {
                    throw new OutOfMemoryError("Required array size too large");
                }
                int n2 = n = this.pos <= MAX_BUFFER_SIZE - this.pos ? this.pos * 2 : MAX_BUFFER_SIZE;
                if (n > this.marklimit) {
                    n = this.marklimit;
                }
                byte[] byArray2 = new byte[n];
                System.arraycopy(byArray, 0, byArray2, 0, this.pos);
                if (!bufUpdater.compareAndSet(this, byArray, byArray2)) {
                    throw new IOException("Stream closed");
                }
                byArray = byArray2;
            }
        }
        this.count = this.pos;
        n = this.getInIfOpen().read(byArray, this.pos, byArray.length - this.pos);
        if (n > 0) {
            this.count = n + this.pos;
        }
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.pos >= this.count) {
            this.fill();
            if (this.pos >= this.count) {
                return -1;
            }
        }
        return this.getBufIfOpen()[this.pos++] & 0xFF;
    }

    private int read1(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.count - this.pos;
        if (n3 <= 0) {
            if (n2 >= this.getBufIfOpen().length && this.markpos < 0) {
                return this.getInIfOpen().read(byArray, n, n2);
            }
            this.fill();
            n3 = this.count - this.pos;
            if (n3 <= 0) {
                return -1;
            }
        }
        int n4 = n3 < n2 ? n3 : n2;
        System.arraycopy(this.getBufIfOpen(), this.pos, byArray, n, n4);
        this.pos += n4;
        return n4;
    }

    @Override
    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        InputStream inputStream;
        this.getBufIfOpen();
        if ((n | n2 | n + n2 | byArray.length - (n + n2)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        do {
            int n4;
            if ((n4 = this.read1(byArray, n + n3, n2 - n3)) <= 0) {
                return n3 == 0 ? n4 : n3;
            }
            if ((n3 += n4) < n2) continue;
            return n3;
        } while ((inputStream = this.in) == null || inputStream.available() > 0);
        return n3;
    }

    @Override
    public synchronized long skip(long l) throws IOException {
        this.getBufIfOpen();
        if (l <= 0L) {
            return 0L;
        }
        long l2 = this.count - this.pos;
        if (l2 <= 0L) {
            if (this.markpos < 0) {
                return this.getInIfOpen().skip(l);
            }
            this.fill();
            l2 = this.count - this.pos;
            if (l2 <= 0L) {
                return 0L;
            }
        }
        long l3 = l2 < l ? l2 : l;
        this.pos = (int)((long)this.pos + l3);
        return l3;
    }

    @Override
    public synchronized int available() throws IOException {
        int n = this.count - this.pos;
        int n2 = this.getInIfOpen().available();
        return n > Integer.MAX_VALUE - n2 ? Integer.MAX_VALUE : n + n2;
    }

    @Override
    public synchronized void mark(int n) {
        this.marklimit = n;
        this.markpos = this.pos;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.getBufIfOpen();
        if (this.markpos < 0) {
            throw new IOException("Resetting to invalid mark");
        }
        this.pos = this.markpos;
    }

    @Override
    public boolean markSupported(@ReadOnly BufferedInputStream this) {
        return true;
    }

    @Override
    public void close() throws IOException {
        block2: {
            byte[] byArray;
            do {
                byArray = this.buf;
                if (this.buf == null) break block2;
            } while (!bufUpdater.compareAndSet(this, byArray, null));
            InputStream inputStream = this.in;
            this.in = null;
            if (inputStream != null) {
                inputStream.close();
            }
            return;
        }
    }
}

