/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.checkerframework.checker.igj.qual.I;
import org.checkerframework.checker.igj.qual.Mutable;
import org.checkerframework.checker.javari.qual.PolyRead;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.KeyFor;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@I
public class TreeMap<K, V>
extends AbstractMap<K, V>
implements NavigableMap<K, V>,
Cloneable,
Serializable {
    private final Comparator<? super K> comparator;
    private transient Entry<K, V> root = null;
    private transient int size = 0;
    private transient int modCount = 0;
    private transient EntrySet entrySet = null;
    private transient KeySet<K> navigableKeySet = null;
    private transient NavigableMap<K, V> descendingMap = null;
    private static final Object UNBOUNDED = new Object();
    private static final boolean RED = false;
    private static final boolean BLACK = true;
    private static final long serialVersionUID = 919286545866124006L;

    public TreeMap() {
        this.comparator = null;
    }

    public TreeMap(@org.checkerframework.checker.igj.qual.ReadOnly Comparator<? super K> comparator) {
        this.comparator = comparator;
    }

    public @PolyRead TreeMap(@org.checkerframework.checker.igj.qual.ReadOnly @PolyRead Map<? extends K, ? extends V> map) {
        this.comparator = null;
        this.putAll(map);
    }

    public @PolyRead TreeMap(@org.checkerframework.checker.igj.qual.ReadOnly @PolyRead SortedMap<K, ? extends V> sortedMap) {
        this.comparator = sortedMap.comparator();
        try {
            this.buildFromSorted(sortedMap.size(), sortedMap.entrySet().iterator(), null, null);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    @Pure
    public int size(@org.checkerframework.checker.igj.qual.ReadOnly TreeMap<K, V> this) {
        return this.size;
    }

    @Override
    @Pure
    public boolean containsKey(@org.checkerframework.checker.igj.qual.ReadOnly TreeMap<K, V> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        return this.getEntry(object) != null;
    }

    @Override
    @Pure
    public boolean containsValue(@org.checkerframework.checker.igj.qual.ReadOnly TreeMap<K, V> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        Entry<K, V> entry = this.getFirstEntry();
        while (entry != null) {
            if (TreeMap.valEquals(object, entry.value)) {
                return true;
            }
            entry = TreeMap.successor(entry);
        }
        return false;
    }

    @Override
    @Pure
    public @Nullable V get(@org.checkerframework.checker.igj.qual.ReadOnly TreeMap<K, V> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        Entry<K, V> entry = this.getEntry(object);
        return entry == null ? null : (V)entry.value;
    }

    @Override
    @SideEffectFree
    public @org.checkerframework.checker.igj.qual.ReadOnly Comparator<? super K> comparator(@org.checkerframework.checker.igj.qual.ReadOnly TreeMap<K, V> this) {
        return this.comparator;
    }

    @Override
    public K firstKey(@org.checkerframework.checker.igj.qual.ReadOnly TreeMap<K, V> this) {
        return TreeMap.key(this.getFirstEntry());
    }

    @Override
    public K lastKey(@org.checkerframework.checker.igj.qual.ReadOnly TreeMap<K, V> this) {
        return TreeMap.key(this.getLastEntry());
    }

    @Override
    public void putAll(@Mutable TreeMap<K, V> this, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Map<? extends K, ? extends V> map) {
        Comparator comparator;
        int n = map.size();
        if (this.size == 0 && n != 0 && map instanceof SortedMap && ((comparator = ((SortedMap)map).comparator()) == this.comparator || comparator != null && comparator.equals(this.comparator))) {
            ++this.modCount;
            try {
                this.buildFromSorted(n, map.entrySet().iterator(), null, null);
            }
            catch (IOException iOException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return;
        }
        super.putAll(map);
    }

    final Entry<K, V> getEntry(Object object) {
        if (this.comparator != null) {
            return this.getEntryUsingComparator(object);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        Comparable comparable = (Comparable)object;
        Entry<K, V> entry = this.root;
        while (entry != null) {
            int n = comparable.compareTo(entry.key);
            if (n < 0) {
                entry = entry.left;
                continue;
            }
            if (n > 0) {
                entry = entry.right;
                continue;
            }
            return entry;
        }
        return null;
    }

    final Entry<K, V> getEntryUsingComparator(Object object) {
        Object object2 = object;
        Comparator<K> comparator = this.comparator;
        if (comparator != null) {
            Entry<K, V> entry = this.root;
            while (entry != null) {
                int n = comparator.compare(object2, entry.key);
                if (n < 0) {
                    entry = entry.left;
                    continue;
                }
                if (n > 0) {
                    entry = entry.right;
                    continue;
                }
                return entry;
            }
        }
        return null;
    }

    final Entry<K, V> getCeilingEntry(K k) {
        Entry<K, V> entry = this.root;
        while (entry != null) {
            int n = this.compare(k, entry.key);
            if (n < 0) {
                if (entry.left != null) {
                    entry = entry.left;
                    continue;
                }
                return entry;
            }
            if (n > 0) {
                if (entry.right != null) {
                    entry = entry.right;
                    continue;
                }
                Entry entry2 = entry.parent;
                Entry<K, V> entry3 = entry;
                while (entry2 != null && entry3 == entry2.right) {
                    entry3 = entry2;
                    entry2 = entry2.parent;
                }
                return entry2;
            }
            return entry;
        }
        return null;
    }

    final Entry<K, V> getFloorEntry(K k) {
        Entry<K, V> entry = this.root;
        while (entry != null) {
            int n = this.compare(k, entry.key);
            if (n > 0) {
                if (entry.right != null) {
                    entry = entry.right;
                    continue;
                }
                return entry;
            }
            if (n < 0) {
                if (entry.left != null) {
                    entry = entry.left;
                    continue;
                }
                Entry entry2 = entry.parent;
                Entry<K, V> entry3 = entry;
                while (entry2 != null && entry3 == entry2.left) {
                    entry3 = entry2;
                    entry2 = entry2.parent;
                }
                return entry2;
            }
            return entry;
        }
        return null;
    }

    final Entry<K, V> getHigherEntry(K k) {
        Entry<K, V> entry = this.root;
        while (entry != null) {
            int n = this.compare(k, entry.key);
            if (n < 0) {
                if (entry.left != null) {
                    entry = entry.left;
                    continue;
                }
                return entry;
            }
            if (entry.right != null) {
                entry = entry.right;
                continue;
            }
            Entry entry2 = entry.parent;
            Entry<K, V> entry3 = entry;
            while (entry2 != null && entry3 == entry2.right) {
                entry3 = entry2;
                entry2 = entry2.parent;
            }
            return entry2;
        }
        return null;
    }

    final Entry<K, V> getLowerEntry(K k) {
        Entry<K, V> entry = this.root;
        while (entry != null) {
            int n = this.compare(k, entry.key);
            if (n > 0) {
                if (entry.right != null) {
                    entry = entry.right;
                    continue;
                }
                return entry;
            }
            if (entry.left != null) {
                entry = entry.left;
                continue;
            }
            Entry entry2 = entry.parent;
            Entry<K, V> entry3 = entry;
            while (entry2 != null && entry3 == entry2.left) {
                entry3 = entry2;
                entry2 = entry2.parent;
            }
            return entry2;
        }
        return null;
    }

    @Override
    public @Nullable V put(@Mutable TreeMap<K, V> this, K k, V v) {
        Object object;
        int n;
        Entry<K, V> entry;
        Entry<K, V> entry2 = this.root;
        if (entry2 == null) {
            this.compare(k, k);
            this.root = new Entry<K, V>(k, v, null);
            this.size = 1;
            ++this.modCount;
            return null;
        }
        Comparator<K> comparator = this.comparator;
        if (comparator != null) {
            do {
                entry = entry2;
                n = comparator.compare(k, entry2.key);
                if (n < 0) {
                    entry2 = entry2.left;
                    continue;
                }
                if (n > 0) {
                    entry2 = entry2.right;
                    continue;
                }
                return entry2.setValue(v);
            } while (entry2 != null);
        } else {
            if (k == null) {
                throw new NullPointerException();
            }
            object = (Comparable)k;
            do {
                entry = entry2;
                n = object.compareTo(entry2.key);
                if (n < 0) {
                    entry2 = entry2.left;
                    continue;
                }
                if (n > 0) {
                    entry2 = entry2.right;
                    continue;
                }
                return entry2.setValue(v);
            } while (entry2 != null);
        }
        object = new Entry<K, V>(k, v, entry);
        if (n < 0) {
            entry.left = object;
        } else {
            entry.right = object;
        }
        this.fixAfterInsertion((Entry<K, V>)object);
        ++this.size;
        ++this.modCount;
        return null;
    }

    @Override
    public @Nullable V remove(@Mutable TreeMap<K, V> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        Entry<K, V> entry = this.getEntry(object);
        if (entry == null) {
            return null;
        }
        Object v = entry.value;
        this.deleteEntry(entry);
        return v;
    }

    @Override
    public void clear(@Mutable TreeMap<K, V> this) {
        ++this.modCount;
        this.size = 0;
        this.root = null;
    }

    @Override
    @SideEffectFree
    public @I(value="N") Object clone() {
        TreeMap treeMap;
        try {
            treeMap = (TreeMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException);
        }
        treeMap.root = null;
        treeMap.size = 0;
        treeMap.modCount = 0;
        treeMap.entrySet = null;
        treeMap.navigableKeySet = null;
        treeMap.descendingMap = null;
        try {
            treeMap.buildFromSorted(this.size, this.entrySet().iterator(), null, null);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return treeMap;
    }

    @Override
    public @Nullable @I @PolyRead Map.Entry<K, V> firstEntry(@org.checkerframework.checker.igj.qual.ReadOnly TreeMap<K, V> this) {
        return TreeMap.exportEntry(this.getFirstEntry());
    }

    @Override
    public @Nullable @I @PolyRead Map.Entry<K, V> lastEntry(@org.checkerframework.checker.igj.qual.ReadOnly TreeMap<K, V> this) {
        return TreeMap.exportEntry(this.getLastEntry());
    }

    @Override
    public @Nullable @I Map.Entry<K, V> pollFirstEntry(@org.checkerframework.checker.igj.qual.ReadOnly TreeMap<K, V> this) {
        Entry<K, V> entry = this.getFirstEntry();
        Map.Entry<K, V> entry2 = TreeMap.exportEntry(entry);
        if (entry != null) {
            this.deleteEntry(entry);
        }
        return entry2;
    }

    @Override
    public @Nullable @I Map.Entry<K, V> pollLastEntry(@org.checkerframework.checker.igj.qual.ReadOnly TreeMap<K, V> this) {
        Entry<K, V> entry = this.getLastEntry();
        Map.Entry<K, V> entry2 = TreeMap.exportEntry(entry);
        if (entry != null) {
            this.deleteEntry(entry);
        }
        return entry2;
    }

    @Override
    public @Nullable @I @PolyRead Map.Entry<K, V> lowerEntry(@org.checkerframework.checker.igj.qual.ReadOnly TreeMap<K, V> this, K k) {
        return TreeMap.exportEntry(this.getLowerEntry(k));
    }

    @Override
    public @Nullable K lowerKey(@org.checkerframework.checker.igj.qual.ReadOnly TreeMap<K, V> this, K k) {
        return TreeMap.keyOrNull(this.getLowerEntry(k));
    }

    @Override
    public @Nullable @I @PolyRead Map.Entry<K, V> floorEntry(@org.checkerframework.checker.igj.qual.ReadOnly TreeMap<K, V> this, K k) {
        return TreeMap.exportEntry(this.getFloorEntry(k));
    }

    @Override
    public @Nullable K floorKey(@org.checkerframework.checker.igj.qual.ReadOnly TreeMap<K, V> this, K k) {
        return TreeMap.keyOrNull(this.getFloorEntry(k));
    }

    @Override
    public @Nullable @I @PolyRead Map.Entry<K, V> ceilingEntry(@org.checkerframework.checker.igj.qual.ReadOnly TreeMap<K, V> this, K k) {
        return TreeMap.exportEntry(this.getCeilingEntry(k));
    }

    @Override
    public @Nullable K ceilingKey(@org.checkerframework.checker.igj.qual.ReadOnly TreeMap<K, V> this, K k) {
        return TreeMap.keyOrNull(this.getCeilingEntry(k));
    }

    @Override
    public @Nullable @I @PolyRead Map.Entry<K, V> higherEntry(@org.checkerframework.checker.igj.qual.ReadOnly TreeMap<K, V> this, K k) {
        return TreeMap.exportEntry(this.getHigherEntry(k));
    }

    @Override
    public @Nullable K higherKey(@org.checkerframework.checker.igj.qual.ReadOnly TreeMap<K, V> this, K k) {
        return TreeMap.keyOrNull(this.getHigherEntry(k));
    }

    @Override
    @SideEffectFree
    public @I Set<@KeyFor(value={"this"}) K> keySet(@org.checkerframework.checker.igj.qual.ReadOnly TreeMap<K, V> this) {
        return this.navigableKeySet();
    }

    @Override
    @SideEffectFree
    public @I @PolyRead NavigableSet<@KeyFor(value={"this"}) K> navigableKeySet(@org.checkerframework.checker.igj.qual.ReadOnly TreeMap<K, V> this) {
        KeySet<K> keySet = this.navigableKeySet;
        return keySet != null ? keySet : (this.navigableKeySet = new KeySet(this));
    }

    @Override
    @SideEffectFree
    public @I @PolyRead NavigableSet<@KeyFor(value={"this"}) K> descendingKeySet(@org.checkerframework.checker.igj.qual.ReadOnly TreeMap<K, V> this) {
        return this.descendingMap().navigableKeySet();
    }

    @Override
    @SideEffectFree
    public @I @PolyRead Collection<V> values(@org.checkerframework.checker.igj.qual.ReadOnly TreeMap<K, V> this) {
        Collection collection = this.values;
        return collection != null ? collection : (this.values = new Values());
    }

    @Override
    @SideEffectFree
    public @I @PolyRead Set<@I Map.Entry<@KeyFor(value={"this"}) K, V>> entrySet(@org.checkerframework.checker.igj.qual.ReadOnly TreeMap<K, V> this) {
        EntrySet entrySet = this.entrySet;
        return entrySet != null ? entrySet : (this.entrySet = new EntrySet());
    }

    @Override
    @SideEffectFree
    public @I @PolyRead NavigableMap<K, V> descendingMap(@org.checkerframework.checker.igj.qual.ReadOnly TreeMap<K, V> this) {
        NavigableMap<K, V> navigableMap = this.descendingMap;
        return navigableMap != null ? navigableMap : (this.descendingMap = new DescendingSubMap(this, true, null, true, true, null, true));
    }

    @Override
    @SideEffectFree
    public @I @PolyRead NavigableMap<K, V> subMap(@org.checkerframework.checker.igj.qual.ReadOnly TreeMap<K, V> this, K k, boolean bl, K k2, boolean bl2) {
        return new AscendingSubMap(this, false, k, bl, false, k2, bl2);
    }

    @Override
    @SideEffectFree
    public @I @PolyRead NavigableMap<K, V> headMap(@org.checkerframework.checker.igj.qual.ReadOnly TreeMap<K, V> this, K k, boolean bl) {
        return new AscendingSubMap(this, true, null, true, false, k, bl);
    }

    @Override
    @SideEffectFree
    public @I @PolyRead NavigableMap<K, V> tailMap(@org.checkerframework.checker.igj.qual.ReadOnly TreeMap<K, V> this, K k, boolean bl) {
        return new AscendingSubMap(this, false, k, bl, true, null, true);
    }

    @Override
    @SideEffectFree
    public @I @PolyRead SortedMap<K, V> subMap(@org.checkerframework.checker.igj.qual.ReadOnly TreeMap<K, V> this, K k, K k2) {
        return this.subMap(k, true, k2, false);
    }

    @Override
    @SideEffectFree
    public @I @PolyRead SortedMap<K, V> headMap(@org.checkerframework.checker.igj.qual.ReadOnly TreeMap<K, V> this, K k) {
        return this.headMap(k, false);
    }

    @Override
    @SideEffectFree
    public @I @PolyRead SortedMap<K, V> tailMap(@org.checkerframework.checker.igj.qual.ReadOnly TreeMap<K, V> this, K k) {
        return this.tailMap(k, true);
    }

    @Override
    public boolean replace(K k, V v, V v2) {
        Entry<K, V> entry = this.getEntry(k);
        if (entry != null && Objects.equals(v, entry.value)) {
            entry.value = v2;
            return true;
        }
        return false;
    }

    @Override
    public V replace(K k, V v) {
        Entry<K, V> entry = this.getEntry(k);
        if (entry != null) {
            Object v2 = entry.value;
            entry.value = v;
            return v2;
        }
        return null;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        Objects.requireNonNull(biConsumer);
        int n = this.modCount;
        Entry<K, V> entry = this.getFirstEntry();
        while (entry != null) {
            biConsumer.accept(entry.key, entry.value);
            if (n != this.modCount) {
                throw new ConcurrentModificationException();
            }
            entry = TreeMap.successor(entry);
        }
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
        Objects.requireNonNull(biFunction);
        int n = this.modCount;
        Entry<K, V> entry = this.getFirstEntry();
        while (entry != null) {
            entry.value = biFunction.apply(entry.key, entry.value);
            if (n != this.modCount) {
                throw new ConcurrentModificationException();
            }
            entry = TreeMap.successor(entry);
        }
    }

    Iterator<K> keyIterator() {
        return new KeyIterator(this, this.getFirstEntry());
    }

    Iterator<K> descendingKeyIterator() {
        return new DescendingKeyIterator(this.getLastEntry());
    }

    final int compare(Object object, Object object2) {
        return this.comparator == null ? ((Comparable)object).compareTo(object2) : this.comparator.compare(object, object2);
    }

    static final boolean valEquals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    static <K, V> Map.Entry<K, V> exportEntry(Entry<K, V> entry) {
        return entry == null ? null : new AbstractMap.SimpleImmutableEntry<K, V>(entry);
    }

    static <K, V> K keyOrNull(Entry<K, V> entry) {
        return entry == null ? null : (K)entry.key;
    }

    static <K> K key(Entry<K, ?> entry) {
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return entry.key;
    }

    final Entry<K, V> getFirstEntry() {
        Entry<K, V> entry = this.root;
        if (entry != null) {
            while (entry.left != null) {
                entry = entry.left;
            }
        }
        return entry;
    }

    final Entry<K, V> getLastEntry() {
        Entry<K, V> entry = this.root;
        if (entry != null) {
            while (entry.right != null) {
                entry = entry.right;
            }
        }
        return entry;
    }

    static <K, V> Entry<K, V> successor(Entry<K, V> entry) {
        if (entry == null) {
            return null;
        }
        if (entry.right != null) {
            Entry entry2 = entry.right;
            while (entry2.left != null) {
                entry2 = entry2.left;
            }
            return entry2;
        }
        Entry entry3 = entry.parent;
        Entry<K, V> entry4 = entry;
        while (entry3 != null && entry4 == entry3.right) {
            entry4 = entry3;
            entry3 = entry3.parent;
        }
        return entry3;
    }

    static <K, V> Entry<K, V> predecessor(Entry<K, V> entry) {
        if (entry == null) {
            return null;
        }
        if (entry.left != null) {
            Entry entry2 = entry.left;
            while (entry2.right != null) {
                entry2 = entry2.right;
            }
            return entry2;
        }
        Entry entry3 = entry.parent;
        Entry<K, V> entry4 = entry;
        while (entry3 != null && entry4 == entry3.left) {
            entry4 = entry3;
            entry3 = entry3.parent;
        }
        return entry3;
    }

    private static <K, V> boolean colorOf(Entry<K, V> entry) {
        return entry == null ? true : entry.color;
    }

    private static <K, V> Entry<K, V> parentOf(Entry<K, V> entry) {
        return entry == null ? null : entry.parent;
    }

    private static <K, V> void setColor(Entry<K, V> entry, boolean bl) {
        if (entry != null) {
            entry.color = bl;
        }
    }

    private static <K, V> Entry<K, V> leftOf(Entry<K, V> entry) {
        return entry == null ? null : entry.left;
    }

    private static <K, V> Entry<K, V> rightOf(Entry<K, V> entry) {
        return entry == null ? null : entry.right;
    }

    private void rotateLeft(Entry<K, V> entry) {
        if (entry != null) {
            Entry entry2 = entry.right;
            entry.right = entry2.left;
            if (entry2.left != null) {
                entry2.left.parent = entry;
            }
            entry2.parent = entry.parent;
            if (entry.parent == null) {
                this.root = entry2;
            } else if (entry.parent.left == entry) {
                entry.parent.left = entry2;
            } else {
                entry.parent.right = entry2;
            }
            entry2.left = entry;
            entry.parent = entry2;
        }
    }

    private void rotateRight(Entry<K, V> entry) {
        if (entry != null) {
            Entry entry2 = entry.left;
            entry.left = entry2.right;
            if (entry2.right != null) {
                entry2.right.parent = entry;
            }
            entry2.parent = entry.parent;
            if (entry.parent == null) {
                this.root = entry2;
            } else if (entry.parent.right == entry) {
                entry.parent.right = entry2;
            } else {
                entry.parent.left = entry2;
            }
            entry2.right = entry;
            entry.parent = entry2;
        }
    }

    private void fixAfterInsertion(Entry<K, V> entry) {
        entry.color = false;
        while (entry != null && entry != this.root && !entry.parent.color) {
            Entry<K, V> entry2;
            if (TreeMap.parentOf(entry) == TreeMap.leftOf(TreeMap.parentOf(TreeMap.parentOf(entry)))) {
                entry2 = TreeMap.rightOf(TreeMap.parentOf(TreeMap.parentOf(entry)));
                if (!TreeMap.colorOf(entry2)) {
                    TreeMap.setColor(TreeMap.parentOf(entry), true);
                    TreeMap.setColor(entry2, true);
                    TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(entry)), false);
                    entry = TreeMap.parentOf(TreeMap.parentOf(entry));
                    continue;
                }
                if (entry == TreeMap.rightOf(TreeMap.parentOf(entry))) {
                    entry = TreeMap.parentOf(entry);
                    this.rotateLeft(entry);
                }
                TreeMap.setColor(TreeMap.parentOf(entry), true);
                TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(entry)), false);
                this.rotateRight(TreeMap.parentOf(TreeMap.parentOf(entry)));
                continue;
            }
            entry2 = TreeMap.leftOf(TreeMap.parentOf(TreeMap.parentOf(entry)));
            if (!TreeMap.colorOf(entry2)) {
                TreeMap.setColor(TreeMap.parentOf(entry), true);
                TreeMap.setColor(entry2, true);
                TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(entry)), false);
                entry = TreeMap.parentOf(TreeMap.parentOf(entry));
                continue;
            }
            if (entry == TreeMap.leftOf(TreeMap.parentOf(entry))) {
                entry = TreeMap.parentOf(entry);
                this.rotateRight(entry);
            }
            TreeMap.setColor(TreeMap.parentOf(entry), true);
            TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(entry)), false);
            this.rotateLeft(TreeMap.parentOf(TreeMap.parentOf(entry)));
        }
        this.root.color = true;
    }

    private void deleteEntry(Entry<K, V> entry) {
        Entry<K, V> entry2;
        ++this.modCount;
        --this.size;
        if (entry.left != null && entry.right != null) {
            entry2 = TreeMap.successor(entry);
            entry.key = entry2.key;
            entry.value = entry2.value;
            entry = entry2;
        }
        Entry entry3 = entry2 = entry.left != null ? entry.left : entry.right;
        if (entry2 != null) {
            entry2.parent = entry.parent;
            if (entry.parent == null) {
                this.root = entry2;
            } else if (entry == entry.parent.left) {
                entry.parent.left = entry2;
            } else {
                entry.parent.right = entry2;
            }
            entry.parent = null;
            entry.right = null;
            entry.left = null;
            if (entry.color) {
                this.fixAfterDeletion(entry2);
            }
        } else if (entry.parent == null) {
            this.root = null;
        } else {
            if (entry.color) {
                this.fixAfterDeletion(entry);
            }
            if (entry.parent != null) {
                if (entry == entry.parent.left) {
                    entry.parent.left = null;
                } else if (entry == entry.parent.right) {
                    entry.parent.right = null;
                }
                entry.parent = null;
            }
        }
    }

    private void fixAfterDeletion(Entry<K, V> entry) {
        while (entry != this.root && TreeMap.colorOf(entry)) {
            Entry<K, V> entry2;
            if (entry == TreeMap.leftOf(TreeMap.parentOf(entry))) {
                entry2 = TreeMap.rightOf(TreeMap.parentOf(entry));
                if (!TreeMap.colorOf(entry2)) {
                    TreeMap.setColor(entry2, true);
                    TreeMap.setColor(TreeMap.parentOf(entry), false);
                    this.rotateLeft(TreeMap.parentOf(entry));
                    entry2 = TreeMap.rightOf(TreeMap.parentOf(entry));
                }
                if (TreeMap.colorOf(TreeMap.leftOf(entry2)) && TreeMap.colorOf(TreeMap.rightOf(entry2))) {
                    TreeMap.setColor(entry2, false);
                    entry = TreeMap.parentOf(entry);
                    continue;
                }
                if (TreeMap.colorOf(TreeMap.rightOf(entry2))) {
                    TreeMap.setColor(TreeMap.leftOf(entry2), true);
                    TreeMap.setColor(entry2, false);
                    this.rotateRight(entry2);
                    entry2 = TreeMap.rightOf(TreeMap.parentOf(entry));
                }
                TreeMap.setColor(entry2, TreeMap.colorOf(TreeMap.parentOf(entry)));
                TreeMap.setColor(TreeMap.parentOf(entry), true);
                TreeMap.setColor(TreeMap.rightOf(entry2), true);
                this.rotateLeft(TreeMap.parentOf(entry));
                entry = this.root;
                continue;
            }
            entry2 = TreeMap.leftOf(TreeMap.parentOf(entry));
            if (!TreeMap.colorOf(entry2)) {
                TreeMap.setColor(entry2, true);
                TreeMap.setColor(TreeMap.parentOf(entry), false);
                this.rotateRight(TreeMap.parentOf(entry));
                entry2 = TreeMap.leftOf(TreeMap.parentOf(entry));
            }
            if (TreeMap.colorOf(TreeMap.rightOf(entry2)) && TreeMap.colorOf(TreeMap.leftOf(entry2))) {
                TreeMap.setColor(entry2, false);
                entry = TreeMap.parentOf(entry);
                continue;
            }
            if (TreeMap.colorOf(TreeMap.leftOf(entry2))) {
                TreeMap.setColor(TreeMap.rightOf(entry2), true);
                TreeMap.setColor(entry2, false);
                this.rotateLeft(entry2);
                entry2 = TreeMap.leftOf(TreeMap.parentOf(entry));
            }
            TreeMap.setColor(entry2, TreeMap.colorOf(TreeMap.parentOf(entry)));
            TreeMap.setColor(TreeMap.parentOf(entry), true);
            TreeMap.setColor(TreeMap.leftOf(entry2), true);
            this.rotateRight(TreeMap.parentOf(entry));
            entry = this.root;
        }
        TreeMap.setColor(entry, true);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        for (Map.Entry<K, V> entry : this.entrySet()) {
            objectOutputStream.writeObject(entry.getKey());
            objectOutputStream.writeObject(entry.getValue());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.buildFromSorted(n, null, objectInputStream, null);
    }

    void readTreeSet(int n, ObjectInputStream objectInputStream, V v) throws IOException, ClassNotFoundException {
        this.buildFromSorted(n, null, objectInputStream, v);
    }

    void addAllForTreeSet(SortedSet<? extends K> sortedSet, V v) {
        try {
            this.buildFromSorted(sortedSet.size(), sortedSet.iterator(), null, v);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void buildFromSorted(int n, Iterator<?> iterator, ObjectInputStream objectInputStream, V v) throws IOException, ClassNotFoundException {
        this.size = n;
        this.root = this.buildFromSorted(0, 0, n - 1, TreeMap.computeRedLevel(n), iterator, objectInputStream, v);
    }

    private final Entry<K, V> buildFromSorted(int n, int n2, int n3, int n4, Iterator<?> iterator, ObjectInputStream objectInputStream, V v) throws IOException, ClassNotFoundException {
        V v2;
        Object object;
        Entry<Object, V> entry;
        if (n3 < n2) {
            return null;
        }
        int n5 = n2 + n3 >>> 1;
        Entry<K, V> entry2 = null;
        if (n2 < n5) {
            entry2 = this.buildFromSorted(n + 1, n2, n5 - 1, n4, iterator, objectInputStream, v);
        }
        if (iterator != null) {
            if (v == null) {
                entry = (Entry<Object, V>)iterator.next();
                object = entry.getKey();
                v2 = entry.getValue();
            } else {
                object = iterator.next();
                v2 = v;
            }
        } else {
            object = objectInputStream.readObject();
            v2 = v != null ? v : objectInputStream.readObject();
        }
        entry = new Entry<Object, V>(object, v2, null);
        if (n == n4) {
            entry.color = false;
        }
        if (entry2 != null) {
            entry.left = entry2;
            entry2.parent = entry;
        }
        if (n5 < n3) {
            Entry<K, V> entry3 = this.buildFromSorted(n + 1, n5 + 1, n3, n4, iterator, objectInputStream, v);
            entry.right = entry3;
            entry3.parent = entry;
        }
        return entry;
    }

    private static int computeRedLevel(int n) {
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            ++n2;
            n3 = n3 / 2 - 1;
        }
        return n2;
    }

    static <K> Spliterator<K> keySpliteratorFor(NavigableMap<K, ?> navigableMap) {
        NavigableSubMap navigableSubMap;
        if (navigableMap instanceof TreeMap) {
            TreeMap treeMap = (TreeMap)navigableMap;
            return treeMap.keySpliterator();
        }
        if (navigableMap instanceof DescendingSubMap) {
            navigableSubMap = (DescendingSubMap)navigableMap;
            TreeMap treeMap = ((DescendingSubMap)navigableSubMap).m;
            if (navigableSubMap == treeMap.descendingMap) {
                TreeMap treeMap2 = treeMap;
                return treeMap2.descendingKeySpliterator();
            }
        }
        navigableSubMap = (NavigableSubMap)navigableMap;
        return navigableSubMap.keySpliterator();
    }

    final Spliterator<K> keySpliterator() {
        return new KeySpliterator(this, null, null, 0, -1, 0);
    }

    final Spliterator<K> descendingKeySpliterator() {
        return new DescendingKeySpliterator(this, null, null, 0, -2, 0);
    }

    static /* synthetic */ void access$000(TreeMap treeMap, Entry entry) {
        treeMap.deleteEntry(entry);
    }

    static /* synthetic */ int access$100(TreeMap treeMap) {
        return treeMap.modCount;
    }

    static /* synthetic */ Object access$200() {
        return UNBOUNDED;
    }

    static /* synthetic */ Comparator access$300(TreeMap treeMap) {
        return treeMap.comparator;
    }

    static /* synthetic */ int access$400(TreeMap treeMap) {
        return treeMap.size;
    }

    static /* synthetic */ Entry access$500(TreeMap treeMap) {
        return treeMap.root;
    }

    static final class AscendingSubMap<K, V>
    extends NavigableSubMap<K, V> {
        private static final long serialVersionUID = 912986545866124060L;

        AscendingSubMap(TreeMap<K, V> m, boolean fromStart, K lo, boolean loInclusive, boolean toEnd, K hi, boolean hiInclusive) {
            super(m, fromStart, lo, loInclusive, toEnd, hi, hiInclusive);
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.m.comparator();
        }

        @Override
        public NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            if (!this.inRange(fromKey, fromInclusive)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            if (!this.inRange(toKey, toInclusive)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new AscendingSubMap<K, V>(this.m, false, fromKey, fromInclusive, false, toKey, toInclusive);
        }

        @Override
        public NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
            if (!this.inRange(toKey, inclusive)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new AscendingSubMap<Object, V>(this.m, this.fromStart, this.lo, this.loInclusive, false, toKey, inclusive);
        }

        @Override
        public NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
            if (!this.inRange(fromKey, inclusive)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            return new AscendingSubMap<Object, V>(this.m, false, fromKey, inclusive, this.toEnd, this.hi, this.hiInclusive);
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            DescendingSubMap mv = this.descendingMapView;
            return mv != null ? mv : (this.descendingMapView = new DescendingSubMap(this.m, this.fromStart, this.lo, this.loInclusive, this.toEnd, this.hi, this.hiInclusive));
        }

        @Override
        Iterator<K> keyIterator() {
            return new NavigableSubMap.SubMapKeyIterator(this.absLowest(), this.absHighFence());
        }

        @Override
        Spliterator<K> keySpliterator() {
            return new NavigableSubMap.SubMapKeyIterator(this.absLowest(), this.absHighFence());
        }

        @Override
        Iterator<K> descendingKeyIterator() {
            return new NavigableSubMap.DescendingSubMapKeyIterator(this, this.absHighest(), this.absLowFence());
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            NavigableSubMap.EntrySetView es = this.entrySetView;
            return es != null ? es : (this.entrySetView = new AscendingEntrySetView());
        }

        @Override
        Entry<K, V> subLowest() {
            return this.absLowest();
        }

        @Override
        Entry<K, V> subHighest() {
            return this.absHighest();
        }

        @Override
        Entry<K, V> subCeiling(K key) {
            return this.absCeiling(key);
        }

        @Override
        Entry<K, V> subHigher(K key) {
            return this.absHigher(key);
        }

        @Override
        Entry<K, V> subFloor(K key) {
            return this.absFloor(key);
        }

        @Override
        Entry<K, V> subLower(K key) {
            return this.absLower(key);
        }

        final class AscendingEntrySetView
        extends NavigableSubMap.EntrySetView {
            AscendingEntrySetView() {
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new NavigableSubMap.SubMapEntryIterator(AscendingSubMap.this, AscendingSubMap.this.absLowest(), AscendingSubMap.this.absHighFence());
            }
        }
    }

    final class DescendingKeyIterator
    extends PrivateEntryIterator<K> {
        DescendingKeyIterator(Entry<K, V> first) {
            super(first);
        }

        @Override
        public K next() {
            return this.prevEntry().key;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (TreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            TreeMap.this.deleteEntry(this.lastReturned);
            this.lastReturned = null;
            this.expectedModCount = TreeMap.this.modCount;
        }
    }

    static final class DescendingKeySpliterator<K, V>
    extends TreeMapSpliterator<K, V>
    implements Spliterator<K> {
        DescendingKeySpliterator(TreeMap<K, V> tree, Entry<K, V> origin, Entry<K, V> fence, int side, int est, int expectedModCount) {
            super(tree, origin, fence, side, est, expectedModCount);
        }

        public DescendingKeySpliterator<K, V> trySplit() {
            Entry s;
            if (this.est < 0) {
                this.getEstimate();
            }
            int d = this.side;
            Entry e = this.current;
            Entry f = this.fence;
            Entry entry = e == null || e == f ? null : (d == 0 ? this.tree.root : (d < 0 ? e.left : (s = d > 0 && f != null ? f.right : null)));
            if (s != null && s != e && s != f && this.tree.compare(e.key, s.key) > 0) {
                this.side = 1;
                this.current = s;
                return new DescendingKeySpliterator(this.tree, e, this.current, -1, this.est >>>= 1, this.expectedModCount);
            }
            return null;
        }

        @Override
        public void forEachRemaining(Consumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.est < 0) {
                this.getEstimate();
            }
            Entry f = this.fence;
            Entry e = this.current;
            if (e != null && e != f) {
                Entry p;
                this.current = f;
                do {
                    action.accept(e.key);
                    p = e.left;
                    if (p != null) {
                        Entry pr;
                        while ((pr = p.right) != null) {
                            p = pr;
                        }
                    } else {
                        while ((p = e.parent) != null && e == p.left) {
                            e = p;
                        }
                    }
                } while ((e = p) != null && e != f);
                if (this.tree.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super K> action) {
            Entry e;
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.est < 0) {
                this.getEstimate();
            }
            if ((e = this.current) == null || e == this.fence) {
                return false;
            }
            this.current = TreeMap.predecessor(e);
            action.accept(e.key);
            if (this.tree.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return true;
        }

        @Override
        public int characteristics() {
            return (this.side == 0 ? 64 : 0) | 1 | 0x10;
        }
    }

    static final class DescendingSubMap<K, V>
    extends NavigableSubMap<K, V> {
        private static final long serialVersionUID = 912986545866120460L;
        private final Comparator<? super K> reverseComparator;

        DescendingSubMap(TreeMap<K, V> m, boolean fromStart, K lo, boolean loInclusive, boolean toEnd, K hi, boolean hiInclusive) {
            super(m, fromStart, lo, loInclusive, toEnd, hi, hiInclusive);
            this.reverseComparator = Collections.reverseOrder(this.m.comparator);
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.reverseComparator;
        }

        @Override
        public NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            if (!this.inRange(fromKey, fromInclusive)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            if (!this.inRange(toKey, toInclusive)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new DescendingSubMap<K, V>(this.m, false, toKey, toInclusive, false, fromKey, fromInclusive);
        }

        @Override
        public NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
            if (!this.inRange(toKey, inclusive)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new DescendingSubMap<Object, V>(this.m, false, toKey, inclusive, this.toEnd, this.hi, this.hiInclusive);
        }

        @Override
        public NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
            if (!this.inRange(fromKey, inclusive)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            return new DescendingSubMap<Object, V>(this.m, this.fromStart, this.lo, this.loInclusive, false, fromKey, inclusive);
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            AscendingSubMap mv = this.descendingMapView;
            return mv != null ? mv : (this.descendingMapView = new AscendingSubMap(this.m, this.fromStart, this.lo, this.loInclusive, this.toEnd, this.hi, this.hiInclusive));
        }

        @Override
        Iterator<K> keyIterator() {
            return new NavigableSubMap.DescendingSubMapKeyIterator(this, this.absHighest(), this.absLowFence());
        }

        @Override
        Spliterator<K> keySpliterator() {
            return new NavigableSubMap.DescendingSubMapKeyIterator(this, this.absHighest(), this.absLowFence());
        }

        @Override
        Iterator<K> descendingKeyIterator() {
            return new NavigableSubMap.SubMapKeyIterator(this.absLowest(), this.absHighFence());
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            NavigableSubMap.EntrySetView es = this.entrySetView;
            return es != null ? es : (this.entrySetView = new DescendingEntrySetView());
        }

        @Override
        Entry<K, V> subLowest() {
            return this.absHighest();
        }

        @Override
        Entry<K, V> subHighest() {
            return this.absLowest();
        }

        @Override
        Entry<K, V> subCeiling(K key) {
            return this.absFloor(key);
        }

        @Override
        Entry<K, V> subHigher(K key) {
            return this.absLower(key);
        }

        @Override
        Entry<K, V> subFloor(K key) {
            return this.absCeiling(key);
        }

        @Override
        Entry<K, V> subLower(K key) {
            return this.absHigher(key);
        }

        final class DescendingEntrySetView
        extends NavigableSubMap.EntrySetView {
            DescendingEntrySetView() {
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new NavigableSubMap.DescendingSubMapEntryIterator(DescendingSubMap.this, DescendingSubMap.this.absHighest(), DescendingSubMap.this.absLowFence());
            }
        }
    }

    static final class Entry<K, V>
    implements Map.Entry<K, V> {
        K key;
        V value;
        Entry<K, V> left;
        Entry<K, V> right;
        Entry<K, V> parent;
        boolean color = true;

        Entry(K key, V value, Entry<K, V> parent) {
            this.key = key;
            this.value = value;
            this.parent = parent;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            Map.Entry e;
            return o instanceof Map.Entry && TreeMap.valEquals(this.key, (e = (Map.Entry)o).getKey()) && TreeMap.valEquals(this.value, e.getValue());
        }

        @Override
        public int hashCode() {
            int keyHash = this.key == null ? 0 : this.key.hashCode();
            int valueHash = this.value == null ? 0 : this.value.hashCode();
            return keyHash ^ valueHash;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    final class EntryIterator
    extends PrivateEntryIterator<Map.Entry<K, V>> {
        EntryIterator(TreeMap this$0, Entry<K, V> first) {
            super(first);
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(TreeMap.this, TreeMap.this.getFirstEntry());
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object value = entry.getValue();
            Entry p = TreeMap.this.getEntry(entry.getKey());
            return p != null && TreeMap.valEquals(p.getValue(), value);
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object value = entry.getValue();
            Entry p = TreeMap.this.getEntry(entry.getKey());
            if (p != null && TreeMap.valEquals(p.getValue(), value)) {
                TreeMap.this.deleteEntry(p);
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return TreeMap.this.size();
        }

        @Override
        public void clear() {
            TreeMap.this.clear();
        }

        @Override
        public Spliterator<Map.Entry<K, V>> spliterator() {
            return new EntrySpliterator(TreeMap.this, null, null, 0, -1, 0);
        }
    }

    static final class EntrySpliterator<K, V>
    extends TreeMapSpliterator<K, V>
    implements Spliterator<Map.Entry<K, V>> {
        EntrySpliterator(TreeMap<K, V> tree, Entry<K, V> origin, Entry<K, V> fence, int side, int est, int expectedModCount) {
            super(tree, origin, fence, side, est, expectedModCount);
        }

        public EntrySpliterator<K, V> trySplit() {
            Entry s;
            if (this.est < 0) {
                this.getEstimate();
            }
            int d = this.side;
            Entry e = this.current;
            Entry f = this.fence;
            Entry entry = e == null || e == f ? null : (d == 0 ? this.tree.root : (d > 0 ? e.right : (s = d < 0 && f != null ? f.left : null)));
            if (s != null && s != e && s != f && this.tree.compare(e.key, s.key) < 0) {
                this.side = 1;
                this.current = s;
                return new EntrySpliterator(this.tree, e, this.current, -1, this.est >>>= 1, this.expectedModCount);
            }
            return null;
        }

        @Override
        public void forEachRemaining(Consumer<? super Map.Entry<K, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.est < 0) {
                this.getEstimate();
            }
            Entry f = this.fence;
            Entry e = this.current;
            if (e != null && e != f) {
                Entry p;
                this.current = f;
                do {
                    action.accept(e);
                    p = e.right;
                    if (p != null) {
                        Entry pl;
                        while ((pl = p.left) != null) {
                            p = pl;
                        }
                    } else {
                        while ((p = e.parent) != null && e == p.right) {
                            e = p;
                        }
                    }
                } while ((e = p) != null && e != f);
                if (this.tree.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super Map.Entry<K, V>> action) {
            Entry e;
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.est < 0) {
                this.getEstimate();
            }
            if ((e = this.current) == null || e == this.fence) {
                return false;
            }
            this.current = TreeMap.successor(e);
            action.accept(e);
            if (this.tree.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return true;
        }

        @Override
        public int characteristics() {
            return (this.side == 0 ? 64 : 0) | 1 | 4 | 0x10;
        }

        @Override
        public Comparator<Map.Entry<K, V>> getComparator() {
            if (this.tree.comparator != null) {
                return Map.Entry.comparingByKey(this.tree.comparator);
            }
            return (Comparator & Serializable)(e1, e2) -> {
                Comparable k1 = (Comparable)e1.getKey();
                return k1.compareTo(e2.getKey());
            };
        }
    }

    final class KeyIterator
    extends PrivateEntryIterator<K> {
        KeyIterator(TreeMap this$0, Entry<K, V> first) {
            super(first);
        }

        @Override
        public K next() {
            return this.nextEntry().key;
        }
    }

    static final class KeySet<E>
    extends AbstractSet<E>
    implements NavigableSet<E> {
        private final NavigableMap<E, ?> m;

        KeySet(NavigableMap<E, ?> map) {
            this.m = map;
        }

        @Override
        public Iterator<E> iterator() {
            if (this.m instanceof TreeMap) {
                return ((TreeMap)this.m).keyIterator();
            }
            return ((NavigableSubMap)this.m).keyIterator();
        }

        @Override
        public Iterator<E> descendingIterator() {
            if (this.m instanceof TreeMap) {
                return ((TreeMap)this.m).descendingKeyIterator();
            }
            return ((NavigableSubMap)this.m).descendingKeyIterator();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.m.containsKey(o);
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public E lower(E e) {
            return this.m.lowerKey(e);
        }

        @Override
        public E floor(E e) {
            return this.m.floorKey(e);
        }

        @Override
        public E ceiling(E e) {
            return this.m.ceilingKey(e);
        }

        @Override
        public E higher(E e) {
            return this.m.higherKey(e);
        }

        @Override
        public E first() {
            return (E)this.m.firstKey();
        }

        @Override
        public E last() {
            return (E)this.m.lastKey();
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.m.comparator();
        }

        @Override
        public E pollFirst() {
            Map.Entry<E, ?> e = this.m.pollFirstEntry();
            return e == null ? null : (E)e.getKey();
        }

        @Override
        public E pollLast() {
            Map.Entry<E, ?> e = this.m.pollLastEntry();
            return e == null ? null : (E)e.getKey();
        }

        @Override
        public boolean remove(Object o) {
            int oldSize = this.size();
            this.m.remove(o);
            return this.size() != oldSize;
        }

        @Override
        public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
            return new KeySet<E>(this.m.subMap(fromElement, fromInclusive, toElement, toInclusive));
        }

        @Override
        public NavigableSet<E> headSet(E toElement, boolean inclusive) {
            return new KeySet<E>(this.m.headMap(toElement, inclusive));
        }

        @Override
        public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
            return new KeySet<E>(this.m.tailMap(fromElement, inclusive));
        }

        @Override
        public SortedSet<E> subSet(E fromElement, E toElement) {
            return this.subSet(fromElement, true, toElement, false);
        }

        @Override
        public SortedSet<E> headSet(E toElement) {
            return this.headSet(toElement, false);
        }

        @Override
        public SortedSet<E> tailSet(E fromElement) {
            return this.tailSet(fromElement, true);
        }

        @Override
        public NavigableSet<E> descendingSet() {
            return new KeySet<E>(this.m.descendingMap());
        }

        @Override
        public Spliterator<E> spliterator() {
            return TreeMap.keySpliteratorFor(this.m);
        }
    }

    static final class KeySpliterator<K, V>
    extends TreeMapSpliterator<K, V>
    implements Spliterator<K> {
        KeySpliterator(TreeMap<K, V> tree, Entry<K, V> origin, Entry<K, V> fence, int side, int est, int expectedModCount) {
            super(tree, origin, fence, side, est, expectedModCount);
        }

        public KeySpliterator<K, V> trySplit() {
            Entry s;
            if (this.est < 0) {
                this.getEstimate();
            }
            int d = this.side;
            Entry e = this.current;
            Entry f = this.fence;
            Entry entry = e == null || e == f ? null : (d == 0 ? this.tree.root : (d > 0 ? e.right : (s = d < 0 && f != null ? f.left : null)));
            if (s != null && s != e && s != f && this.tree.compare(e.key, s.key) < 0) {
                this.side = 1;
                this.current = s;
                return new KeySpliterator(this.tree, e, this.current, -1, this.est >>>= 1, this.expectedModCount);
            }
            return null;
        }

        @Override
        public void forEachRemaining(Consumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.est < 0) {
                this.getEstimate();
            }
            Entry f = this.fence;
            Entry e = this.current;
            if (e != null && e != f) {
                Entry p;
                this.current = f;
                do {
                    action.accept(e.key);
                    p = e.right;
                    if (p != null) {
                        Entry pl;
                        while ((pl = p.left) != null) {
                            p = pl;
                        }
                    } else {
                        while ((p = e.parent) != null && e == p.right) {
                            e = p;
                        }
                    }
                } while ((e = p) != null && e != f);
                if (this.tree.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super K> action) {
            Entry e;
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.est < 0) {
                this.getEstimate();
            }
            if ((e = this.current) == null || e == this.fence) {
                return false;
            }
            this.current = TreeMap.successor(e);
            action.accept(e.key);
            if (this.tree.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return true;
        }

        @Override
        public int characteristics() {
            return (this.side == 0 ? 64 : 0) | 1 | 4 | 0x10;
        }

        @Override
        public final Comparator<? super K> getComparator() {
            return this.tree.comparator;
        }
    }

    static abstract class NavigableSubMap<K, V>
    extends AbstractMap<K, V>
    implements NavigableMap<K, V>,
    Serializable {
        private static final long serialVersionUID = -2102997345730753016L;
        final TreeMap<K, V> m;
        final K lo;
        final K hi;
        final boolean fromStart;
        final boolean toEnd;
        final boolean loInclusive;
        final boolean hiInclusive;
        transient NavigableMap<K, V> descendingMapView;
        transient EntrySetView entrySetView;
        transient KeySet<K> navigableKeySetView;

        NavigableSubMap(TreeMap<K, V> m, boolean fromStart, K lo, boolean loInclusive, boolean toEnd, K hi, boolean hiInclusive) {
            if (!fromStart && !toEnd) {
                if (m.compare(lo, hi) > 0) {
                    throw new IllegalArgumentException("fromKey > toKey");
                }
            } else {
                if (!fromStart) {
                    m.compare(lo, lo);
                }
                if (!toEnd) {
                    m.compare(hi, hi);
                }
            }
            this.m = m;
            this.fromStart = fromStart;
            this.lo = lo;
            this.loInclusive = loInclusive;
            this.toEnd = toEnd;
            this.hi = hi;
            this.hiInclusive = hiInclusive;
        }

        final boolean tooLow(Object key) {
            int c;
            return !this.fromStart && ((c = this.m.compare(key, this.lo)) < 0 || c == 0 && !this.loInclusive);
        }

        final boolean tooHigh(Object key) {
            int c;
            return !this.toEnd && ((c = this.m.compare(key, this.hi)) > 0 || c == 0 && !this.hiInclusive);
        }

        final boolean inRange(Object key) {
            return !this.tooLow(key) && !this.tooHigh(key);
        }

        final boolean inClosedRange(Object key) {
            return !(!this.fromStart && this.m.compare(key, this.lo) < 0 || !this.toEnd && this.m.compare(this.hi, key) < 0);
        }

        final boolean inRange(Object key, boolean inclusive) {
            return inclusive ? this.inRange(key) : this.inClosedRange(key);
        }

        final Entry<K, V> absLowest() {
            Entry<K, V> e = this.fromStart ? this.m.getFirstEntry() : (this.loInclusive ? this.m.getCeilingEntry(this.lo) : this.m.getHigherEntry(this.lo));
            return e == null || this.tooHigh(e.key) ? null : e;
        }

        final Entry<K, V> absHighest() {
            Entry<K, V> e = this.toEnd ? this.m.getLastEntry() : (this.hiInclusive ? this.m.getFloorEntry(this.hi) : this.m.getLowerEntry(this.hi));
            return e == null || this.tooLow(e.key) ? null : e;
        }

        final Entry<K, V> absCeiling(K key) {
            if (this.tooLow(key)) {
                return this.absLowest();
            }
            Entry<K, V> e = this.m.getCeilingEntry(key);
            return e == null || this.tooHigh(e.key) ? null : e;
        }

        final Entry<K, V> absHigher(K key) {
            if (this.tooLow(key)) {
                return this.absLowest();
            }
            Entry<K, V> e = this.m.getHigherEntry(key);
            return e == null || this.tooHigh(e.key) ? null : e;
        }

        final Entry<K, V> absFloor(K key) {
            if (this.tooHigh(key)) {
                return this.absHighest();
            }
            Entry<K, V> e = this.m.getFloorEntry(key);
            return e == null || this.tooLow(e.key) ? null : e;
        }

        final Entry<K, V> absLower(K key) {
            if (this.tooHigh(key)) {
                return this.absHighest();
            }
            Entry<K, V> e = this.m.getLowerEntry(key);
            return e == null || this.tooLow(e.key) ? null : e;
        }

        final Entry<K, V> absHighFence() {
            return this.toEnd ? null : (this.hiInclusive ? this.m.getHigherEntry(this.hi) : this.m.getCeilingEntry(this.hi));
        }

        final Entry<K, V> absLowFence() {
            return this.fromStart ? null : (this.loInclusive ? this.m.getLowerEntry(this.lo) : this.m.getFloorEntry(this.lo));
        }

        abstract Entry<K, V> subLowest();

        abstract Entry<K, V> subHighest();

        abstract Entry<K, V> subCeiling(K var1);

        abstract Entry<K, V> subHigher(K var1);

        abstract Entry<K, V> subFloor(K var1);

        abstract Entry<K, V> subLower(K var1);

        abstract Iterator<K> keyIterator();

        abstract Spliterator<K> keySpliterator();

        abstract Iterator<K> descendingKeyIterator();

        @Override
        public boolean isEmpty() {
            return this.fromStart && this.toEnd ? this.m.isEmpty() : this.entrySet().isEmpty();
        }

        @Override
        public int size() {
            return this.fromStart && this.toEnd ? this.m.size() : this.entrySet().size();
        }

        @Override
        public final boolean containsKey(Object key) {
            return this.inRange(key) && this.m.containsKey(key);
        }

        @Override
        public final V put(K key, V value) {
            if (!this.inRange(key)) {
                throw new IllegalArgumentException("key out of range");
            }
            return this.m.put(key, value);
        }

        @Override
        public V putIfAbsent(K key, V value) {
            if (!this.inRange(key)) {
                throw new IllegalArgumentException("key out of range");
            }
            return this.m.putIfAbsent(key, value);
        }

        @Override
        public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
            if (!this.inRange(key)) {
                throw new IllegalArgumentException("key out of range");
            }
            return this.m.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
        }

        @Override
        public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
            if (!this.inRange(key)) {
                if (mappingFunction.apply(key) == null) {
                    return null;
                }
                throw new IllegalArgumentException("key out of range");
            }
            return this.m.computeIfAbsent(key, mappingFunction);
        }

        @Override
        public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            if (!this.inRange(key)) {
                if (remappingFunction.apply(key, null) == null) {
                    return null;
                }
                throw new IllegalArgumentException("key out of range");
            }
            return this.m.compute(key, remappingFunction);
        }

        @Override
        public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            return !this.inRange(key) ? null : (V)this.m.computeIfPresent(key, remappingFunction);
        }

        @Override
        public final V get(Object key) {
            return !this.inRange(key) ? null : (V)this.m.get(key);
        }

        @Override
        public final V remove(Object key) {
            return !this.inRange(key) ? null : (V)this.m.remove(key);
        }

        @Override
        public final Map.Entry<K, V> ceilingEntry(K key) {
            return TreeMap.exportEntry(this.subCeiling(key));
        }

        @Override
        public final K ceilingKey(K key) {
            return TreeMap.keyOrNull(this.subCeiling(key));
        }

        @Override
        public final Map.Entry<K, V> higherEntry(K key) {
            return TreeMap.exportEntry(this.subHigher(key));
        }

        @Override
        public final K higherKey(K key) {
            return TreeMap.keyOrNull(this.subHigher(key));
        }

        @Override
        public final Map.Entry<K, V> floorEntry(K key) {
            return TreeMap.exportEntry(this.subFloor(key));
        }

        @Override
        public final K floorKey(K key) {
            return TreeMap.keyOrNull(this.subFloor(key));
        }

        @Override
        public final Map.Entry<K, V> lowerEntry(K key) {
            return TreeMap.exportEntry(this.subLower(key));
        }

        @Override
        public final K lowerKey(K key) {
            return TreeMap.keyOrNull(this.subLower(key));
        }

        @Override
        public final K firstKey() {
            return TreeMap.key(this.subLowest());
        }

        @Override
        public final K lastKey() {
            return TreeMap.key(this.subHighest());
        }

        @Override
        public final Map.Entry<K, V> firstEntry() {
            return TreeMap.exportEntry(this.subLowest());
        }

        @Override
        public final Map.Entry<K, V> lastEntry() {
            return TreeMap.exportEntry(this.subHighest());
        }

        @Override
        public final Map.Entry<K, V> pollFirstEntry() {
            Entry<K, V> e = this.subLowest();
            Map.Entry<K, V> result = TreeMap.exportEntry(e);
            if (e != null) {
                this.m.deleteEntry(e);
            }
            return result;
        }

        @Override
        public final Map.Entry<K, V> pollLastEntry() {
            Entry<K, V> e = this.subHighest();
            Map.Entry<K, V> result = TreeMap.exportEntry(e);
            if (e != null) {
                this.m.deleteEntry(e);
            }
            return result;
        }

        @Override
        public final NavigableSet<K> navigableKeySet() {
            KeySet<K> nksv = this.navigableKeySetView;
            return nksv != null ? nksv : (this.navigableKeySetView = new KeySet(this));
        }

        @Override
        public final Set<K> keySet() {
            return this.navigableKeySet();
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return this.descendingMap().navigableKeySet();
        }

        @Override
        public final SortedMap<K, V> subMap(K fromKey, K toKey) {
            return this.subMap(fromKey, true, toKey, false);
        }

        @Override
        public final SortedMap<K, V> headMap(K toKey) {
            return this.headMap(toKey, false);
        }

        @Override
        public final SortedMap<K, V> tailMap(K fromKey) {
            return this.tailMap(fromKey, true);
        }

        final class DescendingSubMapKeyIterator
        extends SubMapIterator<K>
        implements Spliterator<K> {
            DescendingSubMapKeyIterator(NavigableSubMap this$0, Entry<K, V> last, Entry<K, V> fence) {
                super(last, fence);
            }

            @Override
            public K next() {
                return this.prevEntry().key;
            }

            @Override
            public void remove() {
                this.removeDescending();
            }

            @Override
            public Spliterator<K> trySplit() {
                return null;
            }

            @Override
            public void forEachRemaining(Consumer<? super K> action) {
                while (this.hasNext()) {
                    action.accept(this.next());
                }
            }

            @Override
            public boolean tryAdvance(Consumer<? super K> action) {
                if (this.hasNext()) {
                    action.accept(this.next());
                    return true;
                }
                return false;
            }

            @Override
            public long estimateSize() {
                return Long.MAX_VALUE;
            }

            @Override
            public int characteristics() {
                return 17;
            }
        }

        final class SubMapKeyIterator
        extends SubMapIterator<K>
        implements Spliterator<K> {
            SubMapKeyIterator(Entry<K, V> first, Entry<K, V> fence) {
                super(first, fence);
            }

            @Override
            public K next() {
                return this.nextEntry().key;
            }

            @Override
            public void remove() {
                this.removeAscending();
            }

            @Override
            public Spliterator<K> trySplit() {
                return null;
            }

            @Override
            public void forEachRemaining(Consumer<? super K> action) {
                while (this.hasNext()) {
                    action.accept(this.next());
                }
            }

            @Override
            public boolean tryAdvance(Consumer<? super K> action) {
                if (this.hasNext()) {
                    action.accept(this.next());
                    return true;
                }
                return false;
            }

            @Override
            public long estimateSize() {
                return Long.MAX_VALUE;
            }

            @Override
            public int characteristics() {
                return 21;
            }

            @Override
            public final Comparator<? super K> getComparator() {
                return NavigableSubMap.this.comparator();
            }
        }

        final class DescendingSubMapEntryIterator
        extends SubMapIterator<Map.Entry<K, V>> {
            DescendingSubMapEntryIterator(NavigableSubMap this$0, Entry<K, V> last, Entry<K, V> fence) {
                super(last, fence);
            }

            @Override
            public Map.Entry<K, V> next() {
                return this.prevEntry();
            }

            @Override
            public void remove() {
                this.removeDescending();
            }
        }

        final class SubMapEntryIterator
        extends SubMapIterator<Map.Entry<K, V>> {
            SubMapEntryIterator(NavigableSubMap this$0, Entry<K, V> first, Entry<K, V> fence) {
                super(first, fence);
            }

            @Override
            public Map.Entry<K, V> next() {
                return this.nextEntry();
            }

            @Override
            public void remove() {
                this.removeAscending();
            }
        }

        abstract class SubMapIterator<T>
        implements Iterator<T> {
            Entry<K, V> lastReturned;
            Entry<K, V> next;
            final Object fenceKey;
            int expectedModCount;

            SubMapIterator(Entry<K, V> first, Entry<K, V> fence) {
                this.expectedModCount = NavigableSubMap.this.m.modCount;
                this.lastReturned = null;
                this.next = first;
                this.fenceKey = fence == null ? UNBOUNDED : fence.key;
            }

            @Override
            public final boolean hasNext() {
                return this.next != null && this.next.key != this.fenceKey;
            }

            final Entry<K, V> nextEntry() {
                Entry e = this.next;
                if (e == null || e.key == this.fenceKey) {
                    throw new NoSuchElementException();
                }
                if (NavigableSubMap.this.m.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                this.next = TreeMap.successor(e);
                this.lastReturned = e;
                return e;
            }

            final Entry<K, V> prevEntry() {
                Entry e = this.next;
                if (e == null || e.key == this.fenceKey) {
                    throw new NoSuchElementException();
                }
                if (NavigableSubMap.this.m.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                this.next = TreeMap.predecessor(e);
                this.lastReturned = e;
                return e;
            }

            final void removeAscending() {
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                if (NavigableSubMap.this.m.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                if (this.lastReturned.left != null && this.lastReturned.right != null) {
                    this.next = this.lastReturned;
                }
                NavigableSubMap.this.m.deleteEntry(this.lastReturned);
                this.lastReturned = null;
                this.expectedModCount = NavigableSubMap.this.m.modCount;
            }

            final void removeDescending() {
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                if (NavigableSubMap.this.m.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                NavigableSubMap.this.m.deleteEntry(this.lastReturned);
                this.lastReturned = null;
                this.expectedModCount = NavigableSubMap.this.m.modCount;
            }
        }

        abstract class EntrySetView
        extends AbstractSet<Map.Entry<K, V>> {
            private transient int size = -1;
            private transient int sizeModCount;

            EntrySetView() {
            }

            @Override
            public int size() {
                if (NavigableSubMap.this.fromStart && NavigableSubMap.this.toEnd) {
                    return NavigableSubMap.this.m.size();
                }
                if (this.size == -1 || this.sizeModCount != NavigableSubMap.this.m.modCount) {
                    this.sizeModCount = NavigableSubMap.this.m.modCount;
                    this.size = 0;
                    Iterator i = this.iterator();
                    while (i.hasNext()) {
                        ++this.size;
                        i.next();
                    }
                }
                return this.size;
            }

            @Override
            public boolean isEmpty() {
                Entry n = NavigableSubMap.this.absLowest();
                return n == null || NavigableSubMap.this.tooHigh(n.key);
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                Object key = entry.getKey();
                if (!NavigableSubMap.this.inRange(key)) {
                    return false;
                }
                Entry node = NavigableSubMap.this.m.getEntry(key);
                return node != null && TreeMap.valEquals(node.getValue(), entry.getValue());
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                Object key = entry.getKey();
                if (!NavigableSubMap.this.inRange(key)) {
                    return false;
                }
                Entry node = NavigableSubMap.this.m.getEntry(key);
                if (node != null && TreeMap.valEquals(node.getValue(), entry.getValue())) {
                    NavigableSubMap.this.m.deleteEntry(node);
                    return true;
                }
                return false;
            }
        }
    }

    abstract class PrivateEntryIterator<T>
    implements Iterator<T> {
        Entry<K, V> next;
        Entry<K, V> lastReturned;
        int expectedModCount;

        PrivateEntryIterator(Entry<K, V> first) {
            this.expectedModCount = TreeMap.this.modCount;
            this.lastReturned = null;
            this.next = first;
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        final Entry<K, V> nextEntry() {
            Entry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            if (TreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.next = TreeMap.successor(e);
            this.lastReturned = e;
            return e;
        }

        final Entry<K, V> prevEntry() {
            Entry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            if (TreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.next = TreeMap.predecessor(e);
            this.lastReturned = e;
            return e;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (TreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastReturned.left != null && this.lastReturned.right != null) {
                this.next = this.lastReturned;
            }
            TreeMap.this.deleteEntry(this.lastReturned);
            this.expectedModCount = TreeMap.this.modCount;
            this.lastReturned = null;
        }
    }

    private class SubMap
    extends AbstractMap<K, V>
    implements SortedMap<K, V>,
    Serializable {
        private static final long serialVersionUID = -6520786458950516097L;
        private boolean fromStart = false;
        private boolean toEnd = false;
        private K fromKey;
        private K toKey;

        private SubMap() {
        }

        private Object readResolve() {
            return new AscendingSubMap(TreeMap.this, this.fromStart, this.fromKey, true, this.toEnd, this.toKey, false);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            throw new InternalError();
        }

        @Override
        public K lastKey() {
            throw new InternalError();
        }

        @Override
        public K firstKey() {
            throw new InternalError();
        }

        @Override
        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            throw new InternalError();
        }

        @Override
        public SortedMap<K, V> headMap(K toKey) {
            throw new InternalError();
        }

        @Override
        public SortedMap<K, V> tailMap(K fromKey) {
            throw new InternalError();
        }

        @Override
        public Comparator<? super K> comparator() {
            throw new InternalError();
        }
    }

    static class TreeMapSpliterator<K, V> {
        final TreeMap<K, V> tree;
        Entry<K, V> current;
        Entry<K, V> fence;
        int side;
        int est;
        int expectedModCount;

        TreeMapSpliterator(TreeMap<K, V> tree, Entry<K, V> origin, Entry<K, V> fence, int side, int est, int expectedModCount) {
            this.tree = tree;
            this.current = origin;
            this.fence = fence;
            this.side = side;
            this.est = est;
            this.expectedModCount = expectedModCount;
        }

        final int getEstimate() {
            int s = this.est;
            if (s < 0) {
                TreeMap<K, V> t = this.tree;
                if (t != null) {
                    this.current = s == -1 ? t.getFirstEntry() : t.getLastEntry();
                    s = this.est = t.size;
                    this.expectedModCount = t.modCount;
                } else {
                    this.est = 0;
                    s = 0;
                }
            }
            return s;
        }

        public final long estimateSize() {
            return this.getEstimate();
        }
    }

    final class ValueIterator
    extends PrivateEntryIterator<V> {
        ValueIterator(TreeMap this$0, Entry<K, V> first) {
            super(first);
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    static final class ValueSpliterator<K, V>
    extends TreeMapSpliterator<K, V>
    implements Spliterator<V> {
        ValueSpliterator(TreeMap<K, V> tree, Entry<K, V> origin, Entry<K, V> fence, int side, int est, int expectedModCount) {
            super(tree, origin, fence, side, est, expectedModCount);
        }

        public ValueSpliterator<K, V> trySplit() {
            Entry s;
            if (this.est < 0) {
                this.getEstimate();
            }
            int d = this.side;
            Entry e = this.current;
            Entry f = this.fence;
            Entry entry = e == null || e == f ? null : (d == 0 ? this.tree.root : (d > 0 ? e.right : (s = d < 0 && f != null ? f.left : null)));
            if (s != null && s != e && s != f && this.tree.compare(e.key, s.key) < 0) {
                this.side = 1;
                this.current = s;
                return new ValueSpliterator(this.tree, e, this.current, -1, this.est >>>= 1, this.expectedModCount);
            }
            return null;
        }

        @Override
        public void forEachRemaining(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.est < 0) {
                this.getEstimate();
            }
            Entry f = this.fence;
            Entry e = this.current;
            if (e != null && e != f) {
                Entry p;
                this.current = f;
                do {
                    action.accept(e.value);
                    p = e.right;
                    if (p != null) {
                        Entry pl;
                        while ((pl = p.left) != null) {
                            p = pl;
                        }
                    } else {
                        while ((p = e.parent) != null && e == p.right) {
                            e = p;
                        }
                    }
                } while ((e = p) != null && e != f);
                if (this.tree.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super V> action) {
            Entry e;
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.est < 0) {
                this.getEstimate();
            }
            if ((e = this.current) == null || e == this.fence) {
                return false;
            }
            this.current = TreeMap.successor(e);
            action.accept(e.value);
            if (this.tree.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return true;
        }

        @Override
        public int characteristics() {
            return (this.side == 0 ? 64 : 0) | 0x10;
        }
    }

    class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator(TreeMap.this, TreeMap.this.getFirstEntry());
        }

        @Override
        public int size() {
            return TreeMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return TreeMap.this.containsValue(o);
        }

        @Override
        public boolean remove(Object o) {
            Entry e = TreeMap.this.getFirstEntry();
            while (e != null) {
                if (TreeMap.valEquals(e.getValue(), o)) {
                    TreeMap.this.deleteEntry(e);
                    return true;
                }
                e = TreeMap.successor(e);
            }
            return false;
        }

        @Override
        public void clear() {
            TreeMap.this.clear();
        }

        @Override
        public Spliterator<V> spliterator() {
            return new ValueSpliterator(TreeMap.this, null, null, 0, -1, 0);
        }
    }
}

