/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.igj.qual.I;
import org.checkerframework.checker.igj.qual.Mutable;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;

@I
public abstract class AbstractSet<E>
extends AbstractCollection<E>
implements Set<E> {
    protected AbstractSet() {
    }

    @Override
    @Pure
    public boolean equals(@org.checkerframework.checker.igj.qual.ReadOnly AbstractSet<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Collection collection = (Collection)object;
        if (collection.size() != this.size()) {
            return false;
        }
        try {
            return this.containsAll(collection);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    @Override
    @Pure
    public int hashCode(@org.checkerframework.checker.igj.qual.ReadOnly AbstractSet<E> this) {
        int n = 0;
        for (Object e : this) {
            if (e == null) continue;
            n += e.hashCode();
        }
        return n;
    }

    @Override
    public boolean removeAll(@Mutable AbstractSet<E> this, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Collection<?> collection) {
        Objects.requireNonNull(collection);
        boolean bl = false;
        if (this.size() > collection.size()) {
            Iterator<?> iterator = collection.iterator();
            while (iterator.hasNext()) {
                bl |= this.remove(iterator.next());
            }
        } else {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (!collection.contains(iterator.next())) continue;
                iterator.remove();
                bl = true;
            }
        }
        return bl;
    }
}

