/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.checkerframework.checker.igj.qual.I;
import org.checkerframework.checker.igj.qual.Mutable;
import org.checkerframework.checker.javari.qual.PolyRead;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@I
public abstract class AbstractCollection<E>
implements Collection<E> {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    protected AbstractCollection() {
    }

    @Override
    public abstract @I @PolyRead Iterator<E> iterator(@org.checkerframework.checker.igj.qual.ReadOnly AbstractCollection<E> this);

    @Override
    @Pure
    public abstract int size(@org.checkerframework.checker.igj.qual.ReadOnly AbstractCollection<E> this);

    @Override
    @Pure
    public boolean isEmpty(@org.checkerframework.checker.igj.qual.ReadOnly AbstractCollection<E> this) {
        return this.size() == 0;
    }

    @Override
    @Pure
    public boolean contains(@org.checkerframework.checker.igj.qual.ReadOnly AbstractCollection<E> this, @Nullable @ReadOnly Object object) {
        Iterator<E> iterator = this.iterator();
        if (object == null) {
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                return true;
            }
        } else {
            while (iterator.hasNext()) {
                if (!object.equals(iterator.next())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Object[] toArray(@org.checkerframework.checker.igj.qual.ReadOnly AbstractCollection<E> this) {
        Object[] objectArray = new Object[this.size()];
        Iterator<E> iterator = this.iterator();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!iterator.hasNext()) {
                return Arrays.copyOf(objectArray, i);
            }
            objectArray[i] = iterator.next();
        }
        return iterator.hasNext() ? AbstractCollection.finishToArray(objectArray, iterator) : objectArray;
    }

    @Override
    public <T> @Nullable T @PolyNull @Mutable [] toArray(@org.checkerframework.checker.igj.qual.ReadOnly AbstractCollection<E> this, @Nullable T @PolyNull @Mutable [] TArray) {
        int n = this.size();
        T[] TArray2 = TArray.length >= n ? TArray : (Object[])Array.newInstance(TArray.getClass().getComponentType(), n);
        Iterator<E> iterator = this.iterator();
        for (int i = 0; i < TArray2.length; ++i) {
            if (!iterator.hasNext()) {
                if (TArray == TArray2) {
                    TArray2[i] = null;
                } else {
                    if (TArray.length < i) {
                        return Arrays.copyOf(TArray2, i);
                    }
                    System.arraycopy(TArray2, 0, TArray, 0, i);
                    if (TArray.length > i) {
                        TArray[i] = null;
                    }
                }
                return TArray;
            }
            TArray2[i] = iterator.next();
        }
        return iterator.hasNext() ? AbstractCollection.finishToArray(TArray2, iterator) : TArray2;
    }

    private static <T> T[] finishToArray(T[] TArray, Iterator<?> iterator) {
        int n = TArray.length;
        while (iterator.hasNext()) {
            int n2 = TArray.length;
            if (n == n2) {
                int n3 = n2 + (n2 >> 1) + 1;
                if (n3 - 0x7FFFFFF7 > 0) {
                    n3 = AbstractCollection.hugeCapacity(n2 + 1);
                }
                TArray = Arrays.copyOf(TArray, n3);
            }
            TArray[n++] = iterator.next();
        }
        return n == TArray.length ? TArray : Arrays.copyOf(TArray, n);
    }

    private static int hugeCapacity(int n) {
        if (n < 0) {
            throw new OutOfMemoryError("Required array size too large");
        }
        return n > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    @Override
    public boolean add(@Mutable AbstractCollection<E> this, E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(@Mutable AbstractCollection<E> this, @Nullable @ReadOnly Object object) {
        Iterator<E> iterator = this.iterator();
        if (object == null) {
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                iterator.remove();
                return true;
            }
        } else {
            while (iterator.hasNext()) {
                if (!object.equals(iterator.next())) continue;
                iterator.remove();
                return true;
            }
        }
        return false;
    }

    @Override
    @Pure
    public boolean containsAll(@org.checkerframework.checker.igj.qual.ReadOnly AbstractCollection<E> this, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(@Mutable AbstractCollection<E> this, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Collection<? extends E> collection) {
        boolean bl = false;
        for (E e : collection) {
            if (!this.add(e)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean removeAll(@Mutable AbstractCollection<E> this, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Collection<?> collection) {
        Objects.requireNonNull(collection);
        boolean bl = false;
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(@Mutable AbstractCollection<E> this, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Collection<?> collection) {
        Objects.requireNonNull(collection);
        boolean bl = false;
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public void clear(@Mutable AbstractCollection<E> this) {
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    @SideEffectFree
    public String toString(@org.checkerframework.checker.igj.qual.ReadOnly AbstractCollection<E> this) {
        Iterator<E> iterator = this.iterator();
        if (!iterator.hasNext()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        while (true) {
            E e;
            stringBuilder.append((Object)((e = iterator.next()) == this ? "(this Collection)" : e));
            if (!iterator.hasNext()) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(',').append(' ');
        }
    }
}

