/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.text.AttributedCharacterIterator;
import java.text.CalendarBuilder;
import java.text.CharacterIteratorFieldDelegate;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DontCareFieldPosition;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.checkerframework.checker.javari.qual.ReadOnly;
import sun.util.calendar.CalendarUtils;
import sun.util.calendar.ZoneInfoFile;
import sun.util.locale.provider.LocaleProviderAdapter;

public class SimpleDateFormat
extends DateFormat {
    static final long serialVersionUID = 4774881970558875024L;
    static final int currentSerialVersion = 1;
    private int serialVersionOnStream = 1;
    private String pattern;
    private transient NumberFormat originalNumberFormat;
    private transient String originalNumberPattern;
    private transient char minusSign = (char)45;
    private transient boolean hasFollowingMinusSign = false;
    private transient boolean forceStandaloneForm = false;
    private transient char[] compiledPattern;
    private static final int TAG_QUOTE_ASCII_CHAR = 100;
    private static final int TAG_QUOTE_CHARS = 101;
    private transient char zeroDigit;
    private DateFormatSymbols formatData;
    private Date defaultCenturyStart;
    private transient int defaultCenturyStartYear;
    private static final int MILLIS_PER_MINUTE = 60000;
    private static final String GMT = "GMT";
    private static final ConcurrentMap<Locale, NumberFormat> cachedNumberFormatData = new ConcurrentHashMap<Locale, NumberFormat>(3);
    private Locale locale;
    transient boolean useDateFormatSymbols;
    private static final int[] PATTERN_INDEX_TO_CALENDAR_FIELD = new int[]{0, 1, 2, 5, 11, 11, 12, 13, 14, 7, 6, 8, 3, 4, 9, 10, 10, 15, 15, 17, 1000, 15, 2};
    private static final int[] PATTERN_INDEX_TO_DATE_FORMAT_FIELD = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 17, 1, 9, 17, 2};
    private static final DateFormat.Field[] PATTERN_INDEX_TO_DATE_FORMAT_FIELD_ID = new DateFormat.Field[]{DateFormat.Field.ERA, DateFormat.Field.YEAR, DateFormat.Field.MONTH, DateFormat.Field.DAY_OF_MONTH, DateFormat.Field.HOUR_OF_DAY1, DateFormat.Field.HOUR_OF_DAY0, DateFormat.Field.MINUTE, DateFormat.Field.SECOND, DateFormat.Field.MILLISECOND, DateFormat.Field.DAY_OF_WEEK, DateFormat.Field.DAY_OF_YEAR, DateFormat.Field.DAY_OF_WEEK_IN_MONTH, DateFormat.Field.WEEK_OF_YEAR, DateFormat.Field.WEEK_OF_MONTH, DateFormat.Field.AM_PM, DateFormat.Field.HOUR1, DateFormat.Field.HOUR0, DateFormat.Field.TIME_ZONE, DateFormat.Field.TIME_ZONE, DateFormat.Field.YEAR, DateFormat.Field.DAY_OF_WEEK, DateFormat.Field.TIME_ZONE, DateFormat.Field.MONTH};
    private static final int[] REST_OF_STYLES = new int[]{32769, 2, 32770};

    public SimpleDateFormat() {
        this("", Locale.getDefault(Locale.Category.FORMAT));
        this.applyPatternImpl(LocaleProviderAdapter.getResourceBundleBased().getLocaleResources(this.locale).getDateTimePattern(3, 3, this.calendar));
    }

    public SimpleDateFormat(String string) {
        this(string, Locale.getDefault(Locale.Category.FORMAT));
    }

    public SimpleDateFormat(String string, Locale locale) {
        if (string == null || locale == null) {
            throw new NullPointerException();
        }
        this.initializeCalendar(locale);
        this.pattern = string;
        this.formatData = DateFormatSymbols.getInstanceRef(locale);
        this.locale = locale;
        this.initialize(locale);
    }

    public SimpleDateFormat(String string, DateFormatSymbols dateFormatSymbols) {
        if (string == null || dateFormatSymbols == null) {
            throw new NullPointerException();
        }
        this.pattern = string;
        this.formatData = (DateFormatSymbols)dateFormatSymbols.clone();
        this.locale = Locale.getDefault(Locale.Category.FORMAT);
        this.initializeCalendar(this.locale);
        this.initialize(this.locale);
        this.useDateFormatSymbols = true;
    }

    private void initialize(Locale locale) {
        this.compiledPattern = this.compile(this.pattern);
        this.numberFormat = (NumberFormat)cachedNumberFormatData.get(locale);
        if (this.numberFormat == null) {
            this.numberFormat = NumberFormat.getIntegerInstance(locale);
            this.numberFormat.setGroupingUsed(false);
            cachedNumberFormatData.putIfAbsent(locale, this.numberFormat);
        }
        this.numberFormat = (NumberFormat)this.numberFormat.clone();
        this.initializeDefaultCentury();
    }

    private void initializeCalendar(Locale locale) {
        if (this.calendar == null) {
            assert (locale != null);
            this.calendar = Calendar.getInstance(TimeZone.getDefault(), locale);
        }
    }

    private char[] compile(String string) {
        int n;
        int n2 = string.length();
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder(n2 * 2);
        StringBuilder stringBuilder2 = null;
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        int n6 = -1;
        for (n = 0; n < n2; ++n) {
            char c;
            int n7;
            char c2 = string.charAt(n);
            if (c2 == '\'') {
                if (n + 1 < n2 && (c2 = string.charAt(n + 1)) == '\'') {
                    ++n;
                    if (n3 != 0) {
                        SimpleDateFormat.encode(n5, n3, stringBuilder);
                        ++n4;
                        n6 = n5;
                        n5 = -1;
                        n3 = 0;
                    }
                    if (bl) {
                        stringBuilder2.append(c2);
                        continue;
                    }
                    stringBuilder.append((char)(0x6400 | c2));
                    continue;
                }
                if (!bl) {
                    if (n3 != 0) {
                        SimpleDateFormat.encode(n5, n3, stringBuilder);
                        ++n4;
                        n6 = n5;
                        n5 = -1;
                        n3 = 0;
                    }
                    if (stringBuilder2 == null) {
                        stringBuilder2 = new StringBuilder(n2);
                    } else {
                        stringBuilder2.setLength(0);
                    }
                    bl = true;
                    continue;
                }
                n7 = stringBuilder2.length();
                if (n7 == 1) {
                    c = stringBuilder2.charAt(0);
                    if (c < '\u0080') {
                        stringBuilder.append((char)(0x6400 | c));
                    } else {
                        stringBuilder.append('\u6501');
                        stringBuilder.append(c);
                    }
                } else {
                    SimpleDateFormat.encode(101, n7, stringBuilder);
                    stringBuilder.append((CharSequence)stringBuilder2);
                }
                bl = false;
                continue;
            }
            if (bl) {
                stringBuilder2.append(c2);
                continue;
            }
            if (!(c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z')) {
                if (n3 != 0) {
                    SimpleDateFormat.encode(n5, n3, stringBuilder);
                    ++n4;
                    n6 = n5;
                    n5 = -1;
                    n3 = 0;
                }
                if (c2 < '\u0080') {
                    stringBuilder.append((char)(0x6400 | c2));
                    continue;
                }
                for (n7 = n + 1; !(n7 >= n2 || (c = string.charAt(n7)) == '\'' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z'); ++n7) {
                }
                stringBuilder.append((char)(0x6500 | n7 - n));
                while (n < n7) {
                    stringBuilder.append(string.charAt(n));
                    ++n;
                }
                --n;
                continue;
            }
            n7 = "GyMdkHmsSEDFwWahKzZYuXL".indexOf(c2);
            if (n7 == -1) {
                throw new IllegalArgumentException("Illegal pattern character '" + c2 + "'");
            }
            if (n5 == -1 || n5 == n7) {
                n5 = n7;
                ++n3;
                continue;
            }
            SimpleDateFormat.encode(n5, n3, stringBuilder);
            ++n4;
            n6 = n5;
            n5 = n7;
            n3 = 1;
        }
        if (bl) {
            throw new IllegalArgumentException("Unterminated quote");
        }
        if (n3 != 0) {
            SimpleDateFormat.encode(n5, n3, stringBuilder);
            ++n4;
            n6 = n5;
        }
        this.forceStandaloneForm = n4 == 1 && n6 == 2;
        n = stringBuilder.length();
        char[] cArray = new char[n];
        stringBuilder.getChars(0, n, cArray, 0);
        return cArray;
    }

    private static void encode(int n, int n2, StringBuilder stringBuilder) {
        if (n == 21 && n2 >= 4) {
            throw new IllegalArgumentException("invalid ISO 8601 format: length=" + n2);
        }
        if (n2 < 255) {
            stringBuilder.append((char)(n << 8 | n2));
        } else {
            stringBuilder.append((char)(n << 8 | 0xFF));
            stringBuilder.append((char)(n2 >>> 16));
            stringBuilder.append((char)(n2 & 0xFFFF));
        }
    }

    private void initializeDefaultCentury() {
        this.calendar.setTimeInMillis(System.currentTimeMillis());
        this.calendar.add(1, -80);
        this.parseAmbiguousDatesAsAfter(this.calendar.getTime());
    }

    private void parseAmbiguousDatesAsAfter(Date date) {
        this.defaultCenturyStart = date;
        this.calendar.setTime(date);
        this.defaultCenturyStartYear = this.calendar.get(1);
    }

    public void set2DigitYearStart(@ReadOnly Date date) {
        this.parseAmbiguousDatesAsAfter(new Date(date.getTime()));
    }

    public Date get2DigitYearStart(@ReadOnly SimpleDateFormat this) {
        return (Date)this.defaultCenturyStart.clone();
    }

    @Override
    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.endIndex = 0;
        fieldPosition.beginIndex = 0;
        return this.format(date, stringBuffer, fieldPosition.getFieldDelegate());
    }

    private StringBuffer format(Date date, StringBuffer stringBuffer, Format.FieldDelegate fieldDelegate) {
        this.calendar.setTime(date);
        boolean bl = this.useDateFormatSymbols();
        int n = 0;
        block4: while (n < this.compiledPattern.length) {
            int n2;
            int n3 = this.compiledPattern[n] >>> 8;
            if ((n2 = this.compiledPattern[n++] & 0xFF) == 255) {
                n2 = this.compiledPattern[n++] << 16;
                n2 |= this.compiledPattern[n++];
            }
            switch (n3) {
                case 100: {
                    stringBuffer.append((char)n2);
                    continue block4;
                }
                case 101: {
                    stringBuffer.append(this.compiledPattern, n, n2);
                    n += n2;
                    continue block4;
                }
            }
            this.subFormat(n3, n2, fieldDelegate, stringBuffer, bl);
        }
        return stringBuffer;
    }

    @Override
    public AttributedCharacterIterator formatToCharacterIterator(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        CharacterIteratorFieldDelegate characterIteratorFieldDelegate = new CharacterIteratorFieldDelegate();
        if (object instanceof Date) {
            this.format((Date)object, stringBuffer, characterIteratorFieldDelegate);
        } else if (object instanceof Number) {
            this.format(new Date(((Number)object).longValue()), stringBuffer, characterIteratorFieldDelegate);
        } else {
            if (object == null) {
                throw new NullPointerException("formatToCharacterIterator must be passed non-null object");
            }
            throw new IllegalArgumentException("Cannot format given Object as a Date");
        }
        return characterIteratorFieldDelegate.getIterator(stringBuffer.toString());
    }

    private void subFormat(int n, int n2, Format.FieldDelegate fieldDelegate, StringBuffer stringBuffer, boolean bl) {
        int n3;
        int n4;
        int n5 = Integer.MAX_VALUE;
        String string = null;
        int n6 = stringBuffer.length();
        int n7 = PATTERN_INDEX_TO_CALENDAR_FIELD[n];
        if (n7 == 17) {
            if (this.calendar.isWeekDateSupported()) {
                n4 = this.calendar.getWeekYear();
            } else {
                n = 1;
                n7 = PATTERN_INDEX_TO_CALENDAR_FIELD[n];
                n4 = this.calendar.get(n7);
            }
        } else {
            n4 = n7 == 1000 ? CalendarBuilder.toISODayOfWeek(this.calendar.get(7)) : this.calendar.get(n7);
        }
        int n8 = n3 = n2 >= 4 ? 2 : 1;
        if (!bl && n7 < 15 && n != 22) {
            string = this.calendar.getDisplayName(n7, n3, this.locale);
        }
        switch (n) {
            case 0: {
                String[] stringArray;
                if (bl && n4 < (stringArray = this.formatData.getEras()).length) {
                    string = stringArray[n4];
                }
                if (string != null) break;
                string = "";
                break;
            }
            case 1: 
            case 19: {
                if (this.calendar instanceof GregorianCalendar) {
                    if (n2 != 2) {
                        this.zeroPaddingNumber(n4, n2, n5, stringBuffer);
                        break;
                    }
                    this.zeroPaddingNumber(n4, 2, 2, stringBuffer);
                    break;
                }
                if (string != null) break;
                this.zeroPaddingNumber(n4, n3 == 2 ? 1 : n2, n5, stringBuffer);
                break;
            }
            case 2: {
                if (bl) {
                    String[] stringArray;
                    if (n2 >= 4) {
                        stringArray = this.formatData.getMonths();
                        string = stringArray[n4];
                    } else if (n2 == 3) {
                        stringArray = this.formatData.getShortMonths();
                        string = stringArray[n4];
                    }
                } else if (n2 < 3) {
                    string = null;
                } else if (this.forceStandaloneForm && (string = this.calendar.getDisplayName(n7, n3 | 0x8000, this.locale)) == null) {
                    string = this.calendar.getDisplayName(n7, n3, this.locale);
                }
                if (string != null) break;
                this.zeroPaddingNumber(n4 + 1, n2, n5, stringBuffer);
                break;
            }
            case 22: {
                assert (string == null);
                if (this.locale == null) {
                    String[] stringArray;
                    if (n2 >= 4) {
                        stringArray = this.formatData.getMonths();
                        string = stringArray[n4];
                    } else if (n2 == 3) {
                        stringArray = this.formatData.getShortMonths();
                        string = stringArray[n4];
                    }
                } else if (n2 >= 3) {
                    string = this.calendar.getDisplayName(n7, n3 | 0x8000, this.locale);
                }
                if (string != null) break;
                this.zeroPaddingNumber(n4 + 1, n2, n5, stringBuffer);
                break;
            }
            case 4: {
                if (string != null) break;
                if (n4 == 0) {
                    this.zeroPaddingNumber(this.calendar.getMaximum(11) + 1, n2, n5, stringBuffer);
                    break;
                }
                this.zeroPaddingNumber(n4, n2, n5, stringBuffer);
                break;
            }
            case 9: {
                String[] stringArray;
                if (!bl) break;
                if (n2 >= 4) {
                    stringArray = this.formatData.getWeekdays();
                    string = stringArray[n4];
                    break;
                }
                stringArray = this.formatData.getShortWeekdays();
                string = stringArray[n4];
                break;
            }
            case 14: {
                if (!bl) break;
                String[] stringArray = this.formatData.getAmPmStrings();
                string = stringArray[n4];
                break;
            }
            case 15: {
                if (string != null) break;
                if (n4 == 0) {
                    this.zeroPaddingNumber(this.calendar.getLeastMaximum(10) + 1, n2, n5, stringBuffer);
                    break;
                }
                this.zeroPaddingNumber(n4, n2, n5, stringBuffer);
                break;
            }
            case 17: {
                int n9;
                if (string != null) break;
                if (this.formatData.locale == null || this.formatData.isZoneStringsSet) {
                    int n10 = this.formatData.getZoneIndex(this.calendar.getTimeZone().getID());
                    if (n10 == -1) {
                        n4 = this.calendar.get(15) + this.calendar.get(16);
                        stringBuffer.append(ZoneInfoFile.toCustomID(n4));
                        break;
                    }
                    int n11 = n9 = this.calendar.get(16) == 0 ? 1 : 3;
                    if (n2 < 4) {
                        ++n9;
                    }
                    String[][] stringArray = this.formatData.getZoneStringsWrapper();
                    stringBuffer.append(stringArray[n10][n9]);
                    break;
                }
                TimeZone timeZone = this.calendar.getTimeZone();
                n9 = this.calendar.get(16) != 0 ? 1 : 0;
                int n12 = n2 < 4 ? 0 : 1;
                stringBuffer.append(timeZone.getDisplayName(n9 != 0, n12, this.formatData.locale));
                break;
            }
            case 18: {
                n4 = (this.calendar.get(15) + this.calendar.get(16)) / 60000;
                int n13 = 4;
                if (n4 >= 0) {
                    stringBuffer.append('+');
                } else {
                    ++n13;
                }
                int n9 = n4 / 60 * 100 + n4 % 60;
                CalendarUtils.sprintf0d(stringBuffer, n9, n13);
                break;
            }
            case 21: {
                n4 = this.calendar.get(15) + this.calendar.get(16);
                if (n4 == 0) {
                    stringBuffer.append('Z');
                    break;
                }
                if ((n4 /= 60000) >= 0) {
                    stringBuffer.append('+');
                } else {
                    stringBuffer.append('-');
                    n4 = -n4;
                }
                CalendarUtils.sprintf0d(stringBuffer, n4 / 60, 2);
                if (n2 == 1) break;
                if (n2 == 3) {
                    stringBuffer.append(':');
                }
                CalendarUtils.sprintf0d(stringBuffer, n4 % 60, 2);
                break;
            }
            default: {
                if (string != null) break;
                this.zeroPaddingNumber(n4, n2, n5, stringBuffer);
            }
        }
        if (string != null) {
            stringBuffer.append(string);
        }
        int n14 = PATTERN_INDEX_TO_DATE_FORMAT_FIELD[n];
        DateFormat.Field field = PATTERN_INDEX_TO_DATE_FORMAT_FIELD_ID[n];
        fieldDelegate.formatted(n14, field, field, n6, stringBuffer.length(), stringBuffer);
    }

    private void zeroPaddingNumber(int n, int n2, int n3, StringBuffer stringBuffer) {
        try {
            if (this.zeroDigit == '\u0000') {
                this.zeroDigit = ((DecimalFormat)this.numberFormat).getDecimalFormatSymbols().getZeroDigit();
            }
            if (n >= 0) {
                if (n < 100 && n2 >= 1 && n2 <= 2) {
                    if (n < 10) {
                        if (n2 == 2) {
                            stringBuffer.append(this.zeroDigit);
                        }
                        stringBuffer.append((char)(this.zeroDigit + n));
                    } else {
                        stringBuffer.append((char)(this.zeroDigit + n / 10));
                        stringBuffer.append((char)(this.zeroDigit + n % 10));
                    }
                    return;
                }
                if (n >= 1000 && n < 10000) {
                    if (n2 == 4) {
                        stringBuffer.append((char)(this.zeroDigit + n / 1000));
                        stringBuffer.append((char)(this.zeroDigit + (n %= 1000) / 100));
                        stringBuffer.append((char)(this.zeroDigit + (n %= 100) / 10));
                        stringBuffer.append((char)(this.zeroDigit + n % 10));
                        return;
                    }
                    if (n2 == 2 && n3 == 2) {
                        this.zeroPaddingNumber(n % 100, 2, 2, stringBuffer);
                        return;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.numberFormat.setMinimumIntegerDigits(n2);
        this.numberFormat.setMaximumIntegerDigits(n3);
        this.numberFormat.format(n, stringBuffer, DontCareFieldPosition.INSTANCE);
    }

    @Override
    public Date parse(String string, ParsePosition parsePosition) {
        Date date;
        int n;
        this.checkNegativeNumberExpression();
        int n2 = n = parsePosition.index;
        int n3 = string.length();
        boolean[] blArray = new boolean[]{false};
        CalendarBuilder calendarBuilder = new CalendarBuilder();
        int n4 = 0;
        block6: while (n4 < this.compiledPattern.length) {
            int n5;
            int n6 = this.compiledPattern[n4] >>> 8;
            if ((n5 = this.compiledPattern[n4++] & 0xFF) == 255) {
                n5 = this.compiledPattern[n4++] << 16;
                n5 |= this.compiledPattern[n4++];
            }
            switch (n6) {
                case 100: {
                    if (n >= n3 || string.charAt(n) != (char)n5) {
                        parsePosition.index = n2;
                        parsePosition.errorIndex = n;
                        return null;
                    }
                    ++n;
                    continue block6;
                }
                case 101: {
                    while (n5-- > 0) {
                        if (n >= n3 || string.charAt(n) != this.compiledPattern[n4++]) {
                            parsePosition.index = n2;
                            parsePosition.errorIndex = n;
                            return null;
                        }
                        ++n;
                    }
                    continue block6;
                }
            }
            boolean bl = false;
            boolean bl2 = false;
            if (n4 < this.compiledPattern.length) {
                int n7;
                int n8 = this.compiledPattern[n4] >>> 8;
                if (n8 != 100 && n8 != 101) {
                    bl = true;
                }
                if (this.hasFollowingMinusSign && (n8 == 100 || n8 == 101) && (n7 = n8 == 100 ? this.compiledPattern[n4] & 0xFF : this.compiledPattern[n4 + 1]) == this.minusSign) {
                    bl2 = true;
                }
            }
            if ((n = this.subParse(string, n, n6, n5, bl, blArray, parsePosition, bl2, calendarBuilder)) >= 0) continue;
            parsePosition.index = n2;
            return null;
        }
        parsePosition.index = n;
        try {
            date = calendarBuilder.establish(this.calendar).getTime();
            if (blArray[0] && date.before(this.defaultCenturyStart)) {
                date = calendarBuilder.addYear(100).establish(this.calendar).getTime();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            parsePosition.errorIndex = n;
            parsePosition.index = n2;
            return null;
        }
        return date;
    }

    private int matchString(String string, int n, int n2, String[] stringArray, CalendarBuilder calendarBuilder) {
        int n3 = 0;
        int n4 = stringArray.length;
        if (n2 == 7) {
            n3 = 1;
        }
        int n5 = 0;
        int n6 = -1;
        while (n3 < n4) {
            int n7 = stringArray[n3].length();
            if (n7 > n5 && string.regionMatches(true, n, stringArray[n3], 0, n7)) {
                n6 = n3;
                n5 = n7;
            }
            ++n3;
        }
        if (n6 >= 0) {
            calendarBuilder.set(n2, n6);
            return n + n5;
        }
        return -n;
    }

    private int matchString(String string, int n, int n2, Map<String, Integer> map, CalendarBuilder calendarBuilder) {
        if (map != null) {
            if (map instanceof SortedMap) {
                for (String string2 : map.keySet()) {
                    if (!string.regionMatches(true, n, string2, 0, string2.length())) continue;
                    calendarBuilder.set(n2, map.get(string2));
                    return n + string2.length();
                }
                return -n;
            }
            String string3 = null;
            for (String string4 : map.keySet()) {
                int n3 = string4.length();
                if (string3 != null && n3 <= string3.length() || !string.regionMatches(true, n, string4, 0, n3)) continue;
                string3 = string4;
            }
            if (string3 != null) {
                calendarBuilder.set(n2, map.get(string3));
                return n + string3.length();
            }
        }
        return -n;
    }

    private int matchZoneString(String string, int n, String[] stringArray) {
        for (int i = 1; i <= 4; ++i) {
            String string2 = stringArray[i];
            if (!string.regionMatches(true, n, string2, 0, string2.length())) continue;
            return i;
        }
        return -1;
    }

    private boolean matchDSTString(String string, int n, int n2, int n3, String[][] stringArray) {
        int n4 = n3 + 2;
        String string2 = stringArray[n2][n4];
        return string.regionMatches(true, n, string2, 0, string2.length());
    }

    private int subParseZoneString(String string, int n, CalendarBuilder calendarBuilder) {
        int n2;
        boolean bl = false;
        TimeZone timeZone = this.getTimeZone();
        int n3 = this.formatData.getZoneIndex(timeZone.getID());
        Object object = null;
        String[][] stringArray = this.formatData.getZoneStringsWrapper();
        String[] stringArray2 = null;
        int n4 = 0;
        if (n3 != -1 && (n4 = this.matchZoneString(string, n, stringArray2 = stringArray[n3])) > 0) {
            if (n4 <= 2) {
                bl = stringArray2[n4].equalsIgnoreCase(stringArray2[n4 + 2]);
            }
            object = TimeZone.getTimeZone(stringArray2[0]);
        }
        if (object == null && (n3 = this.formatData.getZoneIndex(TimeZone.getDefault().getID())) != -1 && (n4 = this.matchZoneString(string, n, stringArray2 = stringArray[n3])) > 0) {
            if (n4 <= 2) {
                bl = stringArray2[n4].equalsIgnoreCase(stringArray2[n4 + 2]);
            }
            object = TimeZone.getTimeZone(stringArray2[0]);
        }
        if (object == null) {
            n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                stringArray2 = stringArray[i];
                n4 = this.matchZoneString(string, n, stringArray2);
                if (n4 <= 0) continue;
                if (n4 <= 2) {
                    bl = stringArray2[n4].equalsIgnoreCase(stringArray2[n4 + 2]);
                }
                object = TimeZone.getTimeZone(stringArray2[0]);
                break;
            }
        }
        if (object != null) {
            if (!object.equals(timeZone)) {
                this.setTimeZone((TimeZone)object);
            }
            int n5 = n2 = n4 >= 3 ? ((TimeZone)object).getDSTSavings() : 0;
            if (!(bl || n4 >= 3 && n2 == 0)) {
                calendarBuilder.clear(15).set(16, n2);
            }
            return n + stringArray2[n4].length();
        }
        return 0;
    }

    private int subParseNumericZone(String string, int n, int n2, int n3, boolean bl, CalendarBuilder calendarBuilder) {
        int n4;
        block7: {
            n4 = n;
            try {
                char c = string.charAt(n4++);
                if (!this.isDigit(c)) break block7;
                int n5 = c - 48;
                if (this.isDigit(c = string.charAt(n4++))) {
                    n5 = n5 * 10 + (c - 48);
                } else {
                    if (n3 > 0 || !bl) break block7;
                    --n4;
                }
                if (n5 > 23) break block7;
                int n6 = 0;
                if (n3 != 1) {
                    c = string.charAt(n4++);
                    if (bl) {
                        if (c != ':') break block7;
                        c = string.charAt(n4++);
                    }
                    if (!this.isDigit(c)) break block7;
                    n6 = c - 48;
                    if (!this.isDigit(c = string.charAt(n4++)) || (n6 = n6 * 10 + (c - 48)) > 59) break block7;
                }
                calendarBuilder.set(15, (n6 += n5 * 60) * 60000 * n2).set(16, 0);
                return n4;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return 1 - n4;
    }

    private boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private int subParse(String string, int n, int n2, int n3, boolean bl, boolean[] blArray, ParsePosition parsePosition, boolean bl2, CalendarBuilder calendarBuilder) {
        ParsePosition parsePosition2;
        block54: {
            Number number;
            int n4;
            int n5;
            int n6;
            block52: {
                block56: {
                    block55: {
                        block53: {
                            n6 = 0;
                            parsePosition2 = new ParsePosition(0);
                            parsePosition2.index = n;
                            if (n2 == 19 && !this.calendar.isWeekDateSupported()) {
                                n2 = 1;
                            }
                            n5 = PATTERN_INDEX_TO_CALENDAR_FIELD[n2];
                            while (true) {
                                if (parsePosition2.index >= string.length()) {
                                    parsePosition.errorIndex = n;
                                    return -1;
                                }
                                n4 = string.charAt(parsePosition2.index);
                                if (n4 != 32 && n4 != 9) break;
                                ++parsePosition2.index;
                            }
                            n4 = parsePosition2.index;
                            if (n2 != 4 && n2 != 15 && (n2 != 2 || n3 > 2) && n2 != 1 && n2 != 19) break block52;
                            if (!bl) break block53;
                            if (n + n3 > string.length()) break block54;
                            number = this.numberFormat.parse(string.substring(0, n + n3), parsePosition2);
                            break block55;
                        }
                        number = this.numberFormat.parse(string, parsePosition2);
                    }
                    if (number != null) break block56;
                    if (n2 == 1 && !(this.calendar instanceof GregorianCalendar)) break block52;
                    break block54;
                }
                n6 = number.intValue();
                if (bl2 && n6 < 0 && (parsePosition2.index < string.length() && string.charAt(parsePosition2.index) != this.minusSign || parsePosition2.index == string.length() && string.charAt(parsePosition2.index - 1) == this.minusSign)) {
                    n6 = -n6;
                    --parsePosition2.index;
                }
            }
            boolean bl3 = this.useDateFormatSymbols();
            switch (n2) {
                case 0: {
                    if (bl3) {
                        int n7 = this.matchString(string, n, 0, this.formatData.getEras(), calendarBuilder);
                        if (n7 <= 0) break;
                        return n7;
                    }
                    Map<String, Integer> map = this.getDisplayNamesMap(n5, this.locale);
                    int n8 = this.matchString(string, n, n5, map, calendarBuilder);
                    if (n8 <= 0) break;
                    return n8;
                }
                case 1: 
                case 19: {
                    if (!(this.calendar instanceof GregorianCalendar)) {
                        int n9;
                        int n10 = n3 >= 4 ? 2 : 1;
                        Map<String, Integer> map = this.calendar.getDisplayNames(n5, n10, this.locale);
                        if (map != null && (n9 = this.matchString(string, n, n5, map, calendarBuilder)) > 0) {
                            return n9;
                        }
                        calendarBuilder.set(n5, n6);
                        return parsePosition2.index;
                    }
                    if (n3 <= 2 && parsePosition2.index - n4 == 2 && Character.isDigit(string.charAt(n4)) && Character.isDigit(string.charAt(n4 + 1))) {
                        int n11 = this.defaultCenturyStartYear % 100;
                        blArray[0] = n6 == n11;
                        n6 += this.defaultCenturyStartYear / 100 * 100 + (n6 < n11 ? 100 : 0);
                    }
                    calendarBuilder.set(n5, n6);
                    return parsePosition2.index;
                }
                case 2: {
                    if (n3 <= 2) {
                        calendarBuilder.set(2, n6 - 1);
                        return parsePosition2.index;
                    }
                    if (bl3) {
                        int n12 = this.matchString(string, n, 2, this.formatData.getMonths(), calendarBuilder);
                        if (n12 > 0) {
                            return n12;
                        }
                        int n13 = this.matchString(string, n, 2, this.formatData.getShortMonths(), calendarBuilder);
                        if (n13 <= 0) break;
                        return n13;
                    }
                    Map<String, Integer> map = this.getDisplayNamesMap(n5, this.locale);
                    int n14 = this.matchString(string, n, n5, map, calendarBuilder);
                    if (n14 <= 0) break;
                    return n14;
                }
                case 4: {
                    if (!this.isLenient() && (n6 < 1 || n6 > 24)) break;
                    if (n6 == this.calendar.getMaximum(11) + 1) {
                        n6 = 0;
                    }
                    calendarBuilder.set(11, n6);
                    return parsePosition2.index;
                }
                case 9: {
                    int[] nArray;
                    if (bl3) {
                        int n15 = this.matchString(string, n, 7, this.formatData.getWeekdays(), calendarBuilder);
                        if (n15 > 0) {
                            return n15;
                        }
                        int n16 = this.matchString(string, n, 7, this.formatData.getShortWeekdays(), calendarBuilder);
                        if (n16 <= 0) break;
                        return n16;
                    }
                    for (int n17 : nArray = new int[]{2, 1}) {
                        Map<String, Integer> map = this.calendar.getDisplayNames(n5, n17, this.locale);
                        int n18 = this.matchString(string, n, n5, map, calendarBuilder);
                        if (n18 <= 0) continue;
                        return n18;
                    }
                    break;
                }
                case 14: {
                    if (bl3) {
                        int n19 = this.matchString(string, n, 9, this.formatData.getAmPmStrings(), calendarBuilder);
                        if (n19 <= 0) break;
                        return n19;
                    }
                    Map<String, Integer> map = this.getDisplayNamesMap(n5, this.locale);
                    int n20 = this.matchString(string, n, n5, map, calendarBuilder);
                    if (n20 <= 0) break;
                    return n20;
                }
                case 15: {
                    if (!this.isLenient() && (n6 < 1 || n6 > 12)) break;
                    if (n6 == this.calendar.getLeastMaximum(10) + 1) {
                        n6 = 0;
                    }
                    calendarBuilder.set(10, n6);
                    return parsePosition2.index;
                }
                case 17: 
                case 18: {
                    int n21 = 0;
                    try {
                        int n22;
                        char c = string.charAt(parsePosition2.index);
                        if (c == '+') {
                            n21 = 1;
                        } else if (c == '-') {
                            n21 = -1;
                        }
                        if (n21 == 0) {
                            if ((c == 'G' || c == 'g') && string.length() - n >= GMT.length() && string.regionMatches(true, n, GMT, 0, GMT.length())) {
                                int n23;
                                parsePosition2.index = n + GMT.length();
                                if (string.length() - parsePosition2.index > 0) {
                                    c = string.charAt(parsePosition2.index);
                                    if (c == '+') {
                                        n21 = 1;
                                    } else if (c == '-') {
                                        n21 = -1;
                                    }
                                }
                                if (n21 == 0) {
                                    calendarBuilder.set(15, 0).set(16, 0);
                                    return parsePosition2.index;
                                }
                                if ((n23 = this.subParseNumericZone(string, ++parsePosition2.index, n21, 0, true, calendarBuilder)) > 0) {
                                    return n23;
                                }
                                parsePosition2.index = -n23;
                                break;
                            }
                            int n24 = this.subParseZoneString(string, parsePosition2.index, calendarBuilder);
                            if (n24 > 0) {
                                return n24;
                            }
                            parsePosition2.index = -n24;
                            break;
                        }
                        if ((n22 = this.subParseNumericZone(string, ++parsePosition2.index, n21, 0, false, calendarBuilder)) > 0) {
                            return n22;
                        }
                        parsePosition2.index = -n22;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                    break;
                }
                case 21: {
                    int n25;
                    if (string.length() - parsePosition2.index <= 0) break;
                    char c = string.charAt(parsePosition2.index);
                    if (c == 'Z') {
                        calendarBuilder.set(15, 0).set(16, 0);
                        return ++parsePosition2.index;
                    }
                    if (c == '+') {
                        n25 = 1;
                    } else if (c == '-') {
                        n25 = -1;
                    } else {
                        ++parsePosition2.index;
                        break;
                    }
                    int n26 = this.subParseNumericZone(string, ++parsePosition2.index, n25, n3, n3 == 3, calendarBuilder);
                    if (n26 > 0) {
                        return n26;
                    }
                    parsePosition2.index = -n26;
                    break;
                }
                default: {
                    if (bl) {
                        if (n + n3 > string.length()) break;
                        number = this.numberFormat.parse(string.substring(0, n + n3), parsePosition2);
                    } else {
                        number = this.numberFormat.parse(string, parsePosition2);
                    }
                    if (number == null) break;
                    n6 = number.intValue();
                    if (bl2 && n6 < 0 && (parsePosition2.index < string.length() && string.charAt(parsePosition2.index) != this.minusSign || parsePosition2.index == string.length() && string.charAt(parsePosition2.index - 1) == this.minusSign)) {
                        n6 = -n6;
                        --parsePosition2.index;
                    }
                    calendarBuilder.set(n5, n6);
                    return parsePosition2.index;
                }
            }
        }
        parsePosition.errorIndex = parsePosition2.index;
        return -1;
    }

    private boolean useDateFormatSymbols() {
        return this.useDateFormatSymbols || this.locale == null;
    }

    private String translatePattern(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl) {
                if (c == '\'') {
                    bl = false;
                }
            } else if (c == '\'') {
                bl = true;
            } else if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                int n = string2.indexOf(c);
                if (n >= 0) {
                    if (n < string3.length()) {
                        c = string3.charAt(n);
                    }
                } else {
                    throw new IllegalArgumentException("Illegal pattern  character '" + c + "'");
                }
            }
            stringBuilder.append(c);
        }
        if (bl) {
            throw new IllegalArgumentException("Unfinished quote in pattern");
        }
        return stringBuilder.toString();
    }

    public String toPattern(@ReadOnly SimpleDateFormat this) {
        return this.pattern;
    }

    public String toLocalizedPattern(@ReadOnly SimpleDateFormat this) {
        return this.translatePattern(this.pattern, "GyMdkHmsSEDFwWahKzZYuXL", this.formatData.getLocalPatternChars());
    }

    public void applyPattern(String string) {
        this.applyPatternImpl(string);
    }

    private void applyPatternImpl(String string) {
        this.compiledPattern = this.compile(string);
        this.pattern = string;
    }

    public void applyLocalizedPattern(String string) {
        String string2 = this.translatePattern(string, this.formatData.getLocalPatternChars(), "GyMdkHmsSEDFwWahKzZYuXL");
        this.compiledPattern = this.compile(string2);
        this.pattern = string2;
    }

    public DateFormatSymbols getDateFormatSymbols(@ReadOnly SimpleDateFormat this) {
        return (DateFormatSymbols)this.formatData.clone();
    }

    public void setDateFormatSymbols(@ReadOnly DateFormatSymbols dateFormatSymbols) {
        this.formatData = (DateFormatSymbols)dateFormatSymbols.clone();
        this.useDateFormatSymbols = true;
    }

    @Override
    public Object clone(@ReadOnly SimpleDateFormat this) {
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)super.clone();
        simpleDateFormat.formatData = (DateFormatSymbols)this.formatData.clone();
        return simpleDateFormat;
    }

    @Override
    public int hashCode(@ReadOnly SimpleDateFormat this) {
        return this.pattern.hashCode();
    }

    @Override
    public boolean equals(@ReadOnly SimpleDateFormat this, @ReadOnly Object object) {
        if (!super.equals(object)) {
            return false;
        }
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)object;
        return this.pattern.equals(simpleDateFormat.pattern) && this.formatData.equals(simpleDateFormat.formatData);
    }

    private Map<String, Integer> getDisplayNamesMap(int n, Locale locale) {
        Map<String, Integer> map = this.calendar.getDisplayNames(n, 1, locale);
        for (int n2 : REST_OF_STYLES) {
            Map<String, Integer> map2 = this.calendar.getDisplayNames(n, n2, locale);
            if (map2 == null) continue;
            map.putAll(map2);
        }
        return map;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        String string;
        TimeZone timeZone;
        objectInputStream.defaultReadObject();
        try {
            this.compiledPattern = this.compile(this.pattern);
        }
        catch (Exception exception) {
            throw new InvalidObjectException("invalid pattern");
        }
        if (this.serialVersionOnStream < 1) {
            this.initializeDefaultCentury();
        } else {
            this.parseAmbiguousDatesAsAfter(this.defaultCenturyStart);
        }
        this.serialVersionOnStream = 1;
        TimeZone timeZone2 = this.getTimeZone();
        if (timeZone2 instanceof SimpleTimeZone && (timeZone = TimeZone.getTimeZone(string = timeZone2.getID())) != null && timeZone.hasSameRules(timeZone2) && timeZone.getID().equals(string)) {
            this.setTimeZone(timeZone);
        }
    }

    private void checkNegativeNumberExpression() {
        if (this.numberFormat instanceof DecimalFormat && !this.numberFormat.equals(this.originalNumberFormat)) {
            String string = ((DecimalFormat)this.numberFormat).toPattern();
            if (!string.equals(this.originalNumberPattern)) {
                int n;
                this.hasFollowingMinusSign = false;
                int n2 = string.indexOf(59);
                if (n2 > -1 && (n = string.indexOf(45, n2)) > string.lastIndexOf(48) && n > string.lastIndexOf(35)) {
                    this.hasFollowingMinusSign = true;
                    this.minusSign = ((DecimalFormat)this.numberFormat).getDecimalFormatSymbols().getMinusSign();
                }
                this.originalNumberPattern = string;
            }
            this.originalNumberFormat = this.numberFormat;
        }
    }
}

