/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationFormatError;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.nio.ByteBuffer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import sun.misc.SharedSecrets;
import sun.reflect.CallerSensitive;
import sun.reflect.ConstantPool;
import sun.reflect.MethodAccessor;
import sun.reflect.Reflection;
import sun.reflect.annotation.AnnotationParser;
import sun.reflect.annotation.AnnotationType;
import sun.reflect.annotation.ExceptionProxy;
import sun.reflect.generics.factory.CoreReflectionFactory;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.repository.MethodRepository;
import sun.reflect.generics.scope.MethodScope;

@SuppressWarnings(value={"rawtypes"})
public final class Method
extends Executable {
    private Class<?> clazz;
    private int slot;
    private String name;
    private Class<?> returnType;
    private Class<?>[] parameterTypes;
    private Class<?>[] exceptionTypes;
    private int modifiers;
    private transient String signature;
    private transient MethodRepository genericInfo;
    private byte[] annotations;
    private byte[] parameterAnnotations;
    private byte[] annotationDefault;
    private volatile MethodAccessor methodAccessor;
    private Method root;

    private String getGenericSignature() {
        return this.signature;
    }

    private GenericsFactory getFactory() {
        return CoreReflectionFactory.make(this, MethodScope.make(this));
    }

    @Override
    MethodRepository getGenericInfo() {
        if (this.genericInfo == null) {
            this.genericInfo = MethodRepository.make(this.getGenericSignature(), this.getFactory());
        }
        return this.genericInfo;
    }

    Method(Class<?> clazz, String string, Class<?>[] classArray, Class<?> clazz2, Class<?>[] classArray2, int n, int n2, String string2, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.clazz = clazz;
        this.name = string;
        this.parameterTypes = classArray;
        this.returnType = clazz2;
        this.exceptionTypes = classArray2;
        this.modifiers = n;
        this.slot = n2;
        this.signature = string2;
        this.annotations = byArray;
        this.parameterAnnotations = byArray2;
        this.annotationDefault = byArray3;
    }

    Method copy() {
        Method method = new Method(this.clazz, this.name, this.parameterTypes, this.returnType, this.exceptionTypes, this.modifiers, this.slot, this.signature, this.annotations, this.parameterAnnotations, this.annotationDefault);
        method.root = this;
        method.methodAccessor = this.methodAccessor;
        return method;
    }

    @Override
    boolean hasGenericInformation() {
        return this.getGenericSignature() != null;
    }

    @Override
    byte[] getAnnotationBytes() {
        return this.annotations;
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.clazz;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    public TypeVariable<Method>[] getTypeParameters() {
        if (this.getGenericSignature() != null) {
            return this.getGenericInfo().getTypeParameters();
        }
        return new TypeVariable[0];
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public Type getGenericReturnType() {
        if (this.getGenericSignature() != null) {
            return this.getGenericInfo().getReturnType();
        }
        return this.getReturnType();
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return (Class[])this.parameterTypes.clone();
    }

    @Override
    public int getParameterCount() {
        return this.parameterTypes.length;
    }

    @Override
    public Type[] getGenericParameterTypes() {
        return super.getGenericParameterTypes();
    }

    @Override
    public Class<?>[] getExceptionTypes() {
        return (Class[])this.exceptionTypes.clone();
    }

    @Override
    public Type[] getGenericExceptionTypes() {
        return super.getGenericExceptionTypes();
    }

    @Pure
    public boolean equals(@Nullable Object object) {
        if (object != null && object instanceof Method) {
            Method method = (Method)object;
            if (this.getDeclaringClass() == method.getDeclaringClass() && this.getName() == method.getName()) {
                if (!this.returnType.equals(method.getReturnType())) {
                    return false;
                }
                return this.equalParamTypes(this.parameterTypes, method.parameterTypes);
            }
        }
        return false;
    }

    @Pure
    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode() ^ this.getName().hashCode();
    }

    @SideEffectFree
    public String toString() {
        return this.sharedToString(Modifier.methodModifiers(), this.isDefault(), this.parameterTypes, this.exceptionTypes);
    }

    @Override
    void specificToStringHeader(StringBuilder stringBuilder) {
        stringBuilder.append(this.getReturnType().getTypeName()).append(' ');
        stringBuilder.append(this.getDeclaringClass().getTypeName()).append('.');
        stringBuilder.append(this.getName());
    }

    @Override
    public String toGenericString() {
        return this.sharedToGenericString(Modifier.methodModifiers(), this.isDefault());
    }

    @Override
    void specificToGenericStringHeader(StringBuilder stringBuilder) {
        Type type = this.getGenericReturnType();
        stringBuilder.append(type.getTypeName()).append(' ');
        stringBuilder.append(this.getDeclaringClass().getTypeName()).append('.');
        stringBuilder.append(this.getName());
    }

    @CallerSensitive
    public Object invoke(@Nullable Object object, Object ... objectArray) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object object2;
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, (int)this.modifiers)) {
            object2 = Reflection.getCallerClass();
            this.checkAccess((Class<?>)object2, this.clazz, object, this.modifiers);
        }
        if ((object2 = this.methodAccessor) == null) {
            object2 = this.acquireMethodAccessor();
        }
        return object2.invoke(object, objectArray);
    }

    @Pure
    public boolean isBridge() {
        return (this.getModifiers() & 0x40) != 0;
    }

    @Override
    @Pure
    public boolean isVarArgs() {
        return super.isVarArgs();
    }

    @Override
    @Pure
    public boolean isSynthetic() {
        return super.isSynthetic();
    }

    public boolean isDefault() {
        return (this.getModifiers() & 0x409) == 1 && this.getDeclaringClass().isInterface();
    }

    private MethodAccessor acquireMethodAccessor() {
        MethodAccessor methodAccessor = null;
        if (this.root != null) {
            methodAccessor = this.root.getMethodAccessor();
        }
        if (methodAccessor != null) {
            this.methodAccessor = methodAccessor;
        } else {
            methodAccessor = reflectionFactory.newMethodAccessor(this);
            this.setMethodAccessor(methodAccessor);
        }
        return methodAccessor;
    }

    MethodAccessor getMethodAccessor() {
        return this.methodAccessor;
    }

    void setMethodAccessor(MethodAccessor methodAccessor) {
        this.methodAccessor = methodAccessor;
        if (this.root != null) {
            this.root.setMethodAccessor(methodAccessor);
        }
    }

    public @Nullable Object getDefaultValue() {
        if (this.annotationDefault == null) {
            return null;
        }
        Class<?> clazz = AnnotationType.invocationHandlerReturnType(this.getReturnType());
        Object object = AnnotationParser.parseMemberValue(clazz, (ByteBuffer)ByteBuffer.wrap(this.annotationDefault), (ConstantPool)SharedSecrets.getJavaLangAccess().getConstantPool(this.getDeclaringClass()), this.getDeclaringClass());
        if (object instanceof ExceptionProxy) {
            throw new AnnotationFormatError("Invalid default: " + this);
        }
        return object;
    }

    @Override
    public <T extends Annotation> @Nullable T getAnnotation(Class<T> clazz) {
        return super.getAnnotation(clazz);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return super.getDeclaredAnnotations();
    }

    @Override
    public Annotation[][] getParameterAnnotations() {
        return this.sharedGetParameterAnnotations(this.parameterTypes, this.parameterAnnotations);
    }

    @Override
    public AnnotatedType getAnnotatedReturnType() {
        return this.getAnnotatedReturnType0(this.getGenericReturnType());
    }

    void handleParameterNumberMismatch(int n, int n2) {
        throw new AnnotationFormatError("Parameter annotations don't match number of parameters");
    }
}

