/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.Raw;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import sun.misc.SharedSecrets;
import sun.reflect.CallerSensitive;
import sun.reflect.ConstantPool;
import sun.reflect.FieldAccessor;
import sun.reflect.Reflection;
import sun.reflect.annotation.AnnotationParser;
import sun.reflect.annotation.AnnotationSupport;
import sun.reflect.annotation.TypeAnnotation;
import sun.reflect.annotation.TypeAnnotationParser;
import sun.reflect.generics.factory.CoreReflectionFactory;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.repository.FieldRepository;
import sun.reflect.generics.scope.ClassScope;

public final class Field
extends AccessibleObject
implements Member {
    private Class<?> clazz;
    private int slot;
    private String name;
    private Class<?> type;
    private int modifiers;
    private transient String signature;
    private transient FieldRepository genericInfo;
    private byte[] annotations;
    private FieldAccessor fieldAccessor;
    private FieldAccessor overrideFieldAccessor;
    private Field root;
    private transient Map<Class<? extends Annotation>, Annotation> declaredAnnotations;

    private String getGenericSignature() {
        return this.signature;
    }

    private GenericsFactory getFactory() {
        Class<?> clazz = this.getDeclaringClass();
        return CoreReflectionFactory.make(clazz, ClassScope.make(clazz));
    }

    private FieldRepository getGenericInfo() {
        if (this.genericInfo == null) {
            this.genericInfo = FieldRepository.make(this.getGenericSignature(), this.getFactory());
        }
        return this.genericInfo;
    }

    Field(Class<?> clazz, String string, Class<?> clazz2, int n, int n2, String string2, byte[] byArray) {
        this.clazz = clazz;
        this.name = string;
        this.type = clazz2;
        this.modifiers = n;
        this.slot = n2;
        this.signature = string2;
        this.annotations = byArray;
    }

    Field copy() {
        Field field = new Field(this.clazz, this.name, this.type, this.modifiers, this.slot, this.signature, this.annotations);
        field.root = this;
        field.fieldAccessor = this.fieldAccessor;
        field.overrideFieldAccessor = this.overrideFieldAccessor;
        return field;
    }

    @Override
    @SideEffectFree
    public Class<?> getDeclaringClass(@ReadOnly Field this) {
        return this.clazz;
    }

    @Override
    @SideEffectFree
    public String getName(@ReadOnly Field this) {
        return this.name;
    }

    @Override
    @Pure
    public int getModifiers(@ReadOnly Field this) {
        return this.modifiers;
    }

    @Pure
    public boolean isEnumConstant(@ReadOnly Field this) {
        return (this.getModifiers() & 0x4000) != 0;
    }

    @Override
    @Pure
    public boolean isSynthetic(@ReadOnly Field this) {
        return Modifier.isSynthetic(this.getModifiers());
    }

    @SideEffectFree
    public Class<?> getType(@ReadOnly Field this) {
        return this.type;
    }

    @SideEffectFree
    public Type getGenericType() {
        if (this.getGenericSignature() != null) {
            return this.getGenericInfo().getGenericType();
        }
        return this.getType();
    }

    @Pure
    public boolean equals(@ReadOnly Field this, @Nullable @ReadOnly Object object) {
        if (object != null && object instanceof Field) {
            Field field = (Field)object;
            return this.getDeclaringClass() == field.getDeclaringClass() && this.getName() == field.getName() && this.getType() == field.getType();
        }
        return false;
    }

    @Pure
    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode() ^ this.getName().hashCode();
    }

    @SideEffectFree
    public String toString() {
        int n = this.getModifiers();
        return (n == 0 ? "" : Modifier.toString(n) + " ") + this.getType().getTypeName() + " " + this.getDeclaringClass().getTypeName() + "." + this.getName();
    }

    @SideEffectFree
    public String toGenericString() {
        int n = this.getModifiers();
        Type type = this.getGenericType();
        return (n == 0 ? "" : Modifier.toString(n) + " ") + type.getTypeName() + " " + this.getDeclaringClass().getTypeName() + "." + this.getName();
    }

    @CallerSensitive
    @SideEffectFree
    public @Nullable Object get(@UnknownInitialization @Raw @Nullable Object object) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, (int)this.modifiers)) {
            Class clazz = Reflection.getCallerClass();
            this.checkAccess(clazz, this.clazz, object, this.modifiers);
        }
        return this.getFieldAccessor(object).get(object);
    }

    @CallerSensitive
    @Pure
    public boolean getBoolean(@UnknownInitialization @Raw @Nullable Object object) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, (int)this.modifiers)) {
            Class clazz = Reflection.getCallerClass();
            this.checkAccess(clazz, this.clazz, object, this.modifiers);
        }
        return this.getFieldAccessor(object).getBoolean(object);
    }

    @CallerSensitive
    @Pure
    public byte getByte(@UnknownInitialization @Raw @Nullable Object object) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, (int)this.modifiers)) {
            Class clazz = Reflection.getCallerClass();
            this.checkAccess(clazz, this.clazz, object, this.modifiers);
        }
        return this.getFieldAccessor(object).getByte(object);
    }

    @CallerSensitive
    @Pure
    public char getChar(@UnknownInitialization @Raw @Nullable Object object) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, (int)this.modifiers)) {
            Class clazz = Reflection.getCallerClass();
            this.checkAccess(clazz, this.clazz, object, this.modifiers);
        }
        return this.getFieldAccessor(object).getChar(object);
    }

    @CallerSensitive
    @Pure
    public short getShort(@UnknownInitialization @Raw @Nullable Object object) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, (int)this.modifiers)) {
            Class clazz = Reflection.getCallerClass();
            this.checkAccess(clazz, this.clazz, object, this.modifiers);
        }
        return this.getFieldAccessor(object).getShort(object);
    }

    @CallerSensitive
    @Pure
    public int getInt(@UnknownInitialization @Raw @Nullable Object object) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, (int)this.modifiers)) {
            Class clazz = Reflection.getCallerClass();
            this.checkAccess(clazz, this.clazz, object, this.modifiers);
        }
        return this.getFieldAccessor(object).getInt(object);
    }

    @CallerSensitive
    @Pure
    public long getLong(@UnknownInitialization @Raw @Nullable Object object) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, (int)this.modifiers)) {
            Class clazz = Reflection.getCallerClass();
            this.checkAccess(clazz, this.clazz, object, this.modifiers);
        }
        return this.getFieldAccessor(object).getLong(object);
    }

    @CallerSensitive
    @Pure
    public float getFloat(@UnknownInitialization @Raw @Nullable Object object) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, (int)this.modifiers)) {
            Class clazz = Reflection.getCallerClass();
            this.checkAccess(clazz, this.clazz, object, this.modifiers);
        }
        return this.getFieldAccessor(object).getFloat(object);
    }

    @CallerSensitive
    @Pure
    public double getDouble(@UnknownInitialization @Raw @Nullable Object object) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, (int)this.modifiers)) {
            Class clazz = Reflection.getCallerClass();
            this.checkAccess(clazz, this.clazz, object, this.modifiers);
        }
        return this.getFieldAccessor(object).getDouble(object);
    }

    @CallerSensitive
    public void set(@UnknownInitialization @Raw @Nullable Object object, @Nullable Object object2) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, (int)this.modifiers)) {
            Class clazz = Reflection.getCallerClass();
            this.checkAccess(clazz, this.clazz, object, this.modifiers);
        }
        this.getFieldAccessor(object).set(object, object2);
    }

    @CallerSensitive
    public void setBoolean(@UnknownInitialization @Raw @Nullable Object object, boolean bl) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, (int)this.modifiers)) {
            Class clazz = Reflection.getCallerClass();
            this.checkAccess(clazz, this.clazz, object, this.modifiers);
        }
        this.getFieldAccessor(object).setBoolean(object, bl);
    }

    @CallerSensitive
    public void setByte(@UnknownInitialization @Raw @Nullable Object object, byte by) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, (int)this.modifiers)) {
            Class clazz = Reflection.getCallerClass();
            this.checkAccess(clazz, this.clazz, object, this.modifiers);
        }
        this.getFieldAccessor(object).setByte(object, by);
    }

    @CallerSensitive
    public void setChar(@UnknownInitialization @Raw @Nullable Object object, char c) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, (int)this.modifiers)) {
            Class clazz = Reflection.getCallerClass();
            this.checkAccess(clazz, this.clazz, object, this.modifiers);
        }
        this.getFieldAccessor(object).setChar(object, c);
    }

    @CallerSensitive
    public void setShort(@UnknownInitialization @Raw @Nullable Object object, short s) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, (int)this.modifiers)) {
            Class clazz = Reflection.getCallerClass();
            this.checkAccess(clazz, this.clazz, object, this.modifiers);
        }
        this.getFieldAccessor(object).setShort(object, s);
    }

    @CallerSensitive
    public void setInt(@UnknownInitialization @Raw @Nullable Object object, int n) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, (int)this.modifiers)) {
            Class clazz = Reflection.getCallerClass();
            this.checkAccess(clazz, this.clazz, object, this.modifiers);
        }
        this.getFieldAccessor(object).setInt(object, n);
    }

    @CallerSensitive
    public void setLong(@UnknownInitialization @Raw @Nullable Object object, long l) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, (int)this.modifiers)) {
            Class clazz = Reflection.getCallerClass();
            this.checkAccess(clazz, this.clazz, object, this.modifiers);
        }
        this.getFieldAccessor(object).setLong(object, l);
    }

    @CallerSensitive
    public void setFloat(@UnknownInitialization @Raw @Nullable Object object, float f) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, (int)this.modifiers)) {
            Class clazz = Reflection.getCallerClass();
            this.checkAccess(clazz, this.clazz, object, this.modifiers);
        }
        this.getFieldAccessor(object).setFloat(object, f);
    }

    @CallerSensitive
    public void setDouble(@UnknownInitialization @Raw @Nullable Object object, double d) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, (int)this.modifiers)) {
            Class clazz = Reflection.getCallerClass();
            this.checkAccess(clazz, this.clazz, object, this.modifiers);
        }
        this.getFieldAccessor(object).setDouble(object, d);
    }

    private FieldAccessor getFieldAccessor(Object object) throws IllegalAccessException {
        boolean bl = this.override;
        FieldAccessor fieldAccessor = bl ? this.overrideFieldAccessor : this.fieldAccessor;
        return fieldAccessor != null ? fieldAccessor : this.acquireFieldAccessor(bl);
    }

    private FieldAccessor acquireFieldAccessor(boolean bl) {
        FieldAccessor fieldAccessor = null;
        if (this.root != null) {
            fieldAccessor = this.root.getFieldAccessor(bl);
        }
        if (fieldAccessor != null) {
            if (bl) {
                this.overrideFieldAccessor = fieldAccessor;
            } else {
                this.fieldAccessor = fieldAccessor;
            }
        } else {
            fieldAccessor = reflectionFactory.newFieldAccessor(this, bl);
            this.setFieldAccessor(fieldAccessor, bl);
        }
        return fieldAccessor;
    }

    private FieldAccessor getFieldAccessor(boolean bl) {
        return bl ? this.overrideFieldAccessor : this.fieldAccessor;
    }

    private void setFieldAccessor(FieldAccessor fieldAccessor, boolean bl) {
        if (bl) {
            this.overrideFieldAccessor = fieldAccessor;
        } else {
            this.fieldAccessor = fieldAccessor;
        }
        if (this.root != null) {
            this.root.setFieldAccessor(fieldAccessor, bl);
        }
    }

    @Override
    @SideEffectFree
    public <T extends Annotation> @Nullable T getAnnotation(Class<@NonNull T> clazz) {
        Objects.requireNonNull(clazz);
        return (T)((Annotation)clazz.cast(this.declaredAnnotations().get(clazz)));
    }

    @Override
    public <T extends Annotation> T[] getAnnotationsByType(Class<T> clazz) {
        Objects.requireNonNull(clazz);
        return AnnotationSupport.getDirectlyAndIndirectlyPresent(this.declaredAnnotations(), clazz);
    }

    @Override
    @SideEffectFree
    public Annotation[] getDeclaredAnnotations() {
        return AnnotationParser.toArray(this.declaredAnnotations());
    }

    private synchronized Map<Class<? extends Annotation>, Annotation> declaredAnnotations() {
        if (this.declaredAnnotations == null) {
            this.declaredAnnotations = AnnotationParser.parseAnnotations((byte[])this.annotations, (ConstantPool)SharedSecrets.getJavaLangAccess().getConstantPool(this.getDeclaringClass()), this.getDeclaringClass());
        }
        return this.declaredAnnotations;
    }

    private native byte[] getTypeAnnotationBytes0();

    public AnnotatedType getAnnotatedType() {
        return TypeAnnotationParser.buildAnnotatedType((byte[])this.getTypeAnnotationBytes0(), (ConstantPool)SharedSecrets.getJavaLangAccess().getConstantPool(this.getDeclaringClass()), (AnnotatedElement)this, this.getDeclaringClass(), (Type)this.getGenericType(), (TypeAnnotation.TypeAnnotationTarget)TypeAnnotation.TypeAnnotationTarget.FIELD);
    }
}

