/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Random;
import org.checkerframework.dataflow.qual.Pure;

public final class Math {
    public static final double E = 2.718281828459045;
    public static final double PI = 3.141592653589793;
    private static long negativeZeroFloatBits = Float.floatToRawIntBits(-0.0f);
    private static long negativeZeroDoubleBits = Double.doubleToRawLongBits(-0.0);
    static double twoToTheDoubleScaleUp = Math.powerOfTwoD(512);
    static double twoToTheDoubleScaleDown = Math.powerOfTwoD(-512);

    private Math() {
    }

    @Pure
    public static double sin(double d) {
        return StrictMath.sin(d);
    }

    @Pure
    public static double cos(double d) {
        return StrictMath.cos(d);
    }

    @Pure
    public static double tan(double d) {
        return StrictMath.tan(d);
    }

    @Pure
    public static double asin(double d) {
        return StrictMath.asin(d);
    }

    @Pure
    public static double acos(double d) {
        return StrictMath.acos(d);
    }

    @Pure
    public static double atan(double d) {
        return StrictMath.atan(d);
    }

    @Pure
    public static double toRadians(double d) {
        return d / 180.0 * Math.PI;
    }

    @Pure
    public static double toDegrees(double d) {
        return d * 180.0 / Math.PI;
    }

    @Pure
    public static double exp(double d) {
        return StrictMath.exp(d);
    }

    @Pure
    public static double log(double d) {
        return StrictMath.log(d);
    }

    @Pure
    public static double log10(double d) {
        return StrictMath.log10(d);
    }

    @Pure
    public static double sqrt(double d) {
        return StrictMath.sqrt(d);
    }

    @Pure
    public static double cbrt(double d) {
        return StrictMath.cbrt(d);
    }

    @Pure
    public static double IEEEremainder(double d, double d2) {
        return StrictMath.IEEEremainder(d, d2);
    }

    @Pure
    public static double ceil(double d) {
        return StrictMath.ceil(d);
    }

    @Pure
    public static double floor(double d) {
        return StrictMath.floor(d);
    }

    @Pure
    public static double rint(double d) {
        return StrictMath.rint(d);
    }

    @Pure
    public static double atan2(double d, double d2) {
        return StrictMath.atan2(d, d2);
    }

    @Pure
    public static double pow(double d, double d2) {
        return StrictMath.pow(d, d2);
    }

    @Pure
    public static int round(float f) {
        int n = Float.floatToRawIntBits(f);
        int n2 = (n & 0x7F800000) >> 23;
        int n3 = 149 - n2;
        if ((n3 & 0xFFFFFFE0) == 0) {
            int n4 = n & 0x7FFFFF | 0x800000;
            if (n < 0) {
                n4 = -n4;
            }
            return (n4 >> n3) + 1 >> 1;
        }
        return (int)f;
    }

    @Pure
    public static long round(double d) {
        long l = Double.doubleToRawLongBits(d);
        long l2 = (l & 0x7FF0000000000000L) >> 52;
        long l3 = 1074L - l2;
        if ((l3 & 0xFFFFFFFFFFFFFFC0L) == 0L) {
            long l4 = l & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
            if (l < 0L) {
                l4 = -l4;
            }
            return (l4 >> (int)l3) + 1L >> 1;
        }
        return (long)d;
    }

    @Pure
    public static double random() {
        return RandomNumberGeneratorHolder.randomNumberGenerator.nextDouble();
    }

    public static int addExact(int n, int n2) {
        int n3 = n + n2;
        if (((n ^ n3) & (n2 ^ n3)) < 0) {
            throw new ArithmeticException("integer overflow");
        }
        return n3;
    }

    public static long addExact(long l, long l2) {
        long l3 = l + l2;
        if (((l ^ l3) & (l2 ^ l3)) < 0L) {
            throw new ArithmeticException("long overflow");
        }
        return l3;
    }

    public static int subtractExact(int n, int n2) {
        int n3 = n - n2;
        if (((n ^ n2) & (n ^ n3)) < 0) {
            throw new ArithmeticException("integer overflow");
        }
        return n3;
    }

    public static long subtractExact(long l, long l2) {
        long l3 = l - l2;
        if (((l ^ l2) & (l ^ l3)) < 0L) {
            throw new ArithmeticException("long overflow");
        }
        return l3;
    }

    public static int multiplyExact(int n, int n2) {
        long l = (long)n * (long)n2;
        if ((long)((int)l) != l) {
            throw new ArithmeticException("integer overflow");
        }
        return (int)l;
    }

    public static long multiplyExact(long l, long l2) {
        long l3;
        long l4 = l * l2;
        long l5 = Math.abs(l);
        if ((l5 | (l3 = Math.abs(l2))) >>> 31 != 0L && (l2 != 0L && l4 / l2 != l || l == Long.MIN_VALUE && l2 == -1L)) {
            throw new ArithmeticException("long overflow");
        }
        return l4;
    }

    public static int incrementExact(int n) {
        if (n == Integer.MAX_VALUE) {
            throw new ArithmeticException("integer overflow");
        }
        return n + 1;
    }

    public static long incrementExact(long l) {
        if (l == Long.MAX_VALUE) {
            throw new ArithmeticException("long overflow");
        }
        return l + 1L;
    }

    public static int decrementExact(int n) {
        if (n == Integer.MIN_VALUE) {
            throw new ArithmeticException("integer overflow");
        }
        return n - 1;
    }

    public static long decrementExact(long l) {
        if (l == Long.MIN_VALUE) {
            throw new ArithmeticException("long overflow");
        }
        return l - 1L;
    }

    public static int negateExact(int n) {
        if (n == Integer.MIN_VALUE) {
            throw new ArithmeticException("integer overflow");
        }
        return -n;
    }

    public static long negateExact(long l) {
        if (l == Long.MIN_VALUE) {
            throw new ArithmeticException("long overflow");
        }
        return -l;
    }

    public static int toIntExact(long l) {
        if ((long)((int)l) != l) {
            throw new ArithmeticException("integer overflow");
        }
        return (int)l;
    }

    public static int floorDiv(int n, int n2) {
        int n3 = n / n2;
        if ((n ^ n2) < 0 && n3 * n2 != n) {
            --n3;
        }
        return n3;
    }

    public static long floorDiv(long l, long l2) {
        long l3 = l / l2;
        if ((l ^ l2) < 0L && l3 * l2 != l) {
            --l3;
        }
        return l3;
    }

    public static int floorMod(int n, int n2) {
        int n3 = n - Math.floorDiv(n, n2) * n2;
        return n3;
    }

    public static long floorMod(long l, long l2) {
        return l - Math.floorDiv(l, l2) * l2;
    }

    @Pure
    public static int abs(int n) {
        return n < 0 ? -n : n;
    }

    @Pure
    public static long abs(long l) {
        return l < 0L ? -l : l;
    }

    @Pure
    public static float abs(float f) {
        return f <= 0.0f ? 0.0f - f : f;
    }

    @Pure
    public static double abs(double d) {
        return d <= 0.0 ? 0.0 - d : d;
    }

    @Pure
    public static int max(int n, int n2) {
        return n >= n2 ? n : n2;
    }

    @Pure
    public static long max(long l, long l2) {
        return l >= l2 ? l : l2;
    }

    @Pure
    public static float max(float f, float f2) {
        if (f != f) {
            return f;
        }
        if (f == 0.0f && f2 == 0.0f && (long)Float.floatToRawIntBits(f) == negativeZeroFloatBits) {
            return f2;
        }
        return f >= f2 ? f : f2;
    }

    @Pure
    public static double max(double d, double d2) {
        if (d != d) {
            return d;
        }
        if (d == 0.0 && d2 == 0.0 && Double.doubleToRawLongBits(d) == negativeZeroDoubleBits) {
            return d2;
        }
        return d >= d2 ? d : d2;
    }

    @Pure
    public static int min(int n, int n2) {
        return n <= n2 ? n : n2;
    }

    @Pure
    public static long min(long l, long l2) {
        return l <= l2 ? l : l2;
    }

    @Pure
    public static float min(float f, float f2) {
        if (f != f) {
            return f;
        }
        if (f == 0.0f && f2 == 0.0f && (long)Float.floatToRawIntBits(f2) == negativeZeroFloatBits) {
            return f2;
        }
        return f <= f2 ? f : f2;
    }

    @Pure
    public static double min(double d, double d2) {
        if (d != d) {
            return d;
        }
        if (d == 0.0 && d2 == 0.0 && Double.doubleToRawLongBits(d2) == negativeZeroDoubleBits) {
            return d2;
        }
        return d <= d2 ? d : d2;
    }

    @Pure
    public static double ulp(double d) {
        int n = Math.getExponent(d);
        switch (n) {
            case 1024: {
                return Math.abs(d);
            }
            case -1023: {
                return Double.MIN_VALUE;
            }
        }
        assert (n <= 1023 && n >= -1022);
        if ((n -= 52) >= -1022) {
            return Math.powerOfTwoD(n);
        }
        return Double.longBitsToDouble(1L << n - -1074);
    }

    @Pure
    public static float ulp(float f) {
        int n = Math.getExponent(f);
        switch (n) {
            case 128: {
                return Math.abs(f);
            }
            case -127: {
                return Float.MIN_VALUE;
            }
        }
        assert (n <= 127 && n >= -126);
        if ((n -= 23) >= -126) {
            return Math.powerOfTwoF(n);
        }
        return Float.intBitsToFloat(1 << n - -149);
    }

    @Pure
    public static double signum(double d) {
        return d == 0.0 || Double.isNaN(d) ? d : Math.copySign(1.0, d);
    }

    @Pure
    public static float signum(float f) {
        return f == 0.0f || Float.isNaN(f) ? f : Math.copySign(1.0f, f);
    }

    @Pure
    public static double sinh(double d) {
        return StrictMath.sinh(d);
    }

    @Pure
    public static double cosh(double d) {
        return StrictMath.cosh(d);
    }

    @Pure
    public static double tanh(double d) {
        return StrictMath.tanh(d);
    }

    @Pure
    public static double hypot(double d, double d2) {
        return StrictMath.hypot(d, d2);
    }

    @Pure
    public static double expm1(double d) {
        return StrictMath.expm1(d);
    }

    @Pure
    public static double log1p(double d) {
        return StrictMath.log1p(d);
    }

    @Pure
    public static double copySign(double d, double d2) {
        return Double.longBitsToDouble(Double.doubleToRawLongBits(d2) & Long.MIN_VALUE | Double.doubleToRawLongBits(d) & Long.MAX_VALUE);
    }

    @Pure
    public static float copySign(float f, float f2) {
        return Float.intBitsToFloat(Float.floatToRawIntBits(f2) & Integer.MIN_VALUE | Float.floatToRawIntBits(f) & Integer.MAX_VALUE);
    }

    @Pure
    public static int getExponent(float f) {
        return ((Float.floatToRawIntBits(f) & 0x7F800000) >> 23) - 127;
    }

    @Pure
    public static int getExponent(double d) {
        return (int)(((Double.doubleToRawLongBits(d) & 0x7FF0000000000000L) >> 52) - 1023L);
    }

    @Pure
    public static double nextAfter(double d, double d2) {
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return d + d2;
        }
        if (d == d2) {
            return d2;
        }
        long l = Double.doubleToRawLongBits(d + 0.0);
        if (d2 > d) {
            l += l >= 0L ? 1L : -1L;
        } else {
            assert (d2 < d);
            l = l > 0L ? --l : (l < 0L ? ++l : -9223372036854775807L);
        }
        return Double.longBitsToDouble(l);
    }

    @Pure
    public static float nextAfter(float f, double d) {
        if (Float.isNaN(f) || Double.isNaN(d)) {
            return f + (float)d;
        }
        if ((double)f == d) {
            return (float)d;
        }
        int n = Float.floatToRawIntBits(f + 0.0f);
        if (d > (double)f) {
            n += n >= 0 ? 1 : -1;
        } else {
            assert (d < (double)f);
            n = n > 0 ? --n : (n < 0 ? ++n : -2147483647);
        }
        return Float.intBitsToFloat(n);
    }

    @Pure
    public static double nextUp(double d) {
        if (Double.isNaN(d) || d == Double.POSITIVE_INFINITY) {
            return d;
        }
        return Double.longBitsToDouble(Double.doubleToRawLongBits(d += 0.0) + (d >= 0.0 ? 1L : -1L));
    }

    @Pure
    public static float nextUp(float f) {
        if (Float.isNaN(f) || f == Float.POSITIVE_INFINITY) {
            return f;
        }
        return Float.intBitsToFloat(Float.floatToRawIntBits(f += 0.0f) + (f >= 0.0f ? 1 : -1));
    }

    public static double nextDown(double d) {
        if (Double.isNaN(d) || d == Double.NEGATIVE_INFINITY) {
            return d;
        }
        if (d == 0.0) {
            return -4.9E-324;
        }
        return Double.longBitsToDouble(Double.doubleToRawLongBits(d) + (d > 0.0 ? -1L : 1L));
    }

    public static float nextDown(float f) {
        if (Float.isNaN(f) || f == Float.NEGATIVE_INFINITY) {
            return f;
        }
        if (f == 0.0f) {
            return -1.4E-45f;
        }
        return Float.intBitsToFloat(Float.floatToRawIntBits(f) + (f > 0.0f ? -1 : 1));
    }

    @Pure
    public static double scalb(double d, int n) {
        int n2 = 0;
        int n3 = 0;
        double d2 = Double.NaN;
        if (n < 0) {
            n = Math.max(n, -2099);
            n3 = -512;
            d2 = twoToTheDoubleScaleDown;
        } else {
            n = Math.min(n, 2099);
            n3 = 512;
            d2 = twoToTheDoubleScaleUp;
        }
        int n4 = n >> 8 >>> 23;
        n2 = (n + n4 & 0x1FF) - n4;
        d *= Math.powerOfTwoD(n2);
        n -= n2;
        while (n != 0) {
            d *= d2;
            n -= n3;
        }
        return d;
    }

    @Pure
    public static float scalb(float f, int n) {
        n = Math.max(Math.min(n, 278), -278);
        return (float)((double)f * Math.powerOfTwoD(n));
    }

    static double powerOfTwoD(int n) {
        assert (n >= -1022 && n <= 1023);
        return Double.longBitsToDouble((long)n + 1023L << 52 & 0x7FF0000000000000L);
    }

    static float powerOfTwoF(int n) {
        assert (n >= -126 && n <= 127);
        return Float.intBitsToFloat(n + 127 << 23 & 0x7F800000);
    }

    private static final class RandomNumberGeneratorHolder {
        static final Random randomNumberGenerator = new Random();

        private RandomNumberGeneratorHolder() {
        }
    }
}

