/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyFor;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.framework.qual.FromByteCode;
import sun.misc.Unsafe;

/*
 * Exception performing whole class analysis.
 * Exception performing whole class analysis ignored.
 */
public class ConcurrentHashMap<@KeyForBottom K, @KeyForBottom V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
Serializable {
    private static final long serialVersionUID = 7249069246763182397L;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MIN_SEGMENT_TABLE_CAPACITY = 2;
    static final int MAX_SEGMENTS = 65536;
    static final int RETRIES_BEFORE_LOCK = 2;
    private final transient int hashSeed;
    final int segmentMask;
    final int segmentShift;
    final Segment<K, V>[] segments;
    transient Set<K> keySet;
    transient Set<Map.Entry<K, V>> entrySet;
    transient Collection<V> values;
    private static final Unsafe UNSAFE;
    private static final long SBASE;
    private static final int SSHIFT;
    private static final long TBASE;
    private static final int TSHIFT;
    private static final long HASHSEED_OFFSET;
    private static final long SEGSHIFT_OFFSET;
    private static final long SEGMASK_OFFSET;
    private static final long SEGMENTS_OFFSET;

    private static int randomHashSeed(ConcurrentHashMap var0);

    static final <K, V> HashEntry<K, V> entryAt(HashEntry<K, V>[] var0, int var1);

    static final <K, V> void setEntryAt(HashEntry<K, V>[] var0, int var1, HashEntry<K, V> var2);

    private int hash(Object var1);

    static final <K, V> Segment<K, V> segmentAt(Segment<K, V>[] var0, int var1);

    private Segment<K, V> ensureSegment(int var1);

    private Segment<K, V> segmentForHash(int var1);

    static final <K, V> HashEntry<K, V> entryForHash(Segment<K, V> var0, int var1);

    @FromByteCode
    public ConcurrentHashMap(@UnknownKeyFor @NonNull @Initialized int var1, @UnknownKeyFor @NonNull @Initialized float var2, @UnknownKeyFor @NonNull @Initialized int var3);

    @FromByteCode
    public ConcurrentHashMap(@UnknownKeyFor @NonNull @Initialized int var1, @UnknownKeyFor @NonNull @Initialized float var2);

    @FromByteCode
    public ConcurrentHashMap(@UnknownKeyFor @NonNull @Initialized int var1);

    @FromByteCode
    public ConcurrentHashMap();

    public ConcurrentHashMap(Map<? extends K, ? extends V> var1);

    @Override
    @Pure
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized boolean isEmpty();

    @Override
    @Pure
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized int size();

    @Override
    @Pure
    @FromByteCode
    public @Nullable V get(@NonNull @UnknownKeyFor @Initialized Object var1);

    @Override
    @Pure
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized boolean containsKey(@NonNull @UnknownKeyFor @Initialized Object var1);

    @Override
    @Pure
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized boolean containsValue(@NonNull @UnknownKeyFor @Initialized Object var1);

    @Pure
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized boolean contains(@NonNull @UnknownKeyFor @Initialized Object var1);

    @Override
    @FromByteCode
    public @Nullable V put(K var1, V var2);

    @Override
    @FromByteCode
    public @Nullable V putIfAbsent(K var1, V var2);

    @Override
    @FromByteCode
    public void putAll(@UnknownKeyFor @NonNull @Initialized Map<@KeyForBottom @NonNull @Initialized ? extends K, @KeyForBottom @NonNull @Initialized ? extends V> var1);

    @Override
    @FromByteCode
    public @Nullable V remove(@UnknownKeyFor @NonNull @Initialized Object var1);

    @Override
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized boolean remove(@NonNull @UnknownKeyFor @Initialized Object var1, @NonNull @UnknownKeyFor @Initialized Object var2);

    @Override
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized boolean replace(K var1, V var2, V var3);

    @Override
    @FromByteCode
    public @Nullable V replace(K var1, V var2);

    @Override
    @FromByteCode
    public void clear();

    @Override
    @SideEffectFree
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized Set<@KeyFor(value={"this"}) K> keySet();

    @Override
    @SideEffectFree
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized Collection<V> values();

    @Override
    @SideEffectFree
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Map.Entry<@KeyFor(value={"this"}) K, V>> entrySet();

    @SideEffectFree
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized Enumeration<K> keys();

    @SideEffectFree
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized Enumeration<V> elements();

    private void writeObject(ObjectOutputStream var1) throws IOException;

    private void readObject(ObjectInputStream var1) throws IOException, ClassNotFoundException;

    static;

    static class Segment<K, V>
    extends ReentrantLock
    implements Serializable {
        private static final long serialVersionUID = 2249069246763182397L;
        final float loadFactor;

        Segment(float lf) {
            this.loadFactor = lf;
        }
    }

    static final class KeyIterator<K, V>
    extends BaseIterator<K, V>
    implements Iterator<K>,
    Enumeration<K> {
        KeyIterator(Node<K, V>[] tab, int size, int index, int limit, ConcurrentHashMap<K, V> map) {
            super(tab, size, index, limit, map);
        }

        @Override
        public final K next() {
            Node p = this.next;
            if (p == null) {
                throw new NoSuchElementException();
            }
            Object k = p.key;
            this.lastReturned = p;
            this.advance();
            return k;
        }

        @Override
        public final K nextElement() {
            return this.next();
        }
    }

    static final class ValueIterator<K, V>
    extends BaseIterator<K, V>
    implements Iterator<V>,
    Enumeration<V> {
        ValueIterator(Node<K, V>[] tab, int size, int index, int limit, ConcurrentHashMap<K, V> map) {
            super(tab, size, index, limit, map);
        }

        @Override
        public final V next() {
            Node p = this.next;
            if (p == null) {
                throw new NoSuchElementException();
            }
            Object v = p.val;
            this.lastReturned = p;
            this.advance();
            return v;
        }

        @Override
        public final V nextElement() {
            return this.next();
        }
    }

    static final class EntryIterator<K, V>
    extends BaseIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator(Node<K, V>[] tab, int size, int index, int limit, ConcurrentHashMap<K, V> map) {
            super(tab, size, index, limit, map);
        }

        @Override
        public final Map.Entry<K, V> next() {
            Node p = this.next;
            if (p == null) {
                throw new NoSuchElementException();
            }
            Object k = p.key;
            Object v = p.val;
            this.lastReturned = p;
            this.advance();
            return new MapEntry(k, v, this.map);
        }
    }
}

