/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import org.checkerframework.checker.igj.qual.I;
import org.checkerframework.checker.igj.qual.Mutable;
import org.checkerframework.checker.javari.qual.PolyRead;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

/*
 * Exception performing whole class analysis.
 * Exception performing whole class analysis ignored.
 */
@I
public class ArrayDeque<E>
extends AbstractCollection<E>
implements Deque<E>,
Cloneable,
Serializable {
    private transient E[] elements;
    private transient int head;
    private transient int tail;
    private static final int MIN_INITIAL_CAPACITY = 8;
    private static final long serialVersionUID = 2340985798034038923L;

    private void allocateElements(int var1);

    private void doubleCapacity();

    private <T> T[] copyElements(T[] var1);

    public ArrayDeque();

    public ArrayDeque(int var1);

    public @PolyRead ArrayDeque(@org.checkerframework.checker.igj.qual.ReadOnly @PolyRead Collection<? extends E> var1);

    @Override
    public void addFirst(@Mutable ArrayDeque<E> this, E var1);

    @Override
    public void addLast(@Mutable ArrayDeque<E> this, E var1);

    @Override
    public boolean offerFirst(@Mutable ArrayDeque<E> this, E var1);

    @Override
    public boolean offerLast(@Mutable ArrayDeque<E> this, E var1);

    @Override
    public E removeFirst(@Mutable ArrayDeque<E> this);

    @Override
    public E removeLast(@Mutable ArrayDeque<E> this);

    @Override
    public @Nullable E pollFirst(@Mutable ArrayDeque<E> this);

    @Override
    public @Nullable E pollLast(@Mutable ArrayDeque<E> this);

    @Override
    public E getFirst(@org.checkerframework.checker.igj.qual.ReadOnly ArrayDeque<E> this);

    @Override
    public E getLast(@org.checkerframework.checker.igj.qual.ReadOnly ArrayDeque<E> this);

    @Override
    public @Nullable E peekFirst(@org.checkerframework.checker.igj.qual.ReadOnly ArrayDeque<E> this);

    @Override
    public @Nullable E peekLast(@org.checkerframework.checker.igj.qual.ReadOnly ArrayDeque<E> this);

    @Override
    public boolean removeFirstOccurrence(@Mutable ArrayDeque<E> this, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    @Override
    public boolean removeLastOccurrence(@Mutable ArrayDeque<E> this, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    @Override
    public boolean add(@Mutable ArrayDeque<E> this, E var1);

    @Override
    public boolean offer(@Mutable ArrayDeque<E> this, E var1);

    @Override
    public E remove(@Mutable ArrayDeque<E> this);

    @Override
    public @Nullable E poll(@Mutable ArrayDeque<E> this);

    @Override
    public E element(@org.checkerframework.checker.igj.qual.ReadOnly ArrayDeque<E> this);

    @Override
    public @Nullable E peek(@org.checkerframework.checker.igj.qual.ReadOnly ArrayDeque<E> this);

    @Override
    public void push(@Mutable ArrayDeque<E> this, E var1);

    @Override
    public E pop(@Mutable ArrayDeque<E> this);

    private void checkInvariants();

    private boolean delete(int var1);

    @Override
    @Pure
    public int size(@org.checkerframework.checker.igj.qual.ReadOnly ArrayDeque<E> this);

    @Override
    @EnsuresNonNullIf(result=false, expression={"peek()", "peekFirst()", "peekLast()", "poll()", "pollFirst()", "pollLast()"})
    @Pure
    public boolean isEmpty(@org.checkerframework.checker.igj.qual.ReadOnly ArrayDeque<E> this);

    @Override
    public @I @PolyRead Iterator<E> iterator(@org.checkerframework.checker.igj.qual.ReadOnly ArrayDeque<E> this);

    @Override
    public @I @PolyRead Iterator<E> descendingIterator(@org.checkerframework.checker.igj.qual.ReadOnly ArrayDeque<E> this);

    @Override
    @Pure
    public boolean contains(@org.checkerframework.checker.igj.qual.ReadOnly ArrayDeque<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    @Override
    public boolean remove(@Mutable ArrayDeque<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    @Override
    public void clear(@Mutable ArrayDeque<E> this);

    @Override
    public Object[] toArray(@org.checkerframework.checker.igj.qual.ReadOnly ArrayDeque<E> this);

    @Override
    public <T> @Nullable T @PolyNull [] toArray(@org.checkerframework.checker.igj.qual.ReadOnly ArrayDeque<E> this, T @PolyNull [] var1);

    @SideEffectFree
    public @I(value="N") ArrayDeque<E> clone();

    private void writeObject(ObjectOutputStream var1) throws IOException;

    private void readObject(ObjectInputStream var1) throws IOException, ClassNotFoundException;

    static;

    private class DeqIterator
    implements Iterator<E> {
        int cursor;
        int remaining;
        int lastRet;

        DeqIterator() {
            this.remaining = ArrayDeque.this.size();
            this.lastRet = -1;
            this.cursor = ArrayDeque.this.head;
        }

        @Override
        public final boolean hasNext() {
            return this.remaining > 0;
        }

        @Override
        public E next() {
            if (this.remaining <= 0) {
                throw new NoSuchElementException();
            }
            Object[] es = ArrayDeque.this.elements;
            Object e = ArrayDeque.nonNullElementAt((Object[])es, (int)this.cursor);
            this.lastRet = this.cursor;
            this.cursor = ArrayDeque.inc((int)this.lastRet, (int)es.length);
            --this.remaining;
            return e;
        }

        void postDelete(boolean leftShifted) {
            if (leftShifted) {
                this.cursor = ArrayDeque.dec((int)this.cursor, (int)ArrayDeque.this.elements.length);
            }
        }

        @Override
        public final void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.postDelete(ArrayDeque.this.delete(this.lastRet));
            this.lastRet = -1;
        }

        public void forEachRemaining(Consumer<? super E> action) {
            int to;
            Objects.requireNonNull(action);
            int r = this.remaining;
            if (r <= 0) {
                return;
            }
            this.remaining = 0;
            Object[] es = ArrayDeque.this.elements;
            if (es[this.cursor] == null || ArrayDeque.sub((int)ArrayDeque.this.tail, (int)this.cursor, (int)es.length) != r) {
                throw new ConcurrentModificationException();
            }
            int i = this.cursor;
            int end = ArrayDeque.this.tail;
            int n = to = i <= end ? end : es.length;
            while (true) {
                if (i < to) {
                    action.accept(ArrayDeque.elementAt((Object[])es, (int)i));
                    ++i;
                    continue;
                }
                if (to == end) {
                    if (end != ArrayDeque.this.tail) {
                        throw new ConcurrentModificationException();
                    }
                    break;
                }
                i = 0;
                to = end;
            }
            this.lastRet = ArrayDeque.dec((int)end, (int)es.length);
        }
    }

    private class DescendingIterator
    extends DeqIterator {
        DescendingIterator() {
            this.cursor = ArrayDeque.dec((int)ArrayDeque.this.tail, (int)ArrayDeque.this.elements.length);
        }

        @Override
        public final E next() {
            if (this.remaining <= 0) {
                throw new NoSuchElementException();
            }
            Object[] es = ArrayDeque.this.elements;
            Object e = ArrayDeque.nonNullElementAt((Object[])es, (int)this.cursor);
            this.lastRet = this.cursor;
            this.cursor = ArrayDeque.dec((int)this.lastRet, (int)es.length);
            --this.remaining;
            return e;
        }

        @Override
        void postDelete(boolean leftShifted) {
            if (!leftShifted) {
                this.cursor = ArrayDeque.inc((int)this.cursor, (int)ArrayDeque.this.elements.length);
            }
        }

        @Override
        public final void forEachRemaining(Consumer<? super E> action) {
            int to;
            Objects.requireNonNull(action);
            int r = this.remaining;
            if (r <= 0) {
                return;
            }
            this.remaining = 0;
            Object[] es = ArrayDeque.this.elements;
            if (es[this.cursor] == null || ArrayDeque.sub((int)this.cursor, (int)ArrayDeque.this.head, (int)es.length) + 1 != r) {
                throw new ConcurrentModificationException();
            }
            int i = this.cursor;
            int end = ArrayDeque.this.head;
            int n = to = i >= end ? end : 0;
            while (true) {
                if (i > to - 1) {
                    action.accept(ArrayDeque.elementAt((Object[])es, (int)i));
                    --i;
                    continue;
                }
                if (to == end) {
                    if (end != ArrayDeque.this.head) {
                        throw new ConcurrentModificationException();
                    }
                    break;
                }
                i = es.length - 1;
                to = end;
            }
            this.lastRet = end;
        }
    }
}

