/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.checkerframework.checker.javari.qual.PolyRead;
import org.checkerframework.checker.javari.qual.ReadOnly;

/*
 * Exception performing whole class analysis.
 * Exception performing whole class analysis ignored.
 */
public class EnumMap<K extends Enum<K>, V>
extends AbstractMap<K, V>
implements Serializable,
Cloneable {
    private final Class<K> keyType;
    private transient K[] keyUniverse;
    private transient Object[] vals;
    private transient int size;
    private static final Object NULL;
    private static final Enum[] ZERO_LENGTH_ENUM_ARRAY;
    private transient Set<Map.Entry<K, V>> entrySet;
    private static final long serialVersionUID = 458661240069192865L;

    private Object maskNull(Object var1);

    private V unmaskNull(Object var1);

    public EnumMap(Class<K> var1);

    public @PolyRead EnumMap(@PolyRead EnumMap<K, ? extends V> var1);

    public @PolyRead EnumMap(@PolyRead Map<K, ? extends V> var1);

    @Override
    public int size(@ReadOnly EnumMap<K, V> this);

    @Override
    public boolean containsValue(@ReadOnly EnumMap<K, V> this, @ReadOnly Object var1);

    @Override
    public boolean containsKey(@ReadOnly EnumMap<K, V> this, @ReadOnly Object var1);

    private boolean containsMapping(Object var1, Object var2);

    @Override
    public V get(@ReadOnly EnumMap<K, V> this, @ReadOnly Object var1);

    @Override
    public V put(K var1, V var2);

    @Override
    public V remove(@ReadOnly Object var1);

    private boolean removeMapping(Object var1, Object var2);

    private boolean isValidKey(Object var1);

    @Override
    public void putAll(@ReadOnly Map<? extends K, ? extends V> var1);

    @Override
    public void clear();

    @Override
    public @PolyRead Set<K> keySet(@PolyRead EnumMap<K, V> this);

    @Override
    public @PolyRead Collection<V> values(@PolyRead EnumMap<K, V> this);

    @Override
    public @PolyRead Set<Map.Entry<K, V>> entrySet(@PolyRead EnumMap<K, V> this);

    @Override
    public boolean equals(@ReadOnly EnumMap<K, V> this, @ReadOnly Object var1);

    private boolean equals(EnumMap var1);

    @Override
    public int hashCode();

    private int entryHashCode(int var1);

    @Override
    public EnumMap<K, V> clone();

    private void typeCheck(K var1);

    private static <K extends Enum<K>> K[] getKeyUniverse(Class<K> var0);

    private void writeObject(ObjectOutputStream var1) throws IOException;

    private void readObject(ObjectInputStream var1) throws IOException, ClassNotFoundException;

    static;

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return EnumMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return EnumMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            int oldSize = EnumMap.this.size;
            EnumMap.this.remove(o);
            return EnumMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            EnumMap.this.clear();
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return EnumMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return EnumMap.this.containsValue(o);
        }

        @Override
        public boolean remove(Object o) {
            o = EnumMap.this.maskNull(o);
            for (int i = 0; i < EnumMap.this.vals.length; ++i) {
                if (!o.equals(EnumMap.this.vals[i])) continue;
                EnumMap.this.vals[i] = null;
                --EnumMap.this.size;
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            EnumMap.this.clear();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            Map.Entry entry;
            return o instanceof Map.Entry && EnumMap.this.containsMapping((entry = (Map.Entry)o).getKey(), entry.getValue());
        }

        @Override
        public boolean remove(Object o) {
            Map.Entry entry;
            return o instanceof Map.Entry && EnumMap.this.removeMapping((entry = (Map.Entry)o).getKey(), entry.getValue());
        }

        @Override
        public int size() {
            return EnumMap.this.size;
        }

        @Override
        public void clear() {
            EnumMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            return this.fillEntryArray(new Object[EnumMap.this.size]);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            int size = this.size();
            if (a.length < size) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
            }
            if (a.length > size) {
                a[size] = null;
            }
            return this.fillEntryArray(a);
        }

        private Object[] fillEntryArray(Object[] a) {
            int j = 0;
            for (int i = 0; i < EnumMap.this.vals.length; ++i) {
                if (EnumMap.this.vals[i] == null) continue;
                a[j++] = new AbstractMap.SimpleEntry(EnumMap.this.keyUniverse[i], EnumMap.this.unmaskNull(EnumMap.this.vals[i]));
            }
            return a;
        }
    }

    private abstract class EnumMapIterator<T>
    implements Iterator<T> {
        int index = 0;
        int lastReturnedIndex = -1;

        private EnumMapIterator() {
        }

        @Override
        public boolean hasNext() {
            while (this.index < EnumMap.this.vals.length && EnumMap.this.vals[this.index] == null) {
                ++this.index;
            }
            return this.index != EnumMap.this.vals.length;
        }

        @Override
        public void remove() {
            this.checkLastReturnedIndex();
            if (EnumMap.this.vals[this.lastReturnedIndex] != null) {
                EnumMap.this.vals[this.lastReturnedIndex] = null;
                --EnumMap.this.size;
            }
            this.lastReturnedIndex = -1;
        }

        private void checkLastReturnedIndex() {
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException();
            }
        }
    }

    private class KeyIterator
    extends EnumMapIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturnedIndex = this.index++;
            return EnumMap.this.keyUniverse[this.lastReturnedIndex];
        }
    }

    private class ValueIterator
    extends EnumMapIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturnedIndex = this.index++;
            return EnumMap.this.unmaskNull(EnumMap.this.vals[this.lastReturnedIndex]);
        }
    }

    private class EntryIterator
    extends EnumMapIterator<Map.Entry<K, V>> {
        private java.util.EnumMap$EntryIterator.Entry lastReturnedEntry;

        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturnedEntry = new Entry(this.index++);
            return this.lastReturnedEntry;
        }

        @Override
        public void remove() {
            this.lastReturnedIndex = null == this.lastReturnedEntry ? -1 : this.lastReturnedEntry.index;
            super.remove();
            this.lastReturnedEntry.index = this.lastReturnedIndex;
            this.lastReturnedEntry = null;
        }

        private class Entry
        implements Map.Entry<K, V> {
            private int index;

            private Entry(int index) {
                this.index = index;
            }

            @Override
            public K getKey() {
                this.checkIndexForEntryUse();
                return EnumMap.this.keyUniverse[this.index];
            }

            @Override
            public V getValue() {
                this.checkIndexForEntryUse();
                return EnumMap.this.unmaskNull(EnumMap.this.vals[this.index]);
            }

            @Override
            public V setValue(V value) {
                this.checkIndexForEntryUse();
                Object oldValue = EnumMap.this.unmaskNull(EnumMap.this.vals[this.index]);
                EnumMap.this.vals[this.index] = EnumMap.this.maskNull(value);
                return oldValue;
            }

            @Override
            public boolean equals(Object o) {
                if (this.index < 0) {
                    return o == this;
                }
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                Object ourValue = EnumMap.this.unmaskNull(EnumMap.this.vals[this.index]);
                Object hisValue = e.getValue();
                return e.getKey() == EnumMap.this.keyUniverse[this.index] && (ourValue == hisValue || ourValue != null && ourValue.equals(hisValue));
            }

            @Override
            public int hashCode() {
                if (this.index < 0) {
                    return super.hashCode();
                }
                return EnumMap.this.entryHashCode(this.index);
            }

            public String toString() {
                if (this.index < 0) {
                    return super.toString();
                }
                return EnumMap.this.keyUniverse[this.index] + "=" + EnumMap.this.unmaskNull(EnumMap.this.vals[this.index]);
            }

            private void checkIndexForEntryUse() {
                if (this.index < 0) {
                    throw new IllegalStateException("Entry was removed");
                }
            }
        }
    }
}

