/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import org.checkerframework.checker.igj.qual.I;
import org.checkerframework.checker.igj.qual.Mutable;
import org.checkerframework.checker.javari.qual.PolyRead;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@I
public class PriorityQueue<E>
extends AbstractQueue<E>
implements Serializable {
    private static final long serialVersionUID = -7720805057305804111L;
    private static final int DEFAULT_INITIAL_CAPACITY = 11;
    private transient Object[] queue;
    private int size = 0;
    private final Comparator<? super E> comparator;
    private transient int modCount = 0;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public PriorityQueue() {
        this(11, null);
    }

    public PriorityQueue(int n) {
        this(n, null);
    }

    public PriorityQueue(int n, @org.checkerframework.checker.igj.qual.ReadOnly Comparator<? super E> comparator) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.queue = new Object[n];
        this.comparator = comparator;
    }

    public @PolyRead PriorityQueue(@org.checkerframework.checker.igj.qual.ReadOnly @PolyRead Collection<? extends E> collection) {
        if (collection instanceof SortedSet) {
            SortedSet sortedSet = (SortedSet)collection;
            this.comparator = sortedSet.comparator();
            this.initElementsFromCollection(sortedSet);
        } else if (collection instanceof PriorityQueue) {
            PriorityQueue priorityQueue = (PriorityQueue)collection;
            this.comparator = priorityQueue.comparator();
            this.initFromPriorityQueue(priorityQueue);
        } else {
            this.comparator = null;
            this.initFromCollection(collection);
        }
    }

    public @PolyRead PriorityQueue(@org.checkerframework.checker.igj.qual.ReadOnly @PolyRead PriorityQueue<? extends E> priorityQueue) {
        this.comparator = priorityQueue.comparator();
        this.initFromPriorityQueue(priorityQueue);
    }

    public @PolyRead PriorityQueue(@org.checkerframework.checker.igj.qual.ReadOnly @PolyRead SortedSet<? extends E> sortedSet) {
        this.comparator = sortedSet.comparator();
        this.initElementsFromCollection(sortedSet);
    }

    private void initFromPriorityQueue(PriorityQueue<? extends E> priorityQueue) {
        if (priorityQueue.getClass() == PriorityQueue.class) {
            this.queue = priorityQueue.toArray();
            this.size = priorityQueue.size();
        } else {
            this.initFromCollection(priorityQueue);
        }
    }

    private void initElementsFromCollection(Collection<? extends E> collection) {
        int n;
        Object[] objectArray = collection.toArray();
        if (objectArray.getClass() != Object[].class) {
            objectArray = Arrays.copyOf(objectArray, objectArray.length, Object[].class);
        }
        if ((n = objectArray.length) == 1 || this.comparator != null) {
            for (int i = 0; i < n; ++i) {
                if (objectArray[i] != null) continue;
                throw new NullPointerException();
            }
        }
        this.queue = objectArray;
        this.size = objectArray.length;
    }

    private void initFromCollection(Collection<? extends E> collection) {
        this.initElementsFromCollection(collection);
        this.heapify();
    }

    private void grow(int n) {
        int n2;
        int n3 = n2 + ((n2 = this.queue.length) < 64 ? n2 + 2 : n2 >> 1);
        if (n3 - 0x7FFFFFF7 > 0) {
            n3 = PriorityQueue.hugeCapacity(n);
        }
        this.queue = Arrays.copyOf(this.queue, n3);
    }

    private static int hugeCapacity(int n) {
        if (n < 0) {
            throw new OutOfMemoryError();
        }
        return n > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    @Override
    public boolean add(@Mutable PriorityQueue<E> this, E e) {
        return this.offer(e);
    }

    @Override
    public boolean offer(@Mutable PriorityQueue<E> this, E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        ++this.modCount;
        int n = this.size;
        if (n >= this.queue.length) {
            this.grow(n + 1);
        }
        this.size = n + 1;
        if (n == 0) {
            this.queue[0] = e;
        } else {
            this.siftUp(n, e);
        }
        return true;
    }

    @Override
    public @Nullable E peek(@org.checkerframework.checker.igj.qual.ReadOnly PriorityQueue<E> this) {
        if (this.size == 0) {
            return null;
        }
        return (E)this.queue[0];
    }

    private int indexOf(Object object) {
        if (object != null) {
            for (int i = 0; i < this.size; ++i) {
                if (!object.equals(this.queue[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean remove(@Mutable PriorityQueue<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        int n = this.indexOf(object);
        if (n == -1) {
            return false;
        }
        this.removeAt(n);
        return true;
    }

    boolean removeEq(Object object) {
        for (int i = 0; i < this.size; ++i) {
            if (object != this.queue[i]) continue;
            this.removeAt(i);
            return true;
        }
        return false;
    }

    @Override
    @Pure
    public boolean contains(@org.checkerframework.checker.igj.qual.ReadOnly PriorityQueue<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public Object[] toArray(@org.checkerframework.checker.igj.qual.ReadOnly PriorityQueue<E> this) {
        return Arrays.copyOf(this.queue, this.size);
    }

    @Override
    public <T> @Nullable T @PolyNull [] toArray(@org.checkerframework.checker.igj.qual.ReadOnly PriorityQueue<E> this, T @PolyNull [] TArray) {
        if (TArray.length < this.size) {
            return Arrays.copyOf(this.queue, this.size, TArray.getClass());
        }
        System.arraycopy(this.queue, 0, TArray, 0, this.size);
        if (TArray.length > this.size) {
            TArray[this.size] = null;
        }
        return TArray;
    }

    @Override
    public @I @PolyRead Iterator<E> iterator(@org.checkerframework.checker.igj.qual.ReadOnly PriorityQueue<E> this) {
        return new Itr(this, null);
    }

    @Override
    @Pure
    public int size(@org.checkerframework.checker.igj.qual.ReadOnly PriorityQueue<E> this) {
        return this.size;
    }

    @Override
    public void clear(@Mutable PriorityQueue<E> this) {
        ++this.modCount;
        for (int i = 0; i < this.size; ++i) {
            this.queue[i] = null;
        }
        this.size = 0;
    }

    @Override
    public @Nullable E poll(@Mutable PriorityQueue<E> this) {
        if (this.size == 0) {
            return null;
        }
        int n = --this.size;
        ++this.modCount;
        Object object = this.queue[0];
        Object object2 = this.queue[n];
        this.queue[n] = null;
        if (n != 0) {
            this.siftDown(0, object2);
        }
        return (E)object;
    }

    private E removeAt(int n) {
        int n2;
        assert (n >= 0 && n < this.size);
        ++this.modCount;
        if ((n2 = --this.size) == n) {
            this.queue[n] = null;
        } else {
            Object object = this.queue[n2];
            this.queue[n2] = null;
            this.siftDown(n, object);
            if (this.queue[n] == object) {
                this.siftUp(n, object);
                if (this.queue[n] != object) {
                    return (E)object;
                }
            }
        }
        return null;
    }

    private void siftUp(int n, E e) {
        if (this.comparator != null) {
            this.siftUpUsingComparator(n, e);
        } else {
            this.siftUpComparable(n, e);
        }
    }

    private void siftUpComparable(int n, E e) {
        int n2;
        Object object;
        Comparable comparable = (Comparable)e;
        while (n > 0 && comparable.compareTo(object = this.queue[n2 = n - 1 >>> 1]) < 0) {
            this.queue[n] = object;
            n = n2;
        }
        this.queue[n] = comparable;
    }

    private void siftUpUsingComparator(int n, E e) {
        int n2;
        Object object;
        while (n > 0 && this.comparator.compare(e, object = this.queue[n2 = n - 1 >>> 1]) < 0) {
            this.queue[n] = object;
            n = n2;
        }
        this.queue[n] = e;
    }

    private void siftDown(int n, E e) {
        if (this.comparator != null) {
            this.siftDownUsingComparator(n, e);
        } else {
            this.siftDownComparable(n, e);
        }
    }

    private void siftDownComparable(int n, E e) {
        Comparable comparable = (Comparable)e;
        int n2 = this.size >>> 1;
        while (n < n2) {
            int n3 = (n << 1) + 1;
            Object object = this.queue[n3];
            int n4 = n3 + 1;
            if (n4 < this.size && ((Comparable)object).compareTo(this.queue[n4]) > 0) {
                n3 = n4;
                object = this.queue[n3];
            }
            if (comparable.compareTo(object) <= 0) break;
            this.queue[n] = object;
            n = n3;
        }
        this.queue[n] = comparable;
    }

    private void siftDownUsingComparator(int n, E e) {
        int n2 = this.size >>> 1;
        while (n < n2) {
            int n3 = (n << 1) + 1;
            Object object = this.queue[n3];
            int n4 = n3 + 1;
            if (n4 < this.size && this.comparator.compare(object, this.queue[n4]) > 0) {
                n3 = n4;
                object = this.queue[n3];
            }
            if (this.comparator.compare(e, object) <= 0) break;
            this.queue[n] = object;
            n = n3;
        }
        this.queue[n] = e;
    }

    private void heapify() {
        for (int i = (this.size >>> 1) - 1; i >= 0; --i) {
            this.siftDown(i, this.queue[i]);
        }
    }

    @SideEffectFree
    public @org.checkerframework.checker.igj.qual.ReadOnly Comparator<? super E> comparator(@org.checkerframework.checker.igj.qual.ReadOnly PriorityQueue<E> this) {
        return this.comparator;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(Math.max(2, this.size + 1));
        for (int i = 0; i < this.size; ++i) {
            objectOutputStream.writeObject(this.queue[i]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        objectInputStream.readInt();
        this.queue = new Object[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.queue[i] = objectInputStream.readObject();
        }
        this.heapify();
    }

    static /* synthetic */ int access$100(PriorityQueue priorityQueue) {
        return priorityQueue.modCount;
    }

    static /* synthetic */ int access$200(PriorityQueue priorityQueue) {
        return priorityQueue.size;
    }

    static /* synthetic */ Object[] access$300(PriorityQueue priorityQueue) {
        return priorityQueue.queue;
    }

    static /* synthetic */ Object access$400(PriorityQueue priorityQueue, int n) {
        return priorityQueue.removeAt(n);
    }

    private final class Itr
    implements Iterator<E> {
        private int cursor;
        private int lastRet = -1;
        private ArrayDeque<E> forgetMeNot;
        private E lastRetElt;
        private int expectedModCount;

        Itr() {
            this.expectedModCount = PriorityQueue.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < PriorityQueue.this.size || this.forgetMeNot != null && !this.forgetMeNot.isEmpty();
        }

        @Override
        public E next() {
            if (this.expectedModCount != PriorityQueue.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.cursor < PriorityQueue.this.size) {
                this.lastRet = this.cursor++;
                return PriorityQueue.this.queue[this.lastRet];
            }
            if (this.forgetMeNot != null) {
                this.lastRet = -1;
                this.lastRetElt = this.forgetMeNot.poll();
                if (this.lastRetElt != null) {
                    return this.lastRetElt;
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.expectedModCount != PriorityQueue.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastRet != -1) {
                Object moved = PriorityQueue.this.removeAt(this.lastRet);
                this.lastRet = -1;
                if (moved == null) {
                    --this.cursor;
                } else {
                    if (this.forgetMeNot == null) {
                        this.forgetMeNot = new ArrayDeque();
                    }
                    this.forgetMeNot.add(moved);
                }
            } else if (this.lastRetElt != null) {
                PriorityQueue.this.removeEq(this.lastRetElt);
                this.lastRetElt = null;
            } else {
                throw new IllegalStateException();
            }
            this.expectedModCount = PriorityQueue.this.modCount;
        }
    }
}

