/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Closeable;
import java.io.IOException;
import java.nio.CharBuffer;
import org.checkerframework.checker.javari.qual.ReadOnly;

public abstract class Reader
implements Readable,
Closeable {
    protected @ReadOnly Object lock;
    private static final int maxSkipBufferSize = 8192;
    private char[] skipBuffer = null;

    protected Reader() {
        this.lock = this;
    }

    protected Reader(@ReadOnly Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        this.lock = object;
    }

    @Override
    public int read(CharBuffer charBuffer) throws IOException {
        int n = charBuffer.remaining();
        char[] cArray = new char[n];
        int n2 = this.read(cArray, 0, n);
        if (n2 > 0) {
            charBuffer.put(cArray, 0, n2);
        }
        return n2;
    }

    public int read() throws IOException {
        char[] cArray = new char[1];
        if (this.read(cArray, 0, 1) == -1) {
            return -1;
        }
        return cArray[0];
    }

    public int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    public abstract int read(char[] var1, int var2, int var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("skip value is negative");
        }
        int n = (int)Math.min(l, 8192L);
        Object object = this.lock;
        synchronized (object) {
            long l2;
            int n2;
            if (this.skipBuffer == null || this.skipBuffer.length < n) {
                this.skipBuffer = new char[n];
            }
            for (l2 = l; l2 > 0L && (n2 = this.read(this.skipBuffer, 0, (int)Math.min(l2, (long)n))) != -1; l2 -= (long)n2) {
            }
            return l - l2;
        }
    }

    public boolean ready(@ReadOnly Reader this) throws IOException {
        return false;
    }

    public boolean markSupported(@ReadOnly Reader this) {
        return false;
    }

    public void mark(int n) throws IOException {
        throw new IOException("mark() not supported");
    }

    public void reset() throws IOException {
        throw new IOException("reset() not supported");
    }

    @Override
    public abstract void close() throws IOException;
}

