/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Cleaner;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipCoder;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipUtils;
import jdk.internal.access.JavaUtilZipFileAccess;
import jdk.internal.ref.CleanerFactory;
import org.checkerframework.checker.javari.qual.ReadOnly;
import sun.misc.PerfCounter;
import sun.misc.VM;

public class ZipFile
implements ZipConstants,
Closeable {
    private long jzfile;
    private String name;
    private int total;
    private volatile boolean closeRequested = false;
    private static final int STORED = 0;
    private static final int DEFLATED = 8;
    public static final int OPEN_READ = 1;
    public static final int OPEN_DELETE = 4;
    private static final boolean usemmap;
    private ZipCoder zc;
    private final Map<InputStream, Inflater> streams = new WeakHashMap<InputStream, Inflater>();
    private Deque<Inflater> inflaterCache = new ArrayDeque<Inflater>();
    private static final int JZENTRY_NAME = 0;
    private static final int JZENTRY_EXTRA = 1;
    private static final int JZENTRY_COMMENT = 2;

    private static native void initIDs();

    public ZipFile(String string) throws IOException {
        this(new File(string), 1);
    }

    public ZipFile(File file, int n) throws IOException {
        this(file, n, StandardCharsets.UTF_8);
    }

    public ZipFile(File file) throws ZipException, IOException {
        this(file, 1);
    }

    public ZipFile(File file, int n, Charset charset) throws IOException {
        if ((n & 1) == 0 || (n & 0xFFFFFFFA) != 0) {
            throw new IllegalArgumentException("Illegal mode: 0x" + Integer.toHexString(n));
        }
        String string = file.getPath();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string);
            if ((n & 4) != 0) {
                securityManager.checkDelete(string);
            }
        }
        if (charset == null) {
            throw new NullPointerException("charset is null");
        }
        this.zc = ZipCoder.get(charset);
        long l = System.nanoTime();
        this.jzfile = ZipFile.open(string, n, file.lastModified(), usemmap);
        PerfCounter.getZipFileOpenTime().addElapsedTimeFrom(l);
        PerfCounter.getZipFileCount().increment();
        this.name = string;
        this.total = ZipFile.getTotal(this.jzfile);
    }

    public ZipFile(String string, Charset charset) throws IOException {
        this(new File(string), 1, charset);
    }

    public ZipFile(File file, Charset charset) throws IOException {
        this(file, 1, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getComment(@ReadOnly ZipFile this) {
        ZipFile zipFile = this;
        synchronized (zipFile) {
            this.ensureOpen();
            byte[] byArray = ZipFile.getCommentBytes(this.jzfile);
            if (byArray == null) {
                return null;
            }
            return this.zc.toString(byArray, byArray.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipEntry getEntry(String string) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        long l = 0L;
        ZipFile zipFile = this;
        synchronized (zipFile) {
            this.ensureOpen();
            l = ZipFile.getEntry(this.jzfile, this.zc.getBytes(string), true);
            if (l != 0L) {
                ZipEntry zipEntry = this.getZipEntry(string, l);
                ZipFile.freeEntry(this.jzfile, l);
                return zipEntry;
            }
        }
        return null;
    }

    private static native long getEntry(long var0, byte[] var2, boolean var3);

    private static native void freeEntry(long var0, long var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        if (zipEntry == null) {
            throw new NullPointerException("entry");
        }
        long l = 0L;
        ZipFileInputStream zipFileInputStream = null;
        ZipFile zipFile = this;
        synchronized (zipFile) {
            this.ensureOpen();
            l = !this.zc.isUTF8() && (zipEntry.flag & 0x800) != 0 ? ZipFile.getEntry(this.jzfile, this.zc.getBytesUTF8(zipEntry.name), false) : ZipFile.getEntry(this.jzfile, this.zc.getBytes(zipEntry.name), false);
            if (l == 0L) {
                return null;
            }
            zipFileInputStream = new ZipFileInputStream(this, l);
            switch (ZipFile.getEntryMethod(l)) {
                case 0: {
                    Map<InputStream, Inflater> map = this.streams;
                    synchronized (map) {
                        this.streams.put(zipFileInputStream, null);
                    }
                    return zipFileInputStream;
                }
                case 8: {
                    long l2 = ZipFile.getEntrySize(l) + 2L;
                    if (l2 > 65536L) {
                        l2 = 8192L;
                    }
                    if (l2 <= 0L) {
                        l2 = 4096L;
                    }
                    Inflater inflater = this.getInflater();
                    ZipFileInflaterInputStream zipFileInflaterInputStream = new ZipFileInflaterInputStream(this, zipFileInputStream, inflater, (int)l2);
                    Map<InputStream, Inflater> map = this.streams;
                    synchronized (map) {
                        this.streams.put(zipFileInflaterInputStream, inflater);
                    }
                    return zipFileInflaterInputStream;
                }
            }
            throw new ZipException("invalid compression method");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Inflater getInflater() {
        Deque<Inflater> deque = this.inflaterCache;
        synchronized (deque) {
            Inflater inflater;
            while (null != (inflater = this.inflaterCache.poll())) {
                if (inflater.ended()) continue;
                return inflater;
            }
        }
        return new Inflater(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseInflater(Inflater inflater) {
        if (!inflater.ended()) {
            inflater.reset();
            Deque<Inflater> deque = this.inflaterCache;
            synchronized (deque) {
                this.inflaterCache.add(inflater);
            }
        }
    }

    public String getName(@ReadOnly ZipFile this) {
        return this.name;
    }

    public Enumeration<? extends ZipEntry> entries() {
        this.ensureOpen();
        return new JavaUtilZipFileAccess(this){

            @Override
            public boolean startsWithLocHeader(ZipFile zip) {
                return zip.res.zsrc.startsWithLoc;
            }

            @Override
            public List<String> getManifestAndSignatureRelatedFiles(JarFile jar) {
                return jar.getManifestAndSignatureRelatedFiles();
            }

            @Override
            public int getManifestNum(JarFile jar) {
                return jar.getManifestNum();
            }

            @Override
            public String getManifestName(JarFile jar, boolean onlyIfHasSignatureRelatedFiles) {
                return jar.getManifestName(onlyIfHasSignatureRelatedFiles);
            }

            @Override
            public int[] getMetaInfVersions(JarFile jar) {
                return jar.getMetaInfVersions();
            }

            @Override
            public Enumeration<JarEntry> entries(ZipFile zip) {
                return zip.jarEntries();
            }

            @Override
            public Stream<JarEntry> stream(ZipFile zip) {
                return zip.jarStream();
            }

            @Override
            public Stream<String> entryNameStream(ZipFile zip) {
                return zip.entryNameStream();
            }

            @Override
            public int getExtraAttributes(ZipEntry ze) {
                return ze.extraAttributes;
            }

            @Override
            public void setExtraAttributes(ZipEntry ze, int extraAttrs) {
                ze.extraAttributes = extraAttrs;
            }
        };
    }

    private ZipEntry getZipEntry(String string, long l) {
        byte[] byArray;
        ZipEntry zipEntry = new ZipEntry();
        zipEntry.flag = ZipFile.getEntryFlag(l);
        if (string != null) {
            zipEntry.name = string;
        } else {
            byArray = ZipFile.getEntryBytes(l, 0);
            zipEntry.name = !this.zc.isUTF8() && (zipEntry.flag & 0x800) != 0 ? this.zc.toStringUTF8(byArray, byArray.length) : this.zc.toString(byArray, byArray.length);
        }
        zipEntry.time = ZipFile.getEntryTime(l);
        zipEntry.crc = ZipFile.getEntryCrc(l);
        zipEntry.size = ZipFile.getEntrySize(l);
        zipEntry.csize = ZipFile.getEntryCSize(l);
        zipEntry.method = ZipFile.getEntryMethod(l);
        zipEntry.extra = ZipFile.getEntryBytes(l, 1);
        byArray = ZipFile.getEntryBytes(l, 2);
        zipEntry.comment = byArray == null ? null : (!this.zc.isUTF8() && (zipEntry.flag & 0x800) != 0 ? this.zc.toStringUTF8(byArray, byArray.length) : this.zc.toString(byArray, byArray.length));
        return zipEntry;
    }

    private static native long getNextEntry(long var0, int var2);

    public int size(@ReadOnly ZipFile this) {
        this.ensureOpen();
        return this.total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.closeRequested) {
            return;
        }
        this.closeRequested = true;
        ZipFile zipFile = this;
        synchronized (zipFile) {
            Object object;
            Object object2 = this.streams;
            synchronized (object2) {
                if (!this.streams.isEmpty()) {
                    object = new HashMap<InputStream, Inflater>(this.streams);
                    this.streams.clear();
                    for (Map.Entry entry : object.entrySet()) {
                        ((InputStream)entry.getKey()).close();
                        Inflater inflater = (Inflater)entry.getValue();
                        if (inflater == null) continue;
                        inflater.end();
                    }
                }
            }
            object = this.inflaterCache;
            synchronized (object) {
                while (null != (object2 = this.inflaterCache.poll())) {
                    ((Inflater)object2).end();
                }
            }
            if (this.jzfile != 0L) {
                long l = this.jzfile;
                this.jzfile = 0L;
                ZipFile.close(l);
            }
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    private static native void close(long var0);

    private void ensureOpen() {
        if (this.closeRequested) {
            throw new IllegalStateException("zip file closed");
        }
        if (this.jzfile == 0L) {
            throw new IllegalStateException("The object is not initialized.");
        }
    }

    private void ensureOpenOrZipException() throws IOException {
        if (this.closeRequested) {
            throw new ZipException("ZipFile closed");
        }
    }

    private static native long open(String var0, int var1, long var2, boolean var4) throws IOException;

    private static native int getTotal(long var0);

    private static native int read(long var0, long var2, long var4, byte[] var6, int var7, int var8);

    private static native long getEntryTime(long var0);

    private static native long getEntryCrc(long var0);

    private static native long getEntryCSize(long var0);

    private static native long getEntrySize(long var0);

    private static native int getEntryMethod(long var0);

    private static native int getEntryFlag(long var0);

    private static native byte[] getCommentBytes(long var0);

    private static native byte[] getEntryBytes(long var0, int var2);

    private static native String getZipMessage(long var0);

    static /* synthetic */ Map access$000(ZipFile zipFile) {
        return zipFile.streams;
    }

    static /* synthetic */ void access$100(ZipFile zipFile, Inflater inflater) {
        zipFile.releaseInflater(inflater);
    }

    static /* synthetic */ void access$200(ZipFile zipFile) {
        zipFile.ensureOpen();
    }

    static /* synthetic */ int access$300(ZipFile zipFile) {
        return zipFile.total;
    }

    static /* synthetic */ long access$400(ZipFile zipFile) {
        return zipFile.jzfile;
    }

    static /* synthetic */ long access$500(long l, int n) {
        return ZipFile.getNextEntry(l, n);
    }

    static /* synthetic */ boolean access$600(ZipFile zipFile) {
        return zipFile.closeRequested;
    }

    static /* synthetic */ String access$700(long l) {
        return ZipFile.getZipMessage(l);
    }

    static /* synthetic */ String access$800(ZipFile zipFile) {
        return zipFile.name;
    }

    static /* synthetic */ ZipEntry access$900(ZipFile zipFile, String string, long l) {
        return zipFile.getZipEntry(string, l);
    }

    static /* synthetic */ void access$1000(long l, long l2) {
        ZipFile.freeEntry(l, l2);
    }

    static /* synthetic */ long access$1100(long l) {
        return ZipFile.getEntryCSize(l);
    }

    static /* synthetic */ long access$1200(long l) {
        return ZipFile.getEntrySize(l);
    }

    static /* synthetic */ void access$1300(ZipFile zipFile) throws IOException {
        zipFile.ensureOpenOrZipException();
    }

    static /* synthetic */ int access$1400(long l, long l2, long l3, byte[] byArray, int n, int n2) {
        return ZipFile.read(l, l2, l3, byArray, n, n2);
    }

    static {
        ZipFile.initIDs();
        String string = VM.getSavedProperty((String)"sun.zip.disableMemoryMapping");
        usemmap = string == null || string.length() != 0 && !string.equalsIgnoreCase("true");
    }

    private class ZipFileInflaterInputStream
    extends InflaterInputStream {
        private volatile boolean closeRequested;
        private boolean eof;
        private final Cleaner.Cleanable cleanable;

        ZipFileInflaterInputStream(ZipFileInputStream zfin, CleanableResource res, int size) {
            this(zfin, res, res.getInflater(), size);
        }

        private ZipFileInflaterInputStream(ZipFileInputStream zfin, CleanableResource res, Inflater inf, int size) {
            super(zfin, inf, size);
            this.eof = false;
            this.cleanable = CleanerFactory.cleaner().register(this, new InflaterCleanupAction(inf, res));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (this.closeRequested) {
                return;
            }
            this.closeRequested = true;
            super.close();
            Set<InputStream> set = ZipFile.this.res.istreams;
            synchronized (set) {
                ZipFile.this.res.istreams.remove(this);
            }
            this.cleanable.clean();
        }

        @Override
        protected void fill() throws IOException {
            if (this.eof) {
                throw new EOFException("Unexpected end of ZLIB input stream");
            }
            this.len = this.in.read(this.buf, 0, this.buf.length);
            if (this.len == -1) {
                this.buf[0] = 0;
                this.len = 1;
                this.eof = true;
            }
            this.inf.setInput(this.buf, 0, this.len);
        }

        @Override
        public int available() throws IOException {
            if (this.closeRequested) {
                return 0;
            }
            long avail = ((ZipFileInputStream)this.in).size() - this.inf.getBytesWritten();
            return avail > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)avail;
        }
    }

    private class ZipFileInputStream
    extends InputStream {
        private volatile boolean closeRequested;
        private long pos;
        private long startingPos;
        protected long rem;
        protected long size;

        ZipFileInputStream(byte[] cen, int cenpos) {
            this.rem = ZipUtils.CENSIZ(cen, cenpos);
            this.size = ZipUtils.CENLEN(cen, cenpos);
            this.pos = ZipUtils.CENOFF(cen, cenpos);
            if (this.rem == 0xFFFFFFFFL || this.size == 0xFFFFFFFFL || this.pos == 0xFFFFFFFFL) {
                this.checkZIP64(cen, cenpos);
            }
            this.pos = -(this.pos + ZipFile.this.res.zsrc.locpos);
        }

        private void checkZIP64(byte[] cen, int cenpos) {
            int off = cenpos + 46 + ZipUtils.CENNAM(cen, cenpos);
            int end = off + ZipUtils.CENEXT(cen, cenpos);
            while (off + 4 < end) {
                int sz;
                int tag = ZipUtils.get16(cen, off);
                if ((off += 4) + (sz = ZipUtils.get16(cen, off + 2)) > end) break;
                if (tag == 1) {
                    if (this.size == 0xFFFFFFFFL) {
                        if (sz < 8 || off + 8 > end) break;
                        this.size = ZipUtils.get64(cen, off);
                        sz -= 8;
                        off += 8;
                    }
                    if (this.rem == 0xFFFFFFFFL) {
                        if (sz < 8 || off + 8 > end) break;
                        this.rem = ZipUtils.get64(cen, off);
                        sz -= 8;
                        off += 8;
                    }
                    if (this.pos != 0xFFFFFFFFL || sz < 8 || off + 8 > end) break;
                    this.pos = ZipUtils.get64(cen, off);
                    sz -= 8;
                    off += 8;
                    break;
                }
                off += sz;
            }
        }

        private long initDataOffset() throws IOException {
            if (this.pos <= 0L) {
                byte[] loc = new byte[30];
                this.pos = -this.pos;
                int len = ZipFile.this.res.zsrc.readFullyAt(loc, 0, loc.length, this.pos);
                if (len != 30) {
                    throw new ZipException("ZipFile error reading zip file");
                }
                if (ZipUtils.LOCSIG(loc) != 67324752L) {
                    throw new ZipException("ZipFile invalid LOC header (bad signature)");
                }
                this.pos += (long)(30 + ZipUtils.LOCNAM(loc) + ZipUtils.LOCEXT(loc));
                this.startingPos = this.pos;
            }
            return this.pos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            ZipFile zipFile = ZipFile.this;
            synchronized (zipFile) {
                ZipFile.this.ensureOpenOrZipException();
                this.initDataOffset();
                if (this.rem == 0L) {
                    return -1;
                }
                if ((long)len > this.rem) {
                    len = (int)this.rem;
                }
                if (len <= 0) {
                    return 0;
                }
                if ((len = ZipFile.this.res.zsrc.readAt(b, off, len, this.pos)) > 0) {
                    this.pos += (long)len;
                    this.rem -= (long)len;
                }
            }
            if (this.rem == 0L) {
                this.close();
            }
            return len;
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            if (this.read(b, 0, 1) == 1) {
                return b[0] & 0xFF;
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long skip(long n) throws IOException {
            ZipFile zipFile = ZipFile.this;
            synchronized (zipFile) {
                this.initDataOffset();
                long newPos = this.pos + n;
                if (n > 0L) {
                    if (newPos < 0L || n > this.rem) {
                        n = this.rem;
                    }
                } else if (newPos < this.startingPos) {
                    n = this.startingPos - this.pos;
                }
                this.pos += n;
                this.rem -= n;
            }
            if (this.rem == 0L) {
                this.close();
            }
            return n;
        }

        @Override
        public int available() {
            return this.rem > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.rem;
        }

        public long size() {
            return this.size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (this.closeRequested) {
                return;
            }
            this.closeRequested = true;
            this.rem = 0L;
            Set<InputStream> set = ZipFile.this.res.istreams;
            synchronized (set) {
                ZipFile.this.res.istreams.remove(this);
            }
        }
    }
}

