/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.Consumer;
import org.checkerframework.checker.igj.qual.I;
import org.checkerframework.checker.igj.qual.Mutable;
import org.checkerframework.checker.javari.qual.PolyRead;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@I
public class Vector<E>
extends AbstractList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    protected Object[] elementData;
    protected int elementCount;
    protected int capacityIncrement;
    private static final long serialVersionUID = -2767605614048989439L;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public Vector(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        this.elementData = new Object[n];
        this.capacityIncrement = n2;
    }

    public Vector(int n) {
        this(n, 0);
    }

    public Vector() {
        this(10);
    }

    public @PolyRead Vector(@org.checkerframework.checker.igj.qual.ReadOnly @PolyRead Collection<? extends E> collection) {
        this.elementData = collection.toArray();
        this.elementCount = this.elementData.length;
        if (this.elementData.getClass() != Object[].class) {
            this.elementData = Arrays.copyOf(this.elementData, this.elementCount, Object[].class);
        }
    }

    public synchronized void copyInto(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object @Mutable @org.checkerframework.checker.javari.qual.Mutable [] objectArray) {
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
    }

    public synchronized void trimToSize(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this) {
        ++this.modCount;
        int n = this.elementData.length;
        if (this.elementCount < n) {
            this.elementData = Arrays.copyOf(this.elementData, this.elementCount);
        }
    }

    public synchronized void ensureCapacity(int n) {
        if (n > 0) {
            ++this.modCount;
            this.ensureCapacityHelper(n);
        }
    }

    private void ensureCapacityHelper(int n) {
        if (n - this.elementData.length > 0) {
            this.grow(n);
        }
    }

    private void grow(int n) {
        int n2 = this.elementData.length;
        int n3 = n2 + (this.capacityIncrement > 0 ? this.capacityIncrement : n2);
        if (n3 - n < 0) {
            n3 = n;
        }
        if (n3 - 0x7FFFFFF7 > 0) {
            n3 = Vector.hugeCapacity(n);
        }
        this.elementData = Arrays.copyOf(this.elementData, n3);
    }

    private static int hugeCapacity(int n) {
        if (n < 0) {
            throw new OutOfMemoryError();
        }
        return n > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    public synchronized void setSize(@Mutable Vector<E> this, int n) {
        ++this.modCount;
        if (n > this.elementCount) {
            this.ensureCapacityHelper(n);
        } else {
            for (int i = n; i < this.elementCount; ++i) {
                this.elementData[i] = null;
            }
        }
        this.elementCount = n;
    }

    public synchronized int capacity(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this) {
        return this.elementData.length;
    }

    @Override
    @Pure
    public synchronized int size(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this) {
        return this.elementCount;
    }

    @Override
    @Pure
    public synchronized boolean isEmpty(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this) {
        return this.elementCount == 0;
    }

    public @PolyRead Enumeration<E> elements(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this) {
        return new Enumeration<E>(){
            int count = 0;

            @Override
            public boolean hasMoreElements() {
                return this.count < Vector.this.elementCount;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public E nextElement() {
                Vector vector = Vector.this;
                synchronized (vector) {
                    if (this.count < Vector.this.elementCount) {
                        return Vector.this.elementData(this.count++);
                    }
                }
                throw new NoSuchElementException("Vector Enumeration");
            }
        };
    }

    @Override
    @Pure
    public boolean contains(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        return this.indexOf(object, 0) >= 0;
    }

    @Override
    @Pure
    public int indexOf(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        return this.indexOf(object, 0);
    }

    @Pure
    public synchronized int indexOf(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object, int n) {
        if (object == null) {
            for (int i = n; i < this.elementCount; ++i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = n; i < this.elementCount; ++i) {
                if (!object.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    @Pure
    public synchronized int lastIndexOf(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        return this.lastIndexOf(object, this.elementCount - 1);
    }

    @Pure
    public synchronized int lastIndexOf(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object, int n) {
        if (n >= this.elementCount) {
            throw new IndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        if (object == null) {
            for (int i = n; i >= 0; --i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = n; i >= 0; --i) {
                if (!object.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public synchronized E elementAt(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this, int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        return this.elementData(n);
    }

    public synchronized E firstElement(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this) {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData(0);
    }

    public synchronized E lastElement(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this) {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData(this.elementCount - 1);
    }

    public synchronized void setElementAt(@Mutable Vector<E> this, E e, int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        this.elementData[n] = e;
    }

    public synchronized void removeElementAt(@Mutable Vector<E> this, int n) {
        ++this.modCount;
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = null;
    }

    public synchronized void insertElementAt(@Mutable Vector<E> this, E e, int n) {
        ++this.modCount;
        if (n > this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " > " + this.elementCount);
        }
        this.ensureCapacityHelper(this.elementCount + 1);
        System.arraycopy(this.elementData, n, this.elementData, n + 1, this.elementCount - n);
        this.elementData[n] = e;
        ++this.elementCount;
    }

    public synchronized void addElement(@Mutable Vector<E> this, E e) {
        ++this.modCount;
        this.ensureCapacityHelper(this.elementCount + 1);
        this.elementData[this.elementCount++] = e;
    }

    public synchronized boolean removeElement(@Mutable Vector<E> this, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        ++this.modCount;
        int n = this.indexOf(object);
        if (n >= 0) {
            this.removeElementAt(n);
            return true;
        }
        return false;
    }

    public synchronized void removeAllElements(@Mutable Vector<E> this) {
        ++this.modCount;
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = null;
        }
        this.elementCount = 0;
    }

    @SideEffectFree
    public synchronized @I(value="N") Object clone() {
        try {
            Vector vector = (Vector)super.clone();
            vector.elementData = Arrays.copyOf(this.elementData, this.elementCount);
            vector.modCount = 0;
            return vector;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public synchronized @Nullable Object[] toArray(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this) {
        return Arrays.copyOf(this.elementData, this.elementCount);
    }

    @Override
    public synchronized <T> @Nullable T @PolyNull [] toArray(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this, T @PolyNull [] TArray) {
        if (TArray.length < this.elementCount) {
            return Arrays.copyOf(this.elementData, this.elementCount, TArray.getClass());
        }
        System.arraycopy(this.elementData, 0, TArray, 0, this.elementCount);
        if (TArray.length > this.elementCount) {
            TArray[this.elementCount] = null;
        }
        return TArray;
    }

    E elementData(int n) {
        return (E)this.elementData[n];
    }

    @Override
    @Pure
    public synchronized E get(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this, int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.elementData(n);
    }

    @Override
    public synchronized E set(@Mutable Vector<E> this, int n, E e) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        E e2 = this.elementData(n);
        this.elementData[n] = e;
        return e2;
    }

    @Override
    public synchronized boolean add(@Mutable Vector<E> this, E e) {
        ++this.modCount;
        this.ensureCapacityHelper(this.elementCount + 1);
        this.elementData[this.elementCount++] = e;
        return true;
    }

    @Override
    public boolean remove(@Mutable Vector<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        return this.removeElement(object);
    }

    @Override
    public void add(@Mutable Vector<E> this, int n, E e) {
        this.insertElementAt(e, n);
    }

    @Override
    public synchronized E remove(@Mutable Vector<E> this, int n) {
        ++this.modCount;
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        E e = this.elementData(n);
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        this.elementData[--this.elementCount] = null;
        return e;
    }

    @Override
    public void clear(@Mutable Vector<E> this) {
        this.removeAllElements();
    }

    @Override
    @Pure
    public synchronized boolean containsAll(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Collection<?> collection) {
        return super.containsAll(collection);
    }

    @Override
    public synchronized boolean addAll(@Mutable Vector<E> this, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Collection<? extends E> collection) {
        ++this.modCount;
        Object[] objectArray = collection.toArray();
        int n = objectArray.length;
        this.ensureCapacityHelper(this.elementCount + n);
        System.arraycopy(objectArray, 0, this.elementData, this.elementCount, n);
        this.elementCount += n;
        return n != 0;
    }

    @Override
    public synchronized boolean removeAll(@Mutable Vector<E> this, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Collection<?> collection) {
        return super.removeAll(collection);
    }

    @Override
    public synchronized boolean retainAll(@Mutable Vector<E> this, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Collection<?> collection) {
        return super.retainAll(collection);
    }

    @Override
    public synchronized boolean addAll(@Mutable Vector<E> this, int n, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Collection<? extends E> collection) {
        ++this.modCount;
        if (n < 0 || n > this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        Object[] objectArray = collection.toArray();
        int n2 = objectArray.length;
        this.ensureCapacityHelper(this.elementCount + n2);
        int n3 = this.elementCount - n;
        if (n3 > 0) {
            System.arraycopy(this.elementData, n, this.elementData, n + n2, n3);
        }
        System.arraycopy(objectArray, 0, this.elementData, n, n2);
        this.elementCount += n2;
        return n2 != 0;
    }

    @Override
    @Pure
    public synchronized boolean equals(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        return super.equals(object);
    }

    @Override
    @Pure
    public synchronized int hashCode(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this) {
        return super.hashCode();
    }

    @Override
    @SideEffectFree
    public synchronized String toString(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this) {
        return super.toString();
    }

    @Override
    @SideEffectFree
    public synchronized @I @PolyRead List<E> subList(@org.checkerframework.checker.igj.qual.ReadOnly Vector<E> this, int n, int n2) {
        return Collections.synchronizedList(super.subList(n, n2), this);
    }

    @Override
    protected synchronized void removeRange(int n, int n2) {
        ++this.modCount;
        int n3 = this.elementCount - n2;
        System.arraycopy(this.elementData, n2, this.elementData, n, n3);
        int n4 = this.elementCount - (n2 - n);
        while (this.elementCount != n4) {
            this.elementData[--this.elementCount] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Object[] objectArray;
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        Vector vector = this;
        synchronized (vector) {
            putField.put("capacityIncrement", this.capacityIncrement);
            putField.put("elementCount", this.elementCount);
            objectArray = (Object[])this.elementData.clone();
        }
        putField.put("elementData", objectArray);
        objectOutputStream.writeFields();
    }

    @Override
    public synchronized ListIterator<E> listIterator(int n) {
        if (n < 0 || n > this.elementCount) {
            throw new IndexOutOfBoundsException("Index: " + n);
        }
        return new ListItr(n);
    }

    @Override
    public synchronized ListIterator<E> listIterator() {
        return new ListItr(0);
    }

    @Override
    public synchronized Iterator<E> iterator() {
        return new Itr(this, null);
    }

    private class Itr
    implements Iterator<E> {
        int cursor;
        int lastRet = -1;
        int expectedModCount;

        private Itr() {
            this.expectedModCount = Vector.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != Vector.this.elementCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E next() {
            Vector vector = Vector.this;
            synchronized (vector) {
                this.checkForComodification();
                int i = this.cursor;
                if (i >= Vector.this.elementCount) {
                    throw new NoSuchElementException();
                }
                this.cursor = i + 1;
                this.lastRet = i;
                return Vector.this.elementData(this.lastRet);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            Vector vector = Vector.this;
            synchronized (vector) {
                this.checkForComodification();
                Vector.this.remove(this.lastRet);
                this.expectedModCount = Vector.this.modCount;
            }
            this.cursor = this.lastRet;
            this.lastRet = -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forEachRemaining(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            Vector vector = Vector.this;
            synchronized (vector) {
                int size = Vector.this.elementCount;
                int i = this.cursor;
                if (i >= size) {
                    return;
                }
                Object[] es = Vector.this.elementData;
                if (i >= es.length) {
                    throw new ConcurrentModificationException();
                }
                while (i < size && Vector.this.modCount == this.expectedModCount) {
                    action.accept(Vector.elementAt((Object[])es, (int)i++));
                }
                this.cursor = i;
                this.lastRet = i - 1;
                this.checkForComodification();
            }
        }

        final void checkForComodification() {
            if (Vector.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    final class ListItr
    extends Itr
    implements ListIterator<E> {
        ListItr(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E previous() {
            Vector vector = Vector.this;
            synchronized (vector) {
                this.checkForComodification();
                int i = this.cursor - 1;
                if (i < 0) {
                    throw new NoSuchElementException();
                }
                this.cursor = i;
                this.lastRet = i;
                return Vector.this.elementData(this.lastRet);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(E e) {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            Vector vector = Vector.this;
            synchronized (vector) {
                this.checkForComodification();
                Vector.this.set(this.lastRet, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(E e) {
            int i = this.cursor;
            Vector vector = Vector.this;
            synchronized (vector) {
                this.checkForComodification();
                Vector.this.add(i, e);
                this.expectedModCount = Vector.this.modCount;
            }
            this.cursor = i + 1;
            this.lastRet = -1;
        }
    }
}

