/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Console;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.module.ModuleDescriptor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.channels.Channel;
import java.nio.channels.spi.SelectorProvider;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyPermission;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import jdk.internal.javac.PreviewFeature;
import jdk.internal.misc.CarrierThreadLocal;
import jdk.internal.module.ServicesCatalog;
import jdk.internal.reflect.ConstantPool;
import jdk.internal.vm.Continuation;
import jdk.internal.vm.ContinuationScope;
import jdk.internal.vm.StackableScope;
import jdk.internal.vm.ThreadContainer;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import sun.misc.JavaLangAccess;
import sun.misc.SharedSecrets;
import sun.misc.VM;
import sun.misc.Version;
import sun.nio.ch.Interruptible;
import sun.reflect.Reflection;
import sun.reflect.annotation.AnnotationType;
import sun.security.util.SecurityConstants;

public final class System {
    public static final InputStream in;
    public static final PrintStream out;
    public static final PrintStream err;
    private static volatile SecurityManager security;
    private static volatile Console cons;
    private static Properties props;
    private static String lineSeparator;

    private static native void registerNatives();

    private System() {
    }

    public static void setIn(InputStream inputStream) {
        System.checkIO();
        System.setIn0(inputStream);
    }

    public static void setOut(PrintStream printStream) {
        System.checkIO();
        System.setOut0(printStream);
    }

    public static void setErr(PrintStream printStream) {
        System.checkIO();
        System.setErr0(printStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static @Nullable Console console() {
        if (cons != null) return cons;
        Class<System> clazz = System.class;
        synchronized (System.class) {
            cons = SharedSecrets.getJavaIOAccess().console();
            // ** MonitorExit[var0] (shouldn't be in output)
            return cons;
        }
    }

    public static @Nullable Channel inheritedChannel() throws IOException {
        return SelectorProvider.provider().inheritedChannel();
    }

    private static void checkIO() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("setIO"));
        }
    }

    private static native void setIn0(InputStream var0);

    private static native void setOut0(PrintStream var0);

    private static native void setErr0(PrintStream var0);

    public static void setSecurityManager(@Nullable SecurityManager securityManager) {
        try {
            securityManager.checkPackageAccess("java.lang");
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.setSecurityManager0(securityManager);
    }

    private static synchronized void setSecurityManager0(final SecurityManager securityManager) {
        SecurityManager securityManager2 = System.getSecurityManager();
        if (securityManager2 != null) {
            securityManager2.checkPermission(new RuntimePermission("setSecurityManager"));
        }
        if (securityManager != null && securityManager.getClass().getClassLoader() != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    securityManager.getClass().getProtectionDomain().implies(SecurityConstants.ALL_PERMISSION);
                    return null;
                }
            });
        }
        security = securityManager;
    }

    public static @Nullable SecurityManager getSecurityManager() {
        return security;
    }

    public static native long currentTimeMillis();

    public static native long nanoTime();

    @SideEffectFree
    public static native void arraycopy(Object var0, int var1, Object var2, int var3, int var4);

    @Pure
    public static native int identityHashCode(@Nullable @ReadOnly Object var0);

    private static native Properties initProperties(Properties var0);

    public static Properties getProperties() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertiesAccess();
        }
        return props;
    }

    public static String lineSeparator() {
        return lineSeparator;
    }

    public static void setProperties(@Nullable Properties properties) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertiesAccess();
        }
        if (properties == null) {
            properties = new Properties();
            System.initProperties(properties);
        }
        props = properties;
    }

    @Pure
    public static @Nullable String getProperty(String string) {
        System.checkKey(string);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertyAccess(string);
        }
        return props.getProperty(string);
    }

    @Pure
    public static @PolyNull String getProperty(String string, @PolyNull String string2) {
        System.checkKey(string);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertyAccess(string);
        }
        return props.getProperty(string, string2);
    }

    public static @Nullable String setProperty(String string, String string2) {
        System.checkKey(string);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PropertyPermission(string, "write"));
        }
        return (String)props.setProperty(string, string2);
    }

    public static @Nullable String clearProperty(String string) {
        System.checkKey(string);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PropertyPermission(string, "write"));
        }
        return (String)props.remove(string);
    }

    private static void checkKey(String string) {
        if (string == null) {
            throw new NullPointerException("key can't be null");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("key can't be empty");
        }
    }

    public static @Nullable String getenv(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("getenv." + string));
        }
        return ProcessEnvironment.getenv(string);
    }

    public static @ReadOnly Map<String, String> getenv() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("getenv.*"));
        }
        return ProcessEnvironment.getenv();
    }

    public static void exit(int n) {
        Runtime.getRuntime().exit(n);
    }

    public static void gc() {
        Runtime.getRuntime().gc();
    }

    public static void runFinalization() {
        Runtime.getRuntime().runFinalization();
    }

    @Deprecated
    @Deprecated
    @Deprecated
    public static void runFinalizersOnExit(boolean bl) {
        Runtime.getRuntime();
        Runtime.runFinalizersOnExit(bl);
    }

    public static void load(String string) {
        Runtime.getRuntime().load0(System.getCallerClass(), string);
    }

    public static void loadLibrary(String string) {
        Runtime.getRuntime().loadLibrary0(System.getCallerClass(), string);
    }

    public static native String mapLibraryName(String var0);

    private static void initializeSystemClass() {
        props = new Properties();
        System.initProperties(props);
        VM.saveAndRemoveProperties((Properties)props);
        lineSeparator = props.getProperty("line.separator");
        Version.init();
        FileInputStream fileInputStream = new FileInputStream(FileDescriptor.in);
        FileOutputStream fileOutputStream = new FileOutputStream(FileDescriptor.out);
        FileOutputStream fileOutputStream2 = new FileOutputStream(FileDescriptor.err);
        System.setIn0(new BufferedInputStream(fileInputStream));
        System.setOut0(new PrintStream(new BufferedOutputStream(fileOutputStream, 128), true));
        System.setErr0(new PrintStream(new BufferedOutputStream(fileOutputStream2, 128), true));
        System.loadLibrary("zip");
        Terminator.setup();
        VM.initializeOSEnvironment();
        VM.booted();
        Thread thread = Thread.currentThread();
        thread.getThreadGroup().add(thread);
        System.setJavaLangAccess();
    }

    private static void setJavaLangAccess() {
        SharedSecrets.setJavaLangAccess((JavaLangAccess)new jdk.internal.access.JavaLangAccess(){

            @Override
            public List<Method> getDeclaredPublicMethods(Class<?> klass, String name, Class<?> ... parameterTypes) {
                return klass.getDeclaredPublicMethods(name, parameterTypes);
            }

            @Override
            public ConstantPool getConstantPool(Class<?> klass) {
                return klass.getConstantPool();
            }

            @Override
            public boolean casAnnotationType(Class<?> klass, AnnotationType oldType, AnnotationType newType) {
                return klass.casAnnotationType(oldType, newType);
            }

            @Override
            public AnnotationType getAnnotationType(Class<?> klass) {
                return klass.getAnnotationType();
            }

            @Override
            public Map<Class<? extends Annotation>, Annotation> getDeclaredAnnotationMap(Class<?> klass) {
                return klass.getDeclaredAnnotationMap();
            }

            @Override
            public byte[] getRawClassAnnotations(Class<?> klass) {
                return klass.getRawAnnotations();
            }

            @Override
            public byte[] getRawClassTypeAnnotations(Class<?> klass) {
                return klass.getRawTypeAnnotations();
            }

            @Override
            public byte[] getRawExecutableTypeAnnotations(Executable executable) {
                return Class.getExecutableTypeAnnotationBytes((Executable)executable);
            }

            @Override
            public <E extends Enum<E>> E[] getEnumConstantsShared(Class<E> klass) {
                return (Enum[])klass.getEnumConstantsShared();
            }

            @Override
            public void blockedOn(Interruptible b) {
                Thread.blockedOn(b);
            }

            @Override
            public void registerShutdownHook(int slot, boolean registerShutdownInProgress, Runnable hook) {
                Shutdown.add(slot, registerShutdownInProgress, hook);
            }

            @Override
            public Thread newThreadWithAcc(Runnable target, AccessControlContext acc) {
                return new Thread(target, acc);
            }

            @Override
            public void invokeFinalize(Object o) throws Throwable {
                o.finalize();
            }

            @Override
            public ConcurrentHashMap<?, ?> createOrGetClassLoaderValueMap(ClassLoader cl) {
                return cl.createOrGetClassLoaderValueMap();
            }

            @Override
            public Class<?> defineClass(ClassLoader loader, String name, byte[] b, ProtectionDomain pd, String source) {
                return ClassLoader.defineClass1((ClassLoader)loader, (String)name, (byte[])b, (int)0, (int)b.length, (ProtectionDomain)pd, (String)source);
            }

            @Override
            public Class<?> defineClass(ClassLoader loader, Class<?> lookup, String name, byte[] b, ProtectionDomain pd, boolean initialize, int flags, Object classData) {
                return ClassLoader.defineClass0((ClassLoader)loader, lookup, (String)name, (byte[])b, (int)0, (int)b.length, (ProtectionDomain)pd, (boolean)initialize, (int)flags, (Object)classData);
            }

            @Override
            public Class<?> findBootstrapClassOrNull(String name) {
                return ClassLoader.findBootstrapClassOrNull(name);
            }

            @Override
            public Package definePackage(ClassLoader cl, String name, Module module) {
                return cl.definePackage(name, module);
            }

            @Override
            public String fastUUID(long lsb, long msb) {
                return Long.fastUUID((long)lsb, (long)msb);
            }

            @Override
            public void addNonExportedPackages(ModuleLayer layer) {
                SecurityManager.addNonExportedPackages((ModuleLayer)layer);
            }

            @Override
            public void invalidatePackageAccessCache() {
                SecurityManager.invalidatePackageAccessCache();
            }

            @Override
            public Module defineModule(ClassLoader loader, ModuleDescriptor descriptor, URI uri) {
                return new Module(null, loader, descriptor, uri);
            }

            @Override
            public Module defineUnnamedModule(ClassLoader loader) {
                return new Module(loader);
            }

            @Override
            public void addReads(Module m1, Module m2) {
                m1.implAddReads(m2);
            }

            @Override
            public void addReadsAllUnnamed(Module m) {
                m.implAddReadsAllUnnamed();
            }

            @Override
            public void addExports(Module m, String pn) {
                m.implAddExports(pn);
            }

            @Override
            public void addExports(Module m, String pn, Module other) {
                m.implAddExports(pn, other);
            }

            @Override
            public void addExportsToAllUnnamed(Module m, String pn) {
                m.implAddExportsToAllUnnamed(pn);
            }

            @Override
            public void addOpens(Module m, String pn, Module other) {
                m.implAddOpens(pn, other);
            }

            @Override
            public void addOpensToAllUnnamed(Module m, String pn) {
                m.implAddOpensToAllUnnamed(pn);
            }

            @Override
            public void addOpensToAllUnnamed(Module m, Set<String> concealedPackages, Set<String> exportedPackages) {
                m.implAddOpensToAllUnnamed(concealedPackages, exportedPackages);
            }

            @Override
            public void addUses(Module m, Class<?> service) {
                m.implAddUses(service);
            }

            @Override
            public boolean isReflectivelyExported(Module m, String pn, Module other) {
                return m.isReflectivelyExported(pn, other);
            }

            @Override
            public boolean isReflectivelyOpened(Module m, String pn, Module other) {
                return m.isReflectivelyOpened(pn, other);
            }

            @Override
            public Module addEnableNativeAccess(Module m) {
                return m.implAddEnableNativeAccess();
            }

            @Override
            public void addEnableNativeAccessToAllUnnamed() {
                Module.implAddEnableNativeAccessToAllUnnamed();
            }

            @Override
            public void ensureNativeAccess(Module m, Class<?> owner, String methodName) {
                m.ensureNativeAccess(owner, methodName);
            }

            @Override
            public ServicesCatalog getServicesCatalog(ModuleLayer layer) {
                return layer.getServicesCatalog();
            }

            @Override
            public void bindToLoader(ModuleLayer layer, ClassLoader loader) {
                layer.bindToLoader(loader);
            }

            @Override
            public Stream<ModuleLayer> layers(ModuleLayer layer) {
                return layer.layers();
            }

            @Override
            public Stream<ModuleLayer> layers(ClassLoader loader) {
                return ModuleLayer.layers(loader);
            }

            @Override
            public int countPositives(byte[] bytes, int offset, int length) {
                return StringCoding.countPositives(bytes, offset, length);
            }

            @Override
            public String newStringNoRepl(byte[] bytes, Charset cs) throws CharacterCodingException {
                return String.newStringNoRepl((byte[])bytes, (Charset)cs);
            }

            @Override
            public char getUTF16Char(byte[] bytes, int index) {
                return StringUTF16.getChar(bytes, index);
            }

            @Override
            public byte[] getBytesNoRepl(String s, Charset cs) throws CharacterCodingException {
                return String.getBytesNoRepl((String)s, (Charset)cs);
            }

            @Override
            public String newStringUTF8NoRepl(byte[] bytes, int off, int len) {
                return String.newStringUTF8NoRepl((byte[])bytes, (int)off, (int)len, (boolean)true);
            }

            @Override
            public byte[] getBytesUTF8NoRepl(String s) {
                return String.getBytesUTF8NoRepl((String)s);
            }

            @Override
            public void inflateBytesToChars(byte[] src, int srcOff, char[] dst, int dstOff, int len) {
                StringLatin1.inflate(src, srcOff, dst, dstOff, len);
            }

            @Override
            public int decodeASCII(byte[] src, int srcOff, char[] dst, int dstOff, int len) {
                return String.decodeASCII((byte[])src, (int)srcOff, (char[])dst, (int)dstOff, (int)len);
            }

            @Override
            public int encodeASCII(char[] src, int srcOff, byte[] dst, int dstOff, int len) {
                return StringCoding.implEncodeAsciiArray(src, srcOff, dst, dstOff, len);
            }

            @Override
            public InputStream initialSystemIn() {
                return initialIn;
            }

            @Override
            public void setCause(Throwable t, Throwable cause) {
                t.setCause(cause);
            }

            @Override
            public ProtectionDomain protectionDomain(Class<?> c) {
                return c.protectionDomain();
            }

            @Override
            public MethodHandle stringConcatHelper(String name, MethodType methodType) {
                return StringConcatHelper.lookupStatic(name, methodType);
            }

            @Override
            public long stringConcatInitialCoder() {
                return StringConcatHelper.initialCoder();
            }

            @Override
            public long stringConcatMix(long lengthCoder, String constant) {
                return StringConcatHelper.mix(lengthCoder, constant);
            }

            @Override
            @PreviewFeature(feature=PreviewFeature.Feature.STRING_TEMPLATES)
            public long stringConcatCoder(char value) {
                return StringConcatHelper.coder(value);
            }

            @Override
            @PreviewFeature(feature=PreviewFeature.Feature.STRING_TEMPLATES)
            public long stringBuilderConcatMix(long lengthCoder, StringBuilder sb) {
                return sb.mix(lengthCoder);
            }

            @Override
            @PreviewFeature(feature=PreviewFeature.Feature.STRING_TEMPLATES)
            public long stringBuilderConcatPrepend(long lengthCoder, byte[] buf, StringBuilder sb) {
                return sb.prepend(lengthCoder, buf);
            }

            @Override
            public String join(String prefix, String suffix, String delimiter, String[] elements, int size) {
                return String.join((String)prefix, (String)suffix, (String)delimiter, (String[])elements, (int)size);
            }

            @Override
            public Object classData(Class<?> c) {
                return c.getClassData();
            }

            @Override
            public long findNative(ClassLoader loader, String entry) {
                return ClassLoader.findNative(loader, entry);
            }

            @Override
            public void exit(int statusCode) {
                Shutdown.exit(statusCode);
            }

            @Override
            public Thread[] getAllThreads() {
                return Thread.getAllThreads();
            }

            @Override
            public ThreadContainer threadContainer(Thread thread) {
                return thread.threadContainer();
            }

            @Override
            public void start(Thread thread, ThreadContainer container) {
                thread.start(container);
            }

            @Override
            public StackableScope headStackableScope(Thread thread) {
                return thread.headStackableScopes();
            }

            @Override
            public void setHeadStackableScope(StackableScope scope) {
                Thread.setHeadStackableScope((StackableScope)scope);
            }

            @Override
            public Thread currentCarrierThread() {
                return Thread.currentCarrierThread();
            }

            @Override
            public <V> V executeOnCarrierThread(Callable<V> task) throws Exception {
                Thread thread = Thread.currentThread();
                if (thread instanceof VirtualThread) {
                    VirtualThread vthread = (VirtualThread)thread;
                    return vthread.executeOnCarrierThread(task);
                }
                return task.call();
            }

            @Override
            public <T> T getCarrierThreadLocal(CarrierThreadLocal<T> local) {
                return (T)local.getCarrierThreadLocal();
            }

            @Override
            public <T> void setCarrierThreadLocal(CarrierThreadLocal<T> local, T value) {
                local.setCarrierThreadLocal(value);
            }

            @Override
            public void removeCarrierThreadLocal(CarrierThreadLocal<?> local) {
                local.removeCarrierThreadLocal();
            }

            @Override
            public boolean isCarrierThreadLocalPresent(CarrierThreadLocal<?> local) {
                return local.isCarrierThreadLocalPresent();
            }

            @Override
            public Object[] scopedValueCache() {
                return Thread.scopedValueCache();
            }

            @Override
            public void setScopedValueCache(Object[] cache) {
                Thread.setScopedValueCache((Object[])cache);
            }

            @Override
            public Object scopedValueBindings() {
                return Thread.scopedValueBindings();
            }

            @Override
            public Continuation getContinuation(Thread thread) {
                return thread.getContinuation();
            }

            @Override
            public void setContinuation(Thread thread, Continuation continuation) {
                thread.setContinuation(continuation);
            }

            @Override
            public ContinuationScope virtualThreadContinuationScope() {
                return VirtualThread.continuationScope();
            }

            @Override
            public void parkVirtualThread() {
                Thread thread = Thread.currentThread();
                if (!(thread instanceof BaseVirtualThread)) {
                    throw new WrongThreadException();
                }
                BaseVirtualThread vthread = (BaseVirtualThread)thread;
                vthread.park();
            }

            @Override
            public void parkVirtualThread(long nanos) {
                Thread thread = Thread.currentThread();
                if (!(thread instanceof BaseVirtualThread)) {
                    throw new WrongThreadException();
                }
                BaseVirtualThread vthread = (BaseVirtualThread)thread;
                vthread.parkNanos(nanos);
            }

            @Override
            public void unparkVirtualThread(Thread thread) {
                if (!(thread instanceof BaseVirtualThread)) {
                    throw new WrongThreadException();
                }
                BaseVirtualThread vthread = (BaseVirtualThread)thread;
                vthread.unpark();
            }

            @Override
            public StackWalker newStackWalkerInstance(Set<StackWalker.Option> options, ContinuationScope contScope, Continuation continuation) {
                return StackWalker.newInstance(options, null, contScope, continuation);
            }

            @Override
            public String getLoaderNameID(ClassLoader loader) {
                return loader != null ? loader.nameAndId() : "null";
            }
        });
    }

    @SuppressWarnings(value={"rawtypes"})
    static Class<?> getCallerClass() {
        return Reflection.getCallerClass((int)3);
    }

    static {
        System.registerNatives();
        in = null;
        out = null;
        err = null;
        security = null;
        cons = null;
    }
}

