/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@ReadOnly
public abstract class Enum<E extends Enum<E>>
implements Comparable<E>,
Serializable {
    private final String name;
    private final int ordinal;

    public final String name() {
        return this.name;
    }

    public final int ordinal() {
        return this.ordinal;
    }

    protected Enum(String string, int n) {
        this.name = string;
        this.ordinal = n;
    }

    @SideEffectFree
    public String toString() {
        return this.name;
    }

    @Pure
    public final boolean equals(@Nullable @ReadOnly Object object) {
        return this == object;
    }

    @Pure
    public final int hashCode() {
        return super.hashCode();
    }

    @SideEffectFree
    protected final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    @SuppressWarnings(value={"rawtypes"})
    public final int compareTo(E e) {
        E e2 = e;
        Enum enum_ = this;
        if (enum_.getClass() != e2.getClass() && enum_.getDeclaringClass() != ((Enum)e2).getDeclaringClass()) {
            throw new ClassCastException();
        }
        return enum_.ordinal - ((Enum)e2).ordinal;
    }

    @SuppressWarnings(value={"rawtypes", "unchecked"})
    public final Class<E> getDeclaringClass() {
        Class<?> clazz = this.getClass();
        Class<?> clazz2 = clazz.getSuperclass();
        return clazz2 == Enum.class ? clazz : clazz2;
    }

    public static <T extends Enum<T>> T valueOf(Class<T> clazz, String string) {
        Enum enum_ = (Enum)clazz.enumConstantDirectory().get(string);
        if (enum_ != null) {
            return (T)enum_;
        }
        if (string == null) {
            throw new NullPointerException("Name is null");
        }
        throw new IllegalArgumentException("No enum constant " + clazz.getCanonicalName() + "." + string);
    }

    protected final void finalize() {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException("can't deserialize enum");
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("can't deserialize enum");
    }
}

