/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Reader;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public class CharArrayReader
extends Reader {
    protected char[] buf;
    protected int pos;
    protected int markedPos = 0;
    protected int count;

    public CharArrayReader(char[] cArray) {
        this.buf = cArray;
        this.pos = 0;
        this.count = cArray.length;
    }

    public CharArrayReader(char[] cArray, int n, int n2) {
        if (n < 0 || n > cArray.length || n2 < 0 || n + n2 < 0) {
            throw new IllegalArgumentException();
        }
        this.buf = cArray;
        this.pos = n;
        this.count = Math.min(n + n2, cArray.length);
        this.markedPos = n;
    }

    private void ensureOpen() throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.pos >= this.count) {
                return -1;
            }
            return this.buf[this.pos++];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            if (this.pos >= this.count) {
                return -1;
            }
            if (this.pos + n2 > this.count) {
                n2 = this.count - this.pos;
            }
            if (n2 <= 0) {
                return 0;
            }
            System.arraycopy(this.buf, this.pos, cArray, n, n2);
            this.pos += n2;
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long l) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if ((long)this.pos + l > (long)this.count) {
                l = this.count - this.pos;
            }
            if (l < 0L) {
                return 0L;
            }
            this.pos = (int)((long)this.pos + l);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            return this.count - this.pos > 0;
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.markedPos = this.pos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.pos = this.markedPos;
        }
    }

    @Override
    public void close() {
        this.buf = null;
    }
}

