/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.javacutil;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.CollectionUtils;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.InternalUtils;

public class AnnotationUtils {
    private static final int ANNOTATION_CACHE_SIZE = 500;
    private static final Map<Class<? extends Annotation>, String> annotationClassNames = Collections.synchronizedMap(CollectionUtils.createLRUCache(500));
    private static final Comparator<AnnotationMirror> ANNOTATION_ORDERING = new Comparator<AnnotationMirror>(){

        @Override
        public int compare(AnnotationMirror a1, AnnotationMirror a2) {
            if (AnnotationUtils.areSame(a1, a2)) {
                return 0;
            }
            String n1 = a1.toString();
            String n2 = a2.toString();
            return n1.compareTo(n2);
        }
    };

    private AnnotationUtils() {
        throw new AssertionError((Object)"Class AnnotationUtils cannot be instantiated.");
    }

    public static void clear() {
        AnnotationBuilder.clear();
        annotationClassNames.clear();
    }

    public static final String annotationName(AnnotationMirror annotation) {
        if (annotation instanceof AnnotationBuilder.CheckerFrameworkAnnotationMirror) {
            return ((AnnotationBuilder.CheckerFrameworkAnnotationMirror)annotation).annotationName;
        }
        DeclaredType annoType = annotation.getAnnotationType();
        TypeElement elm = (TypeElement)annoType.asElement();
        String name = elm.getQualifiedName().toString().intern();
        return name;
    }

    @Deprecated
    public static String annotationSimpleName(AnnotationMirror annotation) {
        DeclaredType annoType = annotation.getAnnotationType();
        TypeElement elm = (TypeElement)annoType.asElement();
        String name = elm.getSimpleName().toString().intern();
        return name;
    }

    public static boolean areSame(AnnotationMirror a1, AnnotationMirror a2) {
        if (a1 != null && a2 != null) {
            if (a1 == a2) {
                return true;
            }
            if (AnnotationUtils.annotationName(a1) != AnnotationUtils.annotationName(a2)) {
                return false;
            }
            Map<? extends ExecutableElement, ? extends AnnotationValue> elval1 = AnnotationUtils.getElementValuesWithDefaults(a1);
            Map<? extends ExecutableElement, ? extends AnnotationValue> elval2 = AnnotationUtils.getElementValuesWithDefaults(a2);
            return elval1.toString().equals(elval2.toString());
        }
        return a1 == a2;
    }

    public static boolean areSameIgnoringValues(AnnotationMirror a1, AnnotationMirror a2) {
        if (a1 != null && a2 != null) {
            return a1 == a2 || AnnotationUtils.annotationName(a1) == AnnotationUtils.annotationName(a2);
        }
        return a1 == a2;
    }

    public static boolean areSameByName(AnnotationMirror am, String aname) {
        return AnnotationUtils.annotationName(am) == aname;
    }

    public static boolean areSameByClass(AnnotationMirror am, Class<? extends Annotation> anno) {
        String canonicalName = annotationClassNames.get(anno);
        if (canonicalName == null) {
            canonicalName = anno.getCanonicalName().intern();
            annotationClassNames.put(anno, canonicalName);
        }
        return AnnotationUtils.areSameByName(am, canonicalName);
    }

    public static boolean areSame(Collection<? extends AnnotationMirror> c1, Collection<? extends AnnotationMirror> c2) {
        if (c1.size() != c2.size()) {
            return false;
        }
        if (c1.size() == 1) {
            return AnnotationUtils.areSame(c1.iterator().next(), c2.iterator().next());
        }
        Set<AnnotationMirror> s1 = AnnotationUtils.createAnnotationSet();
        Set<AnnotationMirror> s2 = AnnotationUtils.createAnnotationSet();
        s1.addAll(c1);
        s2.addAll(c2);
        Iterator<AnnotationMirror> iter1 = s1.iterator();
        Iterator<AnnotationMirror> iter2 = s2.iterator();
        while (iter1.hasNext()) {
            AnnotationMirror anno2;
            AnnotationMirror anno1 = iter1.next();
            if (AnnotationUtils.areSame(anno1, anno2 = iter2.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean containsSame(Collection<? extends AnnotationMirror> c, AnnotationMirror anno) {
        return AnnotationUtils.getSame(c, anno) != null;
    }

    public static AnnotationMirror getSame(Collection<? extends AnnotationMirror> c, AnnotationMirror anno) {
        for (AnnotationMirror annotationMirror : c) {
            if (!AnnotationUtils.areSame(annotationMirror, anno)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static boolean containsSameByClass(Collection<? extends AnnotationMirror> c, Class<? extends Annotation> anno) {
        return AnnotationUtils.getAnnotationByClass(c, anno) != null;
    }

    public static AnnotationMirror getAnnotationByClass(Collection<? extends AnnotationMirror> c, Class<? extends Annotation> anno) {
        for (AnnotationMirror annotationMirror : c) {
            if (!AnnotationUtils.areSameByClass(annotationMirror, anno)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static boolean containsSameByName(Collection<? extends AnnotationMirror> c, String anno) {
        return AnnotationUtils.getAnnotationByName(c, anno) != null;
    }

    public static AnnotationMirror getAnnotationByName(Collection<? extends AnnotationMirror> c, String anno) {
        for (AnnotationMirror annotationMirror : c) {
            if (!AnnotationUtils.areSameByName(annotationMirror, anno)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static boolean containsSameIgnoringValues(Collection<? extends AnnotationMirror> c, AnnotationMirror anno) {
        return AnnotationUtils.getSameIgnoringValues(c, anno) != null;
    }

    public static AnnotationMirror getSameIgnoringValues(Collection<? extends AnnotationMirror> c, AnnotationMirror anno) {
        for (AnnotationMirror annotationMirror : c) {
            if (!AnnotationUtils.areSameIgnoringValues(annotationMirror, anno)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static Comparator<AnnotationMirror> annotationOrdering() {
        return ANNOTATION_ORDERING;
    }

    public static <V> Map<AnnotationMirror, V> createAnnotationMap() {
        return new TreeMap(AnnotationUtils.annotationOrdering());
    }

    public static Set<AnnotationMirror> createAnnotationSet() {
        return new TreeSet<AnnotationMirror>(AnnotationUtils.annotationOrdering());
    }

    public static boolean hasInheritedMeta(AnnotationMirror anno) {
        return anno.getAnnotationType().asElement().getAnnotation(Inherited.class) != null;
    }

    public static Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValuesWithDefaults(AnnotationMirror ad) {
        HashMap<? extends ExecutableElement, ? extends AnnotationValue> valMap = new HashMap<ExecutableElement, AnnotationValue>();
        if (ad.getElementValues() != null) {
            valMap.putAll(ad.getElementValues());
        }
        for (ExecutableElement meth : ElementFilter.methodsIn(ad.getAnnotationType().asElement().getEnclosedElements())) {
            AnnotationValue defaultValue = meth.getDefaultValue();
            if (defaultValue == null || valMap.containsKey(meth)) continue;
            valMap.put(meth, defaultValue);
        }
        return valMap;
    }

    public static <T> boolean hasElementValue(AnnotationMirror anno, CharSequence name) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> valmap = anno.getElementValues();
        for (ExecutableElement executableElement : valmap.keySet()) {
            if (!executableElement.getSimpleName().contentEquals(name)) continue;
            return true;
        }
        return false;
    }

    public static <T> T getElementValue(AnnotationMirror anno, CharSequence name, Class<T> expectedType, boolean useDefaults) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> valmap = useDefaults ? AnnotationUtils.getElementValuesWithDefaults(anno) : anno.getElementValues();
        for (ExecutableElement executableElement : valmap.keySet()) {
            if (!executableElement.getSimpleName().contentEquals(name)) continue;
            AnnotationValue val = valmap.get(executableElement);
            return expectedType.cast(val.getValue());
        }
        ErrorReporter.errorAbort("No element with name '" + name + "' in annotation " + anno);
        return null;
    }

    public static <T extends Enum<T>> T getElementValueEnum(AnnotationMirror anno, CharSequence name, Class<T> t, boolean useDefaults) {
        Symbol.VarSymbol vs = AnnotationUtils.getElementValue(anno, name, Symbol.VarSymbol.class, useDefaults);
        T value = Enum.valueOf(t, ((Name)vs.getSimpleName()).toString());
        return value;
    }

    public static <T> List<T> getElementValueArray(AnnotationMirror anno, CharSequence name, Class<T> expectedType, boolean useDefaults) {
        List la = AnnotationUtils.getElementValue(anno, name, List.class, useDefaults);
        ArrayList<T> result = new ArrayList<T>(la.size());
        for (AnnotationValue a : la) {
            result.add(expectedType.cast(a.getValue()));
        }
        return result;
    }

    public static <T extends Enum<T>> List<T> getElementValueEnumArray(AnnotationMirror anno, CharSequence name, Class<T> t, boolean useDefaults) {
        List la = AnnotationUtils.getElementValue(anno, name, List.class, useDefaults);
        ArrayList<T> result = new ArrayList<T>(la.size());
        for (AnnotationValue a : la) {
            T value = Enum.valueOf(t, a.getValue().toString());
            result.add(value);
        }
        return result;
    }

    public static javax.lang.model.element.Name getElementValueClassName(AnnotationMirror anno, CharSequence name, boolean useDefaults) {
        Type.ClassType ct = AnnotationUtils.getElementValue(anno, name, Type.ClassType.class, useDefaults);
        return ((Symbol)ct.asElement()).getQualifiedName();
    }

    public static List<javax.lang.model.element.Name> getElementValueClassNames(AnnotationMirror anno, CharSequence name, boolean useDefaults) {
        List<Type.ClassType> la = AnnotationUtils.getElementValueArray(anno, name, Type.ClassType.class, useDefaults);
        ArrayList<javax.lang.model.element.Name> names = new ArrayList<javax.lang.model.element.Name>();
        for (Type.ClassType classType : la) {
            names.add(((Symbol)classType.asElement()).getQualifiedName());
        }
        return names;
    }

    public static Class<?> getElementValueClass(AnnotationMirror anno, CharSequence name, boolean useDefaults) {
        javax.lang.model.element.Name cn = AnnotationUtils.getElementValueClassName(anno, name, useDefaults);
        try {
            ClassLoader classLoader = InternalUtils.getClassLoaderForClass(AnnotationUtils.class);
            Class<?> cls = Class.forName(cn.toString(), true, classLoader);
            return cls;
        }
        catch (ClassNotFoundException e) {
            String msg = String.format("Could not load class '%s' for field '%s' in annotation %s", cn, name, anno);
            ErrorReporter.errorAbort(msg, e);
            return null;
        }
    }

    public static <T> void updateMappingToImmutableSet(Map<T, Set<AnnotationMirror>> map, T key, Set<AnnotationMirror> newQual) {
        Set<AnnotationMirror> result = AnnotationUtils.createAnnotationSet();
        if (!map.containsKey(key)) {
            result.addAll(newQual);
        } else {
            result.addAll((Collection<AnnotationMirror>)map.get(key));
            result.addAll(newQual);
        }
        map.put(key, Collections.unmodifiableSet(result));
    }

    public static Set<AnnotationMirror> getExplicitAnnotationsOnConstructorResult(MethodTree constructorDeclaration) {
        Set<AnnotationMirror> annotationSet = AnnotationUtils.createAnnotationSet();
        ModifiersTree modifiersTree = constructorDeclaration.getModifiers();
        if (modifiersTree != null) {
            List<? extends AnnotationTree> annotationTrees = modifiersTree.getAnnotations();
            annotationSet.addAll(InternalUtils.annotationsFromTypeAnnotationTrees(annotationTrees));
        }
        return annotationSet;
    }

    @Deprecated
    public static AnnotationMirror fromName(Elements elements, CharSequence name) {
        return AnnotationBuilder.fromName(elements, name);
    }

    @Deprecated
    public static AnnotationMirror fromClass(Elements elements, Class<? extends Annotation> clazz) {
        return AnnotationBuilder.fromClass(elements, clazz);
    }
}

