/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.test;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import javax.annotation.processing.AbstractProcessor;
import org.checkerframework.checker.initialization.qual.UnderInitialization;
import org.checkerframework.framework.test.CheckerFrameworkPerDirectoryTest;
import org.junit.Assert;

public abstract class CheckerFrameworkWPIPerDirectoryTest
extends CheckerFrameworkPerDirectoryTest {
    protected CheckerFrameworkWPIPerDirectoryTest(List<File> testFiles, Class<? extends AbstractProcessor> checker, String testDir, String ... checkerOptions) {
        super(testFiles, checker, testDir, checkerOptions);
        String skipComment = this.checkerOptions.contains("-Ainfer=ajava") ? "@infer-ajava-skip-test" : (this.checkerOptions.contains("-Ainfer=jaifs") ? "@infer-jaifs-skip-test" : (this.checkerOptions.contains("-Ainfer=stubs") ? "@infer-stubs-skip-test" : null));
        if (skipComment != null) {
            ArrayList<File> removeFiles = new ArrayList<File>();
            for (File testFile : testFiles) {
                if (!CheckerFrameworkWPIPerDirectoryTest.hasSkipComment(testFile, skipComment)) continue;
                removeFiles.add(testFile);
            }
            this.testFiles.removeAll(removeFiles);
        }
    }

    protected void doNotTypecheck(@UnderInitialization(value=CheckerFrameworkPerDirectoryTest.class) CheckerFrameworkWPIPerDirectoryTest this, String endswith) {
        int removeIndex = -1;
        for (int i = 0; i < this.testFiles.size(); ++i) {
            File f = (File)this.testFiles.get(i);
            if (!f.getAbsolutePath().endsWith(endswith)) continue;
            if (removeIndex != -1) {
                Assert.fail((String)("When attempting to exclude a file, found more than one match in the test suite. Check the test code and use a more-specific removal key. Attempting to exclude: " + endswith));
            }
            removeIndex = i;
        }
        if (removeIndex != -1) {
            this.testFiles.remove(removeIndex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasSkipComment(File file, String skipComment) {
        try (Scanner in = new Scanner(file, StandardCharsets.UTF_8);){
            String nextLine;
            do {
                if (!in.hasNext()) return false;
            } while (!(nextLine = in.nextLine()).contains(skipComment));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

