/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.dataflow.expression;

import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.interning.qual.EqualsMethod;
import org.checkerframework.shaded.dataflow.analysis.Store;
import org.checkerframework.shaded.dataflow.expression.Unknown;

public abstract class Receiver {
    protected final TypeMirror type;

    protected Receiver(TypeMirror type) {
        assert (type != null);
        this.type = type;
    }

    public TypeMirror getType() {
        return this.type;
    }

    public abstract boolean containsOfClass(Class<? extends Receiver> var1);

    public boolean containsUnknown() {
        return this.containsOfClass(Unknown.class);
    }

    public abstract boolean isUnassignableByOtherCode();

    public abstract boolean isUnmodifiableByOtherCode();

    @EqualsMethod
    public boolean syntacticEquals(Receiver other) {
        return other == this;
    }

    public boolean containsSyntacticEqualReceiver(Receiver other) {
        return this.syntacticEquals(other);
    }

    public boolean containsModifiableAliasOf(Store<?> store, Receiver other) {
        return this.equals(other) || store.canAlias(this, other);
    }

    public String toStringDebug() {
        return String.format("Receiver (%s) %s type=%s", this.getClass().getSimpleName(), this.toString(), this.type);
    }
}

