/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.dataflow.expression;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.org.plumelib.util.UtilPlume;
import org.checkerframework.shaded.dataflow.analysis.Store;
import org.checkerframework.shaded.dataflow.expression.ClassName;
import org.checkerframework.shaded.dataflow.expression.LocalVariable;
import org.checkerframework.shaded.dataflow.expression.Receiver;

public class MethodCall
extends Receiver {
    protected final Receiver receiver;
    protected final List<Receiver> parameters;
    protected final ExecutableElement method;

    public MethodCall(TypeMirror type, ExecutableElement method, Receiver receiver, List<Receiver> parameters) {
        super(type);
        this.receiver = receiver;
        this.parameters = parameters;
        this.method = method;
    }

    @Override
    public boolean containsOfClass(Class<? extends Receiver> clazz) {
        if (this.getClass() == clazz) {
            return true;
        }
        if (this.receiver.containsOfClass(clazz)) {
            return true;
        }
        for (Receiver p : this.parameters) {
            if (!p.containsOfClass(clazz)) continue;
            return true;
        }
        return false;
    }

    public Receiver getReceiver() {
        return this.receiver;
    }

    public List<Receiver> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public ExecutableElement getElement() {
        return this.method;
    }

    @Override
    public boolean isUnassignableByOtherCode() {
        return this.receiver.isUnmodifiableByOtherCode() && this.parameters.stream().allMatch(Receiver::isUnmodifiableByOtherCode);
    }

    @Override
    public boolean isUnmodifiableByOtherCode() {
        return this.isUnassignableByOtherCode();
    }

    @Override
    public boolean containsSyntacticEqualReceiver(Receiver other) {
        return this.syntacticEquals(other) || this.receiver.syntacticEquals(other);
    }

    @Override
    public boolean syntacticEquals(Receiver other) {
        if (!(other instanceof MethodCall)) {
            return false;
        }
        MethodCall otherMethod = (MethodCall)other;
        if (!this.receiver.syntacticEquals(otherMethod.receiver)) {
            return false;
        }
        if (this.parameters.size() != otherMethod.parameters.size()) {
            return false;
        }
        int i = 0;
        for (Receiver p : this.parameters) {
            if (!p.syntacticEquals(otherMethod.parameters.get(i))) {
                return false;
            }
            ++i;
        }
        return this.method.equals(otherMethod.method);
    }

    public boolean containsSyntacticEqualParameter(LocalVariable var) {
        for (Receiver p : this.parameters) {
            if (!p.containsSyntacticEqualReceiver(var)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsModifiableAliasOf(Store<?> store, Receiver other) {
        if (this.receiver.containsModifiableAliasOf(store, other)) {
            return true;
        }
        for (Receiver p : this.parameters) {
            if (!p.containsModifiableAliasOf(store, other)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MethodCall)) {
            return false;
        }
        if (this.method.getKind() == ElementKind.CONSTRUCTOR) {
            return false;
        }
        MethodCall other = (MethodCall)obj;
        return this.parameters.equals(other.parameters) && this.receiver.equals(other.receiver) && this.method.equals(other.method);
    }

    public int hashCode() {
        if (this.method.getKind() == ElementKind.CONSTRUCTOR) {
            return super.hashCode();
        }
        return Objects.hash(this.method, this.receiver, this.parameters);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.receiver instanceof ClassName) {
            result.append(this.receiver.getType());
        } else {
            result.append(this.receiver);
        }
        result.append(".");
        String methodName = this.method.getSimpleName().toString();
        result.append(methodName);
        result.append("(");
        result.append(UtilPlume.join((CharSequence)", ", this.parameters));
        result.append(")");
        return result.toString();
    }
}

