/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.dataflow.expression;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.shaded.dataflow.cfg.node.ArrayAccessNode;
import org.checkerframework.shaded.dataflow.cfg.node.ArrayCreationNode;
import org.checkerframework.shaded.dataflow.cfg.node.BinaryOperationNode;
import org.checkerframework.shaded.dataflow.cfg.node.ClassNameNode;
import org.checkerframework.shaded.dataflow.cfg.node.ExplicitThisLiteralNode;
import org.checkerframework.shaded.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.shaded.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.shaded.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.shaded.dataflow.cfg.node.NarrowingConversionNode;
import org.checkerframework.shaded.dataflow.cfg.node.Node;
import org.checkerframework.shaded.dataflow.cfg.node.StringConversionNode;
import org.checkerframework.shaded.dataflow.cfg.node.SuperNode;
import org.checkerframework.shaded.dataflow.cfg.node.ThisLiteralNode;
import org.checkerframework.shaded.dataflow.cfg.node.ValueLiteralNode;
import org.checkerframework.shaded.dataflow.cfg.node.WideningConversionNode;
import org.checkerframework.shaded.dataflow.expression.ArrayAccess;
import org.checkerframework.shaded.dataflow.expression.ArrayCreation;
import org.checkerframework.shaded.dataflow.expression.BinaryOperation;
import org.checkerframework.shaded.dataflow.expression.ClassName;
import org.checkerframework.shaded.dataflow.expression.FieldAccess;
import org.checkerframework.shaded.dataflow.expression.LocalVariable;
import org.checkerframework.shaded.dataflow.expression.MethodCall;
import org.checkerframework.shaded.dataflow.expression.Receiver;
import org.checkerframework.shaded.dataflow.expression.ThisReference;
import org.checkerframework.shaded.dataflow.expression.Unknown;
import org.checkerframework.shaded.dataflow.expression.ValueLiteral;
import org.checkerframework.shaded.dataflow.util.PurityUtils;
import org.checkerframework.shaded.javacutil.AnnotationProvider;
import org.checkerframework.shaded.javacutil.BugInCF;
import org.checkerframework.shaded.javacutil.ElementUtils;
import org.checkerframework.shaded.javacutil.TreeUtils;

public class FlowExpressions {
    public static FieldAccess internalReprOfFieldAccess(AnnotationProvider provider, FieldAccessNode node) {
        Node receiverNode = node.getReceiver();
        Receiver receiver = node.isStatic() ? new ClassName(receiverNode.getType()) : FlowExpressions.internalReprOf(provider, receiverNode);
        return new FieldAccess(receiver, node);
    }

    public static ArrayAccess internalReprOfArrayAccess(AnnotationProvider provider, ArrayAccessNode node) {
        Receiver receiver = FlowExpressions.internalReprOf(provider, node.getArray());
        Receiver index = FlowExpressions.internalReprOf(provider, node.getIndex());
        return new ArrayAccess(node.getType(), receiver, index);
    }

    public static Receiver internalReprOf(AnnotationProvider provider, Node receiverNode) {
        return FlowExpressions.internalReprOf(provider, receiverNode, false);
    }

    public static Receiver internalReprOf(AnnotationProvider provider, Node receiverNode, boolean allowNonDeterministic) {
        Receiver receiver = null;
        if (receiverNode instanceof FieldAccessNode) {
            FieldAccessNode fan = (FieldAccessNode)receiverNode;
            receiver = fan.getFieldName().equals("this") ? new ThisReference(fan.getReceiver().getType()) : (fan.getFieldName().equals("class") ? new ClassName(fan.getReceiver().getType()) : FlowExpressions.internalReprOfFieldAccess(provider, fan));
        } else if (receiverNode instanceof ExplicitThisLiteralNode) {
            receiver = new ThisReference(receiverNode.getType());
        } else if (receiverNode instanceof ThisLiteralNode) {
            receiver = new ThisReference(receiverNode.getType());
        } else if (receiverNode instanceof SuperNode) {
            receiver = new ThisReference(receiverNode.getType());
        } else if (receiverNode instanceof LocalVariableNode) {
            LocalVariableNode lv = (LocalVariableNode)receiverNode;
            receiver = new LocalVariable(lv);
        } else if (receiverNode instanceof ArrayAccessNode) {
            ArrayAccessNode a = (ArrayAccessNode)receiverNode;
            receiver = FlowExpressions.internalReprOfArrayAccess(provider, a);
        } else {
            if (receiverNode instanceof StringConversionNode) {
                return FlowExpressions.internalReprOf(provider, ((StringConversionNode)receiverNode).getOperand());
            }
            if (receiverNode instanceof WideningConversionNode) {
                return FlowExpressions.internalReprOf(provider, ((WideningConversionNode)receiverNode).getOperand());
            }
            if (receiverNode instanceof NarrowingConversionNode) {
                return FlowExpressions.internalReprOf(provider, ((NarrowingConversionNode)receiverNode).getOperand());
            }
            if (receiverNode instanceof BinaryOperationNode) {
                BinaryOperationNode bopn = (BinaryOperationNode)receiverNode;
                return new BinaryOperation(bopn, FlowExpressions.internalReprOf(provider, bopn.getLeftOperand(), allowNonDeterministic), FlowExpressions.internalReprOf(provider, bopn.getRightOperand(), allowNonDeterministic));
            }
            if (receiverNode instanceof ClassNameNode) {
                ClassNameNode cn = (ClassNameNode)receiverNode;
                receiver = new ClassName(cn.getType());
            } else if (receiverNode instanceof ValueLiteralNode) {
                ValueLiteralNode vn = (ValueLiteralNode)receiverNode;
                receiver = new ValueLiteral(vn.getType(), vn);
            } else if (receiverNode instanceof ArrayCreationNode) {
                ArrayCreationNode an = (ArrayCreationNode)receiverNode;
                ArrayList<Receiver> dimensions = new ArrayList<Receiver>();
                for (Node node : an.getDimensions()) {
                    dimensions.add(FlowExpressions.internalReprOf(provider, node, allowNonDeterministic));
                }
                ArrayList<Receiver> initializers = new ArrayList<Receiver>();
                for (Node initializer : an.getInitializers()) {
                    initializers.add(FlowExpressions.internalReprOf(provider, initializer, allowNonDeterministic));
                }
                receiver = new ArrayCreation(an.getType(), dimensions, initializers);
            } else if (receiverNode instanceof MethodInvocationNode) {
                MethodInvocationNode mn = (MethodInvocationNode)receiverNode;
                MethodInvocationTree t = mn.getTree();
                if (t == null) {
                    throw new BugInCF("Unexpected null tree for node: " + mn);
                }
                assert (TreeUtils.isUseOfElement(t)) : "@AssumeAssertion(nullness): tree kind";
                ExecutableElement invokedMethod = TreeUtils.elementFromUse(t);
                if (allowNonDeterministic || PurityUtils.isDeterministic(provider, invokedMethod)) {
                    ArrayList<Receiver> arrayList = new ArrayList<Receiver>();
                    for (Node p : mn.getArguments()) {
                        arrayList.add(FlowExpressions.internalReprOf(provider, p));
                    }
                    Receiver methodReceiver = ElementUtils.isStatic(invokedMethod) ? new ClassName(mn.getTarget().getReceiver().getType()) : FlowExpressions.internalReprOf(provider, mn.getTarget().getReceiver());
                    receiver = new MethodCall(mn.getType(), invokedMethod, methodReceiver, arrayList);
                }
            }
        }
        if (receiver == null) {
            receiver = new Unknown(receiverNode.getType());
        }
        return receiver;
    }

    public static Receiver internalReprOf(AnnotationProvider provider, ExpressionTree receiverTree) {
        return FlowExpressions.internalReprOf(provider, receiverTree, true);
    }

    public static Receiver internalReprOf(AnnotationProvider provider, ExpressionTree receiverTree, boolean allowNonDeterministic) {
        Receiver receiver;
        block0 : switch (receiverTree.getKind()) {
            case ARRAY_ACCESS: {
                ArrayAccessTree a = (ArrayAccessTree)receiverTree;
                Receiver arrayAccessExpression = FlowExpressions.internalReprOf(provider, a.getExpression());
                Receiver index = FlowExpressions.internalReprOf(provider, a.getIndex());
                receiver = new ArrayAccess(TreeUtils.typeOf(a), arrayAccessExpression, index);
                break;
            }
            case BOOLEAN_LITERAL: 
            case CHAR_LITERAL: 
            case DOUBLE_LITERAL: 
            case FLOAT_LITERAL: 
            case INT_LITERAL: 
            case LONG_LITERAL: 
            case NULL_LITERAL: 
            case STRING_LITERAL: {
                LiteralTree vn = (LiteralTree)receiverTree;
                receiver = new ValueLiteral(TreeUtils.typeOf(receiverTree), vn.getValue());
                break;
            }
            case NEW_ARRAY: {
                NewArrayTree newArrayTree = (NewArrayTree)receiverTree;
                ArrayList<Receiver> dimensions = new ArrayList<Receiver>();
                if (newArrayTree.getDimensions() != null) {
                    for (ExpressionTree expressionTree : newArrayTree.getDimensions()) {
                        dimensions.add(FlowExpressions.internalReprOf(provider, expressionTree, allowNonDeterministic));
                    }
                }
                ArrayList<Receiver> initializers = new ArrayList<Receiver>();
                if (newArrayTree.getInitializers() != null) {
                    for (ExpressionTree expressionTree : newArrayTree.getInitializers()) {
                        initializers.add(FlowExpressions.internalReprOf(provider, expressionTree, allowNonDeterministic));
                    }
                }
                receiver = new ArrayCreation(TreeUtils.typeOf(receiverTree), dimensions, initializers);
                break;
            }
            case METHOD_INVOCATION: {
                MethodInvocationTree methodInvocationTree = (MethodInvocationTree)receiverTree;
                assert (TreeUtils.isUseOfElement(methodInvocationTree)) : "@AssumeAssertion(nullness): tree kind";
                ExecutableElement executableElement = TreeUtils.elementFromUse(methodInvocationTree);
                if (PurityUtils.isDeterministic(provider, executableElement) || allowNonDeterministic) {
                    ExpressionTree expressionTree;
                    ArrayList<Receiver> parameters = new ArrayList<Receiver>();
                    for (ExpressionTree expressionTree2 : methodInvocationTree.getArguments()) {
                        parameters.add(FlowExpressions.internalReprOf(provider, expressionTree2));
                    }
                    Receiver methodReceiver = ElementUtils.isStatic(executableElement) ? new ClassName(TreeUtils.typeOf(methodInvocationTree.getMethodSelect())) : ((expressionTree = TreeUtils.getReceiverTree(methodInvocationTree)) != null ? FlowExpressions.internalReprOf(provider, expressionTree) : FlowExpressions.internalReprOfImplicitReceiver(executableElement));
                    TypeMirror typeMirror = TreeUtils.typeOf(methodInvocationTree);
                    receiver = new MethodCall(typeMirror, executableElement, methodReceiver, parameters);
                    break;
                }
                receiver = null;
                break;
            }
            case MEMBER_SELECT: {
                receiver = FlowExpressions.internalReprOfMemberSelect(provider, (MemberSelectTree)receiverTree);
                break;
            }
            case IDENTIFIER: {
                IdentifierTree identifierTree = (IdentifierTree)receiverTree;
                TypeMirror typeOfId = TreeUtils.typeOf(identifierTree);
                if (identifierTree.getName().contentEquals("this") || identifierTree.getName().contentEquals("super")) {
                    receiver = new ThisReference(typeOfId);
                    break;
                }
                assert (TreeUtils.isUseOfElement(identifierTree)) : "@AssumeAssertion(nullness): tree kind";
                Element element = TreeUtils.elementFromUse(identifierTree);
                if (ElementUtils.isClassElement(element)) {
                    receiver = new ClassName(element.asType());
                    break;
                }
                switch (element.getKind()) {
                    case LOCAL_VARIABLE: 
                    case RESOURCE_VARIABLE: 
                    case EXCEPTION_PARAMETER: 
                    case PARAMETER: {
                        receiver = new LocalVariable(element);
                        break block0;
                    }
                    case FIELD: {
                        TypeMirror enclosingType = ElementUtils.enclosingClass(element).asType();
                        Receiver fieldAccessExpression = ElementUtils.isStatic(element) ? new ClassName(enclosingType) : new ThisReference(enclosingType);
                        receiver = new FieldAccess(fieldAccessExpression, typeOfId, (VariableElement)element);
                        break block0;
                    }
                }
                receiver = null;
                break;
            }
            case UNARY_PLUS: {
                return FlowExpressions.internalReprOf(provider, ((UnaryTree)receiverTree).getExpression(), allowNonDeterministic);
            }
            default: {
                receiver = null;
            }
        }
        if (receiver == null) {
            receiver = new Unknown(TreeUtils.typeOf(receiverTree));
        }
        return receiver;
    }

    public static Receiver internalReprOfImplicitReceiver(Element ele) {
        TypeElement enclosingClass = ElementUtils.enclosingClass(ele);
        if (enclosingClass == null) {
            throw new BugInCF("internalReprOfImplicitReceiver's arg has no enclosing class: " + ele);
        }
        TypeMirror enclosingType = enclosingClass.asType();
        if (ElementUtils.isStatic(ele)) {
            return new ClassName(enclosingType);
        }
        return new ThisReference(enclosingType);
    }

    public static Receiver internalReprOfPseudoReceiver(TreePath path, TypeMirror enclosingType) {
        if (TreeUtils.isTreeInStaticScope(path)) {
            return new ClassName(enclosingType);
        }
        return new ThisReference(enclosingType);
    }

    private static Receiver internalReprOfMemberSelect(AnnotationProvider provider, MemberSelectTree memberSelectTree) {
        TypeMirror expressionType = TreeUtils.typeOf(memberSelectTree.getExpression());
        if (TreeUtils.isClassLiteral(memberSelectTree)) {
            return new ClassName(expressionType);
        }
        assert (TreeUtils.isUseOfElement(memberSelectTree)) : "@AssumeAssertion(nullness): tree kind";
        Element ele = TreeUtils.elementFromUse(memberSelectTree);
        if (ElementUtils.isClassElement(ele)) {
            TypeMirror selectType = TreeUtils.typeOf(memberSelectTree);
            return new ClassName(selectType);
        }
        switch (ele.getKind()) {
            case METHOD: 
            case CONSTRUCTOR: {
                return FlowExpressions.internalReprOf(provider, memberSelectTree.getExpression());
            }
            case FIELD: 
            case ENUM_CONSTANT: {
                TypeMirror fieldType = TreeUtils.typeOf(memberSelectTree);
                Receiver r = FlowExpressions.internalReprOf(provider, memberSelectTree.getExpression());
                return new FieldAccess(r, fieldType, (VariableElement)ele);
            }
        }
        throw new BugInCF("Unexpected element kind: %s element: %s", new Object[]{ele.getKind(), ele});
    }

    public static @Nullable List<Receiver> getParametersOfEnclosingMethod(AnnotationProvider annotationProvider, TreePath path) {
        MethodTree methodTree = TreeUtils.enclosingMethod(path);
        if (methodTree == null) {
            return null;
        }
        ArrayList<Receiver> internalArguments = new ArrayList<Receiver>();
        for (VariableTree variableTree : methodTree.getParameters()) {
            internalArguments.add(FlowExpressions.internalReprOf(annotationProvider, new LocalVariableNode(variableTree)));
        }
        return internalArguments;
    }
}

