/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.org.plumelib.util;

import java.util.Collections;
import java.util.IdentityHashMap;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.shaded.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.shaded.checker.formatter.qual.FormatBottom;
import org.checkerframework.shaded.checker.formatter.qual.UnknownFormat;
import org.checkerframework.shaded.checker.index.qual.LessThanUnknown;
import org.checkerframework.shaded.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.shaded.checker.index.qual.SameLenUnknown;
import org.checkerframework.shaded.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.shaded.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.shaded.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.shaded.checker.initialization.qual.Initialized;
import org.checkerframework.shaded.checker.interning.qual.FindDistinct;
import org.checkerframework.shaded.checker.interning.qual.Interned;
import org.checkerframework.shaded.checker.interning.qual.UnknownInterned;
import org.checkerframework.shaded.checker.lock.qual.GuardSatisfied;
import org.checkerframework.shaded.checker.lock.qual.GuardedBy;
import org.checkerframework.shaded.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.shaded.checker.mustcall.qual.MustCall;
import org.checkerframework.shaded.checker.nonempty.qual.EnsuresNonEmpty;
import org.checkerframework.shaded.checker.nonempty.qual.EnsuresNonEmptyIf;
import org.checkerframework.shaded.checker.nullness.qual.NonNull;
import org.checkerframework.shaded.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.shaded.checker.regex.qual.UnknownRegex;
import org.checkerframework.shaded.checker.signature.qual.SignatureUnknown;
import org.checkerframework.shaded.checker.signedness.qual.Signed;
import org.checkerframework.shaded.checker.signedness.qual.UnknownSignedness;
import org.checkerframework.shaded.common.initializedfields.qual.InitializedFields;
import org.checkerframework.shaded.common.returnsreceiver.qual.UnknownThis;
import org.checkerframework.shaded.common.value.qual.UnknownVal;
import org.checkerframework.shaded.org.plumelib.util.AbstractMostlySingletonSet;

public final class IdentityMostlySingletonSet<@FormatBottom T>
extends AbstractMostlySingletonSet<T> {
    public IdentityMostlySingletonSet() {
        super(AbstractMostlySingletonSet.State.EMPTY);
    }

    public IdentityMostlySingletonSet(T value) {
        super(AbstractMostlySingletonSet.State.SINGLETON, value);
    }

    @Override
    @EnsuresNonEmpty(value={"this"})
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) boolean add(@GuardSatisfied IdentityMostlySingletonSet<T> this, @FindDistinct T e) {
        switch (this.state) {
            case EMPTY: {
                this.state = AbstractMostlySingletonSet.State.SINGLETON;
                this.value = e;
                return true;
            }
            case SINGLETON: {
                if (this.value == e) {
                    return false;
                }
                this.makeNonSingleton();
            }
            case ANY: {
                assert (this.set != null) : "@AssumeAssertion(nullness): set initialized before";
                return this.set.add(e);
            }
        }
        throw new IllegalStateException("Unhandled state " + (Object)((Object)this.state));
    }

    private void makeNonSingleton(@GuardSatisfied IdentityMostlySingletonSet<T> this) {
        this.state = AbstractMostlySingletonSet.State.ANY;
        this.set = Collections.newSetFromMap(new IdentityHashMap(4));
        assert (this.value != null) : "@AssumeAssertion(nullness): previous add is non-null";
        this.set.add(this.value);
        this.value = null;
    }

    @Override
    @EnsuresNonEmptyIf(result=true, expression={"this"})
    @Pure
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) boolean contains(@GuardSatisfied IdentityMostlySingletonSet<T> this, @GuardSatisfied @UnknownSignedness @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @InitializedFields(value={}) Object o) {
        switch (this.state) {
            case EMPTY: {
                return false;
            }
            case SINGLETON: {
                return o == this.value;
            }
            case ANY: {
                assert (this.set != null) : "@AssumeAssertion(nullness): set initialized before";
                return this.set.contains(o);
            }
        }
        throw new IllegalStateException("Unhandled state " + (Object)((Object)this.state));
    }
}

