/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.dataflow.constantpropagation;

import java.util.List;
import org.checkerframework.shaded.checker.nullness.qual.Nullable;
import org.checkerframework.shaded.dataflow.analysis.ConditionalTransferResult;
import org.checkerframework.shaded.dataflow.analysis.ForwardTransferFunction;
import org.checkerframework.shaded.dataflow.analysis.RegularTransferResult;
import org.checkerframework.shaded.dataflow.analysis.TransferInput;
import org.checkerframework.shaded.dataflow.analysis.TransferResult;
import org.checkerframework.shaded.dataflow.cfg.UnderlyingAST;
import org.checkerframework.shaded.dataflow.cfg.node.AbstractNodeVisitor;
import org.checkerframework.shaded.dataflow.cfg.node.AssignmentNode;
import org.checkerframework.shaded.dataflow.cfg.node.EqualToNode;
import org.checkerframework.shaded.dataflow.cfg.node.IntegerLiteralNode;
import org.checkerframework.shaded.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.shaded.dataflow.cfg.node.Node;
import org.checkerframework.shaded.dataflow.constantpropagation.Constant;
import org.checkerframework.shaded.dataflow.constantpropagation.ConstantPropagationStore;

public class ConstantPropagationTransfer
extends AbstractNodeVisitor<TransferResult<Constant, ConstantPropagationStore>, TransferInput<Constant, ConstantPropagationStore>>
implements ForwardTransferFunction<Constant, ConstantPropagationStore> {
    @Override
    public ConstantPropagationStore initialStore(UnderlyingAST underlyingAST, @Nullable List<LocalVariableNode> parameters) {
        ConstantPropagationStore store = new ConstantPropagationStore();
        return store;
    }

    @Override
    public TransferResult<Constant, ConstantPropagationStore> visitLocalVariable(LocalVariableNode node, TransferInput<Constant, ConstantPropagationStore> before) {
        ConstantPropagationStore store = before.getRegularStore();
        Constant value = store.getInformation(node);
        return new RegularTransferResult<Constant, ConstantPropagationStore>(value, store);
    }

    @Override
    public TransferResult<Constant, ConstantPropagationStore> visitNode(Node n, TransferInput<Constant, ConstantPropagationStore> p) {
        return new RegularTransferResult<Object, ConstantPropagationStore>(null, p.getRegularStore());
    }

    @Override
    public TransferResult<Constant, ConstantPropagationStore> visitAssignment(AssignmentNode n, TransferInput<Constant, ConstantPropagationStore> pi) {
        ConstantPropagationStore p = pi.getRegularStore();
        Node target = n.getTarget();
        Constant info = null;
        if (target instanceof LocalVariableNode) {
            LocalVariableNode t2 = (LocalVariableNode)target;
            info = p.getInformation(n.getExpression());
            p.setInformation(t2, info);
        }
        return new RegularTransferResult<Object, ConstantPropagationStore>(info, p);
    }

    @Override
    public TransferResult<Constant, ConstantPropagationStore> visitIntegerLiteral(IntegerLiteralNode n, TransferInput<Constant, ConstantPropagationStore> pi) {
        ConstantPropagationStore p = pi.getRegularStore();
        Constant c = new Constant(n.getValue());
        p.setInformation(n, c);
        return new RegularTransferResult<Constant, ConstantPropagationStore>(c, p);
    }

    @Override
    public TransferResult<Constant, ConstantPropagationStore> visitEqualTo(EqualToNode n, TransferInput<Constant, ConstantPropagationStore> pi) {
        ConstantPropagationStore p = pi.getRegularStore();
        ConstantPropagationStore old = p.copy();
        Node left = n.getLeftOperand();
        Node right = n.getRightOperand();
        this.process(p, left, right);
        this.process(p, right, left);
        return new ConditionalTransferResult<Object, ConstantPropagationStore>(null, p, old);
    }

    protected void process(ConstantPropagationStore p, Node a, Node b) {
        Constant val = p.getInformation(a);
        if (b instanceof LocalVariableNode && val.isConstant()) {
            p.setInformation(b, val);
        }
    }
}

