/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.dataflow.cfg.node;

import com.sun.source.tree.Tree;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.checkerframework.shaded.checker.nullness.qual.Nullable;
import org.checkerframework.shaded.dataflow.cfg.node.Node;
import org.checkerframework.shaded.dataflow.cfg.node.NodeVisitor;

public class TypeCastNode
extends Node {
    protected final Tree tree;
    protected final Node operand;
    protected final Types types;

    public TypeCastNode(Tree tree, Node operand, TypeMirror type, Types types) {
        super(type);
        this.tree = tree;
        this.operand = operand;
        this.types = types;
    }

    public Node getOperand() {
        return this.operand;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitTypeCast(this, p);
    }

    public String toString() {
        return "(" + this.getType() + ")" + this.getOperand();
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof TypeCastNode)) {
            return false;
        }
        TypeCastNode other = (TypeCastNode)obj;
        return this.getOperand().equals(other.getOperand()) && this.types.isSameType(this.getType(), other.getType());
    }

    public int hashCode() {
        return Objects.hash(this.getType(), this.getOperand());
    }

    @Override
    public Collection<Node> getOperands() {
        return Collections.singletonList(this.getOperand());
    }
}

