/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.dataflow.cfg;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.util.Log;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.shaded.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.shaded.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.shaded.checker.nullness.qual.Nullable;
import org.checkerframework.shaded.dataflow.cfg.ControlFlowGraph;
import org.checkerframework.shaded.dataflow.cfg.builder.CFGBuilder;
import org.checkerframework.shaded.javacutil.BasicTypeProcessor;
import org.checkerframework.shaded.javacutil.TreeUtils;

@SupportedAnnotationTypes(value={"*"})
public class CFGProcessor
extends BasicTypeProcessor {
    private final String className;
    private final String methodName;
    private @Nullable CompilationUnitTree rootTree;
    private @Nullable ClassTree classTree;
    private @Nullable MethodTree methodTree;
    private @MonotonicNonNull CFGProcessResult result = null;

    public CFGProcessor(String className, String methodName) {
        this.className = className;
        this.methodName = methodName;
    }

    public final @Nullable CFGProcessResult getCFGProcessResult() {
        return this.result;
    }

    @Override
    public void typeProcessingOver() {
        if (this.rootTree == null) {
            this.result = new CFGProcessResult("Root tree is null.");
        } else if (this.classTree == null) {
            this.result = new CFGProcessResult("Method tree is null.");
        } else if (this.methodTree == null) {
            this.result = new CFGProcessResult("Class tree is null.");
        } else {
            Log log = this.getCompilerLog();
            if (log.nerrors > 0) {
                this.result = new CFGProcessResult("Compilation issued an error.");
            } else {
                ControlFlowGraph cfg = CFGBuilder.build(this.rootTree, this.methodTree, this.classTree, this.processingEnv);
                this.result = new CFGProcessResult(cfg);
            }
        }
        super.typeProcessingOver();
    }

    @Override
    protected TreePathScanner<?, ?> createTreePathScanner(CompilationUnitTree root) {
        this.rootTree = root;
        return new TreePathScanner<Void, Void>(){

            @Override
            public Void visitClass(ClassTree node, Void p) {
                TypeElement el = TreeUtils.elementFromDeclaration(node);
                if (el.getSimpleName().contentEquals(CFGProcessor.this.className)) {
                    CFGProcessor.this.classTree = node;
                }
                return (Void)super.visitClass(node, p);
            }

            @Override
            public Void visitMethod(MethodTree node, Void p) {
                ExecutableElement el = TreeUtils.elementFromDeclaration(node);
                if (el.getSimpleName().contentEquals(CFGProcessor.this.methodName)) {
                    CFGProcessor.this.methodTree = node;
                    throw new RuntimeException();
                }
                return null;
            }
        };
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    public static class CFGProcessResult {
        private final @Nullable ControlFlowGraph controlFlowGraph;
        private final boolean isSuccess;
        private final @Nullable String errMsg;

        CFGProcessResult(ControlFlowGraph cfg) {
            this(cfg, true, null);
        }

        CFGProcessResult(String errMsg) {
            this(null, false, errMsg);
        }

        private CFGProcessResult(@Nullable ControlFlowGraph cfg, boolean isSuccess, @Nullable String errMsg) {
            this.controlFlowGraph = cfg;
            this.isSuccess = isSuccess;
            this.errMsg = errMsg;
        }

        @Pure
        @EnsuresNonNullIf(expression={"getCFG()"}, result=true)
        public boolean isSuccess() {
            return this.isSuccess;
        }

        @Pure
        public @Nullable ControlFlowGraph getCFG() {
            return this.controlFlowGraph;
        }

        @Pure
        public @Nullable String getErrMsg() {
            return this.errMsg;
        }
    }
}

